import styled from 'styled-components';

import { selectSelectedDeviceLabelOrName } from '@suite-common/wallet-core';
import { Paragraph } from '@trezor/components';

import { Translation } from 'src/components/suite/Translation';
import { DeviceConfirmImage, Modal, ModalProps } from 'src/components/suite';
import { TrezorDevice } from 'src/types/suite';
import { useSelector } from 'src/hooks/suite';

const Divider = styled.div`
    margin-bottom: 10px;
`;

const StyledModal = styled(Modal)`
    width: 360px;
`;

interface PinInvalidModalProps extends ModalProps {
    device: TrezorDevice;
}

export const PinInvalidModal = ({ device, ...rest }: PinInvalidModalProps) => {
    const deviceLabel = useSelector(selectSelectedDeviceLabelOrName);

    return (
        <StyledModal
            heading={<Translation id="TR_ENTERED_PIN_NOT_CORRECT" values={{ deviceLabel }} />}
            {...rest}
        >
            <DeviceConfirmImage device={device} />
            <Divider />
            <Paragraph typographyStyle="hint">
                <Translation id="TR_RETRYING_DOT_DOT" />
            </Paragraph>
        </StyledModal>
    );
};
