// @group_wallet
// @retry=2

import { NetworkSymbol } from '@suite-common/wallet-config';

import { onAccountsPage } from '../../support/pageObjects/accountsObject';

describe('Check coins XPUB', () => {
    beforeEach(() => {
        cy.task('startEmu', { wipe: true });
        cy.task('setupEmu', {
            needs_backup: false,
            mnemonic: 'town grace cat forest dress dust trick practice hair survey pupil regular',
        });
        cy.task('startBridge');

        cy.viewport('macbook-13').resetDb();
        cy.prefixedVisit('/accounts');
        cy.passThroughInitialRun();
        cy.discoveryShouldFinish();
        cy.getTestElement('@account-menu/normal/group').click();
    });

    afterEach(() => {
        cy.task('stopEmu');
    });

    const symbols: NetworkSymbol[] = ['btc', 'ltc', 'vtc', 'ada'];

    /**
     * 1. Start in Accounts section
     * 2. If not Bitcoin test activate coin
     * 3. Apply coin filter
     * 4. Navigate to First accounts Wallet detail
     * 5. Click Show public key
     * 6. Check that XPUB is present
     * 7. Check XPUB prefix matches coin type
     */
    symbols.forEach(symbol => {
        it(`Check ${symbol} XPUB`, () => {
            if (symbol !== 'btc') {
                onAccountsPage.activatNewCoin(symbol);
                cy.getTestElement(`@account-menu/filter/${symbol}`).click();
            }

            cy.getTestElement('@wallet/menu/wallet-details').click();
            cy.getTestElement('@wallets/details/show-xpub-button').click();
            cy.getTestElement('@device-display/paginated-text').should('exist');
            if (symbol !== 'ada') {
                cy.getTestElement('@device-display/paginated-text')
                    .should('be.visible')
                    .invoke('text')
                    .should('contain', 'zpub');
            }
        });
    });
});
