const PREV_TX = {
    txid: '3796497830e70bbf60fbdd8f9570ed53851df6e3d7a34fb1eff2119caf03616d',
    version: 1,
    vin: [
        {
            txid: 'adf4a7fc64379932db9690c6f28a731e3322df9cc1311d09a742f407cf3396c6',
            sequence: 4294967295,
            n: 0,
            addresses: ['DN1ZMYxicfqLqRWcgftsS2iTAUhmLzcDKK'],
            isAddress: true,
            value: '1000000000',
            hex: '47304402207cecdcab4b1c631bbed8da9776c91d5fff3e1afde9e91bfa44e7decffbd8331c022036fec7707d5371a2346ebb52d0ce2805ce6409439b8d6338b05b2c1df485b10f012102960563167bea073f7979cfe5525ca3a24655d3560894f577ab452e19216eda87',
        },
    ],
    vout: [
        {
            value: '11556856856844445555',
            n: 0,
            hex: '76a9148ae3fead7569f965e334788cc40176b3ecee571588ac',
            addresses: ['DHoUv6AUXrxadt5GhqK2TLN6Lw4bgKZnjG'],
            isAddress: true,
        },
    ],
    blockHash: 'deadfea6fa7eaee8568f5ef04c4ea0b1b2c47e08299ec6fd4c45fb4b89792088',
    blockHeight: 4484551,
    confirmations: 79,
    blockTime: 1669212266,
    value: '11556856856844445555',
    valueIn: '1000000000',
    fees: '19200',
    hex: '0100000001c69633cf07f442a7091d31c19cdf22331e738af2c69096db32993764fca7f4ad000000006a47304402207cecdcab4b1c631bbed8da9776c91d5fff3e1afde9e91bfa44e7decffbd8331c022036fec7707d5371a2346ebb52d0ce2805ce6409439b8d6338b05b2c1df485b10f012102960563167bea073f7979cfe5525ca3a24655d3560894f577ab452e19216eda87ffffffff01007f9a3b000000001976a9148ae3fead7569f965e334788cc40176b3ecee571588ac00000000',
};

const DOGE_ACCOUNT = {
    data: {
        page: 1,
        totalPages: 1,
        itemsOnPage: 25,
        address:
            'dgub8rE9bgXY9DuS9fvhBMshxu6auWGdAcD9P6weqZrqnLx13edD963SB3kjHBTWYWBWErhpLW9SkopNwx7zLdvDt1nySVb8qj8zR95iH4578JN',
        balance: '11556856856844445555',
        totalReceived: '11556856856844445555',
        totalSent: '0',
        unconfirmedBalance: '0',
        unconfirmedTxs: 0,
        txs: 1,
        transactions: [
            {
                txid: '3796497830e70bbf60fbdd8f9570ed53851df6e3d7a34fb1eff2119caf03616d',
                version: 1,
                vin: [
                    {
                        txid: 'adf4a7fc64379932db9690c6f28a731e3322df9cc1311d09a742f407cf3396c6',
                        sequence: 4294967295,
                        n: 0,
                        addresses: ['DN1ZMYxicfqLqRWcgftsS2iTAUhmLzcDKK'],
                        isAddress: true,
                        value: '1000000000',
                        hex: '47304402207cecdcab4b1c631bbed8da9776c91d5fff3e1afde9e91bfa44e7decffbd8331c022036fec7707d5371a2346ebb52d0ce2805ce6409439b8d6338b05b2c1df485b10f012102960563167bea073f7979cfe5525ca3a24655d3560894f577ab452e19216eda87',
                    },
                ],
                vout: [
                    {
                        value: '11556856856844445555',
                        n: 0,
                        hex: '76a9148ae3fead7569f965e334788cc40176b3ecee571588ac',
                        addresses: ['DHoUv6AUXrxadt5GhqK2TLN6Lw4bgKZnjG'],
                        isAddress: true,
                        isOwn: true,
                    },
                ],
                blockHash: 'deadfea6fa7eaee8568f5ef04c4ea0b1b2c47e08299ec6fd4c45fb4b89792088',
                blockHeight: 4484551,
                confirmations: 16,
                blockTime: 1669212266,
                value: '11556856856844445555',
                valueIn: '1000000000',
                fees: '19200',
                hex: '0100000001c69633cf07f442a7091d31c19cdf22331e738af2c69096db32993764fca7f4ad000000006a47304402207cecdcab4b1c631bbed8da9776c91d5fff3e1afde9e91bfa44e7decffbd8331c022036fec7707d5371a2346ebb52d0ce2805ce6409439b8d6338b05b2c1df485b10f012102960563167bea073f7979cfe5525ca3a24655d3560894f577ab452e19216eda87ffffffff01007f9a3b000000001976a9148ae3fead7569f965e334788cc40176b3ecee571588ac00000000',
            },
        ],
        usedTokens: 1,
        tokens: [
            {
                type: 'XPUBAddress',
                name: 'DHoUv6AUXrxadt5GhqK2TLN6Lw4bgKZnjG',
                path: "m/44'/3'/0'/0/0",
                transfers: 1,
                decimals: 8,
                balance: '11556856856844445555',
                totalReceived: '11556856856844445555',
                totalSent: '0',
            },
            {
                type: 'XPUBAddress',
                name: 'DBNkNukxRcH6QTPSp69KhVHQWkUpVLotWs',
                path: "m/44'/3'/0'/0/1",
                transfers: 0,
                decimals: 8,
            },
            {
                type: 'XPUBAddress',
                name: 'DCsP6RCfFHvTKFRocJEoW1CjYEPMk9pk3i',
                path: "m/44'/3'/0'/1/0",
                transfers: 0,
                decimals: 8,
            },
            {
                type: 'XPUBAddress',
                name: 'DMRZ3D9ppogDQoY7AUCLy5EaRTTEv6xJ5f',
                path: "m/44'/3'/0'/1/1",
                transfers: 0,
                decimals: 8,
            },
        ],
    },
};

const isFirstAccount = (descriptor: string) => descriptor === DOGE_ACCOUNT.data.address;

export const fixtures = [
    {
        method: 'getInfo',
        default: true,
        response: {
            data: {
                name: 'DogecoinMock',
                shortcut: 'DOGE',
                decimals: 8,
                version: '0.3.6',
                bestHeight: 4484566,
                bestHash: '38fbb073e7eb4bfac9ed485dd0b3212247fb2a3d8b509dc9738c01a86ede33b3',
                block0Hash: '1a91e3dace36e2be3bf030a65679fe821aa1d6ef92e7c9902eb318182c355691',
                network: 'DOGE',
                testnet: false,
                backend: { version: '1140600', subversion: '/Shibetoshi:1.14.6/' },
            },
        },
    },
    {
        method: 'getAccountInfo',
        default: true,
        response: ({ params }: any) => {
            if (isFirstAccount(params.descriptor)) {
                return DOGE_ACCOUNT;
            }
        },
    },
    {
        method: 'getAccountUtxo',
        default: true,
        response: {
            data: [
                {
                    txid: PREV_TX.txid,
                    vout: 0,
                    value: '11556856856844445555',
                    height: 4484551,
                    confirmations: 16,
                    address: 'DHoUv6AUXrxadt5GhqK2TLN6Lw4bgKZnjG',
                    path: "m/44'/3'/0'/0/0",
                },
            ],
        },
    },
    {
        method: 'getBalanceHistory',
        default: true,
        response: {
            data: [
                {
                    time: 1669161600,
                    txs: 1,
                    received: '11556856856844445555',
                    sent: '0',
                    sentToSelf: '0',
                    rates: { usd: 0.078881 },
                },
            ],
        },
    },
    {
        method: 'estimateFee',
        default: true,
        response: {
            data: [
                { feePerUnit: '-100000000' },
                { feePerUnit: '6418769' },
                { feePerUnit: '1003782' },
                { feePerUnit: '1003782' },
                { feePerUnit: '1003782' },
                { feePerUnit: '1003782' },
                { feePerUnit: '1003782' },
                { feePerUnit: '1003782' },
                { feePerUnit: '1003782' },
                { feePerUnit: '1003782' },
            ],
        },
    },
    {
        method: 'getFiatRatesForTimestamps',
        default: true,
        response: {
            data: {
                tickers: [
                    {
                        ts: 1668608419,
                        rates: {
                            usd: 0.085339,
                        },
                    },
                ],
            },
        },
    },
    {
        method: 'getTransaction',
        default: true,
        response: ({ params }: any) => {
            if (params?.txid === PREV_TX.txid) {
                return { data: PREV_TX };
            }
        },
    },
];
