import { parseFirmwareHeaders } from '../parseFirmwareHeaders';

describe('parseFirmwareHeaders', () => {
    test('2.6.3', () => {
        // randomly selected starting chunk of firware that should contain all the headers info
        const fwHex =
            '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';

        const buf = Buffer.from(fwHex, 'hex');
        const header = parseFirmwareHeaders(buf);
        expect(header.version).toEqual([2, 6, 3]);
    });

    test('1.12.1', () => {
        // randomly selected starting chunk of firware that should contain all the headers info
        const fwHex =
            '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';

        const buf = Buffer.from(fwHex, 'hex');
        const header = parseFirmwareHeaders(buf);
        expect(header.version).toEqual([1, 12, 1]);
    });
});
