import path from 'path';
import { merge } from 'webpack-merge';
import { WebpackPluginServe } from 'webpack-plugin-serve';

import prod from './prod.webpack.config';

const dev = {
    mode: 'development',
    watch: true,
    devtool: 'eval-source-map',
    output: {
        filename: '[name].js',
    },
    plugins: [
        new WebpackPluginServe({
            port: process.env.PORT ? parseInt(process.env.PORT) : 8088,
            hmr: true,
            static: [path.join(__dirname, '../build')],
        }),
    ],
};

// eslint-disable-next-line import/no-default-export
export default merge([prod, dev]);
