# @trezor/connect-examples

A collection of example implementations of @trezor/connect in various environments. See individual READMEs for instructions:

| Environment                                                                             | package                                                           | Popup |
| --------------------------------------------------------------------------------------- | ----------------------------------------------------------------- | ----- |
| [Node.js](./node)                                                                       | [@trezor/connect](../connect/README.md)                           | No    |
| [Electron main process](./electron-main-process/)                                       | [@trezor/connect](../connect/README.md)                           | No    |
| [Electron renderer with assets](./electron-renderer-with-assets/)                       | [@trezor/connect](../connect/README.md)                           | No    |
| [Electron renderer with popup](./electron-renderer-with-popup/)                         | [@trezor/connect](../connect/README.md)                           | Yes   |
| [Browser inline script](./browser-inline-script/)                                       | [@trezor/connect-web](../connect-web/README.md)                   | Yes   |
| [Browser with webpack](../connect-explorer/README.md)                                   | [@trezor/connect-web](../connect-web/README.md)                   | Yes   |
| [Webextension Manifest V2](./webextension-mv2/)                                         | [@trezor/connect-web](../connect-web/README.md)                   | Yes   |
| [Webextension Manifest V3](./webextension-mv3)                                          | [@trezor/connect-web](../connect-web/README.md)                   | Yes   |
| [Webextension Manifest V3 with Service Worker](./webextension-mv3-sw)                   | [@trezor/connect-webextension](../connect-webextension/README.md) | Yes   |
| [Webextension Manifest V3 with Service Worker and ES6 module](./webextension-mv3-sw-ts) | [@trezor/connect-webextension](../connect-webextension/README.md) | Yes   |

Also you may explorer 3rd party @trezor/connect integrations.

-   https://github.com/stellar/laboratory
-   https://github.com/vacuumlabs/adalite
