import { Meta, StoryObj } from '@storybook/react';

import { Markdown as MarkdownComponent } from './Markdown';

const meta: Meta = {
    title: 'Markdown',
    component: MarkdownComponent,
} as Meta;

export default meta;

export const Markdown: StoryObj = {
    args: {
        children: `### 🎨 Improvements

-   The "Remember Wallet" feature has been enhanced and renamed to "View-Only Wallet" for better discoverability and clarity.
-   The wallet switcher has been redesigned for a smoother experience.
-   The passphrase is now integrated into the wallet switcher, eliminating prompts at every device connection.
-   Token management has been revamped with manual hide/unhide options, enhanced search functionality, and more.
-   Staked ETH balance is now included in the Dashboard Portfolio.
-   Fractional gas prices now supported for EVM transactions, allowing for more precise gas fee calculations.

### 🔧 Bug fixes

-   Various small improvements and bug fixes.
`,
    },
};
