export const keyboardKeys = {
    BACKSPACE: { code: 8, value: 'Backspace' },
    TAB: { code: 9, value: 'Tab' },
    ENTER: { code: 13, value: 'Enter' },
    SHIFT: { code: 16, value: 'Shift' },
    CTRL: { code: 17, value: 'Ctrl', valueMac: '⌘' },
    CMD: { code: 17, value: '⌘' },
    ALT: { code: 18, value: 'Alt', valueMac: '⌥' },
    PAUSE: { code: 19, value: 'Pause' },
    CAPS_LOCK: { code: 20, value: 'Caps Lock' },
    ESCAPE: { code: 27, value: 'Escape' },
    SPACE: { code: 32, value: 'Space' },
    PAGE_UP: { code: 33, value: 'Page Up' },
    PAGE_DOWN: { code: 34, value: 'Page Down' },
    END: { code: 35, value: 'End' },
    HOME: { code: 36, value: 'Home' },
    LEFT_ARROW: { code: 37, value: '←' },
    UP_ARROW: { code: 38, value: '↑' },
    RIGHT_ARROW: { code: 39, value: '→' },
    DOWN_ARROW: { code: 40, value: '↓' },
    INSERT: { code: 45, value: 'Insert' },
    DELETE: { code: 46, value: 'Delete' },
    KEY_0: { code: 48, value: '0' },
    KEY_1: { code: 49, value: '1' },
    KEY_2: { code: 50, value: '2' },
    KEY_3: { code: 51, value: '3' },
    KEY_4: { code: 52, value: '4' },
    KEY_5: { code: 53, value: '5' },
    KEY_6: { code: 54, value: '6' },
    KEY_7: { code: 55, value: '7' },
    KEY_8: { code: 56, value: '8' },
    KEY_9: { code: 57, value: '9' },
    KEY_A: { code: 65, value: 'A' },
    KEY_B: { code: 66, value: 'B' },
    KEY_C: { code: 67, value: 'C' },
    KEY_D: { code: 68, value: 'D' },
    KEY_E: { code: 69, value: 'E' },
    KEY_F: { code: 70, value: 'F' },
    KEY_G: { code: 71, value: 'G' },
    KEY_H: { code: 72, value: 'H' },
    KEY_I: { code: 73, value: 'I' },
    KEY_J: { code: 74, value: 'J' },
    KEY_K: { code: 75, value: 'K' },
    KEY_L: { code: 76, value: 'L' },
    KEY_M: { code: 77, value: 'M' },
    KEY_N: { code: 78, value: 'N' },
    KEY_O: { code: 79, value: 'O' },
    KEY_P: { code: 80, value: 'P' },
    KEY_Q: { code: 81, value: 'Q' },
    KEY_R: { code: 82, value: 'R' },
    KEY_S: { code: 83, value: 'S' },
    KEY_T: { code: 84, value: 'T' },
    KEY_U: { code: 85, value: 'U' },
    KEY_V: { code: 86, value: 'V' },
    KEY_W: { code: 87, value: 'W' },
    KEY_X: { code: 88, value: 'X' },
    KEY_Y: { code: 89, value: 'Y' },
    KEY_Z: { code: 90, value: 'Z' },
    LEFT_META: { code: 91, value: 'Left Meta' },
    RIGHT_META: { code: 92, value: 'Right Meta' },
    SELECT: { code: 93, value: 'Select' },
    NUMPAD_0: { code: 96, value: 'Numpad 0' },
    NUMPAD_1: { code: 97, value: 'Numpad 1' },
    NUMPAD_2: { code: 98, value: 'Numpad 2' },
    NUMPAD_3: { code: 99, value: 'Numpad 3' },
    NUMPAD_4: { code: 100, value: 'Numpad 4' },
    NUMPAD_5: { code: 101, value: 'Numpad 5' },
    NUMPAD_6: { code: 102, value: 'Numpad 6' },
    NUMPAD_7: { code: 103, value: 'Numpad 7' },
    NUMPAD_8: { code: 104, value: 'Numpad 8' },
    NUMPAD_9: { code: 105, value: 'Numpad 9' },
    MULTIPLY: { code: 106, value: 'Multiply' },
    ADD: { code: 107, value: 'Add' },
    SUBTRACT: { code: 109, value: 'Subtract' },
    DECIMAL: { code: 110, value: 'Decimal' },
    DIVIDE: { code: 111, value: 'Divide' },
    F1: { code: 112, value: 'F1' },
    F2: { code: 113, value: 'F2' },
    F3: { code: 114, value: 'F3' },
    F4: { code: 115, value: 'F4' },
    F5: { code: 116, value: 'F5' },
    F6: { code: 117, value: 'F6' },
    F7: { code: 118, value: 'F7' },
    F8: { code: 119, value: 'F8' },
    F9: { code: 120, value: 'F9' },
    F10: { code: 121, value: 'F10' },
    F11: { code: 122, value: 'F11' },
    F12: { code: 123, value: 'F12' },
    NUM_LOCK: { code: 144, value: 'Num Lock' },
    SCROLL_LOCK: { code: 145, value: 'Scroll Lock' },
    SEMICOLON: { code: 186, value: ';' },
    EQUALS: { code: 187, value: '=' },
    COMMA: { code: 188, value: ',' },
    DASH: { code: 189, value: '-' },
    PERIOD: { code: 190, value: '.' },
    FORWARD_SLASH: { code: 191, value: '/' },
    GRAVE_ACCENT: { code: 192, value: '`' },
    OPEN_BRACKET: { code: 219, value: '[' },
    BACK_SLASH: { code: 220, value: '\\' },
    CLOSE_BRACKET: { code: 221, value: ']' },
    SINGLE_QUOTE: { code: 222, value: "'" },
};

export type KeyboardKeys = typeof keyboardKeys;
export type Keys = keyof typeof keyboardKeys;
