/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.util;

import java.util.Collection;
import net.jsign.log4j.util.PropertySource;

public class SystemPropertiesPropertySource
implements PropertySource {
    public static String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return "log4j2." + PropertySource.Util.joinAsCamelCase(tokens);
    }

    @Override
    public Collection<String> getPropertyNames() {
        try {
            return System.getProperties().stringPropertyNames();
        }
        catch (SecurityException e) {
            return PropertySource.super.getPropertyNames();
        }
    }

    @Override
    public String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            return PropertySource.super.getProperty(key);
        }
    }

    @Override
    public boolean containsProperty(String key) {
        return this.getProperty(key) != null;
    }
}

