/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.log4j.message;

import java.io.Serializable;
import net.jsign.log4j.message.Clearable;
import net.jsign.log4j.message.Message;
import net.jsign.log4j.message.MessageFactory2;
import net.jsign.log4j.message.ReusableParameterizedMessage;
import net.jsign.log4j.message.ReusableSimpleMessage;

public final class ReusableMessageFactory
implements Serializable,
MessageFactory2 {
    public static final ReusableMessageFactory INSTANCE = new ReusableMessageFactory();
    private static ThreadLocal<ReusableParameterizedMessage> threadLocalParameterized = new ThreadLocal();
    private static ThreadLocal<ReusableSimpleMessage> threadLocalSimpleMessage = new ThreadLocal();
    private static ThreadLocal<Object> threadLocalObjectMessage = new ThreadLocal();

    private static ReusableParameterizedMessage getParameterized() {
        ReusableParameterizedMessage result = threadLocalParameterized.get();
        if (result == null) {
            result = new ReusableParameterizedMessage();
            threadLocalParameterized.set(result);
        }
        return result.reserved ? new ReusableParameterizedMessage().reserve() : result.reserve();
    }

    private static ReusableSimpleMessage getSimple() {
        ReusableSimpleMessage result = threadLocalSimpleMessage.get();
        if (result == null) {
            result = new ReusableSimpleMessage();
            threadLocalSimpleMessage.set(result);
        }
        return result;
    }

    public static void release(Message message) {
        if (message instanceof Clearable) {
            ((Clearable)((Object)message)).clear();
        }
    }

    @Override
    public Message newMessage(String message, Object ... params) {
        return ReusableMessageFactory.getParameterized().set(message, params);
    }

    @Override
    public Message newMessage(String message, Object p0) {
        return ReusableMessageFactory.getParameterized().set(message, p0);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1) {
        return ReusableMessageFactory.getParameterized().set(message, p0, p1);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2) {
        return ReusableMessageFactory.getParameterized().set(message, p0, p1, p2);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return ReusableMessageFactory.getParameterized().set(message, p0, p1, p2, p3, p4);
    }

    @Override
    public Message newMessage(String message) {
        ReusableSimpleMessage result = ReusableMessageFactory.getSimple();
        result.set(message);
        return result;
    }
}

