/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.json-io.util.io;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.jsign.json-io.util.io.FastPushbackBufferedReader;
import net.jsign.json-io.util.io.FastPushbackReader;
import net.jsign.json-io.util.io.JsonIoException;
import net.jsign.json-io.util.io.JsonObject;
import net.jsign.json-io.util.io.JsonParser;
import net.jsign.json-io.util.io.MapResolver;
import net.jsign.json-io.util.io.MetaUtils;
import net.jsign.json-io.util.io.ObjectResolver;
import net.jsign.json-io.util.io.Readers;
import net.jsign.json-io.util.io.Resolver;

public class JsonReader
implements Closeable {
    private static Map<Class, JsonClassReaderBase> BASE_READERS;
    protected final Map<Class, JsonClassReaderBase> readers = new HashMap<Class, JsonClassReaderBase>(BASE_READERS);
    protected MissingFieldHandler missingFieldHandler;
    protected final Set<Class> notCustom = new HashSet<Class>();
    private static final Map<String, Factory> factory;
    private final Map<Long, JsonObject> objsRead = new HashMap<Long, JsonObject>();
    private final FastPushbackReader input;
    private final Map<String, Object> args = new HashMap<String, Object>();
    private final int maxParseDepth;
    private static volatile boolean allowNanAndInfinity;

    static {
        factory = new ConcurrentHashMap<String, Factory>();
        allowNanAndInfinity = false;
        CollectionFactory colFactory = new CollectionFactory();
        JsonReader.assignInstantiator(Collection.class, (Factory)colFactory);
        JsonReader.assignInstantiator(List.class, (Factory)colFactory);
        JsonReader.assignInstantiator(Set.class, (Factory)colFactory);
        JsonReader.assignInstantiator(SortedSet.class, (Factory)colFactory);
        MapFactory mapFactory = new MapFactory();
        JsonReader.assignInstantiator(Map.class, (Factory)mapFactory);
        JsonReader.assignInstantiator(SortedMap.class, (Factory)mapFactory);
        HashMap<Class, JsonClassReaderBase> temp = new HashMap<Class, JsonClassReaderBase>();
        temp.put(String.class, new Readers.StringReader());
        temp.put(java.util.Date.class, new Readers.DateReader());
        temp.put(AtomicBoolean.class, new Readers.AtomicBooleanReader());
        temp.put(AtomicInteger.class, new Readers.AtomicIntegerReader());
        temp.put(AtomicLong.class, new Readers.AtomicLongReader());
        temp.put(BigInteger.class, new Readers.BigIntegerReader());
        temp.put(BigDecimal.class, new Readers.BigDecimalReader());
        temp.put(Date.class, new Readers.SqlDateReader());
        temp.put(Timestamp.class, new Readers.TimestampReader());
        temp.put(Calendar.class, new Readers.CalendarReader());
        temp.put(TimeZone.class, new Readers.TimeZoneReader());
        temp.put(Locale.class, new Readers.LocaleReader());
        temp.put(Class.class, new Readers.ClassReader());
        temp.put(StringBuilder.class, new Readers.StringBuilderReader());
        temp.put(StringBuffer.class, new Readers.StringBufferReader());
        temp.put(UUID.class, new Readers.UUIDReader());
        try {
            Class<?> recordClass = Class.forName("java.lang.Record");
            temp.put(recordClass, new Readers.RecordReader());
        }
        catch (ClassNotFoundException classNotFoundException) {}
        BASE_READERS = temp;
    }

    public static boolean isAllowNanAndInfinity() {
        return allowNanAndInfinity;
    }

    public static void assignInstantiator(String n, Factory f) {
        factory.put(n, f);
    }

    public static void assignInstantiator(Class c, Factory f) {
        JsonReader.assignInstantiator(c.getName(), f);
    }

    public void addReader(Class c, JsonClassReaderBase reader) {
        this.readers.put(c, reader);
    }

    public void addNotCustomReader(Class c) {
        this.notCustom.add(c);
    }

    MissingFieldHandler getMissingFieldHandler() {
        return this.missingFieldHandler;
    }

    public void setMissingFieldHandler(MissingFieldHandler handler) {
        this.missingFieldHandler = handler;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public static Map jsonToMaps(String json, int maxDepth) {
        return JsonReader.jsonToMaps(json, null, maxDepth);
    }

    public static Map jsonToMaps(String json) {
        return JsonReader.jsonToMaps(json, 1000);
    }

    public static Map jsonToMaps(String json, Map<String, Object> optionalArgs, int maxDepth) {
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        optionalArgs.put("USE_MAPS", true);
        ByteArrayInputStream ba = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        JsonReader jr = new JsonReader(ba, optionalArgs, maxDepth);
        Object ret = jr.readObject();
        jr.close();
        return JsonReader.adjustOutputMap(ret);
    }

    private static Map adjustOutputMap(Object ret) {
        if (ret instanceof Map) {
            return (Map)ret;
        }
        if (ret != null && ret.getClass().isArray()) {
            JsonObject<String, Object> retMap = new JsonObject<String, Object>();
            retMap.put("@items", ret);
            return retMap;
        }
        JsonObject<String, Object[]> retMap = new JsonObject<String, Object[]>();
        retMap.put("@items", new Object[]{ret});
        return retMap;
    }

    public JsonReader(int maxDepth) {
        this.input = null;
        this.getArgs().put("USE_MAPS", false);
        this.getArgs().put("CLASSLOADER", JsonReader.class.getClassLoader());
        this.maxParseDepth = maxDepth;
    }

    public JsonReader() {
        this(1000);
    }

    public JsonReader(InputStream inp, Map<String, Object> optionalArgs, int maxDepth) {
        this.initializeFromArgs(optionalArgs);
        this.input = new FastPushbackBufferedReader(new InputStreamReader(inp, StandardCharsets.UTF_8));
        this.maxParseDepth = maxDepth;
    }

    private void initializeFromArgs(Map<String, Object> optionalArgs) {
        Iterable notCustomReaders;
        Map typeNames;
        if (optionalArgs == null) {
            optionalArgs = new HashMap<String, Object>();
        }
        Map<String, Object> args = this.getArgs();
        args.putAll(optionalArgs);
        args.put("JSON_READER", this);
        if (!args.containsKey("CLASSLOADER")) {
            args.put("CLASSLOADER", JsonReader.class.getClassLoader());
        }
        if ((typeNames = (Map)args.get("TYPE_NAME_MAP")) != null) {
            HashMap<String, String> typeNameMap = new HashMap<String, String>();
            for (Map.Entry entry : typeNames.entrySet()) {
                typeNameMap.put((String)entry.getValue(), (String)entry.getKey());
            }
            args.put("TYPE_NAME_MAP_REVERSE", typeNameMap);
        }
        this.setMissingFieldHandler((MissingFieldHandler)args.get("MISSING_FIELD_HANDLER"));
        Map customReaders = (Map)args.get("CUSTOM_READERS");
        if (customReaders != null) {
            for (Map.Entry entry : customReaders.entrySet()) {
                this.addReader((Class)entry.getKey(), (JsonClassReaderBase)entry.getValue());
            }
        }
        if ((notCustomReaders = (Iterable)args.get("NOT_CUSTOM_READERS")) != null) {
            for (Class c : notCustomReaders) {
                this.addNotCustomReader(c);
            }
        }
    }

    public Map<Long, JsonObject> getObjectsRead() {
        return this.objsRead;
    }

    public Object readObject() {
        Object graph;
        Object o;
        JsonParser parser = new JsonParser(this.input, this.objsRead, this.getArgs(), this.maxParseDepth);
        JsonObject<String, Object> root = new JsonObject<String, Object>();
        try {
            o = parser.readValue(root);
            if (o == "~!o~") {
                return new JsonObject();
            }
        }
        catch (JsonIoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonIoException("error parsing JSON value", e);
        }
        if (o instanceof Object[]) {
            root.setType(Object[].class.getName());
            root.setTarget(o);
            root.put("@items", o);
            graph = this.convertParsedMapsToJava(root);
        } else {
            Object object = graph = o instanceof JsonObject ? this.convertParsedMapsToJava((JsonObject)o) : o;
        }
        if (this.useMaps()) {
            return o;
        }
        return graph;
    }

    protected boolean useMaps() {
        return Boolean.TRUE.equals(this.getArgs().get("USE_MAPS"));
    }

    ClassLoader getClassLoader() {
        return (ClassLoader)this.args.get("CLASSLOADER");
    }

    protected Object convertParsedMapsToJava(JsonObject root) {
        try {
            Resolver resolver = this.useMaps() ? new MapResolver(this) : new ObjectResolver(this, (ClassLoader)this.args.get("CLASSLOADER"));
            resolver.createJavaObjectInstance(Object.class, root);
            Object graph = resolver.convertMapsToObjects(root);
            resolver.cleanup();
            this.readers.clear();
            return graph;
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {}
            if (e instanceof JsonIoException) {
                throw (JsonIoException)e;
            }
            throw new JsonIoException(this.getErrorMessage(e.getMessage()), e);
        }
    }

    public static Object newInstance(Class c, JsonObject jsonObject) {
        if (factory.containsKey(c.getName())) {
            Factory cf = factory.get(c.getName());
            if (cf instanceof ClassFactoryEx) {
                HashMap<String, JsonObject> args = new HashMap<String, JsonObject>();
                args.put("jsonObj", jsonObject);
                return ((ClassFactoryEx)cf).newInstance(c, args);
            }
            if (cf instanceof ClassFactory) {
                return ((ClassFactory)cf).newInstance(c);
            }
            throw new JsonIoException("Unknown instantiator (Factory) class.  Must subclass ClassFactoryEx or ClassFactory, found: " + cf.getClass().getName());
        }
        return MetaUtils.newInstance(c);
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to close input", e);
        }
    }

    private String getErrorMessage(String msg) {
        if (this.input != null) {
            return String.valueOf(msg) + "\nLast read: " + this.input.getLastSnippet() + "\nline: " + this.input.getLine() + ", col: " + this.input.getCol();
        }
        return msg;
    }

    public static interface ClassFactory
    extends Factory {
        public Object newInstance(Class var1);
    }

    public static interface ClassFactoryEx
    extends Factory {
        public Object newInstance(Class var1, Map var2);
    }

    public static class CollectionFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (List.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            if (SortedSet.class.isAssignableFrom(c)) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(c)) {
                return new LinkedHashSet();
            }
            if (Collection.class.isAssignableFrom(c)) {
                return new ArrayList();
            }
            throw new JsonIoException("CollectionFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static interface Factory {
    }

    public static interface JsonClassReader
    extends JsonClassReaderBase {
        public Object read(Object var1, Deque<JsonObject<String, Object>> var2);
    }

    public static interface JsonClassReaderBase {
    }

    public static interface JsonClassReaderEx
    extends JsonClassReaderBase {
        public Object read(Object var1, Deque<JsonObject<String, Object>> var2, Map<String, Object> var3);
    }

    public static class MapFactory
    implements ClassFactory {
        @Override
        public Object newInstance(Class c) {
            if (SortedMap.class.isAssignableFrom(c)) {
                return new TreeMap();
            }
            if (Map.class.isAssignableFrom(c)) {
                return new LinkedHashMap();
            }
            throw new JsonIoException("MapFactory handed Class for which it was not expecting: " + c.getName());
        }
    }

    public static interface MissingFieldHandler {
        public void fieldMissing(Object var1, String var2, Object var3);
    }
}

