/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import net.jsign.commons.io.HexDump;

abstract class SmartCard {
    private final CardChannel channel;
    protected String pin;
    protected final Map<Integer, byte[]> dataObjectCache = new HashMap<Integer, byte[]>();
    protected boolean debug;

    protected SmartCard(CardChannel channel) {
        this.channel = channel;
    }

    public void verify(String pin) {
        this.pin = pin;
    }

    protected ResponseAPDU transmit(CommandAPDU command) throws CardException {
        if (this.debug) {
            System.out.println(command);
            try {
                HexDump.dump(command.getBytes(), 0L, System.out, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        long t1 = System.nanoTime();
        ResponseAPDU response = this.channel.transmit(command);
        long t2 = System.nanoTime();
        if (this.debug) {
            System.out.println(response + " (" + (t2 - t1) / 1000000L + " ms)");
            if (response.getData().length > 0) {
                try {
                    HexDump.dump(response.getData(), 0L, System.out, 0);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            System.out.println();
        }
        return response;
    }

    protected void handleError(ResponseAPDU response) throws CardException {
        switch (response.getSW()) {
            case 36864: {
                return;
            }
            case 25536: 
            case 25537: 
            case 25538: 
            case 25539: 
            case 25540: 
            case 25541: 
            case 25542: 
            case 25543: 
            case 25544: 
            case 25545: 
            case 25546: 
            case 25547: 
            case 25548: 
            case 25549: 
            case 25550: 
            case 25551: {
                throw new CardException("PIN verification failed, " + (response.getSW() & 0xF) + " tries left");
            }
            case 26368: {
                throw new CardException("Wrong length");
            }
            case 27010: {
                throw new CardException("PIN verification required");
            }
            case 27011: {
                throw new CardException("PIN blocked");
            }
            case 27013: {
                throw new CardException("Conditions of use not satisfied");
            }
            case 27264: {
                throw new CardException("The parameters in the data field are incorrect");
            }
            case 27266: {
                throw new CardException("Incorrect P1 or P2 parameter");
            }
            case 27904: {
                throw new CardException("Instruction code not supported or invalid");
            }
        }
        throw new CardException("Error " + Integer.toHexString(response.getSW()));
    }

    static CardChannel openChannel(String name) throws CardException {
        CardTerminal terminal = SmartCard.getTerminal(name);
        if (terminal != null) {
            try {
                Card card = terminal.connect("T=1");
                return card.getBasicChannel();
            }
            catch (CardException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static CardTerminal getTerminal(String name) throws CardException {
        CardTerminals terminals = TerminalFactory.getDefault().terminals();
        for (CardTerminal terminal : terminals.list(CardTerminals.State.CARD_PRESENT)) {
            if (name != null && !terminal.getName().toLowerCase().contains(name.toLowerCase())) continue;
            return terminal;
        }
        return null;
    }
}

