/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.security.Key;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Vector;
import net.jsign.jca.AbstractKeyStoreSpi;
import net.jsign.jca.SigningService;

class SigningServiceKeyStore
extends AbstractKeyStoreSpi {
    private final SigningService service;

    public SigningServiceKeyStore(SigningService service) {
        this.service = service;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
        return this.service.getPrivateKey(alias, password);
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        try {
            return this.service.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        try {
            return new Vector<String>(this.service.aliases()).elements();
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

