/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.commons.io.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.jsign.commons.io.file.DeleteOption;

public final class PathUtils {
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileAttribute<?>[] EMPTY_FILE_ATTRIBUTE_ARRAY = new FileAttribute[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    @Deprecated
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    static final LinkOption NULL_LINK_OPTION = null;
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    public static Path createParentDirectories(Path path, LinkOption linkOption, FileAttribute<?> ... attrs) throws IOException {
        Path parent = PathUtils.getParent(path);
        Path path2 = parent = linkOption == LinkOption.NOFOLLOW_LINKS ? parent : PathUtils.readIfSymbolicLink(parent);
        if (parent == null) {
            return null;
        }
        boolean exists = linkOption == null ? Files.exists(parent, new LinkOption[0]) : Files.exists(parent, linkOption);
        return exists ? parent : Files.createDirectories(parent, attrs);
    }

    private static boolean exists(Path path, LinkOption ... options) {
        Objects.requireNonNull(path, "path");
        return options != null ? Files.exists(path, options) : Files.exists(path, new LinkOption[0]);
    }

    private static Path getParent(Path path) {
        return path == null ? null : path.getParent();
    }

    public static OutputStream newOutputStream(Path path, boolean append) throws IOException {
        return PathUtils.newOutputStream(path, EMPTY_LINK_OPTION_ARRAY, append ? OPEN_OPTIONS_APPEND : OPEN_OPTIONS_TRUNCATE);
    }

    static OutputStream newOutputStream(Path path, LinkOption[] linkOptions, OpenOption ... openOptions) throws IOException {
        if (!PathUtils.exists(path, linkOptions)) {
            PathUtils.createParentDirectories(path, linkOptions != null && linkOptions.length > 0 ? linkOptions[0] : NULL_LINK_OPTION, new FileAttribute[0]);
        }
        ArrayList<OpenOption> list = new ArrayList<OpenOption>(Arrays.asList(openOptions != null ? openOptions : EMPTY_OPEN_OPTION_ARRAY));
        list.addAll(Arrays.asList(linkOptions != null ? linkOptions : EMPTY_LINK_OPTION_ARRAY));
        return Files.newOutputStream(path, list.toArray(EMPTY_OPEN_OPTION_ARRAY));
    }

    private static Path readIfSymbolicLink(Path path) throws IOException {
        return path != null ? (Files.isSymbolicLink(path) ? Files.readSymbolicLink(path) : path) : null;
    }
}

