/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.util;

import java.util.NoSuchElementException;

public final class Arrays {
    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        return java.util.Arrays.equals(byArray, byArray2);
    }

    public static boolean areEqual(char[] cArray, char[] cArray2) {
        return java.util.Arrays.equals(cArray, cArray2);
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        return java.util.Arrays.equals(nArray, nArray2);
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n3 = byArray.length ^ byArray2.length;
        for (n = 0; n != n2; ++n) {
            n3 |= byArray[n] ^ byArray2[n];
        }
        for (n = n2; n < byArray2.length; ++n) {
            n3 |= byArray2[n] ^ ~byArray2[n];
        }
        return n3 == 0;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = byArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= byArray[n];
        }
        return n2;
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return 0;
        }
        int n3 = n2;
        int n4 = n3 + 1;
        while (--n3 >= 0) {
            n4 *= 257;
            n4 ^= byArray[n + n3];
        }
        return n4;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = cArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= cArray[n];
        }
        return n2;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = nArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= nArray[n];
        }
        return n2;
    }

    public static byte[] clone(byte[] byArray) {
        return null == byArray ? null : (byte[])byArray.clone();
    }

    public static int[] clone(int[] nArray) {
        return null == nArray ? null : (int[])nArray.clone();
    }

    public static long[] clone(long[] lArray) {
        return null == lArray ? null : (long[])lArray.clone();
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        int n3 = Arrays.getLength(n, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    private static int getLength(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        return n3;
    }

    public static byte[] prepend(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 1, n);
        byArray2[0] = by;
        return byArray2;
    }

    public static boolean isNullOrContainsNull(Object[] objectArray) {
        if (null == objectArray) {
            return true;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (null != objectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static class Iterator<T>
    implements java.util.Iterator<T> {
        private final T[] dataArray;
        private int position = 0;

        public Iterator(T[] TArray) {
            this.dataArray = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.dataArray.length;
        }

        @Override
        public T next() {
            if (this.position == this.dataArray.length) {
                throw new NoSuchElementException("Out of elements: " + this.position);
            }
            return this.dataArray[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from an Array.");
        }
    }
}

