/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.tsp;

import java.io.IOException;
import net.jsign.bouncycastle.asn1.cmp.PKIFreeText;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.jsign.bouncycastle.asn1.tsp.TimeStampResp;
import net.jsign.bouncycastle.tsp.TSPException;
import net.jsign.bouncycastle.tsp.TSPValidationException;
import net.jsign.bouncycastle.tsp.TimeStampRequest;
import net.jsign.bouncycastle.tsp.TimeStampToken;
import net.jsign.bouncycastle.tsp.TimeStampTokenInfo;
import net.jsign.bouncycastle.util.Arrays;

public class TimeStampResponse {
    TimeStampResp resp;
    TimeStampToken timeStampToken;

    public TimeStampResponse(TimeStampResp timeStampResp) throws TSPException, IOException {
        this.resp = timeStampResp;
        if (timeStampResp.getTimeStampToken() != null) {
            this.timeStampToken = new TimeStampToken(timeStampResp.getTimeStampToken());
        }
    }

    public int getStatus() {
        return this.resp.getStatus().getStatus().intValue();
    }

    public String getStatusString() {
        if (this.resp.getStatus().getStatusString() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            PKIFreeText pKIFreeText = this.resp.getStatus().getStatusString();
            for (int i = 0; i != pKIFreeText.size(); ++i) {
                stringBuffer.append(pKIFreeText.getStringAtUTF8(i).getString());
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public void validate(TimeStampRequest timeStampRequest) throws TSPException {
        TimeStampToken timeStampToken = this.getTimeStampToken();
        if (timeStampToken != null) {
            TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
            if (timeStampRequest.getNonce() != null && !timeStampRequest.getNonce().equals(timeStampTokenInfo.getNonce())) {
                throw new TSPValidationException("response contains wrong nonce value.");
            }
            if (this.getStatus() != 0 && this.getStatus() != 1) {
                throw new TSPValidationException("time stamp token found in failed request.");
            }
            if (!Arrays.constantTimeAreEqual(timeStampRequest.getMessageImprintDigest(), timeStampTokenInfo.getMessageImprintDigest())) {
                throw new TSPValidationException("response for different message imprint digest.");
            }
            if (!timeStampTokenInfo.getMessageImprintAlgOID().equals(timeStampRequest.getMessageImprintAlgOID())) {
                throw new TSPValidationException("response for different message imprint algorithm.");
            }
            Attribute attribute = timeStampToken.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            Attribute attribute2 = timeStampToken.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
            if (attribute == null && attribute2 == null) {
                throw new TSPValidationException("no signing certificate attribute present.");
            }
            if (attribute == null || attribute2 != null) {
                // empty if block
            }
            if (timeStampRequest.getReqPolicy() != null && !timeStampRequest.getReqPolicy().equals(timeStampTokenInfo.getPolicy())) {
                throw new TSPValidationException("TSA policy wrong for request.");
            }
        } else if (this.getStatus() == 0 || this.getStatus() == 1) {
            throw new TSPValidationException("no time stamp token found and one expected.");
        }
    }
}

