/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.tsp;

import java.math.BigInteger;
import net.jsign.bouncycastle.asn1.ASN1Boolean;
import net.jsign.bouncycastle.asn1.ASN1Integer;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.tsp.MessageImprint;
import net.jsign.bouncycastle.asn1.tsp.TimeStampReq;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.Extensions;
import net.jsign.bouncycastle.asn1.x509.ExtensionsGenerator;
import net.jsign.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import net.jsign.bouncycastle.tsp.TimeStampRequest;

public class TimeStampRequestGenerator {
    private static final DefaultDigestAlgorithmIdentifierFinder dgstAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
    private ASN1ObjectIdentifier reqPolicy;
    private ASN1Boolean certReq;
    private ExtensionsGenerator extGenerator = new ExtensionsGenerator();

    public void setCertReq(boolean bl) {
        this.certReq = ASN1Boolean.getInstance(bl);
    }

    public TimeStampRequest generate(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) {
        return this.generate(dgstAlgFinder.find(aSN1ObjectIdentifier), byArray);
    }

    public TimeStampRequest generate(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        return this.generate(algorithmIdentifier, byArray, null);
    }

    public TimeStampRequest generate(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, BigInteger bigInteger) {
        if (algorithmIdentifier == null) {
            throw new IllegalArgumentException("digest algorithm not specified");
        }
        MessageImprint messageImprint = new MessageImprint(algorithmIdentifier, byArray);
        Extensions extensions = null;
        if (!this.extGenerator.isEmpty()) {
            extensions = this.extGenerator.generate();
        }
        if (bigInteger != null) {
            return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, new ASN1Integer(bigInteger), this.certReq, extensions));
        }
        return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, null, this.certReq, extensions));
    }
}

