/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.math.raw;

import java.math.BigInteger;
import net.jsign.bouncycastle.util.Pack;

public abstract class Nat {
    public static int[] create(int n) {
        return new int[n];
    }

    public static int equalTo(int n, int[] nArray, int n2) {
        int n3 = nArray[0] ^ n2;
        for (int i = 1; i < n; ++i) {
            n3 |= nArray[i];
        }
        n3 = n3 >>> 1 | n3 & 1;
        return n3 - 1 >> 31;
    }

    public static int equalToZero(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 |= nArray[i];
        }
        n2 = n2 >>> 1 | n2 & 1;
        return n2 - 1 >> 31;
    }

    public static int[] fromBigInteger(int n, BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > n) {
            throw new IllegalArgumentException();
        }
        int n2 = n + 31 >> 5;
        int[] nArray = Nat.create(n2);
        for (int i = 0; i < n2; ++i) {
            nArray[i] = bigInteger.intValue();
            bigInteger = bigInteger.shiftRight(32);
        }
        return nArray;
    }

    public static BigInteger toBigInteger(int n, int[] nArray) {
        byte[] byArray = new byte[n << 2];
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            Pack.intToBigEndian(n2, byArray, n - 1 - i << 2);
        }
        return new BigInteger(1, byArray);
    }
}

