/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.math.ec;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.math.Primes;
import net.jsign.bouncycastle.math.ec.ECAlgorithms;
import net.jsign.bouncycastle.math.ec.ECFieldElement;
import net.jsign.bouncycastle.math.ec.ECMultiplier;
import net.jsign.bouncycastle.math.ec.ECPoint;
import net.jsign.bouncycastle.math.ec.LongArray;
import net.jsign.bouncycastle.math.ec.endo.ECEndomorphism;
import net.jsign.bouncycastle.math.field.FiniteField;
import net.jsign.bouncycastle.math.field.FiniteFields;
import net.jsign.bouncycastle.util.BigIntegers;
import net.jsign.bouncycastle.util.Integers;
import net.jsign.bouncycastle.util.Properties;

public abstract class ECCurve {
    protected FiniteField field;
    protected ECFieldElement a;
    protected ECFieldElement b;
    protected BigInteger order;
    protected BigInteger cofactor;
    protected int coord = 0;
    protected ECEndomorphism endomorphism = null;
    protected ECMultiplier multiplier = null;

    protected ECCurve(FiniteField finiteField) {
        this.field = finiteField;
    }

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract ECFieldElement randomFieldElementMult(SecureRandom var1);

    public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2) {
        return this.createRawPoint(this.fromBigInteger(bigInteger), this.fromBigInteger(bigInteger2));
    }

    protected abstract ECPoint createRawPoint(ECFieldElement var1, ECFieldElement var2);

    public ECPoint importPoint(ECPoint eCPoint) {
        if (this == eCPoint.getCurve()) {
            return eCPoint;
        }
        if (eCPoint.isInfinity()) {
            return this.getInfinity();
        }
        eCPoint = eCPoint.normalize();
        return this.createPoint(eCPoint.getXCoord().toBigInteger(), eCPoint.getYCoord().toBigInteger());
    }

    public void normalizeAll(ECPoint[] eCPointArray) {
        this.normalizeAll(eCPointArray, 0, eCPointArray.length, null);
    }

    public void normalizeAll(ECPoint[] eCPointArray, int n, int n2, ECFieldElement eCFieldElement) {
        int n3;
        this.checkPoints(eCPointArray, n, n2);
        switch (this.getCoordinateSystem()) {
            case 0: 
            case 5: {
                if (eCFieldElement != null) {
                    throw new IllegalArgumentException("'iso' not valid for affine coordinates");
                }
                return;
            }
        }
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[n2];
        int[] nArray = new int[n2];
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            ECPoint eCPoint = eCPointArray[n + n3];
            if (null == eCPoint || eCFieldElement == null && eCPoint.isNormalized()) continue;
            eCFieldElementArray[n4] = eCPoint.getZCoord(0);
            nArray[n4++] = n + n3;
        }
        if (n4 == 0) {
            return;
        }
        ECAlgorithms.montgomeryTrick(eCFieldElementArray, 0, n4, eCFieldElement);
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray[n3];
            eCPointArray[n5] = eCPointArray[n5].normalize(eCFieldElementArray[n3]);
        }
    }

    public abstract ECPoint getInfinity();

    public FiniteField getField() {
        return this.field;
    }

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    public int getCoordinateSystem() {
        return this.coord;
    }

    protected void checkPoints(ECPoint[] eCPointArray, int n, int n2) {
        if (eCPointArray == null) {
            throw new IllegalArgumentException("'points' cannot be null");
        }
        if (n < 0 || n2 < 0 || n > eCPointArray.length - n2) {
            throw new IllegalArgumentException("invalid range specified for 'points'");
        }
        for (int i = 0; i < n2; ++i) {
            ECPoint eCPoint = eCPointArray[n + i];
            if (null == eCPoint || this == eCPoint.getCurve()) continue;
            throw new IllegalArgumentException("'points' entries must be null or on this curve");
        }
    }

    public boolean equals(ECCurve eCCurve) {
        return this == eCCurve || null != eCCurve && this.getField().equals(eCCurve.getField()) && this.getA().toBigInteger().equals(eCCurve.getA().toBigInteger()) && this.getB().toBigInteger().equals(eCCurve.getB().toBigInteger());
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ECCurve && this.equals((ECCurve)object);
    }

    public int hashCode() {
        return this.getField().hashCode() ^ Integers.rotateLeft(this.getA().toBigInteger().hashCode(), 8) ^ Integers.rotateLeft(this.getB().toBigInteger().hashCode(), 16);
    }

    private static int getNumberOfIterations(int n, int n2) {
        if (n >= 1536) {
            return n2 <= 100 ? 3 : (n2 <= 128 ? 4 : 4 + (n2 - 128 + 1) / 2);
        }
        if (n >= 1024) {
            return n2 <= 100 ? 4 : (n2 <= 112 ? 5 : 5 + (n2 - 112 + 1) / 2);
        }
        if (n >= 512) {
            return n2 <= 80 ? 5 : (n2 <= 100 ? 7 : 7 + (n2 - 100 + 1) / 2);
        }
        return n2 <= 80 ? 40 : 40 + (n2 - 80 + 1) / 2;
    }

    public static abstract class AbstractF2m
    extends ECCurve {
        private BigInteger[] si = null;

        private static FiniteField buildField(int n, int n2, int n3, int n4) {
            int[] nArray;
            if ((n3 | n4) == 0) {
                int[] nArray2 = new int[3];
                nArray2[0] = 0;
                nArray2[1] = n2;
                nArray = nArray2;
                nArray2[2] = n;
            } else {
                int[] nArray3 = new int[5];
                nArray3[0] = 0;
                nArray3[1] = n2;
                nArray3[2] = n3;
                nArray3[3] = n4;
                nArray = nArray3;
                nArray3[4] = n;
            }
            int[] nArray4 = nArray;
            return FiniteFields.getBinaryExtensionField(nArray4);
        }

        protected AbstractF2m(int n, int n2, int n3, int n4) {
            super(AbstractF2m.buildField(n, n2, n3, n4));
        }

        @Override
        public ECPoint createPoint(BigInteger bigInteger, BigInteger bigInteger2) {
            ECFieldElement eCFieldElement = this.fromBigInteger(bigInteger);
            ECFieldElement eCFieldElement2 = this.fromBigInteger(bigInteger2);
            int n = this.getCoordinateSystem();
            switch (n) {
                case 5: 
                case 6: {
                    if (eCFieldElement.isZero()) {
                        if (eCFieldElement2.square().equals(this.getB())) break;
                        throw new IllegalArgumentException();
                    }
                    eCFieldElement2 = eCFieldElement2.divide(eCFieldElement).add(eCFieldElement);
                    break;
                }
            }
            return this.createRawPoint(eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
            int n = this.getFieldSize();
            ECFieldElement eCFieldElement = this.fromBigInteger(AbstractF2m.implRandomFieldElementMult(secureRandom, n));
            ECFieldElement eCFieldElement2 = this.fromBigInteger(AbstractF2m.implRandomFieldElementMult(secureRandom, n));
            return eCFieldElement.multiply(eCFieldElement2);
        }

        private static BigInteger implRandomFieldElementMult(SecureRandom secureRandom, int n) {
            BigInteger bigInteger;
            while ((bigInteger = BigIntegers.createRandomBigInteger(n, secureRandom)).signum() <= 0) {
            }
            return bigInteger;
        }
    }

    public static abstract class AbstractFp
    extends ECCurve {
        protected AbstractFp(BigInteger bigInteger) {
            super(FiniteFields.getPrimeField(bigInteger));
        }

        @Override
        public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
            BigInteger bigInteger = this.getField().getCharacteristic();
            ECFieldElement eCFieldElement = this.fromBigInteger(AbstractFp.implRandomFieldElementMult(secureRandom, bigInteger));
            ECFieldElement eCFieldElement2 = this.fromBigInteger(AbstractFp.implRandomFieldElementMult(secureRandom, bigInteger));
            return eCFieldElement.multiply(eCFieldElement2);
        }

        private static BigInteger implRandomFieldElementMult(SecureRandom secureRandom, BigInteger bigInteger) {
            BigInteger bigInteger2;
            while ((bigInteger2 = BigIntegers.createRandomBigInteger(bigInteger.bitLength(), secureRandom)).signum() <= 0 || bigInteger2.compareTo(bigInteger) >= 0) {
            }
            return bigInteger2;
        }
    }

    public static class F2m
    extends AbstractF2m {
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private ECPoint.F2m infinity;

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            super(n, n2, n3, n4);
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            this.order = bigInteger3;
            this.cofactor = bigInteger4;
            this.infinity = new ECPoint.F2m(this, null, null);
            this.a = this.fromBigInteger(bigInteger);
            this.b = this.fromBigInteger(bigInteger2);
            this.coord = 6;
        }

        @Override
        public int getFieldSize() {
            return this.m;
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            int[] nArray;
            if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.bitLength() > this.m) {
                throw new IllegalArgumentException("x value invalid in F2m field element");
            }
            if ((this.k2 | this.k3) == 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = this.k1;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = this.k1;
                nArray3[1] = this.k2;
                nArray = nArray3;
                nArray3[2] = this.k3;
            }
            int[] nArray4 = nArray;
            return new ECFieldElement.F2m(this.m, nArray4, new LongArray(bigInteger));
        }

        @Override
        protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            return new ECPoint.F2m(this, eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }
    }

    public static class Fp
    extends AbstractFp {
        private static final Set<BigInteger> knownQs = Collections.synchronizedSet(new HashSet());
        private static final BigIntegers.Cache validatedQs = new BigIntegers.Cache();
        BigInteger q;
        BigInteger r;
        ECPoint.Fp infinity;

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
            this(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, false);
        }

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, boolean bl) {
            super(bigInteger);
            if (bl) {
                this.q = bigInteger;
                knownQs.add(bigInteger);
            } else if (knownQs.contains(bigInteger) || validatedQs.contains(bigInteger)) {
                this.q = bigInteger;
            } else {
                int n = Properties.asInteger("net.jsign.bouncycastle.ec.fp_max_size", 1042);
                int n2 = Properties.asInteger("net.jsign.bouncycastle.ec.fp_certainty", 100);
                int n3 = bigInteger.bitLength();
                if (n < n3) {
                    throw new IllegalArgumentException("Fp q value out of range");
                }
                if (Primes.hasAnySmallFactors(bigInteger) || !Primes.isMRProbablePrime(bigInteger, CryptoServicesRegistrar.getSecureRandom(), ECCurve.getNumberOfIterations(n3, n2))) {
                    throw new IllegalArgumentException("Fp q value not prime");
                }
                validatedQs.add(bigInteger);
                this.q = bigInteger;
            }
            this.r = ECFieldElement.Fp.calculateResidue(bigInteger);
            this.infinity = new ECPoint.Fp(this, null, null);
            this.a = this.fromBigInteger(bigInteger2);
            this.b = this.fromBigInteger(bigInteger3);
            this.order = bigInteger4;
            this.cofactor = bigInteger5;
            this.coord = 4;
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger bigInteger) {
            if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.compareTo(this.q) >= 0) {
                throw new IllegalArgumentException("x value invalid for Fp field element");
            }
            return new ECFieldElement.Fp(this.q, this.r, bigInteger);
        }

        @Override
        protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            return new ECPoint.Fp(this, eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECPoint importPoint(ECPoint eCPoint) {
            if (this != eCPoint.getCurve() && this.getCoordinateSystem() == 2 && !eCPoint.isInfinity()) {
                switch (eCPoint.getCurve().getCoordinateSystem()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        return new ECPoint.Fp(this, this.fromBigInteger(eCPoint.x.toBigInteger()), this.fromBigInteger(eCPoint.y.toBigInteger()), new ECFieldElement[]{this.fromBigInteger(eCPoint.zs[0].toBigInteger())});
                    }
                }
            }
            return super.importPoint(eCPoint);
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }
    }
}

