/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.bouncycastle.jce.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jsign.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.jsign.bouncycastle.asn1.bc.BCObjectIdentifiers;
import net.jsign.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import net.jsign.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.jsign.bouncycastle.crypto.CryptoServiceConstraintsException;
import net.jsign.bouncycastle.crypto.CryptoServiceProperties;
import net.jsign.bouncycastle.crypto.CryptoServicesRegistrar;
import net.jsign.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.jsign.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import net.jsign.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import net.jsign.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import net.jsign.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import net.jsign.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import net.jsign.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import net.jsign.bouncycastle.pqc.jcajce.provider.bike.BIKEKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.cmce.CMCEKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.dilithium.DilithiumKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.falcon.FalconKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.hqc.HQCKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.kyber.KyberKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.lms.LMSKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.newhope.NHKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.ntru.NTRUKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.picnic.PicnicKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.sphincs.Sphincs256KeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.sphincsplus.SPHINCSPlusKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.xmss.XMSSKeyFactorySpi;
import net.jsign.bouncycastle.pqc.jcajce.provider.xmss.XMSSMTKeyFactorySpi;
import net.jsign.bouncycastle.util.Strings;

public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static final Logger LOG = Logger.getLogger(BouncyCastleProvider.class.getName());
    private static String info = "BouncyCastle Security Provider v1.77";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, "java.security.cert.PKIXRevocationChecker");
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final CryptoServiceProperties[] SYMMETRIC_CIPHERS = new CryptoServiceProperties[]{BouncyCastleProvider.service("AES", 256), BouncyCastleProvider.service("ARC4", 20), BouncyCastleProvider.service("ARIA", 256), BouncyCastleProvider.service("Blowfish", 128), BouncyCastleProvider.service("Camellia", 256), BouncyCastleProvider.service("CAST5", 128), BouncyCastleProvider.service("CAST6", 256), BouncyCastleProvider.service("ChaCha", 128), BouncyCastleProvider.service("DES", 56), BouncyCastleProvider.service("DESede", 112), BouncyCastleProvider.service("GOST28147", 128), BouncyCastleProvider.service("Grainv1", 128), BouncyCastleProvider.service("Grain128", 128), BouncyCastleProvider.service("HC128", 128), BouncyCastleProvider.service("HC256", 256), BouncyCastleProvider.service("IDEA", 128), BouncyCastleProvider.service("Noekeon", 128), BouncyCastleProvider.service("RC2", 128), BouncyCastleProvider.service("RC5", 128), BouncyCastleProvider.service("RC6", 256), BouncyCastleProvider.service("Rijndael", 256), BouncyCastleProvider.service("Salsa20", 128), BouncyCastleProvider.service("SEED", 128), BouncyCastleProvider.service("Serpent", 256), BouncyCastleProvider.service("Shacal2", 128), BouncyCastleProvider.service("Skipjack", 80), BouncyCastleProvider.service("SM4", 128), BouncyCastleProvider.service("TEA", 128), BouncyCastleProvider.service("Twofish", 256), BouncyCastleProvider.service("Threefish", 128), BouncyCastleProvider.service("VMPC", 128), BouncyCastleProvider.service("VMPCKSA3", 128), BouncyCastleProvider.service("XTEA", 128), BouncyCastleProvider.service("XSalsa20", 128), BouncyCastleProvider.service("OpenSSLPBKDF", 128), BouncyCastleProvider.service("DSTU7624", 256), BouncyCastleProvider.service("GOST3412_2015", 256), BouncyCastleProvider.service("Zuc", 128)};
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE", "EXTERNAL"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC", "LMS", "SPHINCSPlus", "Dilithium", "Falcon", "NTRU"};
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka", "Blake3"};
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};
    private Map<String, Provider.Service> serviceMap = new ConcurrentHashMap<String, Provider.Service>();

    public BouncyCastleProvider() {
        super("BC", 1.77, info);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastleProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.digest.", DIGESTS);
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_GENERIC);
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_MACS);
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_CIPHERS);
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_GENERIC);
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_CIPHERS);
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.keystore.", KEYSTORES);
        this.loadAlgorithms("net.jsign.bouncycastle.jcajce.provider.drbg.", SECURE_RANDOMS);
        this.loadPQCKeys();
        this.put("X509Store.CERTIFICATE/COLLECTION", "net.jsign.bouncycastle.jce.provider.X509StoreCertCollection");
        this.put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "net.jsign.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        this.put("X509Store.CRL/COLLECTION", "net.jsign.bouncycastle.jce.provider.X509StoreCRLCollection");
        this.put("X509Store.CERTIFICATEPAIR/COLLECTION", "net.jsign.bouncycastle.jce.provider.X509StoreCertPairCollection");
        this.put("X509Store.CERTIFICATE/LDAP", "net.jsign.bouncycastle.jce.provider.X509StoreLDAPCerts");
        this.put("X509Store.CRL/LDAP", "net.jsign.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        this.put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "net.jsign.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        this.put("X509Store.CERTIFICATEPAIR/LDAP", "net.jsign.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        this.put("X509StreamParser.CERTIFICATE", "net.jsign.bouncycastle.jce.provider.X509CertParser");
        this.put("X509StreamParser.ATTRIBUTECERTIFICATE", "net.jsign.bouncycastle.jce.provider.X509AttrCertParser");
        this.put("X509StreamParser.CRL", "net.jsign.bouncycastle.jce.provider.X509CRLParser");
        this.put("X509StreamParser.CERTIFICATEPAIR", "net.jsign.bouncycastle.jce.provider.X509CertPairParser");
        this.put("Cipher.BROKENPBEWITHMD5ANDDES", "net.jsign.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        this.put("Cipher.BROKENPBEWITHSHA1ANDDES", "net.jsign.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        this.put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "net.jsign.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        if (revChkClass != null) {
            this.put("CertPathValidator.RFC3281", "net.jsign.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3281", "net.jsign.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put("CertPathValidator.RFC3280", "net.jsign.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put("CertPathBuilder.RFC3280", "net.jsign.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put("CertPathValidator.PKIX", "net.jsign.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put("CertPathBuilder.PKIX", "net.jsign.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            this.put("CertPathValidator.RFC3281", "net.jsign.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3281", "net.jsign.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            this.put("CertPathValidator.RFC3280", "net.jsign.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put("CertPathBuilder.RFC3280", "net.jsign.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put("CertPathValidator.PKIX", "net.jsign.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put("CertPathBuilder.PKIX", "net.jsign.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        this.put("CertStore.Collection", "net.jsign.bouncycastle.jce.provider.CertStoreCollectionSpi");
        this.put("CertStore.LDAP", "net.jsign.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        this.put("CertStore.Multi", "net.jsign.bouncycastle.jce.provider.MultiCertStoreSpi");
        this.put("Alg.Alias.CertStore.X509LDAP", "LDAP");
        this.getService("SecureRandom", "DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Provider.Service getService(final String string, final String string2) {
        String string3 = Strings.toUpperCase(string2);
        final String string4 = string + "." + string3;
        Provider.Service service = this.serviceMap.get(string4);
        if (service == null) {
            BouncyCastleProvider bouncyCastleProvider = this;
            synchronized (bouncyCastleProvider) {
                service = !this.serviceMap.containsKey(string4) ? AccessController.doPrivileged(new PrivilegedAction<Provider.Service>(){

                    @Override
                    public Provider.Service run() {
                        Provider.Service service = BouncyCastleProvider.super.getService(string, string2);
                        if (service == null) {
                            return null;
                        }
                        BouncyCastleProvider.this.serviceMap.put(string4, service);
                        BouncyCastleProvider.super.remove(service.getType() + "." + service.getAlgorithm());
                        BouncyCastleProvider.super.putService(service);
                        return service;
                    }
                }) : this.serviceMap.get(string4);
            }
        }
        return service;
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            this.loadServiceClass(string, stringArray[i]);
        }
    }

    private void loadAlgorithms(String string, CryptoServiceProperties[] cryptoServicePropertiesArray) {
        for (int i = 0; i != cryptoServicePropertiesArray.length; ++i) {
            CryptoServiceProperties cryptoServiceProperties = cryptoServicePropertiesArray[i];
            try {
                CryptoServicesRegistrar.checkConstraints(cryptoServiceProperties);
                this.loadServiceClass(string, cryptoServiceProperties.getServiceName());
                continue;
            }
            catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("service for " + cryptoServiceProperties.getServiceName() + " ignored due to constraints");
            }
        }
    }

    private void loadServiceClass(String string, String string2) {
        Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, string + string2 + "$Mappings");
        if (clazz != null) {
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + string2 + "$Mappings : " + exception);
            }
        }
    }

    private void loadPQCKeys() {
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_128f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_192f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256s_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_haraka_256f_r3_simple, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_128s, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_192s, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_sha2_256s, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(new ASN1ObjectIdentifier("1.3.9999.6.4.10"), (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_128f, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_192f, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.sphincsPlus_shake_256f, (AsymmetricKeyInfoConverter)new SPHINCSPlusKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.sphincs256, (AsymmetricKeyInfoConverter)new Sphincs256KeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.newHope, (AsymmetricKeyInfoConverter)new NHKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmss, (AsymmetricKeyInfoConverter)new XMSSKeyFactorySpi());
        this.addKeyInfoConverter(PQCObjectIdentifiers.xmss_mt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(IsaraObjectIdentifiers.id_alg_xmssmt, (AsymmetricKeyInfoConverter)new XMSSMTKeyFactorySpi());
        this.addKeyInfoConverter(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, (AsymmetricKeyInfoConverter)new LMSKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.picnic_key, (AsymmetricKeyInfoConverter)new PicnicKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_512, (AsymmetricKeyInfoConverter)new FalconKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.falcon_1024, (AsymmetricKeyInfoConverter)new FalconKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium2_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium3_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.dilithium5_aes, (AsymmetricKeyInfoConverter)new DilithiumKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber512, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber768, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece348864_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece460896_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6688128_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece6960119_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.mceliece8192128_r3, (AsymmetricKeyInfoConverter)new CMCEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike128, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike192, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.bike256, (AsymmetricKeyInfoConverter)new BIKEKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc128, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc192, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.hqc256, (AsymmetricKeyInfoConverter)new HQCKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber512_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber768_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.kyber1024_aes, (AsymmetricKeyInfoConverter)new KyberKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048509, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps2048677, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhps4096821, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
        this.addKeyInfoConverter(BCObjectIdentifiers.ntruhrss701, (AsymmetricKeyInfoConverter)new NTRUKeyFactorySpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    private static CryptoServiceProperties service(String string, int n) {
        return new JcaCryptoService(string, n);
    }

    private static class JcaCryptoService
    implements CryptoServiceProperties {
        private final String name;
        private final int bitsOfSecurity;

        JcaCryptoService(String string, int n) {
            this.name = string;
            this.bitsOfSecurity = n;
        }

        @Override
        public String getServiceName() {
            return this.name;
        }
    }
}

