/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.appx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import net.jsign.appx.ZipRecord;

class Zip64EndOfCentralDirectoryRecord
extends ZipRecord {
    public int versionMadeBy = 45;
    public int versionNeededToExtract = 45;
    public int numberOfThisDisk;
    public int numberOfTheDiskWithTheStartOfTheCentralDirectory;
    public long numberOfEntriesOnThisDisk;
    public long numberOfEntries;
    public long centralDirectorySize;
    public long centralDirectoryOffset;
    public byte[] extensibleDataSector = new byte[0];

    Zip64EndOfCentralDirectoryRecord() {
    }

    public void read(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(56).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        if (buffer.remaining() < 56) {
            throw new IOException("Invalid ZIP64 End of Central Directory Record");
        }
        int signature = buffer.getInt();
        if (signature != 101075792) {
            throw new IOException("Invalid ZIP64 End of Central Directory Record signature " + String.format("0x%04x", (long)signature & 0xFFFFFFFFL));
        }
        long sizeOfZip64EndOfCentralDirectoryRecord = buffer.getLong();
        this.versionMadeBy = buffer.getShort();
        this.versionNeededToExtract = buffer.getShort();
        this.numberOfThisDisk = buffer.getInt();
        this.numberOfTheDiskWithTheStartOfTheCentralDirectory = buffer.getInt();
        this.numberOfEntriesOnThisDisk = buffer.getLong();
        this.numberOfEntries = buffer.getLong();
        this.centralDirectorySize = buffer.getLong();
        this.centralDirectoryOffset = buffer.getLong();
        long recordSize = sizeOfZip64EndOfCentralDirectoryRecord + 4L + 8L;
        int extensibleDataSectorSize = (int)(recordSize - 56L);
        if (extensibleDataSectorSize > 0x100000) {
            throw new IOException("The extensible data sector of the ZIP64 End of Central Directory Record is too large (" + extensibleDataSectorSize + " bytes)");
        }
        if (extensibleDataSectorSize > 0) {
            this.extensibleDataSector = new byte[extensibleDataSectorSize];
            channel.read(ByteBuffer.wrap(this.extensibleDataSector));
        }
    }

    @Override
    public ByteBuffer toBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(56 + this.extensibleDataSector.length).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(101075792);
        long sizeOfZip64EndOfCentralDirectoryRecord = this.extensibleDataSector.length + 56 - 4 - 8;
        buffer.putLong(sizeOfZip64EndOfCentralDirectoryRecord);
        buffer.putShort((short)this.versionMadeBy);
        buffer.putShort((short)this.versionNeededToExtract);
        buffer.putInt(this.numberOfThisDisk);
        buffer.putInt(this.numberOfTheDiskWithTheStartOfTheCentralDirectory);
        buffer.putLong(this.numberOfEntriesOnThisDisk);
        buffer.putLong(this.numberOfEntries);
        buffer.putLong(this.centralDirectorySize);
        buffer.putLong(this.centralDirectoryOffset);
        buffer.put(this.extensibleDataSector);
        buffer.flip();
        return buffer;
    }
}

