/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.appx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import net.jsign.appx.ZipRecord;

class LocalFileHeader
extends ZipRecord {
    public int versionNeededToExtract;
    public int generalPurposeBitFlag;
    public int compressionMethod;
    public int lastModFileTime;
    public int lastModFileDate;
    public int crc32;
    public long compressedSize;
    public long uncompressedSize;
    public byte[] fileName = new byte[0];
    public byte[] extraField = new byte[0];

    LocalFileHeader() {
    }

    public void read(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(30).order(ByteOrder.LITTLE_ENDIAN);
        channel.read(buffer);
        buffer.flip();
        if (buffer.remaining() < 30) {
            throw new IOException("Invalid Local File Header");
        }
        int signature = buffer.getInt();
        if (signature != 67324752) {
            throw new IOException("Invalid Local File Header signature " + String.format("0x%04x", (long)signature & 0xFFFFFFFFL));
        }
        this.versionNeededToExtract = buffer.getShort();
        this.generalPurposeBitFlag = buffer.getShort();
        this.compressionMethod = buffer.getShort();
        this.lastModFileTime = buffer.getShort();
        this.lastModFileDate = buffer.getShort();
        this.crc32 = buffer.getInt();
        this.compressedSize = (long)buffer.getInt() & 0xFFFFFFFFL;
        this.uncompressedSize = (long)buffer.getInt() & 0xFFFFFFFFL;
        int fileNameLength = buffer.getShort() & 0xFFFF;
        int extraFieldsLength = buffer.getShort() & 0xFFFF;
        if (fileNameLength > 0) {
            this.fileName = new byte[fileNameLength];
            channel.read(ByteBuffer.wrap(this.fileName));
        }
        if (extraFieldsLength > 0) {
            byte[] extraFields = new byte[extraFieldsLength];
            channel.read(ByteBuffer.wrap(extraFields));
        }
    }

    @Override
    public ByteBuffer toBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(30 + this.fileName.length + this.extraField.length).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(67324752);
        buffer.putShort((short)this.versionNeededToExtract);
        buffer.putShort((short)this.generalPurposeBitFlag);
        buffer.putShort((short)this.compressionMethod);
        buffer.putShort((short)this.lastModFileTime);
        buffer.putShort((short)this.lastModFileDate);
        buffer.putInt(this.crc32);
        buffer.putInt((int)this.compressedSize);
        buffer.putInt((int)this.uncompressedSize);
        buffer.putShort((short)this.fileName.length);
        buffer.putShort((short)this.extraField.length);
        buffer.put(this.fileName);
        buffer.put(this.extraField);
        buffer.flip();
        return buffer;
    }
}

