/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.appx;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import net.jsign.ChannelUtils;
import net.jsign.DigestAlgorithm;
import net.jsign.Signable;
import net.jsign.appx.CentralDirectory;
import net.jsign.appx.CentralDirectoryFileHeader;
import net.jsign.appx.ZipFile;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.asn1.authenticode.SpcAttributeTypeAndOptionalValue;
import net.jsign.asn1.authenticode.SpcIndirectDataContent;
import net.jsign.asn1.authenticode.SpcSipInfo;
import net.jsign.asn1.authenticode.SpcUuid;
import net.jsign.bouncycastle.asn1.ASN1Encodable;
import net.jsign.bouncycastle.asn1.ASN1InputStream;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.DERNull;
import net.jsign.bouncycastle.asn1.cms.Attribute;
import net.jsign.bouncycastle.asn1.cms.AttributeTable;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.jsign.bouncycastle.asn1.x509.DigestInfo;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.bouncycastle.cms.SignerInformation;
import net.jsign.commons.io.FileUtils;
import net.jsign.commons.io.output.NullOutputStream;
import net.jsign.poi.util.IOUtils;

public class APPXFile
extends ZipFile
implements Signable {
    public APPXFile(File file) throws IOException {
        super(file);
        this.verifyPackage();
    }

    private void verifyPackage() throws IOException {
        if (this.centralDirectory.entries.get("[Content_Types].xml") == null) {
            throw new IOException("Invalid APPX/MSIX package, [Content_Types].xml is missing");
        }
    }

    @Override
    public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        this.addContentType("/AppxSignature.p7x", "application/vnd.ms-appx.signature");
        long endOfContentOffset = this.centralDirectory.centralDirectoryOffset;
        if (this.centralDirectory.entries.containsKey("AppxSignature.p7x")) {
            endOfContentOffset = this.centralDirectory.entries.get("AppxSignature.p7x").getLocalHeaderOffset();
        }
        MessageDigest axpc = digestAlgorithm.getMessageDigest();
        ChannelUtils.updateDigest(this.channel, axpc, 0L, endOfContentOffset);
        MessageDigest axcd = digestAlgorithm.getMessageDigest();
        axcd.update(this.getUnsignedCentralDirectory());
        MessageDigest axct = digestAlgorithm.getMessageDigest();
        IOUtils.copy(this.getInputStream("[Content_Types].xml"), new DigestOutputStream(NullOutputStream.NULL_OUTPUT_STREAM, axct));
        MessageDigest axbm = digestAlgorithm.getMessageDigest();
        IOUtils.copy(this.getInputStream("AppxBlockMap.xml"), new DigestOutputStream(NullOutputStream.NULL_OUTPUT_STREAM, axbm));
        MessageDigest axci = null;
        if (this.centralDirectory.entries.containsKey("AppxMetadata/CodeIntegrity.cat")) {
            axci = digestAlgorithm.getMessageDigest();
            IOUtils.copy(this.getInputStream("AppxMetadata/CodeIntegrity.cat"), new DigestOutputStream(NullOutputStream.NULL_OUTPUT_STREAM, axci));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("APPX".getBytes());
        out.write("AXPC".getBytes());
        out.write(axpc.digest());
        out.write("AXCD".getBytes());
        out.write(axcd.digest());
        out.write("AXCT".getBytes());
        out.write(axct.digest());
        out.write("AXBM".getBytes());
        out.write(axbm.digest());
        if (axci != null) {
            out.write("AXCI".getBytes());
            out.write(axci.digest());
        }
        return out.toByteArray();
    }

    /*
     * Loose catch block
     */
    private byte[] getUnsignedCentralDirectory() throws IOException {
        CentralDirectory centralDirectory = new CentralDirectory();
        centralDirectory.read(this.channel);
        if (centralDirectory.entries.containsKey("AppxSignature.p7x")) {
            CentralDirectoryFileHeader signatureHeader = centralDirectory.entries.get("AppxSignature.p7x");
            centralDirectory.entries.remove("AppxSignature.p7x");
            centralDirectory.centralDirectoryOffset = signatureHeader.getLocalHeaderOffset();
        }
        File tmp = File.createTempFile("jsign-zip-central-directory", ".bin");
        tmp.deleteOnExit();
        try {
            try (RandomAccessFile raf = new RandomAccessFile(tmp, "rw");){
                centralDirectory.write(raf.getChannel(), centralDirectory.centralDirectoryOffset);
                byte[] byArray = FileUtils.readFileToByteArray(tmp);
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            tmp.delete();
        }
    }

    @Override
    public ASN1Object createIndirectData(DigestAlgorithm digestAlgorithm) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgorithm.oid, DERNull.INSTANCE);
        DigestInfo digestInfo = new DigestInfo(algorithmIdentifier, this.computeDigest(digestAlgorithm));
        boolean bundle = this.centralDirectory.entries.containsKey("AppxBundleManifest.xml");
        SpcUuid uuid = new SpcUuid(bundle ? "B3585F0F-DEAA-9A4B-A434-95742D92ECEB" : "4BDFC50A-07CE-E24D-B76E-23C839A09FD1");
        SpcAttributeTypeAndOptionalValue data = new SpcAttributeTypeAndOptionalValue(AuthenticodeObjectIdentifiers.SPC_SIPINFO_OBJID, new SpcSipInfo(0x1010000, uuid));
        return new SpcIndirectDataContent(data, digestInfo);
    }

    @Override
    public List<CMSSignedData> getSignatures() throws IOException {
        ArrayList<CMSSignedData> signatures = new ArrayList<CMSSignedData>();
        if (this.centralDirectory.entries.containsKey("AppxSignature.p7x")) {
            InputStream in = this.getInputStream("AppxSignature.p7x", 0x100000);
            in.skip(4L);
            byte[] signatureBytes = IOUtils.toByteArray(in);
            try {
                Attribute nestedSignatures;
                CMSSignedData signedData = new CMSSignedData(null, ContentInfo.getInstance(new ASN1InputStream(signatureBytes).readObject()));
                signatures.add(signedData);
                SignerInformation signerInformation = signedData.getSignerInfos().getSigners().iterator().next();
                AttributeTable unsignedAttributes = signerInformation.getUnsignedAttributes();
                if (unsignedAttributes != null && (nestedSignatures = unsignedAttributes.get(AuthenticodeObjectIdentifiers.SPC_NESTED_SIGNATURE_OBJID)) != null) {
                    for (ASN1Encodable nestedSignature : nestedSignatures.getAttrValues()) {
                        signatures.add(new CMSSignedData(null, ContentInfo.getInstance(nestedSignature)));
                    }
                }
            }
            catch (UnsupportedOperationException signedData) {
            }
            catch (Exception | StackOverflowError e) {
                e.printStackTrace();
            }
        }
        return signatures;
    }

    @Override
    public void setSignature(CMSSignedData signature) throws IOException {
        if (this.centralDirectory.entries.containsKey("AppxSignature.p7x")) {
            this.removeEntry("AppxSignature.p7x");
        }
        if (signature != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write("PKCX".getBytes());
            signature.toASN1Structure().encodeTo(out, "DER");
            this.addEntry("AppxSignature.p7x", out.toByteArray(), false);
        }
    }

    void addContentType(String partName, String contentType) throws IOException {
        String override;
        InputStream in = this.getInputStream("[Content_Types].xml", 0xA00000);
        String contentTypes = new String(IOUtils.toByteArray(in), StandardCharsets.UTF_8);
        if (!contentTypes.contains(override = "<Override PartName=\"" + partName + "\" ContentType=\"" + contentType + "\"/>")) {
            contentTypes = contentTypes.replace("</Types>", "<Override PartName=\"" + partName + "\" ContentType=\"" + contentType + "\"/></Types>");
            this.renameEntry("[Content_Types].xml", "[Content_Types].old");
            this.addEntry("[Content_Types].xml", contentTypes.getBytes(), true);
        }
    }

    @Override
    public void save() throws IOException {
    }
}

