/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.List;
import net.jsign.DigestAlgorithm;
import net.jsign.appx.APPXFile;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.bouncycastle.asn1.ASN1Object;
import net.jsign.bouncycastle.asn1.cms.ContentInfo;
import net.jsign.bouncycastle.cms.CMSSignedData;
import net.jsign.cat.CatalogFile;
import net.jsign.mscab.MSCabinetFile;
import net.jsign.msi.MSIFile;
import net.jsign.navx.NAVXFile;
import net.jsign.pe.PEFile;
import net.jsign.script.JScript;
import net.jsign.script.PowerShellScript;
import net.jsign.script.PowerShellXMLScript;
import net.jsign.script.VBScript;
import net.jsign.script.WindowsScript;

public interface Signable
extends Closeable {
    default public ContentInfo createContentInfo(DigestAlgorithm digestAlgorithm) throws IOException {
        return new ContentInfo(AuthenticodeObjectIdentifiers.SPC_INDIRECT_DATA_OBJID, this.createIndirectData(digestAlgorithm));
    }

    default public byte[] computeDigest(MessageDigest digest) throws IOException {
        return this.computeDigest(DigestAlgorithm.of(digest.getAlgorithm()));
    }

    default public byte[] computeDigest(DigestAlgorithm digestAlgorithm) throws IOException {
        return this.computeDigest(digestAlgorithm.getMessageDigest());
    }

    public ASN1Object createIndirectData(DigestAlgorithm var1) throws IOException;

    public List<CMSSignedData> getSignatures() throws IOException;

    public void setSignature(CMSSignedData var1) throws IOException;

    public void save() throws IOException;

    public static Signable of(File file) throws IOException {
        return Signable.of(file, null);
    }

    public static Signable of(File file, Charset encoding) throws IOException {
        if (PEFile.isPEFile(file)) {
            return new PEFile(file);
        }
        if (MSIFile.isMSIFile(file)) {
            return new MSIFile(file);
        }
        if (MSCabinetFile.isMSCabinetFile(file)) {
            return new MSCabinetFile(file);
        }
        if (CatalogFile.isCatalogFile(file)) {
            return new CatalogFile(file);
        }
        if (NAVXFile.isNAVXFile(file)) {
            return new NAVXFile(file);
        }
        if (file.getName().toLowerCase().endsWith(".ps1") || file.getName().toLowerCase().endsWith(".psd1") || file.getName().toLowerCase().endsWith(".psm1")) {
            return new PowerShellScript(file, encoding);
        }
        if (file.getName().toLowerCase().endsWith(".ps1xml")) {
            return new PowerShellXMLScript(file, encoding);
        }
        if (file.getName().toLowerCase().endsWith(".vbs") || file.getName().toLowerCase().endsWith(".vbe")) {
            return new VBScript(file, encoding);
        }
        if (file.getName().toLowerCase().endsWith(".js") || file.getName().toLowerCase().endsWith(".jse")) {
            return new JScript(file, encoding);
        }
        if (file.getName().toLowerCase().endsWith(".wsf")) {
            return new WindowsScript(file, encoding);
        }
        if (file.getName().toLowerCase().endsWith(".msix") || file.getName().toLowerCase().endsWith(".msixbundle") || file.getName().toLowerCase().endsWith(".appx") || file.getName().toLowerCase().endsWith(".appxbundle")) {
            return new APPXFile(file);
        }
        throw new UnsupportedOperationException("Unsupported file: " + file);
    }
}

