/*
 * Decompiled with CFR 0.152.
 */
package net.jsign;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;

public class ChannelUtils {
    public static void copy(SeekableByteChannel src, WritableByteChannel dest) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        src.position(0L);
        while (src.position() < src.size()) {
            buffer.clear();
            src.read(buffer);
            buffer.flip();
            dest.write(buffer);
        }
    }

    public static void copy(SeekableByteChannel src, SeekableByteChannel dest, long length) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        long remaining = length;
        long destOffset = dest.position();
        long srcOffset = src.position();
        while (remaining > 0L) {
            int avail = (int)Math.min(remaining, (long)buffer.capacity());
            buffer.clear();
            buffer.limit(avail);
            src.position(srcOffset);
            src.read(buffer);
            buffer.flip();
            dest.position(destOffset);
            dest.write(buffer);
            remaining -= (long)buffer.position();
            srcOffset += (long)buffer.position();
            destOffset += (long)buffer.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(SeekableByteChannel channel, long position, byte[] data) throws IOException {
        if (position > channel.size()) {
            throw new IOException("Cannot insert data after the end of the file");
        }
        File backupFile = File.createTempFile("jsign", ".tmp");
        try (SeekableByteChannel backupChannel = Files.newByteChannel(backupFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            ChannelUtils.copy(channel, backupChannel);
            channel.position(position);
            channel.write(ByteBuffer.wrap(data));
            backupChannel.position(position);
            ChannelUtils.copy(backupChannel, channel, backupChannel.size() - position);
        }
        finally {
            backupFile.delete();
        }
    }

    public static void updateDigest(SeekableByteChannel channel, MessageDigest digest, long startOffset, long endOffset) throws IOException {
        channel.position(startOffset);
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        for (long position = startOffset; position < endOffset; position += (long)buffer.limit()) {
            buffer.clear();
            buffer.limit((int)Math.min((long)buffer.capacity(), endOffset - position));
            channel.read(buffer);
            buffer.rewind();
            digest.update(buffer);
        }
    }

    public static byte[] readNullTerminatedString(ByteChannel channel) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte singleChar;
            ByteBuffer buffer = ByteBuffer.allocate(1);
            do {
                buffer.clear();
                buffer.limit(1);
                if (channel.read(buffer) < 0) {
                    throw new IOException("End of file reached, cannot read null terminated string");
                }
                buffer.flip();
                singleChar = buffer.array()[0];
                bos.write(singleChar);
            } while (singleChar != 0);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

