Howdy y'all,

Sean Riddle is an absolute pioneer of ROM extraction photography, so
much so that he predates the modern standard of ASCII art dumps.

For a concrete example, his [NEC
uCOM4](https://seanriddle.com/necucom4.html) dump of Fabulous Fred has
a [raw rom dump](https://seanriddle.com/ffredraw.bin) that is just
bytes, exactly the same size as the [decoded
rom](https://seanriddle.com/ffred.bin).

From the [Zorrom README](https://github.com/JohnDMcMaster/zorrom),
bits are simply packed and the row length forgotten about.  The most
significant bit comes first, and each byte is in order.  We can see
this in converting the Fabulous Fred ROM.

```
dell% python3 ~/svn/zorrom/rawbin2txt.py --width 128 ffredraw.bin ffredraw.txt
128w x 128h => 16384 bits
dell% hd ffredraw.bin|head -n 1
9a       00       49       08       ...
dell% head -n1 ffredraw.txt 
10011010 00000000 01001001 00001000 ...
dell% 
```

In GatoRom, these raw binaries are also supported.  Simply pass
`--seanriddle 128` to explain the 128-bit wide raw binary format to
the CLI, or use the `GatoROM(QByteArray input, uint32_t width)`
constructor in C++.

--Travis
