/*
 * Copyright (c) 2023, Trail of Bits, Inc.
 *
 * This source code is licensed in accordance with the terms specified in
 * the LICENSE file found in the root directory of this source tree.
 */
//===--- BuiltinsX86.def - X86 Builtin function database --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Wipen Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This file defines the X86-specific builtin function database.  Users of
// this file must define the TARGET_BUILTIN macro to make use of this information.
//
//===----------------------------------------------------------------------===//

// These are intrinsics that, over time, have been removed from Clang, but may
// still be required by older Clang or GCC versions, or may be required by
// AppleClang but are not in our cxx-common Clang.

TARGET_BUILTIN(__builtin_ia32_pmaxsb128, "V16cV16cV16c", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxsd128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxud128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxuw128, "V8sV8sV8s", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminsb128, "V16cV16cV16c", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminsd128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminud128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminuw128, "V8sV8sV8s", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxub256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxuw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxud256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsd256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminub256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminuw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminud256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminsb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminsw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminsd256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsd512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxsq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxud512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxuq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminsd512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminsq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminud512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminuq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxsb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxsw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxub512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxuw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminsb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminsw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminub512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminuw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxsq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pmaxsq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pmaxuq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pmaxuq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminsq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminsq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminuq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminuq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")


TARGET_BUILTIN(__builtin_ia32_pabsb128, "V16cV16c", "~ncV:128:", "ssse3")
TARGET_BUILTIN(__builtin_ia32_pabsw128, "V8sV8s", "~ncV:128:", "ssse3")
TARGET_BUILTIN(__builtin_ia32_pabsd128, "V4iV4i", "~ncV:128:", "ssse3")
TARGET_BUILTIN(__builtin_ia32_pabsb256, "V32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pabsw256, "V16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pabsd256, "V8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pabsd512, "V16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pabsq512, "V8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pabsb512, "V64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pabsw512, "V32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pabsq128, "V2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pabsq256, "V4WiV4Wi", "~ncV:256:", "avx512vl")

TARGET_BUILTIN(__builtin_ia32_paddsb128, "V16cV16cV16c", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_paddsw128, "V8sV8sV8s", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_psubsb128, "V16cV16cV16c", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_psubsw128, "V8sV8sV8s", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_paddusb128, "V16cV16cV16c", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_paddusw128, "V8sV8sV8s", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_psubusb128, "V16cV16cV16c", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_psubusw128, "V8sV8sV8s", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_paddsb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_paddsw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_psubsb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_psubsw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_paddusb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_paddusw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_psubusb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_psubusw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_paddsb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_paddsw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_paddusb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_paddusw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_psubsb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_psubsw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_psubusb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_psubusw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")

TARGET_BUILTIN(__builtin_ia32_pmaxub128, "V16cV16cV16c", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_pmaxsw128, "V8sV8sV8s", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_pminub128, "V16cV16cV16c", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_pminsw128, "V8sV8sV8s", "~ncV:128:", "sse2")
TARGET_BUILTIN(__builtin_ia32_pmaxsb128, "V16cV16cV16c", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxsd128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxud128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxuw128, "V8sV8sV8s", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminsb128, "V16cV16cV16c", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminsd128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminud128, "V4iV4iV4i", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pminuw128, "V8sV8sV8s", "~ncV:128:", "sse4.1")
TARGET_BUILTIN(__builtin_ia32_pmaxub256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxuw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxud256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsd256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminub256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminuw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminud256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminsb256, "V32cV32cV32c", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminsw256, "V16sV16sV16s", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pminsd256, "V8iV8iV8i", "~ncV:256:", "avx2")
TARGET_BUILTIN(__builtin_ia32_pmaxsd512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxsq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxud512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxuq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminsd512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminsq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminud512, "V16iV16iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pminuq512, "V8WiV8WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_pmaxsb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxsw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxub512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxuw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminsb512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminsw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminub512, "V64cV64cV64c", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pminuw512, "V32sV32sV32s", "~ncV:512:", "avx512bw")
TARGET_BUILTIN(__builtin_ia32_pmaxsq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pmaxsq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pmaxuq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pmaxuq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminsq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminsq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminuq128, "V2WiV2WiV2Wi", "~ncV:128:", "avx512vl")
TARGET_BUILTIN(__builtin_ia32_pminuq256, "V4WiV4WiV4Wi", "~ncV:256:", "avx512vl")

// generic reduction intrinsics
TARGET_BUILTIN(__builtin_ia32_reduce_add_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_add_q512, "WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_and_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_and_q512, "WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_fadd_pd512, "ddV8d", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_fadd_ps512, "ffV16f", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_fmul_pd512, "ddV8d", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_fmul_ps512, "ffV16f", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_mul_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_mul_q512, "WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_or_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_or_q512, "WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_smax_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_smax_q512, "WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_smin_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_smin_q512, "WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_umax_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_umax_q512, "WiV8Wi", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_umin_d512, "iV16i", "~ncV:512:", "avx512f")
TARGET_BUILTIN(__builtin_ia32_reduce_umin_q512, "WiV8Wi", "~ncV:512:", "avx512f")

// Auto-generated from gcc_builtin_headers_ia32.h from CBMC:
TARGET_BUILTIN(__builtin_fabsq, "LLdLLd", "~nc", "")
TARGET_BUILTIN(__builtin_copysignq, "LLdLLdLLd", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pause, "v", "~nc", "")
TARGET_BUILTIN(__builtin_infq, "LLd", "~nc", "")
TARGET_BUILTIN(__builtin_huge_valq, "LLd", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_paddb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_paddw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_paddd, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubd, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_paddsb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_paddsw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubsb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubsw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_paddusb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_paddusw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubusb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubusw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmullw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pand, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pandn, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_por, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pxor, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqd, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtd, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhbw, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhwd, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhdq, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklbw, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklwd, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_punpckldq, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_packsswb, "V8cV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_packssdw, "V4sV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_packuswb, "V8cV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psllw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pslld, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psllq, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrlw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrld, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrlq, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psraw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrad, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psllwi, "V4sV4si", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pslldi, "V2iV2ii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psllqi, "V1WiV1Wii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrlwi, "V4sV4si", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrldi, "V2iV2ii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrlqi, "V1WiV1Wii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psrawi, "V4sV4si", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psradi, "V2iV2ii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhuw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pavgb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pavgw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psadbw, "V1WiV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxub, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pminub, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pminsw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pextrw, "iV4si", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pinsrw, "V4sV4sii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmovmskb, "iV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_maskmovq, "vV8cV8cc*", "~nV:64:", "")
TARGET_BUILTIN(__builtin_ia32_movntq, "vv*.", "~n", "")
TARGET_BUILTIN(__builtin_ia32_sfence, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comieq, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comineq, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comilt, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comile, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comigt, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comige, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomieq, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomineq, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomilt, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomile, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomigt, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomige, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpeqps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpltps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpleps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpgtps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpgeps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpunordps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpneqps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnltps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnleps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpngtps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpngeps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpordps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpeqss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpltss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpless, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpunordss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpneqss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnlts, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnless, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpordss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andnps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_orps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_xorps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movhlps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movlhps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpi2ps, "V4fV4fV2i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsi2ss, "V4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2pi, "V2iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtss2si, "iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2pi, "V2iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttss2si, "iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcpps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcpss, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtss, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtss, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_shufps, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movntps, "vf*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movmskps, "iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadaps, "V4ff*", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storeaps, "vf*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadups, "V4ffC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storeups, "vf*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadsss, "V4ff*", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storess, "vf*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadhps, "V4fV4fvC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadlps, "V4fV4fvC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storehps, "vv*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storelps, "vv*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadlv4si, "V4iV2iC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storelv4si, "vV2i*V4i", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movqv4si, "V4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comisdeq, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comisdlt, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comisdle, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comisdgt, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comisdge, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comisdneq, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomisdeq, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomisdlt, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomisdle, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomisdgt, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomisdge, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucomisdneq, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpeqpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpltpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmplepd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpgtpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpgepd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpunordpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpneqpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnltpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnlepd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpngtpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpngepd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpordpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpeqsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpltsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmplesd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpunordsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpneqsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnltsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnlesd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpordsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddq, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psubq, "V1WiV1WiV1Wi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_addpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andnpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_orpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_xorpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movsd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmullw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pand128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pandn128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_por128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pxor128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pavgb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pavgw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxub128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminub128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminsw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhbw128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhwd128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhdq128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhqdq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklbw128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklwd128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckldq128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklqdq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packsswb128, "V16cV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packssdw128, "V8sV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packuswb128, "V16cV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhuw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskmovdqu, "vV16cV16cc*", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadupd, "V2ddC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storeupd, "vd*V2d", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadhpd, "V2dV2ddC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadlpd, "V2dV2ddC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movmskpd, "iV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovmskb128, "iV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movnti, "vi*i", "~n", "")
TARGET_BUILTIN(__builtin_ia32_movnti64, "vLLi*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_movntpd, "vd*V2d", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movntdq, "vV2Wi*V2Wi", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshufd, "V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshuflw, "V8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshufhw, "V8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psadbw128, "V2WiV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtpd, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtsd, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_shufpd, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2pd, "V2dV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2ps, "V4fV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2dq, "V4iV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2pi, "V2iV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2ps, "V4fV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2dq, "V4iV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2pi, "V2iV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpi2pd, "V2dV2i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsd2si, "iV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttsd2si, "iV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsd2si64, "LLiV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttsd2si64, "LLiV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2dq, "V4iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2pd, "V2dV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2dq, "V4iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsi2sd, "V2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsi642sd, "V2dV2dLLi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsd2ss, "V4fV4fV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtss2sd, "V2dV2dV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_clflush, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_cldemote, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_clflushopt, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_clwb, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_clzero, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_lfence, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_mfence, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_loaddqu, "V16ccC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storedqu, "vc*V16c", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmuludq, "V1WiV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmuludq128, "V2WiV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pslld128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrld128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psraw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrad128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pslldqi128, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllwi128, "V8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pslldi128, "V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllqi128, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrldqi128, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlwi128, "V8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrldi128, "V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlqi128, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrawi128, "V8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psradi128, "V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddwd128, "V4iV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movq128, "V2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addsubpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addsubps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_haddpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_haddps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_hsubpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_hsubps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_lddqu, "V16ccC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_monitor, "vv*UiUi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_movddup, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movshdup, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movsldup, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mwait, "vUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_loadddup, "V2ddC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_phaddd, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_phaddw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_phaddsw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_phsubd, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_phsubw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_phsubsw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddubsw, "V4sV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrsw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pshufb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psignb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psignd, "V2iV2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_psignw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_palignr, "V1WiV1WiV1Wii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pabsb, "V8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pabsd, "V2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pabsw, "V4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_phaddd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_phaddw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_phaddsw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_phsubd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_phsubw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_phsubsw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddubsw128, "V8sV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrsw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshufb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psignb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psignd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psignw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_palignr128, "V2WiV2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pabsb128, "V16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pabsd128, "V4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pabsw128, "V8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendpd, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendps, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendvpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendvps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_dppd, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_dpps, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_insertps128, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movntdqa, "V2WiV2Wi*", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mpsadbw128, "V16cV16cV16ci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packusdw128, "V8sV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pblendvb128, "V16cV16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pblendw128, "V8sV8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_phminposuw128, "V8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxud128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminsb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminsd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminud128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminuw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbd128, "V4iV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbq128, "V2WiV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbw128, "V8sV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxdq128, "V2WiV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwd128, "V4iV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwq128, "V2WiV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbd128, "V4iV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbq128, "V2WiV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbw128, "V8sV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxdq128, "V2WiV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwd128, "V4iV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwq128, "V2WiV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmuldq128, "V2WiV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulld128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestc128, "iV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnzc128, "iV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestz128, "iV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundpd, "V2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundps, "V4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundsd, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundss, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext___gcc_v16qi, "iV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext___gcc_v4sf, "fV4fiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext___gcc_v4si, "iV4iiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext___gcc_v2di, "WiV2WiiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpestrm128, "V16cV16ciV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpestri128, "iV16ciV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpestria128, "iV16ciV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpestric128, "iV16ciV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpestrio128, "iV16ciV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpestris128, "iV16ciV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpestriz128, "iV16ciV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpistrm128, "V16cV16cV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpistri128, "iV16cV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpistria128, "iV16cV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpistric128, "iV16cV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpistrio128, "iV16cV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpistris128, "iV16cV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpistriz128, "iV16cV16ciC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_crc32qi, "UiUiUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_crc32hi, "UiUiUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_crc32si, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_crc32di, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_popcount, "iUi", "~nc", "")
TARGET_BUILTIN(__builtin_popcountl, "iULi", "~nc", "")
TARGET_BUILTIN(__builtin_popcountll, "iULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_addpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_addps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_addsubpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_addsubps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andnpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andnps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendpd256, "V4dV4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendps256, "V8fV8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendvpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendvps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmppd, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmppd256, "V4dV4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpps, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpps256, "V8fV8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpsd, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpss, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2pd256, "V4dV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2ps256, "V8fV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2dq256, "V4iV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2ps256, "V4fV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2dq256, "V8iV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2pd256, "V4dV4f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2dq256, "V4iV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2dq256, "V8iV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_divpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_divps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_dpps256, "V8fV8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_haddpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_haddps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_hsubpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_hsubps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_lddqu256, "V32ccC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loaddqu256, "V32ccC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loadupd256, "V4ddC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loadups256, "V8ffC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadpd, "V2dV2dC*V2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadpd256, "V4dV4dC*V4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadps, "V4fV4fC*V4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadps256, "V8fV8fC*V8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskstorepd, "vV2d*V2WiV2d", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskstorepd256, "vV4d*V4WiV4d", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskstoreps, "vV4f*V4iV4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskstoreps256, "vV8f*V8iV8f", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maxpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maxps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_minpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_minps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movddup256, "V4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movmskpd256, "iV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movmskps256, "iV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movshdup256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movsldup256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_mulpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_mulps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_orpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_orps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pd_pd256, "V2dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pd256_pd, "V4dV2d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ps_ps256, "V4fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ps256_ps, "V8fV4f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestc256, "iV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnzc256, "iV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestz256, "iV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rcpps256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_roundpd256, "V4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_roundps256, "V8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtps_nr256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtps256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shufpd256, "V4dV4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shufps256, "V8fV8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_si_si256, "V4iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_si256_si, "V8iV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtpd256, "V4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps_nr256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storedqu256, "vc*V32c", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storeupd256, "vd*V4d", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storeups256, "vf*V8f", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_subpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_subps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastf128_pd256, "V4dV2dC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastf128_ps256, "V8fV4fC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastsd256, "V4ddC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastss, "V4ffC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastss256, "V8ffC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vextractf128_pd256, "V2dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vextractf128_ps256, "V4fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vextractf128_si256, "V4iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vinsertf128_pd256, "V4dV4dV2di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vinsertf128_ps256, "V8fV8fV4fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vinsertf128_si256, "V8iV8iV4ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vperm2f128_pd256, "V4dV4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vperm2f128_ps256, "V8fV8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vperm2f128_si256, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermil2pd, "V2dV2dV2dV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermil2pd256, "V4dV4dV4dV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermil2ps, "V4fV4fV4fV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermil2ps256, "V8fV8fV8fV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilpd, "V2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilpd256, "V4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilps, "V4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilps256, "V8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarpd, "V2dV2dV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarpd256, "V4dV4dV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarps, "V4fV4fV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarps256, "V8fV8fV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vtestcpd, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vtestcpd256, "iV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vtestcps, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vtestcps256, "iV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vtestnzcpd, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vtestnzcpd256, "iV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vtestnzcps, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vtestnzcps256, "iV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vtestzpd, "iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vtestzpd256, "iV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vtestzps, "iV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vtestzps256, "iV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vzeroall, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_vzeroupper, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xorpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_xorps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_mpsadbw256, "V32cV32cV32ci", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsb256, "V32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsw256, "V16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsd256, "V8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packssdw256, "V16sV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packsswb256, "V32cV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packusdw256, "V16sV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packuswb256, "V32cV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddsb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddsw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddusb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddusw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_palignr256, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andsi256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andnotsi256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pavgb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pavgw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pblendvb256, "V32cV32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pblendw256, "V16sV16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_phaddw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_phaddd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_phaddsw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_phsubw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_phsubd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_phsubsw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddubsw256, "V16sV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddwd256, "V8iV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxub256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxud256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminsb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminsw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminsd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminub256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminuw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminud256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovmskb256, "iV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbw256, "V16sV16c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbd256, "V8iV16c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbq256, "V4WiV16c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwd256, "V8iV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwq256, "V4WiV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxdq256, "V4WiV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbw256, "V16sV16c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbd256, "V8iV16c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbq256, "V4WiV16c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwd256, "V8iV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwq256, "V4WiV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxdq256, "V4WiV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmuldq256, "V4WiV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrsw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhuw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmullw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulld256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmuludq256, "V4WiV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_por256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psadbw256, "V16sV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshufb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshufd256, "V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshufhw256, "V16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshuflw256, "V16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psignb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psignw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psignd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pslldqi256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllwi256, "V16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllw256, "V16sV16sV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pslldi256, "V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pslld256, "V8iV8iV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllqi256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllq256, "V4WiV4WiV2Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrawi256, "V16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psraw256, "V16sV16sV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psradi256, "V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrad256, "V8iV8iV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrldqi256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlwi256, "V16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlw256, "V16sV16sV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrldi256, "V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrld256, "V8iV8iV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlqi256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlq256, "V4WiV4WiV2Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubsb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubsw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubusb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubusw256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhbw256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhwd256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhdq256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhqdq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklbw256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklwd256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckldq256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklqdq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pxor256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movntdqa256, "V4WiV4Wi*", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastss_ps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastss_ps256, "V8fV4f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastsd_pd256, "V4dV2d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbroadcastsi256, "V4WiV2Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pblendd128, "V4iV4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pblendd256, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb256, "V32cV16c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw256, "V16sV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd256, "V8iV4i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq256, "V4WiV2Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb128, "V16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw128, "V8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd128, "V4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq128, "V2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsi256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permdf256, "V4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsf256, "V8fV8fV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permdi256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permti256, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_extract128i256, "V2WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_insert128i256, "V4WiV4WiV2Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadd256, "V8iV8iC*V8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadq256, "V4WiV4WiC*V4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadd, "V4iV4iC*V4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskloadq, "V2WiV2WiC*V2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskstored256, "vV8i*V8iV8i", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskstoreq256, "vV4Wi*V4WiV4Wi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maskstored, "vV4i*V4iV4i", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maskstoreq, "vV2Wi*V2WiV2Wi", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psll__gcc_v8si, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psll__gcc_v4si, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psll__gcc_v4di, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psll__gcc_v2di, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psra__gcc_v8si, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psra__gcc_v4si, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrl__gcc_v8si, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrl__gcc_v4si, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrl__gcc_v4di, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrl__gcc_v2di, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v2df, "V2dV2ddC*V4iV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v4df, "V4dV4ddC*V4iV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v2df, "V2dV2ddC*V2WiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v4df, "V4dV4ddC*V4WiV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v4sf, "V4fV4ffC*V4iV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v8sf, "V8fV8ffC*V8iV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v4sf, "V4fV4ffC*V2WiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v4sf256, "V4fV4ffC*V4WiV4fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v2di, "V2WiV2WiLLiC*V4iV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v4di, "V4WiV4WiLLiC*V4iV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v2di, "V2WiV2WiLLiC*V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v4di, "V4WiV4WiLLiC*V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v4si, "V4iV4iiC*V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersi__gcc_v8si, "V8iV8iiC*V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v4si, "V4iV4iiC*V2WiV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdi__gcc_v4si256, "V4iV4iiC*V4WiV4ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_aesenc128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesenclast128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesdec128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesdeclast128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aeskeygenassist128, "V2WiV2WiiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesimc128, "V2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pclmulqdq128, "V2WiV2WiV2WiiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rdfsbase32, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdfsbase64, "ULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdgsbase32, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdgsbase64, "ULLi", "~nc", "")
TARGET_BUILTIN(_writefsbase_u32, "vUi", "~nc", "")
TARGET_BUILTIN(_writefsbase_u64, "vULLi", "~nc", "")
TARGET_BUILTIN(_writegsbase_u32, "vUi", "~nc", "")
TARGET_BUILTIN(_writegsbase_u64, "vULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdrand16_step, "UiUs*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_rdrand32_step, "UiUi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_rdrand64_step, "UiULLi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_movntsd, "vd*V2d", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movntss, "vf*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_extrq, "V2WiV2WiV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_extrqi, "V2WiV2WiUiUi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_insertq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_insertqi, "V2WiV2WiV2WiUiUi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfrczpd, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfrczps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfrczsd, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfrczss, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfrczpd256, "V4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfrczps256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v2di, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v4si, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v8hi, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v16qi, "V16cV16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v2df, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v4sf, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v4di256, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v8si256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v16hi256, "V16sV16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov_v32qi256, "V32cV32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov___gcc_v4df256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcmov___gcc_v8sf256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomeqb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomeqw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomeqd, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomeqq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomequb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomequd, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomequq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomequw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomeqw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalseb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalsed, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalseq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalseub, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalseud, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalseuq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalseuw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomfalsew, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgeb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomged, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgeq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgeub, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgeud, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgeuq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgeuw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgew, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtd, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtub, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtud, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtuq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtuw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomgtw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomleb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomled, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomleq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomleub, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomleud, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomleuq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomleuw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomlew, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltd, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltub, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltud, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltuq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltuw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomltw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomneb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomned, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomneq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomneub, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomneud, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomneuq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomneuw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomnew, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtrueb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtrued, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtrueq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtrueub, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtrueud, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtrueuq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtrueuw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomtruew, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddbd, "V4iV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddbq, "V2WiV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddbw, "V8sV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphadddq, "V2WiV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddubd, "V4iV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddubq, "V2WiV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddubw, "V8sV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddudq, "V2WiV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphadduwd, "V4iV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphadduwq, "V2WiV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddwd, "V4iV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphaddwq, "V2WiV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphsubbw, "V8sV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphsubdq, "V2WiV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vphsubwd, "V4iV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacsdd, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacsdqh, "V2WiV4iV4iV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacsdql, "V2WiV4iV4iV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacssdd, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacssdqh, "V2WiV4iV4iV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacssdql, "V2WiV4iV4iV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacsswd, "V4iV8sV8sV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacssww, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacswd, "V4iV8sV8sV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmacsww, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadcsswd, "V4iV8sV8sV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadcswd, "V4iV8sV8sV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpperm, "V16cV16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotd, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshab, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshad, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshaq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshaw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshlb, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshlq, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshlw, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddsd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddss, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubsd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubss, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmaddpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmaddps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmaddsd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmaddss, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmsubpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmsubps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmsubsd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fnmsubss, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddsubpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddsubps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubaddpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubaddps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fnmaddpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fnmaddps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fnmsubpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fnmsubps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddsubpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fmaddsubps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubaddpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fmsubaddps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_llwpcb16, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_llwpcb32, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_llwpcb64, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_lwpval16, "vUsUiUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lwpval32, "vUiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lwpval64, "vULLiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lwpins16, "UcUsUiUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lwpins32, "UcUiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lwpins64, "UcULLiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_bextr_u32, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_bextr_u64, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(_bzhi_u32, "UiUiUi", "~nc", "")
TARGET_BUILTIN(_pdep_u32, "UiUiUi", "~nc", "")
TARGET_BUILTIN(_pext_u32, "UiUiUi", "~nc", "")
TARGET_BUILTIN(_bzhi_u64, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(_pdep_u64, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(_pext_u64, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lzcnt_16, "UsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lzcnt_u32, "UiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_lzcnt_u64, "ULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_bextri_u32, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_bextri_u64, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_femms, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pavgusb, "V8cV8cV8c", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pf2id, "V2iV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfacc, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfadd, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfcmpeq, "V2iV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfcmpge, "V2iV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfcmpgt, "V2iV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfmax, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfmin, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfmul, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfrcp, "V2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfrcpit1, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfrcpit2, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfrsqrt, "V2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfrsqrtit1, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfsub, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfsubr, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pi2fd, "V2fV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrw, "V4sV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pf2iw, "V2iV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfnacc, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pfpnacc, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pi2fw, "V2fV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pswapdsf, "V2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_pswapdsi, "V2iV2i", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_cmpnltss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_comeqpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comeqps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comeqsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comeqss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comfalsepd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comfalseps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comfalsesd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comfalsess, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgepd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgeps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgesd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgess, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgtpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgtps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgtsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comgtss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comlepd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comleps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comlesd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comless, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comltpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comltps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comltsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comltss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comneqpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comneqps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comneqsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comneqss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comordpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comordps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comordsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comordss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comtruepd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comtrueps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comtruesd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comtruess, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comueqpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comueqps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comueqsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comueqss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comuneqpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comuneqps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comuneqsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comuneqss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungepd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungeps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungesd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungess, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungtpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungtps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungtsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comungtss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunlepd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunleps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunlesd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunless, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunltpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunltps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunltsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunltss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunordpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunordps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunordsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_comunordss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_frczpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_frczps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_frczsd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_frczss, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcmov, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomeqb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomeqd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomeqq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomequb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomequd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomequq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomequw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomeqw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalseb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalsed, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalseq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalseub, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalseud, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalseuq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalseuw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomfalsew, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgeb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomged, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgeq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgeub, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgeud, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgeuq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgeuw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgew, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtub, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtud, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtuq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtuw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomgtw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomleb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomled, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomleq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomleub, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomleud, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomleuq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomleuw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomlew, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltub, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltud, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltuq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltuw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomltw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomneqb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomneqd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomneqq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomnequb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomnequd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomnequq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomnequw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomneqw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtrueb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtrued, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtrueq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtrueub, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtrueud, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtrueuq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtrueuw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pcomtruew, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_permpd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_permps, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddbd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddbq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddbw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phadddq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddubd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddubq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddubw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddudq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phadduwd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phadduwq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddwd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phaddwq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phsubbw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phsubdq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_phsubwd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacsdd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacsdqh, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacsdql, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacssdd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacssdqh, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacssdql, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacsswd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacssww, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacswd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmacsww, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmadcsswd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmadcswd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pperm, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_protb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_protd, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_protq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_protw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshab, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshad, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshaq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshaw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshlb, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshld, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshlq, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pshlw, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v2df, "dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v2di, "WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v4sf, "fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v4si, "iV4ii", "~ncV:128:", "")

// Auto-generated from gcc_builtin_headers_ia32-2.h from CBMC:
TARGET_BUILTIN(__builtin_ia32_emms, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pmaddwd, "V2iV4sV4s", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_vec_init_v2si, "V2iii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_vec_init_v4hi, "V4sssss", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_vec_init_v8qi, "V8ccccccccc", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v2si, "iV2ii", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_paddusw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubusw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ldmxcsr, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_stmxcsr, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_paddsw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubsw128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddsb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubsb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddusb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubusb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtss2si64, "LLiV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttss2si64, "LLiV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsi642ss, "V4fV4fLLi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshufw, "V4sV4si", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v4hi, "sV4si", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v8hi, "sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v4hi, "V4sV4ssi", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v8hi, "V8sV8ssi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set___gcc_v4sf, "V4fV4ffiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set___gcc_v16qi, "V16cV16ciiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set___gcc_v4si, "V4iV4iiiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set___gcc_v2di, "V2WiV2WiWiiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v16qi, "cV16ci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v16qi, "V16cV16cci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v4si, "V4iV4iii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v2di, "V2WiV2WiWii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rdtsc, "ULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdtscp, "ULLiUi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_fnstenv, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_fldenv, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_fnstsw, "Us", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_fnclex, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_fxsave, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_fxrstor, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsave, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xrstor, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsaveopt, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsaves, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xrstors, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsavec, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_fxsave64, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_fxrstor64, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsave64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xrstor64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsaveopt64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsaves64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xrstors64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_xsavec64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_movntdq256, "vV4Wi*V4Wi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movntpd256, "vd*V4d", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movntps256, "vf*V8f", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoresf512_mask, "vV16f*V16fUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoresi512_mask, "vV16i*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoredf512_mask, "vV8d*V8dUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoredi512_mask, "vV8Wi*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsf512_mask, "V16fV16fC*V16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsf512_maskz, "V16fV16fC*V16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsi512_mask, "V16iV16iC*V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsi512_maskz, "V16iV16iC*V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddf512_mask, "V8dV8dC*V8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddf512_maskz, "V8dV8dC*V8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddi512_mask, "V8WiV8WiC*V8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddi512_maskz, "V8WiV8WiC*V8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loaddqusi512_mask, "V16iiC*V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loaddqudi512_mask, "V8WiLLiC*V8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loadupd512_mask, "V8ddC*V8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loadups512_mask, "V16ffC*V16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loadaps512_mask, "V16fV16fC*V16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32load512_mask, "V16iV16iC*V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loadapd512_mask, "V8dV8dC*V8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64load512_mask, "V8WiV8WiC*V8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movntps512, "vf*V16f", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movntpd512, "vd*V8d", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movntdq512, "vV8Wi*V8Wi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movntdqa512, "V8WiV8Wi*", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storedqusi512_mask, "vi*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storedqudi512_mask, "vLLi*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storeupd512_mask, "vd*V8dUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqd512mem_mask, "vV8i*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqd512mem_mask, "vV8i*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqd512mem_mask, "vV8i*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqw512mem_mask, "vV8s*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqw512mem_mask, "vV8s*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqw512mem_mask, "vV8s*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdw512mem_mask, "vV16s*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdw512mem_mask, "vV16s*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdw512mem_mask, "vV16s*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqb512mem_mask, "vULLi*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqb512mem_mask, "vULLi*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqb512mem_mask, "vULLi*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdb512mem_mask, "vV16c*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdb512mem_mask, "vV16c*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdb512mem_mask, "vV16c*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storeups512_mask, "vf*V16fUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storeaps512_mask, "vV16f*V16fUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32store512_mask, "vV16i*V16iUs", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storeapd512_mask, "vV8d*V8dUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64store512_mask, "vV8Wi*V8WiUc", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_llwpcb, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_slwpcb, "v*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_wrfsbase32, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_wrfsbase64, "vULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_wrgsbase32, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_wrgsbase64, "vULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xbegin, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xend, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xabort, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xtest, "i", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_bsrsi, "ii", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_bsrdi, "LLiLLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdpmc, "ULLii", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rolqi, "UcUci", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rolhi, "UsUsi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rorqi, "UcUci", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rorhi, "UsUsi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pfrsqit1, "V2fV2fV2f", "~ncV:64:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps_nr, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtps_nr, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_copysignps, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtf, "ff", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_copysignpd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vec_pack_sfix, "V4iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_floorpd, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ceilpd, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_truncpd, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rintpd, "V2dV2diC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_floorpd_vec_pack_sfix, "V4iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ceilpd_vec_pack_sfix, "V4iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundpd_az, "V2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundpd_az_vec_pack_sfix, "V4iV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_floorps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ceilps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_truncps, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rintps, "V4fV4fiC", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_floorps_sfix, "V4iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ceilps_sfix, "V4iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundps_az, "V4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_roundps_az_sfix, "V4iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_floorpd256, "V4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ceilpd256, "V4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_truncpd256, "V4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rintpd256, "V4dV4diC", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_roundpd_az256, "V4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_roundpd_az_vec_pack_sfix256, "V8iV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_floorpd_vec_pack_sfix256, "V8iV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ceilpd_vec_pack_sfix256, "V8iV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_floorps256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ceilps256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_truncps256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rintps256, "V8fV8fiC", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_floorps_sfix256, "V8iV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ceilps_sfix256, "V8iV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_roundps_az256, "V8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_roundps_az_sfix256, "V8iV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_copysignps256, "V8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_copysignpd256, "V4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv4di, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv2di, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllv8si, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv4si, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrav8si, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrav4si, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv4di, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv2di, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv8si, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv4si, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_clzs, "UsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ctzs, "UsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2ps, "V4fV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2ps256, "V8fV8s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2ph, "V8sV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2ph256, "V8sV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_bzhi_si, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_bzhi_di, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pdep_si, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pdep_di, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pext_si, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_pext_di, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_alignd512_mask, "V16iV16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_alignq512_mask, "V8WiV8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_blendmd_512_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_blendmpd_512_mask, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_blendmps_512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_blendmq_512_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf32x4_512, "V16fV4fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf64x4_512, "V8dV4dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti32x4_512, "V16iV4iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti64x4_512, "V8WiV4WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastsd512, "V8dV2dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastss512, "V16fV4fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cmpd512_mask, "UsV16iV16iiUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cmpq512_mask, "UcV8WiV8WiiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressdf512_mask, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compresssf512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2pd512_mask, "V8dV8iV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2ph512_mask, "V16sV16fiV16sUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtudq2pd512_mask, "V8dV8iV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtusi2sd32, "V2dV2dUi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expanddf512_mask, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expanddf512_maskz, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandsf512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandsf512_maskz, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extractf32x4_mask, "V4fV16fiV4fUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extractf64x4_mask, "V4dV8diV4dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extracti32x4_mask, "V4iV16iiV4iUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extracti64x4_mask, "V4WiV8WiiV4WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_insertf32x4_mask, "V16fV16fV4fiV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_insertf64x4_mask, "V8dV8dV4diV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti32x4_mask, "V16iV16iV4iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti64x4_mask, "V8WiV8WiV4WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movapd512_mask, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movaps512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movddup512_mask, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32_512_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64_512_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movshdup512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movsldup512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pabsd512_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pabsq512_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pandd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pandnd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pandnq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pandq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd512, "V16iV4iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd512_gpr_mask, "V16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastmb512, "V8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastmw512, "V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq512, "V8WiV2WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq512_gpr_mask, "V8WiLLiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq512_mem_mask, "V8WiLLiV8Wic", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqd512_mask, "UsV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqq512_mask, "UcV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtd512_mask, "UsV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtq512_mask, "UcV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compresssi512_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressdi512_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandsi512_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandsi512_maskz, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expanddi512_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expanddi512_maskz, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxud512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminsd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminsq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminud512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminuq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdb512_mask, "V16cV16iV16cUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdw512_mask, "V16sV16iV16sUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqb512_mask, "V16cV8WiV16cUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqd512_mask, "V8iV8WiV8iUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqw512_mask, "V8sV8WiV8sUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdb512_mask, "V16cV16iV16cUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdw512_mask, "V16sV16iV16sUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqb512_mask, "V16cV8WiV16cUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqd512_mask, "V8iV8WiV8iUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqw512_mask, "V8sV8WiV8sUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbd512_mask, "V16iV16cV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbq512_mask, "V8WiV16cV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxdq512_mask, "V8WiV8iV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwd512_mask, "V16iV16sV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwq512_mask, "V8WiV8sV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdb512_mask, "V16cV16iV16cUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdw512_mask, "V16sV16iV16sUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqb512_mask, "V16cV8WiV16cUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqd512_mask, "V8iV8WiV8iUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqw512_mask, "V8sV8WiV8sUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbd512_mask, "V16iV16cV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbq512_mask, "V8WiV16cV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxdq512_mask, "V8WiV8iV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwd512_mask, "V16iV16sV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwq512_mask, "V8WiV8sV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmuldq512_mask, "V8WiV16iV16iV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmulld512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmuludq512_mask, "V8WiV16iV16iV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pord512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_porq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prold512_mask, "V16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prolq512_mask, "V8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prolvd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prolvq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prord512_mask, "V16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prorq512_mask, "V8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prorvd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prorvq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshufd512_mask, "V16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pslld512_mask, "V16iV16iV4iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pslldi512_mask, "V16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllq512_mask, "V8WiV8WiV2WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllqi512_mask, "V8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllv16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllv8di_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrad512_mask, "V16iV16iV4iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psradi512_mask, "V16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psraq512_mask, "V8WiV8WiV2WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psraqi512_mask, "V8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrav16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrav8di_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrld512_mask, "V16iV16iV4iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrldi512_mask, "V16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlq512_mask, "V8WiV8WiV2WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlqi512_mask, "V8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv8di_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubd512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmd512, "UsV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmq512, "UcV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmd512, "UsV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmq512, "UcV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhdq512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhqdq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpckldq512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklqdq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pxord512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pxorq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14pd512_mask, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14ps512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14sd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14ss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14pd512_mask, "V8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14ps512_mask, "V16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14sd, "V2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14ss, "V4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_shufpd512_mask, "V8dV8dV8diV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shufps512_mask, "V16fV16fV16fiV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f32x4_mask, "V16fV16fV16fiV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f64x2_mask, "V8dV8dV8diV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i32x4_mask, "V16iV16iV16iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i64x2_mask, "V8WiV8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpd512_mask, "UsV16iV16iiUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpq512_mask, "UcV8WiV8WiiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhpd512_mask, "V8dV8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhps512_mask, "V16fV16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklpd512_mask, "V8dV8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklps512_mask, "V16fV16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntd_512_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntq_512_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictsi_512_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictdi_512_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permdf512_mask, "V8dV8diV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permdi512_mask, "V8WiV8WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2vard512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varpd512_mask, "V8dV8dV8WiV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varps512_mask, "V16fV16fV16iV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilpd512_mask, "V8dV8diV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilps512_mask, "V16fV16fiV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarpd512_mask, "V8dV8dV8WiV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarps512_mask, "V16fV16fV16iV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2vard512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2vard512_maskz, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varpd512_mask, "V8dV8WiV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varpd512_maskz, "V8dV8WiV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varps512_mask, "V16fV16iV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varps512_maskz, "V16fV16iV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varq512_maskz, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvardf512_mask, "V8dV8dV8WiV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvardi512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsf512_mask, "V16fV16fV16iV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsi512_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogd512_mask, "V16iV16iV16iV16iiUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogd512_maskz, "V16iV16iV16iV16iiUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogq512_mask, "V8WiV8WiV8WiV8WiiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogq512_maskz, "V8WiV8WiV8WiV8WiiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_copysignps512, "V16fV16fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_copysignpd512, "V8dV8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtpd512, "V8dV8d.", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps512, "V16fV16f.", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_exp2ps, "V16fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_roundpd_az_vec_pack_sfix512, "V16iV8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_floorpd_vec_pack_sfix512, "V16iV8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ceilpd_vec_pack_sfix512, "V16iV8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_kandhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kandnhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_knothi, "UsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_korhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestchi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestzhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kunpckhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxnorhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxorhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kmov16, "ss", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_addpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmppd512_mask, "UcV8dV8diUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cmpps512_mask, "UsV16fV16fiUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cmpsd_mask, "UcV2dV2diUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpss_mask, "UcV4fV4fiUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcomisd, "iV2dV2dii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcomiss, "iV4fV4fii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2ps512_mask, "V16fV16iV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2dq512_mask, "V8iV8dV8ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2ps512_mask, "V8fV8dV8fci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2udq512_mask, "V8iV8dV8ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2ps512_mask, "V16fV16sV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2dq512_mask, "V16iV16fV16isi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2pd512_mask, "V8dV8fV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2udq512_mask, "V16iV16fV16isi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsd2ss_round, "V4fV4fV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsi2sd64, "V2dV2dLLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsi2ss32, "V4fV4fii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsi2ss64, "V4fV4fLLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtss2sd_round, "V2dV2dV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2dq512_mask, "V8iV8dV8ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2udq512_mask, "V8iV8dV8ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2dq512_mask, "V16iV16fV16isi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2udq512_mask, "V16iV16fV16isi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtudq2ps512_mask, "V16fV16iV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtusi2sd64, "V2dV2dULLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtusi2ss32, "V4fV4fUii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtusi2ss64, "V4fV4fULLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmpd512_mask, "V8dV8dV8dV8Wiici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmpd512_maskz, "V8dV8dV8dV8Wiici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmps512_mask, "V16fV16fV16fV16iisi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmps512_maskz, "V16fV16fV16fV16iisi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmsd_mask, "V2dV2dV2dV2Wiici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmsd_maskz, "V2dV2dV2dV2Wiici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmss_mask, "V4fV4fV4fV4iici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmss_maskz, "V4fV4fV4fV4iici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexppd512_mask, "V8dV8dV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_getexpps512_mask, "V16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_getexpsd128_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpss128_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantpd512_mask, "V8dV8diV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_getmantps512_mask, "V16fV16fiV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_getmantsd_round, "V2dV2dV2dii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantss_round, "V4fV4fV4fii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_maxps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_maxsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_minps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_minsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_mulps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_mulsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalepd_mask, "V8dV8diV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleps_mask, "V16fV16fiV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalesd_round, "V2dV2dV2dii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaless_round, "V4fV4fV4fii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scalefps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scalefsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtpd512_mask, "V8dV8dV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps512_mask, "V16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_subps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_subsd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsd2si32, "iV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsd2si64, "LLiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsd2usi32, "UiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsd2usi64, "ULLiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtss2si32, "iV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtss2si64, "LLiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtss2usi32, "UiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtss2usi64, "ULLiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsd2si32, "iV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsd2si64, "LLiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsd2usi32, "UiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsd2usi64, "ULLiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttss2si32, "iV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttss2si64, "LLiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttss2usi32, "UiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttss2usi64, "ULLiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsd3, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddss3, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd512_mask3, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd512_maskz, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps512_mask3, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps512_maskz, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsd3_round, "V2dV2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddss3_round, "V4fV4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd256, "V4dV4dV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps256, "V8fV8fV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd512_mask3, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd512_maskz, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps512_mask3, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps512_maskz, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddpd512_mask3, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddps512_mask3, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd512_mask3, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps512_mask3, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd512_mask3, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps512_mask3, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_exp2pd_mask, "V8dV8dV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_exp2ps_mask, "V16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28pd_mask, "V8dV8dV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28ps_mask, "V16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28sd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28ss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28pd_mask, "V8dV8dV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28ps_mask, "V16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28sd_round, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28ss_round, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin__ITM_WM64, "vV2i*V2i", "~nV:64:", "")
TARGET_BUILTIN(__builtin__ITM_WaRM64, "vV2i*V2i", "~nV:64:", "")
TARGET_BUILTIN(__builtin__ITM_WaWM64, "vV2i*V2i", "~nV:64:", "")
TARGET_BUILTIN(__builtin__ITM_RM64, "V2iV2iC*", "~ncV:64:", "")
TARGET_BUILTIN(__builtin__ITM_RaRM64, "V2iV2iC*", "~ncV:64:", "")
TARGET_BUILTIN(__builtin__ITM_RaWM64, "V2iV2iC*", "~ncV:64:", "")
TARGET_BUILTIN(__builtin__ITM_RfWM64, "V2iV2iC*", "~ncV:64:", "")
TARGET_BUILTIN(__builtin__ITM_WM128, "vV4f*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin__ITM_WaRM128, "vV4f*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin__ITM_WaWM128, "vV4f*V4f", "~nV:128:", "")
TARGET_BUILTIN(__builtin__ITM_RM128, "V4fV4fC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin__ITM_RaRM128, "V4fV4fC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin__ITM_RaWM128, "V4fV4fC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin__ITM_RfWM128, "V4fV4fC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin__ITM_WM256, "vV8f*V8f", "~nV:256:", "")
TARGET_BUILTIN(__builtin__ITM_WaRM256, "vV8f*V8f", "~nV:256:", "")
TARGET_BUILTIN(__builtin__ITM_WaWM256, "vV8f*V8f", "~nV:256:", "")
TARGET_BUILTIN(__builtin__ITM_RM256, "V8fV8fC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin__ITM_RaRM256, "V8fV8fC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin__ITM_RaWM256, "V8fV8fC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin__ITM_RfWM256, "V8fV8fC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin__ITM_LM64, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin__ITM_LM128, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin__ITM_LM256, "vvC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_sha1msg1, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sha1msg2, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sha1nexte, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sha1rnds4, "V4iV4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sha256msg1, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sha256msg2, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sha256rnds2, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv2df, "V2dV2ddC*V4iV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv4df, "V4dV4ddC*V4iV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv2df, "V2dV2ddC*V2WiV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv4df, "V4dV4ddC*V4WiV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv4sf, "V4fV4ffC*V4iV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv8sf, "V8fV8ffC*V8iV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv4sf, "V4fV4ffC*V2WiV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv4sf256, "V4fV4ffC*V4WiV4fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv2di, "V2WiV2WiLiC*V4iV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv4di, "V4WiV4WiLiC*V4iV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv2di, "V2WiV2WiLiC*V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv4di, "V4WiV4WiLiC*V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv4si, "V4iV4iiC*V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv8si, "V8iV8iiC*V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv4si, "V4iV4iiC*V2WiV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv4si256, "V4iV4iiC*V4WiV4ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltsiv4df, "V4dV4ddC*V8iV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltdiv4sf256, "V8fV8ffC*V4WiV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltsiv4di, "V4WiV4WiLiC*V8iV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltdiv4si256, "V8iV8iiC*V4WiV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv16sf, "V16fV16ffC*V16isi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv8df, "V8dV8ddC*V8ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv16sf, "V8fV8ffC*V8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv8df, "V8dV8ddC*V8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv16si, "V16iV16iiC*V16isi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gathersiv8di, "V8WiV8WiLiC*V8ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv16si, "V8iV8iiC*V8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatherdiv8di, "V8WiV8WiLiC*V8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltsiv8df, "V8dV8ddC*V16ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltdiv8sf, "V16fV16ffC*V8Wisi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltsiv8di, "V8WiV8WiLiC*V16ici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatheraltdiv8si, "V16iV16iiC*V8Wisi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv16sf, "vf*sV16iV16fi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv8df, "vd*cV8iV8di", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv16sf, "vf*cV8WiV8fi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv8df, "vd*cV8WiV8di", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv16si, "vi*sV16iV16ii", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv8di, "vLLi*cV8iV8Wii", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv16si, "vi*cV8WiV8ii", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv8di, "vLLi*cV8WiV8Wii", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv2df, "V2dV2ddC*V4ici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv4df, "V4dV4ddC*V4ici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div2df, "V2dV2ddC*V2Wici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div4df, "V4dV4ddC*V4Wici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv4sf, "V4fV4ffC*V4ici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv8sf, "V8fV8ffC*V8ici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div4sf, "V4fV4ffC*V2Wici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div8sf, "V4fV4ffC*V4Wici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv2di, "V2WiV2WiLiC*V4ici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv4di, "V4WiV4WiLiC*V4ici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div2di, "V2WiV2WiLiC*V2Wici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div4di, "V4WiV4WiLiC*V4Wici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv4si, "V4iV4iiC*V4ici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3siv8si, "V8iV8iiC*V8ici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div4si, "V4iV4iiC*V2Wici", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gather3div8si, "V4iV4iiC*V4Wici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3altsiv4df, "V4dV4ddC*V8ici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3altdiv8sf, "V8fV8ffC*V4Wici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3altsiv4di, "V4WiV4WiLiC*V8ici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gather3altdiv8si, "V8iV8iiC*V4Wici", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv8sf, "vf*cV8iV8fi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv4sf, "vf*cV4iV4fi", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv4df, "vd*cV4iV4di", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv2df, "vd*cV4iV2di", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv8sf, "vf*cV4WiV4fi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv4sf, "vf*cV2WiV4fi", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv4df, "vd*cV4WiV4di", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv2df, "vd*cV2WiV2di", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv8si, "vi*cV8iV8ii", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv4si, "vi*cV4iV4ii", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv4di, "vLLi*cV4iV4Wii", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scattersiv2di, "vLLi*cV4iV2Wii", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv8si, "vi*cV4WiV4ii", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv4si, "vi*cV2WiV4ii", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv4di, "vLLi*cV4WiV4Wii", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scatterdiv2di, "vLLi*cV2WiV2Wii", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scatteraltsiv8df, "vd*cV16iV8di", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatteraltdiv8sf, "vf*sV8WiV16fi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatteraltsiv8di, "vLLi*cV16iV8Wii", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatteraltdiv8si, "vi*sV8WiV16ii", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatherpfdpd, "vcV8iLiC*ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherpfdps, "vsV16iiC*ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatherpfqpd, "vcV8WiLiC*ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_gatherpfqps, "vcV8WiiC*ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatterpfdpd, "vcV8iLiC*ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scatterpfdps, "vsV16iiC*ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatterpfqpd, "vcV8WiLiC*ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scatterpfqps, "vcV8WiiC*ii", "~ncV:512:", "")

// Auto-generated from gcc_builtin_headers_ia32-3.h from CBMC:
TARGET_BUILTIN(__builtin_ia32_loaddquhi512_mask, "V32ssC*V32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loaddquqi512_mask, "V64ccC*V64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storedquhi512_mask, "vs*V32sUi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_storedquqi512_mask, "vc*V64cULLi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loaddquhi256_mask, "V16ssC*V16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loaddquhi128_mask, "V8ssC*V8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loaddquqi256_mask, "V32ccC*V32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loaddquqi128_mask, "V16ccC*V16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64load256_mask, "V4WiV4WiC*V4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64load128_mask, "V2WiV2WiC*V2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32load256_mask, "V8iV8iC*V8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32load128_mask, "V4iV4iC*V4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64store256_mask, "vV4Wi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64store128_mask, "vV2Wi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32store256_mask, "vV8i*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32store128_mask, "vV4i*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadapd256_mask, "V4dV4dC*V4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loadapd128_mask, "V2dV2dC*V2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadaps256_mask, "V8fV8fC*V8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loadaps128_mask, "V4fV4fC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storeapd256_mask, "vV4d*V4dUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storeapd128_mask, "vV2d*V2dUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storeaps256_mask, "vV8f*V8fUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storeaps128_mask, "vV4f*V4fUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadupd256_mask, "V4ddC*V4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loadupd128_mask, "V2ddC*V2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadups256_mask, "V8ffC*V8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loadups128_mask, "V4ffC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storeupd256_mask, "vd*V4dUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storeupd128_mask, "vd*V2dUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storeups256_mask, "vf*V8fUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storeups128_mask, "vf*V4fUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loaddqudi256_mask, "V4WiLLiC*V4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loaddqudi128_mask, "V2WiLLiC*V2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loaddqusi256_mask, "V8iiC*V8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_loaddqusi128_mask, "V4iiC*V4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storedqudi256_mask, "vLLi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storedqudi128_mask, "vLLi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storedqusi256_mask, "vi*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storedqusi128_mask, "vi*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storedquhi256_mask, "vs*V16sUs", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storedquhi128_mask, "vs*V8sUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storedquqi256_mask, "vc*V32cUi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_storedquqi128_mask, "vc*V16cUs", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoredf256_mask, "vV4d*V4dUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoredf128_mask, "vV2d*V2dUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoresf256_mask, "vV8f*V8fUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoresf128_mask, "vV4f*V4fUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoredi256_mask, "vV4Wi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoredi128_mask, "vV2Wi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoresi256_mask, "vV8i*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoresi128_mask, "vV4i*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddf256_mask, "V4dV4dC*V4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddf128_mask, "V2dV2dC*V2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsf256_mask, "V8fV8fC*V8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsf128_mask, "V4fV4fC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddi256_mask, "V4WiV4WiC*V4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddi128_mask, "V2WiV2WiC*V2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsi256_mask, "V8iV8iC*V8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsi128_mask, "V4iV4iC*V4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddf256_maskz, "V4dV4dC*V4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddf128_maskz, "V2dV2dC*V2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsf256_maskz, "V8fV8fC*V8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsf128_maskz, "V4fV4fC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddi256_maskz, "V4WiV4WiC*V4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloaddi128_maskz, "V2WiV2WiC*V2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsi256_maskz, "V8iV8iC*V8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadsi128_maskz, "V4iV4iC*V4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqd256mem_mask, "vV4i*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqd128mem_mask, "vULLi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqd256mem_mask, "vV4i*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqd128mem_mask, "vULLi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqd256mem_mask, "vV4i*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqd128mem_mask, "vULLi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqw256mem_mask, "vULLi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqw128mem_mask, "vUi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqw256mem_mask, "vULLi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqw128mem_mask, "vUi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqw256mem_mask, "vULLi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqw128mem_mask, "vUi*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqb256mem_mask, "vUi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqb128mem_mask, "vUs*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqb256mem_mask, "vUi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqb128mem_mask, "vUs*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqb256mem_mask, "vUi*V4WiUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqb128mem_mask, "vUs*V2WiUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdb256mem_mask, "vULLi*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdb128mem_mask, "vUi*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdb256mem_mask, "vULLi*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdb128mem_mask, "vUi*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdb256mem_mask, "vULLi*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdb128mem_mask, "vUi*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdw256mem_mask, "vV8s*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdw128mem_mask, "vULLi*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdw256mem_mask, "vV8s*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdw128mem_mask, "vULLi*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdw256mem_mask, "vV8s*V8iUc", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdw128mem_mask, "vULLi*V4iUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rdpkru, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_wrpkru, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_vec_pack_sfix256, "V8iV4dV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_lzcnt_u16, "UsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_tzcnt_u16, "UsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_tzcnt_u32, "UiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_tzcnt_u64, "ULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_si512_256si, "V16iV8i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ps512_256ps, "V16fV8f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pd512_256pd, "V8dV4d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_si512_si, "V16iV4i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ps512_ps, "V16fV4f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pd512_pd, "V8dV2d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2dq512, "V16iV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vec_pack_sfix512, "V16iV8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_roundps_az_sfix512, "V16iV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_kshiftlihi, "UsUsUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kshiftlisi, "UiUiUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kshiftlidi, "ULLiULLiUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kshiftrihi, "UsUsUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kshiftrisi, "UiUiUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kshiftridi, "ULLiULLiUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kandqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kandsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kanddi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kandnqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kandnsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kandndi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_knotqi, "UcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_knotsi, "UiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_knotdi, "ULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_korqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_korsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kordi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestcqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestzqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestchi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestzhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestcsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestzsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestcdi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ktestzdi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestcqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestzqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestcsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestzsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestcdi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kortestzdi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxnorqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxnorsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxnordi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxorqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxorsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kxordi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kmovb, "UcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kmovw, "UsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kmovd, "UiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kmovq, "ULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kaddqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kaddhi, "UsUsUs", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kaddsi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kadddi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64_256_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa64_128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32_256_mask, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdqa32_128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movapd256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movapd128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movaps256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movaps128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movdquhi256_mask, "V16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdquhi128_mask, "V8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movdquqi256_mask, "V32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movdquqi128_mask, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minps_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxps_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minpd_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxpd_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maxps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_minpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_minps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_mulps_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divps_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulpd_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divpd_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_divps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_mulpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_mulps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_addpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_addps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_subpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_subps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_xorpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_xorpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_xorps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_xorps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_orpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_orpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_orps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_orps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf32x2_256_mask, "V8fV4fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti32x2_256_mask, "V8iV4iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti32x2_128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf64x2_256_mask, "V4dV2dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti64x2_256_mask, "V4WiV2WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf32x4_256_mask, "V8fV4fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti32x4_256_mask, "V8iV4iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_extractf32x4_256_mask, "V4fV8fiV4fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_extracti32x4_256_mask, "V4iV8iiV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_dbpsadbw256_mask, "V16sV32cV32ciV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_dbpsadbw128_mask, "V8sV16cV16ciV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2qq256_mask, "V4WiV4dV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2qq128_mask, "V2WiV2dV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2uqq256_mask, "V4WiV4dV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2uqq128_mask, "V2WiV2dV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2qq256_mask, "V4WiV4dV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2qq128_mask, "V2WiV2dV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2uqq256_mask, "V4WiV4dV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2uqq128_mask, "V2WiV2dV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2udq256_mask, "V4iV4dV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2udq128_mask, "V4iV2dV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2qq256_mask, "V4WiV4fV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2qq128_mask, "V2WiV4fV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2uqq256_mask, "V4WiV4fV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2uqq128_mask, "V2WiV4fV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2dq256_mask, "V8iV8fV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2dq128_mask, "V4iV4fV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2udq256_mask, "V8iV8fV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2udq128_mask, "V4iV4fV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2dq256_mask, "V4iV4dV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2dq128_mask, "V4iV2dV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2udq256_mask, "V4iV4dV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2udq128_mask, "V4iV2dV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2dq256_mask, "V4iV4dV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2dq128_mask, "V4iV2dV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2pd256_mask, "V4dV4iV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2pd128_mask, "V2dV4iV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtudq2pd256_mask, "V4dV4iV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtudq2pd128_mask, "V2dV4iV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2ps256_mask, "V8fV8iV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtdq2ps128_mask, "V4fV4iV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtudq2ps256_mask, "V8fV8iV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtudq2ps128_mask, "V4fV4iV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2pd256_mask, "V4dV4fV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2pd128_mask, "V2dV4fV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb256_mask, "V32cV16cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb256_gpr_mask, "V32ccV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb128_mask, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb128_gpr_mask, "V16ccV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw256_mask, "V16sV8sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw256_gpr_mask, "V16ssV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw128_mask, "V8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw128_gpr_mask, "V8ssV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd256_mask, "V8iV4iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd256_gpr_mask, "V8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastd128_gpr_mask, "V4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq256_mask, "V4WiV2WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq256_gpr_mask, "V4WiLLiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastq128_gpr_mask, "V2WiLLiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastss256_mask, "V8fV4fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastss128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastsd256_mask, "V4dV2dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_extractf64x2_256_mask, "V2dV4diV2dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_extracti64x2_256_mask, "V2WiV4WiiV2WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_insertf32x4_256_mask, "V8fV8fV4fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_inserti32x4_256_mask, "V8iV8iV4iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbw256_mask, "V16sV16cV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbw128_mask, "V8sV16cV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbd256_mask, "V8iV16cV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbd128_mask, "V4iV16cV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbq256_mask, "V4WiV16cV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbq128_mask, "V2WiV16cV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwd256_mask, "V8iV8sV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwd128_mask, "V4iV8sV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwq256_mask, "V4WiV8sV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxwq128_mask, "V2WiV8sV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxdq256_mask, "V4WiV4iV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxdq128_mask, "V2WiV4iV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbw256_mask, "V16sV16cV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbw128_mask, "V8sV16cV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbd256_mask, "V8iV16cV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbd128_mask, "V4iV16cV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbq256_mask, "V4WiV16cV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbq128_mask, "V2WiV16cV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwd256_mask, "V8iV8sV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwd128_mask, "V4iV8sV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwq256_mask, "V4WiV8sV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxwq128_mask, "V2WiV8sV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxdq256_mask, "V4WiV4iV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxdq128_mask, "V2WiV4iV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducepd256_mask, "V4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_reducepd128_mask, "V2dV2diV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reduceps256_mask, "V8fV8fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_reduceps128_mask, "V4fV4fiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducesd, "V2dV2dV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducess, "V4fV4fV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permvarhi256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvarhi128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varhi256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varhi256_maskz, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varhi128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varhi128_maskz, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varhi256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varhi128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14pd256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14pd128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14ps256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14ps128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14pd256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14pd128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14ps256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14ps128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtpd256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtpd128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtps128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddsb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddsw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubsb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubsw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddusb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddusw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubusb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psubusw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_paddb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddsb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddsw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddusb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_paddusw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubsb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubsw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubusb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psubusw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f64x2_256_mask, "V4dV4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i64x2_256_mask, "V4WiV4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i32x4_256_mask, "V8iV8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f32x4_256_mask, "V8fV8fV8fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovwb128_mask, "V16cV8sV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovwb256_mask, "V16cV16sV16cUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovswb128_mask, "V16cV8sV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovswb256_mask, "V16cV16sV16cUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovuswb128_mask, "V16cV8sV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovuswb256_mask, "V16cV16sV16cUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdb128_mask, "V16cV4iV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdb256_mask, "V16cV8iV16cUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdb128_mask, "V16cV4iV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdb256_mask, "V16cV8iV16cUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdb128_mask, "V16cV4iV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdb256_mask, "V16cV8iV16cUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdw128_mask, "V8sV4iV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovdw256_mask, "V8sV8iV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdw128_mask, "V8sV4iV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsdw256_mask, "V8sV8iV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdw128_mask, "V8sV4iV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusdw256_mask, "V8sV8iV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqb128_mask, "V16cV2WiV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqb256_mask, "V16cV4WiV16cUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqb128_mask, "V16cV2WiV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqb256_mask, "V16cV4WiV16cUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqb128_mask, "V16cV2WiV16cUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqb256_mask, "V16cV4WiV16cUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqw128_mask, "V8sV2WiV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqw256_mask, "V8sV4WiV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqw128_mask, "V8sV2WiV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqw256_mask, "V8sV4WiV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqw128_mask, "V8sV2WiV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqw256_mask, "V8sV4WiV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqd128_mask, "V4iV2WiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovqd256_mask, "V4iV4WiV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqd128_mask, "V4iV2WiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsqd256_mask, "V4iV4WiV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqd128_mask, "V4iV2WiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovusqd256_mask, "V4iV4WiV4iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rangepd256_mask, "V4dV4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rangepd128_mask, "V2dV2dV2diV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rangeps256_mask, "V8fV8fV8fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rangeps128_mask, "V4fV4fV4fiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpps256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_getexppd256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_getexpps128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexppd128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmpd256_mask, "V4dV4dV4dV4WiiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmpd256_maskz, "V4dV4dV4dV4WiiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmps256_mask, "V8fV8fV8fV8iiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmps256_maskz, "V8fV8fV8fV8iiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmpd128_mask, "V2dV2dV2dV2WiiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmpd128_maskz, "V2dV2dV2dV2WiiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmps128_mask, "V4fV4fV4fV4iiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fixupimmps128_maskz, "V4fV4fV4fV4iiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pabsq256_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsq128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pabsd256_mask, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsd128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrsw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrsw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhuw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhuw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmullw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmullw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmullq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmullq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andnpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andnpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_andnps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_andnps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pandd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pandd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pandq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pandq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pandnd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pandnd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pandnq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pandnq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pord256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pord128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_porq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_porq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pxord256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pxord128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pxorq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pxorq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packsswb256_mask, "V32cV16sV16sV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packsswb128_mask, "V16cV8sV8sV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packuswb256_mask, "V32cV16sV16sV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packuswb128_mask, "V16cV8sV8sV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleps_256_mask, "V8fV8fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalepd_256_mask, "V4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleps_128_mask, "V4fV4fiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalepd_128_mask, "V2dV2diV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogq256_mask, "V4WiV4WiV4WiV4WiiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogq256_maskz, "V4WiV4WiV4WiV4WiiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogd256_mask, "V8iV8iV8iV8iiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogd256_maskz, "V8iV8iV8iV8iiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogq128_mask, "V2WiV2WiV2WiV2WiiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogq128_maskz, "V2WiV2WiV2WiV2WiiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogd128_mask, "V4iV4iV4iV4iiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pternlogd128_maskz, "V4iV4iV4iV4iiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scalefps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scalefpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd256_mask3, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd256_maskz, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd128_mask3, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddpd128_maskz, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps256_mask3, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps256_maskz, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps128_mask3, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddps128_maskz, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd256_mask3, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd128_mask3, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps256_mask3, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps128_mask3, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd256_mask3, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd128_mask3, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps256_mask3, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps128_mask3, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd256_mask3, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd256_maskz, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd128_mask3, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubpd128_maskz, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps256_mask3, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps256_maskz, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps128_mask3, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubps128_maskz, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddpd256_mask3, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddpd128_mask3, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddps256_mask3, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddps128_mask3, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_insertf64x2_256_mask, "V4dV4dV2diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_inserti64x2_256_mask, "V4WiV4WiV2WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrav16hi_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrav8hi_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddubsw256_mask, "V16sV32cV32cV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddubsw128_mask, "V8sV16cV16cV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddwd256_mask, "V8iV16sV16sV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddwd128_mask, "V4iV8sV8sV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv16hi_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv8hi_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2dq256_mask, "V8iV8fV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2dq128_mask, "V4iV4fV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2udq256_mask, "V8iV8fV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2udq128_mask, "V4iV4fV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2qq256_mask, "V4WiV4fV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2qq128_mask, "V2WiV4fV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2uqq256_mask, "V4WiV4fV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2uqq128_mask, "V2WiV4fV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantps256_mask, "V8fV8fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_getmantps128_mask, "V4fV4fiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantpd256_mask, "V4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_getmantpd128_mask, "V2dV2diV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movddup256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movddup128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movshdup256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movshdup128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movsldup256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_movsldup128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtqq2ps256_mask, "V4fV4WiV4fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtqq2ps128_mask, "V4fV2WiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtuqq2ps256_mask, "V4fV4WiV4fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtuqq2ps128_mask, "V4fV2WiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtqq2pd256_mask, "V4dV4WiV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtqq2pd128_mask, "V2dV2WiV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtuqq2pd256_mask, "V4dV4WiV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtuqq2pd128_mask, "V2dV2WiV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varq256_maskz, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2vard256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2vard256_maskz, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2vard256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varpd256_mask, "V4dV4WiV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varpd256_maskz, "V4dV4WiV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varps256_mask, "V8fV8iV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varps256_maskz, "V8fV8iV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varpd256_mask, "V4dV4dV4WiV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varps256_mask, "V8fV8fV8iV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varq128_maskz, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2vard128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2vard128_maskz, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2vard128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varpd128_mask, "V2dV2WiV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varpd128_maskz, "V2dV2WiV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varps128_mask, "V4fV4iV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varps128_maskz, "V4fV4iV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varpd128_mask, "V2dV2dV2WiV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varps128_mask, "V4fV4fV4iV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshufb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshufb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshufhw256_mask, "V16sV16siV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshufhw128_mask, "V8sV8siV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshuflw256_mask, "V16sV16siV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshuflw128_mask, "V8sV8siV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pshufd256_mask, "V8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pshufd128_mask, "V4iV4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_shufpd256_mask, "V4dV4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shufpd128_mask, "V2dV2dV2diV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_shufps256_mask, "V8fV8fV8fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shufps128_mask, "V4fV4fV4fiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prolvq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prolvq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prolq256_mask, "V4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prolq128_mask, "V2WiV2WiiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prorvq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prorvq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prorq256_mask, "V4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prorq128_mask, "V2WiV2WiiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psravq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psravq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv4di_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv2di_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllv8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrav8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrav4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv4di_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv2di_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prorvd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prolvd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prord256_mask, "V8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prold256_mask, "V8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prorvd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prolvd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prord128_mask, "V4iV4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prold128_mask, "V4iV4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclasspd256_mask, "cV4diUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fpclasspd128_mask, "cV2diUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclasssd, "cV2di", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassps256_mask, "cV8fiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassps128_mask, "cV4fiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassss, "cV4fi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtb2mask128, "UsV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtb2mask256, "UiV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtw2mask128, "UcV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtw2mask256, "UsV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtd2mask128, "UcV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtd2mask256, "UcV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtq2mask128, "UcV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtq2mask256, "UcV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2b128, "V16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2b256, "V32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2w128, "V8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2w256, "V16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2d128, "V4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2d256, "V8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2q128, "V2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2q256, "V4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqb128_mask, "UsV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqb256_mask, "UiV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqw128_mask, "UcV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqw256_mask, "UsV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqd128_mask, "UcV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqd256_mask, "UcV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqq128_mask, "UcV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqq256_mask, "UcV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtb128_mask, "UsV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtb256_mask, "UiV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtw128_mask, "UcV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtw256_mask, "UsV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtd128_mask, "UcV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtd256_mask, "UcV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtq128_mask, "UcV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtq256_mask, "UcV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmb128, "UsV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmb256, "UiV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmw128, "UcV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmw256, "UsV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmd128, "UcV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmd256, "UcV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmq128, "UcV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmq256, "UcV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmb128, "UsV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmb256, "UiV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmw128, "UcV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmw256, "UsV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmd128, "UcV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmd256, "UcV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmq128, "UcV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmq256, "UcV4WiV4WiUc", "~ncV:256:", "")

// Auto-generated from gcc_builtin_headers_ia32-4.h from CBMC:
TARGET_BUILTIN(__builtin_ia32_broadcastmb128, "V2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastmb256, "V4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastmw128, "V4iUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastmw256, "V8iUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressdf256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressdf128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compresssf256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compresssf128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressdi256_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressdi128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compresssi256_mask, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compresssi128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expanddf256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expanddf128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandsf256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandsf128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expanddi256_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expanddi128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandsi256_mask, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandsi128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expanddf256_maskz, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expanddf128_maskz, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandsf256_maskz, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandsf128_maskz, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expanddi256_maskz, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expanddi128_maskz, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandsi256_maskz, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandsi128_maskz, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminsd256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxud256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminud256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminsd128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxud128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminud128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminsq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminuq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminsq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminuq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminsb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminub256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxub256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminsb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminub128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxub128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminsw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminuw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pminsw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pminuw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictdi_256_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictsi_256_mask, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntq_256_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntd_256_mask, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpckhps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictdi_128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictsi_128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntq_128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntd_128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_unpcklps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_alignd256_mask, "V8iV8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_alignq256_mask, "V4WiV4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_alignd128_mask, "V4iV4iV4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_alignq128_mask, "V2WiV2WiV2WiiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2ph256_mask, "V8sV8fiV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2ph_mask, "V8sV4fiV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2ps_mask, "V4fV8sV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2ps256_mask, "V8fV8sV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhdq128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhdq256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhqdq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhqdq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckldq128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckldq256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklqdq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklqdq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhbw128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhbw256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhwd128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhwd256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklbw128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklbw256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklwd128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklwd256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv16hi_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv8hi_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packssdw256_mask, "V16sV8iV8iV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packssdw128_mask, "V8sV4iV4iV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_packusdw256_mask, "V16sV8iV8iV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_packusdw128_mask, "V8sV4iV4iV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pavgb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pavgw256_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pavgb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pavgw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsf256_mask, "V8fV8fV8iV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvardf256_mask, "V4dV4dV4WiV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permdf256_mask, "V4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsb256_mask, "V32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsb128_mask, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pabsw256_mask, "V16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pabsw128_mask, "V8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarpd_mask, "V2dV2dV2WiV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarps_mask, "V4fV4fV4iV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarpd256_mask, "V4dV4dV4WiV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarps256_mask, "V8fV8fV8iV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilpd_mask, "V2dV2diV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilps_mask, "V4fV4fiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilpd256_mask, "V4dV4diV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilps256_mask, "V8fV8fiV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendmq_256_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendmd_256_mask, "V8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendmpd_256_mask, "V4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendmps_256_mask, "V8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendmq_128_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendmd_128_mask, "V4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendmpd_128_mask, "V2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendmps_128_mask, "V4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendmw_256_mask, "V16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendmb_256_mask, "V32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_blendmw_128_mask, "V8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_blendmb_128_mask, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmulld256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmulld128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmuludq256_mask, "V4WiV8iV8iV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmuldq256_mask, "V4WiV8iV8iV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmuldq128_mask, "V2WiV4iV4iV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmuludq128_mask, "V2WiV4iV4iV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2ps256_mask, "V4fV4dV4fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2ps_mask, "V4fV2dV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsi256_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvardi256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permdi256_mask, "V4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpq256_mask, "UcV4WiV4WiiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpd256_mask, "UcV8iV8iiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpq256_mask, "UcV4WiV4WiiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpd256_mask, "UcV8iV8iiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpb256_mask, "UiV32cV32ciUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpw256_mask, "UsV16sV16siUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpb256_mask, "UiV32cV32ciUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpw256_mask, "UsV16sV16siUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmppd256_mask, "cV4dV4diUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpps256_mask, "cV8fV8fiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cmpq128_mask, "UcV2WiV2WiiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpd128_mask, "UcV4iV4iiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpq128_mask, "UcV2WiV2WiiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpd128_mask, "UcV4iV4iiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpb128_mask, "UsV16cV16ciUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpw128_mask, "UcV8sV8siUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpb128_mask, "UsV16cV16ciUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpw128_mask, "UcV8sV8siUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmppd128_mask, "UcV2dV2diUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpps128_mask, "UcV4fV4fiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf32x2_512_mask, "V16fV4fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti32x2_512_mask, "V16iV4iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf64x2_512_mask, "V8dV2dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti64x2_512_mask, "V8WiV2WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcastf32x8_512_mask, "V16fV8fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_broadcasti32x8_512_mask, "V16iV8iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extractf64x2_512_mask, "V2dV8diV2dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extractf32x8_mask, "V8fV16fiV8fUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extracti64x2_512_mask, "V2WiV8WiiV2WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_extracti32x8_mask, "V8iV16iiV8iUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reducepd512_mask, "V8dV8diV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduceps512_mask, "V16fV16fiV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmullq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_xorpd512_mask, "V8dV8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_xorps512_mask, "V16fV16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_orpd512_mask, "V8dV8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_orps512_mask, "V16fV16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_andpd512_mask, "V8dV8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_andps512_mask, "V16fV16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_andnpd512_mask, "V8dV8dV8dV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_andnps512_mask, "V16fV16fV16fV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_insertf32x8_mask, "V16fV16fV8fiV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti32x8_mask, "V16iV16iV8iiV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_insertf64x2_512_mask, "V8dV8dV2diV8dUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti64x2_512_mask, "V8WiV8WiV2WiiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_fpclasspd512_mask, "cV8diUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassps512_mask, "sV16fiUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtd2mask512, "UsV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtq2mask512, "UcV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2d512, "V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2q512, "V8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_kunpcksi, "UiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kunpckdi, "ULLiULLiULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_packusdw512_mask, "V32sV16iV16iV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_packssdw512_mask, "V32sV16iV16iV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdquhi512_mask, "V32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_movdquqi512_mask, "V64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psadbw512, "V8WiV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_dbpsadbw512_mask, "V32sV64cV64ciV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb512_mask, "V64cV16cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastb512_gpr_mask, "V64ccV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw512_mask, "V32sV8sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pbroadcastw512_gpr_mask, "V32ssV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovsxbw512_mask, "V32sV32cV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovzxbw512_mask, "V32sV32cV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarhi512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varhi512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varhi512_maskz, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varhi512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pavgb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pavgw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubsb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddsb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubusb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddusb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubsw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddsw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psubusw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_paddusw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxuw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminuw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminsw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxub512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaxsb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminub512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pminsb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovwb512_mask, "V32cV32sV32cUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovswb512_mask, "V32cV32sV32cUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovuswb512_mask, "V32cV32sV32cUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrsw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhuw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmullw512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_packsswb512_mask, "V64cV32sV32sV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_packuswb512_mask, "V64cV32sV32sV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrav32hi_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddubsw512_mask, "V32sV64cV64cV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddwd512_mask, "V16iV32sV32sV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv32hi_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhbw512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpckhwd512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklbw512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_punpcklwd512_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshufb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshufhw512_mask, "V32sV32siV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshuflw512_mask, "V32sV32siV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtb2mask512, "ULLiV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtw2mask512, "UiV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2b512, "V64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtmask2w512, "V32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqb512_mask, "ULLiV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpeqw512_mask, "UiV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtb512_mask, "ULLiV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pcmpgtw512_mask, "UiV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmb512, "ULLiV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestmw512, "UiV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmb512, "ULLiV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ptestnmw512, "UiV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllv32hi_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pabsb512_mask, "V64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pabsw512_mask, "V32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_blendmw_512_mask, "V32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_blendmb_512_mask, "V64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cmpb512_mask, "ULLiV64cV64ciULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cmpw512_mask, "UiV32sV32siUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpb512_mask, "ULLiV64cV64ciULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ucmpw512_mask, "UiV32sV32siUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq512_maskz, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq512_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq512_maskz, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq256_maskz, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq256_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq256_maskz, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq128_maskz, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq128_maskz, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmultishiftqb512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmultishiftqb256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmultishiftqb128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permvarqi512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varqi512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varqi512_maskz, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varqi512_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarqi256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvarqi128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varqi256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varqi256_maskz, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varqi128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermt2varqi128_maskz, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varqi256_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varqi128_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rangesd128_round, "V2dV2dV2dii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rangess128_round, "V4fV4fV4fii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2qq512_mask, "V8WiV8dV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2qq512_mask, "V8WiV8fV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtpd2uqq512_mask, "V8WiV8dV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtps2uqq512_mask, "V8WiV8fV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtqq2ps512_mask, "V8fV8WiV8fci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtuqq2ps512_mask, "V8fV8WiV8fci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtqq2pd512_mask, "V8dV8WiV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtuqq2pd512_mask, "V8dV8WiV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2qq512_mask, "V8WiV8fV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvttps2uqq512_mask, "V8WiV8fV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2qq512_mask, "V8WiV8dV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvttpd2uqq512_mask, "V8WiV8dV8Wici", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rangeps512_mask, "V16fV16fV16fiV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rangepd512_mask, "V8dV8dV8diV8dci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_4fmaddps_mask, "V16fV16fV16fV16fV16fV16fV4fC*V16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_4fmaddps, "V16fV16fV16fV16fV16fV16fV4fC*", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_4fmaddss, "V4fV4fV4fV4fV4fV4fV4fC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_4fmaddss_mask, "V4fV4fV4fV4fV4fV4fV4fC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_4fnmaddps_mask, "V16fV16fV16fV16fV16fV16fV4fC*V16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_4fnmaddps, "V16fV16fV16fV16fV16fV16fV4fC*", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_4fnmaddss, "V4fV4fV4fV4fV4fV4fV4fC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_4fnmaddss_mask, "V4fV4fV4fV4fV4fV4fV4fC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vp4dpwssd, "V16iV16iV16iV16iV16iV16iV4iC*", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vp4dpwssd_mask, "V16iV16iV16iV16iV16iV16iV4iC*V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vp4dpwssds, "V16iV16iV16iV16iV16iV16iV4iC*", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vp4dpwssds_mask, "V16iV16iV16iV16iV16iV16iV4iC*V16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountd_v16si, "V16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountd_v16si_mask, "V16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountq_v8di, "V8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountq_v8di_mask, "V8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rdpid, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_sizeof, "ULi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xgetbv, "ULLii", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xsetbv, "viLLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_loadsd_mask, "V2ddC*V2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadss_mask, "V4ffC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storesd_mask, "vd*V2dUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storess_mask, "vf*V4fUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_2intersectd512, "vUs*Us*V16iV16i", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_2intersectq512, "vUc*Uc*V8WiV8Wi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_2intersectd256, "vUc*Uc*V8iV8i", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_2intersectq256, "vUc*Uc*V4WiV4Wi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_2intersectd128, "vUc*Uc*V4iV4i", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_2intersectq128, "vUc*Uc*V2WiV2Wi", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovwb128mem_mask, "vULLi*V8sUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovwb256mem_mask, "vV16c*V16sUs", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovswb128mem_mask, "vULLi*V8sUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovswb256mem_mask, "vV16c*V16sUs", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovuswb128mem_mask, "vULLi*V8sUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pmovuswb256mem_mask, "vV16c*V16sUs", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pmovuswb512mem_mask, "vV32c*V32sUi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovswb512mem_mask, "vV32c*V32sUi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmovwb512mem_mask, "vV32c*V32sUi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreuqi512_mask, "vV64c*V64cULLi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreuhi512_mask, "vV32s*V32sUi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreuqi256_mask, "vV32c*V32cUi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreuqi128_mask, "vV16c*V16cUs", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreuhi256_mask, "vV16s*V16sUs", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreuhi128_mask, "vV8s*V8sUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadqi512_mask, "V64cV64cC*V64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadqi512_maskz, "V64cV64cC*V64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadhi512_mask, "V32sV32sC*V32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadhi512_maskz, "V32sV32sC*V32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadqi256_mask, "V32cV32cC*V32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadqi256_maskz, "V32cV32cC*V32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadhi256_mask, "V16sV16sC*V16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadhi256_maskz, "V16sV16sC*V16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadqi128_mask, "V16cV16cC*V16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadqi128_maskz, "V16cV16cC*V16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadhi128_mask, "V8sV8sC*V8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandloadhi128_maskz, "V8sV8sC*V8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_wbinvd, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_directstoreu_u32, "vUi*Ui", "~n", "")
TARGET_BUILTIN(__builtin_ia32_directstoreu_u64, "vULLi*ULLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_wbnoinvd, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_movdir64b, "vv*vC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ptwrite32, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_ptwrite64, "vULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_enqcmd, "iv*vC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_enqcmds, "iv*vC*", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_serialize, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xsusldtrk, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_xresldtrk, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_clui, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_stui, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_senduipi, "vULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_urdmsr, "ULLiULLi", "n", "")
TARGET_BUILTIN(__builtin_ia32_uwrmsr, "vULLiULLi", "n", "")
TARGET_BUILTIN(__builtin_ia32_hreset, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_loadiwkey, "vV2WiV2WiV2WiUi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesdec128kl_u8, "UcV2Wi*V2WivC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesdec256kl_u8, "UcV2Wi*V2WivC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesenc128kl_u8, "UcV2Wi*V2WivC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesenc256kl_u8, "UcV2Wi*V2WivC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_encodekey128_u32, "UiUiV2Wiv*", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_encodekey256_u32, "UiUiV2WiV2Wiv*", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesdecwide128kl_u8, "UcV2Wi*V2WiC*vC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesdecwide256kl_u8, "UcV2Wi*V2WiC*vC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesencwide128kl_u8, "UcV2Wi*V2WiC*vC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesencwide256kl_u8, "UcV2Wi*V2WiC*vC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14sd_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp14ss_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14sd_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt14ss_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movesd_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_movess_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_floorps512, "V16fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ceilps512, "V16fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_truncps512, "V16fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_floorpd512, "V8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ceilpd512, "V8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_truncpd512, "V8dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_floorps_sfix512, "V16iV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_ceilps_sfix512, "V16iV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_kshiftliqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_kshiftriqi, "UcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_palignr256_mask, "V4WiV4WiV4WiiV4WiUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_palignr128_mask, "V2WiV2WiV2WiiV2WiUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducesd_mask, "V2dV2dV2diV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducess_mask, "V4fV4fV4fiV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllwi128_mask, "V8sV8siV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pslldi128_mask, "V4iV4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllqi128_mask, "V2WiV2WiiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pslld128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psllwi256_mask, "V16sV16siV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllw256_mask, "V16sV16sV8sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pslldi256_mask, "V8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pslld256_mask, "V8iV8iV4iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllqi256_mask, "V4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllq256_mask, "V4WiV4WiV2WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psradi128_mask, "V4iV4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrad128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psradi256_mask, "V8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrad256_mask, "V8iV8iV4iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psraqi128_mask, "V2WiV2WiiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psraq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psraqi256_mask, "V4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psraq256_mask, "V4WiV4WiV2WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrldi128_mask, "V4iV4iiV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrld128_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrldi256_mask, "V8iV8iiV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrld256_mask, "V8iV8iV4iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlqi128_mask, "V2WiV2WiiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlq128_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlqi256_mask, "V4WiV4WiiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlq256_mask, "V4WiV4WiV2WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd256_mask, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd256_maskz, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd128_mask, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd128_maskz, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps256_mask, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps256_maskz, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps128_mask, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps128_maskz, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd256_mask3, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd256_maskz, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd128_mask3, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd128_maskz, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps256_mask3, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps256_maskz, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps128_mask3, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps128_maskz, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd256_maskz, "V4dV4dV4dV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd128_maskz, "V2dV2dV2dV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps256_maskz, "V8fV8fV8fV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps128_maskz, "V4fV4fV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrawi256_mask, "V16sV16siV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psraw256_mask, "V16sV16sV8sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrawi128_mask, "V8sV8siV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psraw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlwi256_mask, "V16sV16siV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlw256_mask, "V16sV16sV8sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlwi128_mask, "V8sV8siV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlw128_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclasssd_mask, "cV2diUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassss_mask, "cV4fiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_pslldq512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrldq512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_palignr512, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_palignr512_mask, "V8WiV8WiV8WiiV8WiULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllwi512_mask, "V32sV32siV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllw512_mask, "V32sV32sV8sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrawi512_mask, "V32sV32siV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psraw512_mask, "V32sV32sV8sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlwi512_mask, "V32sV32siV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlw512_mask, "V32sV32sV8sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressqi512_mask, "V64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compresshi512_mask, "V32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressqi256_mask, "V32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressqi128_mask, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compresshi256_mask, "V16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compresshi128_mask, "V8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandqi512_mask, "V64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandqi512_maskz, "V64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandhi512_mask, "V32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandhi512_maskz, "V32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_expandqi256_mask, "V32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandqi256_maskz, "V32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandqi128_mask, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandqi128_maskz, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandhi256_mask, "V16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandhi256_maskz, "V16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_expandhi128_mask, "V8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_expandhi128_maskz, "V8sV8sV8sUc", "~ncV:128:", "")

// Auto-generated from gcc_builtin_headers_ia32-5.h from CBMC:
TARGET_BUILTIN(__builtin_ia32_vpshrd_v32hi, "V32sV32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v32hi_mask, "V32sV32sV32siV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v16hi, "V16sV16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v16hi_mask, "V16sV16sV16siV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v8hi, "V8sV8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v8hi_mask, "V8sV8sV8siV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v16si, "V16iV16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v16si_mask, "V16iV16iV16iiV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v8si, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v8si_mask, "V8iV8iV8iiV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v4si, "V4iV4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v4si_mask, "V4iV4iV4iiV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v8di, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v8di_mask, "V8WiV8WiV8WiiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v4di, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v4di_mask, "V4WiV4WiV4WiiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v2di, "V2WiV2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrd_v2di_mask, "V2WiV2WiV2WiiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v32hi, "V32sV32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v32hi_mask, "V32sV32sV32siV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v16hi, "V16sV16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v16hi_mask, "V16sV16sV16siV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v8hi, "V8sV8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v8hi_mask, "V8sV8sV8siV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v16si, "V16iV16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v16si_mask, "V16iV16iV16iiV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v8si, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v8si_mask, "V8iV8iV8iiV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v4si, "V4iV4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v4si_mask, "V4iV4iV4iiV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v8di, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v8di_mask, "V8WiV8WiV8WiiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v4di, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v4di_mask, "V4WiV4WiV4WiiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v2di, "V2WiV2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshld_v2di_mask, "V2WiV2WiV2WiiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v32hi, "V32sV32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v32hi_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v32hi_maskz, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v16hi, "V16sV16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v16hi_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v16hi_maskz, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8hi, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8hi_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8hi_maskz, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v16si, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v16si_maskz, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8si, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8si_maskz, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v4si, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v4si_maskz, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8di, "V8WiV8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8di_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v8di_maskz, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v4di, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v4di_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v4di_maskz, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v2di, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v2di_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdv_v2di_maskz, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v32hi, "V32sV32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v32hi_mask, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v32hi_maskz, "V32sV32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v16hi, "V16sV16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v16hi_mask, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v16hi_maskz, "V16sV16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8hi, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8hi_mask, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8hi_maskz, "V8sV8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v16si, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v16si_maskz, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8si, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8si_maskz, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v4si, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v4si_maskz, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8di, "V8WiV8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8di_mask, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v8di_maskz, "V8WiV8WiV8WiV8WiUc", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v4di, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v4di_mask, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v4di_maskz, "V4WiV4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v2di, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v2di_mask, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldv_v2di_maskz, "V2WiV2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineinvqb_v64qi, "V64cV64cV64ci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineinvqb_v64qi_mask, "V64cV64cV64ciV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineinvqb_v32qi, "V32cV32cV32ci", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineinvqb_v32qi_mask, "V32cV32cV32ciV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineinvqb_v16qi, "V16cV16cV16ci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineinvqb_v16qi_mask, "V16cV16cV16ciV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineqb_v64qi, "V64cV64cV64ci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineqb_v64qi_mask, "V64cV64cV64ciV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineqb_v32qi, "V32cV32cV32ci", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineqb_v32qi_mask, "V32cV32cV32ciV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineqb_v16qi, "V16cV16cV16ci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8affineqb_v16qi_mask, "V16cV16cV16ciV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8mulb_v64qi, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8mulb_v64qi_mask, "V64cV64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8mulb_v32qi, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8mulb_v32qi_mask, "V32cV32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8mulb_v16qi, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vgf2p8mulb_v16qi_mask, "V16cV16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v16si, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v16si_maskz, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v8si, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v8si_maskz, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v4si, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd_v4si_maskz, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v16si, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v16si_maskz, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v8si, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v8si_maskz, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v4si, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds_v4si_maskz, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v16si, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v16si_maskz, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v8si, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v8si_maskz, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v4si, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd_v4si_maskz, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v16si, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v16si_mask, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v16si_maskz, "V16iV16iV16iV16iUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v8si, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v8si_mask, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v8si_maskz, "V8iV8iV8iV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v4si, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v4si_mask, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds_v4si_maskz, "V4iV4iV4iV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpclmulqdq_v2di, "V2WiV2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpclmulqdq_v4di, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpclmulqdq_v8di, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountq_v4di, "V4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountq_v4di_mask, "V4WiV4WiV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountq_v2di, "V2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountq_v2di_mask, "V2WiV2WiV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountd_v4si, "V4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountd_v4si_mask, "V4iV4iV4iUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountd_v8si, "V8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountd_v8si_mask, "V8iV8iV8iUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountb_v64qi, "V64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountb_v64qi_mask, "V64cV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountb_v32qi, "V32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountb_v32qi_mask, "V32cV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountb_v16qi, "V16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountb_v16qi_mask, "V16cV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountw_v32hi, "V32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountw_v32hi_mask, "V32sV32sV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountw_v16hi, "V16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountw_v16hi_mask, "V16sV16sV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountw_v8hi, "V8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcountw_v8hi_mask, "V8sV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshufbitqmb512_mask, "ULLiV64cV64cULLi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshufbitqmb256_mask, "UiV32cV32cUi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshufbitqmb128_mask, "UsV16cV16cUs", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vaesdec_v16qi, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vaesdec_v32qi, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vaesdec_v64qi, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vaesdeclast_v16qi, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vaesdeclast_v32qi, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vaesdeclast_v64qi, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vaesenc_v16qi, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vaesenc_v32qi, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vaesenc_v64qi, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vaesenclast_v16qi, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vaesenclast_v32qi, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vaesenclast_v64qi, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v32hi, "V32sV16fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v32hi_mask, "V32sV16fV16fV32sUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v32hi_maskz, "V32sV16fV16fUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v16hi, "V16sV8fV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v16hi_mask, "V16sV8fV8fV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v16hi_maskz, "V16sV8fV8fUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v8hi, "V8sV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v8hi_mask, "V8sV4fV4fV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtne2ps2bf16_v8hi_maskz, "V8sV4fV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v16sf, "V16sV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v16sf_mask, "V16sV16fV16sUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v16sf_maskz, "V16sV16fUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v8sf, "V8sV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v8sf_mask, "V8sV8fV8sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v8sf_maskz, "V8sV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v4sf, "V8sV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v4sf_mask, "V8sV4fV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtneps2bf16_v4sf_maskz, "V8sV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v16sf, "V16fV16fV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v16sf_mask, "V16fV16fV32sV32sUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v16sf_maskz, "V16fV16fV32sV32sUs", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v8sf, "V8fV8fV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v8sf_mask, "V8fV8fV16sV16sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v8sf_maskz, "V8fV8fV16sV16sUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v4sf, "V4fV4fV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v4sf_mask, "V4fV4fV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_dpbf16ps_v4sf_maskz, "V4fV4fV8sV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtsd2ss_mask_round, "V4fV4fV2dV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cvtss2sd_mask_round, "V2dV2dV4fV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantsd_mask_round, "V2dV2dV2diV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantss_mask_round, "V4fV4fV4fiV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalesd_mask_round, "V2dV2dV2diV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaless_mask_round, "V4fV4fV4fiV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subsd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsd3_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsd3_mask3, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsd3_maskz, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubsd3_mask3, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddss3_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddss3_mask3, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddss3_maskz, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubss3_mask3, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd512_mask, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubpd512_maskz, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps512_mask, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubps512_maskz, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd512_mask3, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddpd512_maskz, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps512_mask3, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddps512_maskz, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubpd512_maskz, "V8dV8dV8dV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubps512_maskz, "V16fV16fV16fV16fsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28sd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28ss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28sd_mask_round, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28ss_mask_round, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducepd512_mask_round, "V8dV8diV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduceps512_mask_round, "V16fV16fiV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reducesd_mask_round, "V2dV2dV2diV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducess_mask_round, "V4fV4fV4fiV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rangesd128_mask_round, "V2dV2dV2diV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rangess128_mask_round, "V4fV4fV4fiV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rdsspd, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdsspq, "ULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_incsspd, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_incsspq, "vULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_saveprevssp, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rstorssp, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_wrssd, "vUiv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_wrssq, "vULLiv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_wrussd, "vUiv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_wrussq, "vULLiv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_setssbsy, "v", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_clrssbsy, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_addcarryx_u32, "UcUcUiUiUi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_addcarryx_u64, "UcUcULLiULLiULLi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_addph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassph128_mask, "UcV8hiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpph128_mask, "V8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantph128_mask, "V8hV8hiV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcpph128_mask, "V8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reduceph128_mask, "V8hV8hiV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleph128_mask, "V8hV8hiV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtph128_mask, "V8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtph128_mask, "V8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_divph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassph256_mask, "sV16hiUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_getexpph256_mask, "V16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_getmantph256_mask, "V16hV16hiV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maxph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_minph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_mulph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rcpph256_mask, "V16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_reduceph256_mask, "V16hV16hiV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleph256_mask, "V16hV16hiV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtph256_mask, "V16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_scalefph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtph256_mask, "V16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_subph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_addph512_mask, "V23hV23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divph512_mask, "V23hV23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_fpclassph512_mask, "iV23hiUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_getexpph512_mask, "V23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_getmantph512_mask, "V23hV23hiV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_maxph512_mask, "V23hV23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_minph512_mask, "V23hV23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_mulph512_mask, "V23hV23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rcpph512_mask, "V23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtph512_mask, "V23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_subph512_mask, "V23hV23hV23hV23hUi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addph512_mask_round, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divph512_mask_round, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_maxph512_mask_round, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_minph512_mask_round, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_mulph512_mask_round, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduceph512_mask_round, "V23hV23hiV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleph512_mask_round, "V23hV23hiV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scalefph512_mask_round, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtph512_mask_round, "V23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_subph512_mask_round, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_fpclasssh_mask, "cV8hiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadsh_mask, "V8hhC*V8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcpsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrtsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storesh_mask, "vhC*V8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vmovsh_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpsh_mask_round, "UcV8hV8hiUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantsh_mask_round, "V8hV8hV8hiV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reducesh_mask_round, "V8hV8hV8hiV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalesh_mask_round, "V8hV8hV8hiV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2dq128_mask, "V4iV8hV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2dq256_mask, "V8iV8hV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2udq128_mask, "V4iV8hV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2udq256_mask, "V8iV8hV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2dq128_mask, "V4iV8hV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2dq256_mask, "V8iV8hV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2udq128_mask, "V4iV8hV4iUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2udq256_mask, "V8iV8hV8iUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2qq128_mask, "V2WiV8hV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2qq256_mask, "V4WiV8hV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uqq128_mask, "V2WiV8hV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uqq256_mask, "V4WiV8hV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2qq128_mask, "V2WiV8hV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2qq256_mask, "V4WiV8hV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uqq128_mask, "V2WiV8hV2WiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uqq256_mask, "V4WiV8hV4WiUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2w128_mask, "V8sV8hV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2w256_mask, "V16sV16hV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uw128_mask, "V8sV8hV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uw256_mask, "V16sV16hV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2w128_mask, "V8sV8hV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2w256_mask, "V16sV16hV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uw128_mask, "V8sV8hV8sUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uw256_mask, "V16sV16hV16sUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtw2ph128_mask, "V8hV8sV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtw2ph256_mask, "V16hV16sV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuw2ph128_mask, "V8hV8sV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuw2ph256_mask, "V16hV16sV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtdq2ph128_mask, "V8hV4iV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtdq2ph256_mask, "V8hV8iV8hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtudq2ph128_mask, "V8hV4iV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtudq2ph256_mask, "V8hV8iV8hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtqq2ph128_mask, "V8hV2WiV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtqq2ph256_mask, "V8hV4WiV8hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuqq2ph128_mask, "V8hV2WiV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuqq2ph256_mask, "V8hV4WiV8hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2pd128_mask, "V2dV8hV2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2pd256_mask, "V4dV8hV4dUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2psx128_mask, "V4fV8hV4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2psx256_mask, "V8fV8hV8fUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2phx128_mask, "V8hV4fV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2phx256_mask, "V8hV8fV8hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtpd2ph128_mask, "V8hV2dV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtpd2ph256_mask, "V8hV4dV8hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph256_mask3, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph256_maskz, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph256_mask3, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph256_maskz, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph256_mask3, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph256_maskz, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph256_mask3, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph256_maskz, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph256_mask3, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph256_maskz, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph256_mask, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph256_mask3, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph256_maskz, "V16hV16hV16hV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph128, "V8hV8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph256, "V16hV16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph256_mask, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph256_mask3, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph256_maskz, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph128, "V8hV8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph128_mask3, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph128_maskz, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph256, "V16hV16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph256_mask, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph256_mask3, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph256_maskz, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcph128, "V8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcph256, "V16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcph256_mask, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcph128, "V8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcph128_mask, "V8hV8hV8hV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcph256, "V16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcph256_mask, "V16hV16hV16hV16hUc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2dq512_mask_round, "V16iV16hV16iUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2udq512_mask_round, "V16iV16hV16iUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2dq512_mask_round, "V16iV16hV16iUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2udq512_mask_round, "V16iV16hV16iUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2qq512_mask_round, "V8WiV8hV8WiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uqq512_mask_round, "V8WiV8hV8WiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2qq512_mask_round, "V8WiV8hV8WiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uqq512_mask_round, "V8WiV8hV8WiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2w512_mask_round, "V32sV23hV32sUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uw512_mask_round, "V32sV23hV32sUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2w512_mask_round, "V32sV23hV32sUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uw512_mask_round, "V32sV23hV32sUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtw2ph512_mask_round, "V23hV32sV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuw2ph512_mask_round, "V23hV32sV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtdq2ph512_mask_round, "V16hV16iV16hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtudq2ph512_mask_round, "V16hV16iV16hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtqq2ph512_mask_round, "V8hV8WiV8hUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuqq2ph512_mask_round, "V8hV8WiV8hUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2si32_round, "iV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2si64_round, "LLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2usi32_round, "UiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2usi64_round, "ULLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2si32_round, "iV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2si64_round, "LLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2usi32_round, "UiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2usi64_round, "ULLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsi2sh32_round, "V8hV8hii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsi2sh64_round, "V8hV8hLLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtusi2sh32_round, "V8hV8hUii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtusi2sh64_round, "V8hV8hULLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2pd512_mask_round, "V8dV8hV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2psx512_mask_round, "V16fV16hV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtpd2ph512_mask_round, "V8hV8dV8hUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2phx512_mask_round, "V16hV16fV16hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2ss_mask_round, "V4fV8hV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2sd_mask_round, "V2dV8hV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtss2sh_mask_round, "V8hV4fV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsd2sh_mask_round, "V8hV2dV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph512_mask, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph512_mask3, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph512_maskz, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph512_mask, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph512_mask3, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubaddph512_maskz, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph512_mask, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph512_mask3, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph512_maskz, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph512_mask, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph512_mask3, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddph512_maskz, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph512_mask, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph512_mask3, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubph512_maskz, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph512_mask, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph512_mask3, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmsubph512_maskz, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsh3_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsh3_mask3, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsh3_maskz, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddsh3_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddsh3_mask3, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfnmaddsh3_maskz, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmsubsh3_mask3, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph512_round, "V23hV23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph512_mask_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph512_mask3_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph512_maskz_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph512_round, "V23hV23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph512_mask_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph512_mask3_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph512_maskz_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcph512_round, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcph512_mask_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcph512_round, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcph512_mask_round, "V23hV23hV23hV23hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_round, "V8hV8hV8hV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_mask3_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_maskz_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_round, "V8hV8hV8hV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_mask3_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_maskz_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcsh_round, "V8hV8hV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcsh_round, "V8hV8hV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcsh_mask_round, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_monitorx, "vvC*UiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_mwaitx, "vUiUiUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdseed_di_step, "iULLi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_rdseed_hi_step, "iUs*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_rdseed_si_step, "iUi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_readeflags_u64, "ULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_writeeflags_u64, "vULLi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_sbb_u32, "UcUcUiUiUi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_sbb_u64, "UcUcULLiULLiULLi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_testui, "Uc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_tpause, "UcUi.", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_umonitor, "vv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_umwait, "UcUi.", "~nc", "")

// Auto-generated from gcc_builtin_headers_ia32-6.h from CBMC:
TARGET_BUILTIN(__builtin_ia32_tdpfp16ps, "vUcUcUc", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_tdpfp16ps_internal, "V256iUsUsUsV256iV256iV256i", "~ncV:8192:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v16hi, "sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v32qi, "cV32ci", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v4di, "LLiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vec_ext_v8si, "iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v16hi, "V16sV16ssi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v32qi, "V32cV32cci", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v4di, "V4WiV4WiLLii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vec_set_v8si, "V8iV8iii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_d, "V4iV4iiC*V4iV4ic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_d256, "V8iV8iiC*V8iV8ic", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_pd, "V2dV2ddC*V4iV2dc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_pd256, "V4dV4ddC*V4iV4dc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_ps, "V4fV4ffC*V4iV4fc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_ps256, "V8fV8ffC*V8iV8fc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_q, "V2WiV2WiLLiC*V4iV2Wic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherd_q256, "V4WiV4WiLLiC*V4iV4Wic", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_d, "V4iV4iiC*V2WiV4ic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_d256, "V4iV4iiC*V4WiV4ic", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_pd, "V2dV2ddC*V2WiV2dc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_pd256, "V4dV4ddC*V4WiV4dc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_ps, "V4fV4ffC*V2WiV4fc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_ps256, "V4fV4ffC*V4WiV4fc", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_q, "V2WiV2WiLLiC*V2WiV2Wic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_gatherq_q256, "V4WiV4WiLLiC*V4WiV4Wic", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pslldqi256_byteshift, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrldqi256_byteshift, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_selectpbf_512, "V23hUiV23hV23h", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_selectsbf_128, "V8hUcV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_selectpbf_128, "V8hUcV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_selectpbf_256, "V16hUsV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneps2bf16128, "V8hV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneps2bf16256, "V8hV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntb_512, "V64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntw_512, "V32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_dbpsadbw512, "V32sV64cV64ci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_packssdw512, "V32sV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_packsswb512, "V64cV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_packusdw512, "V32sV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_packuswb512, "V64cV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pavgb512, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pavgw512, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarhi512, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddubsw512, "V32sV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmaddwd512, "V16iV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhrsw512, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhuw512, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmulhw512, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshufb512, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshufhw512, "V32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshuflw512, "V32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pslldqi512_byteshift, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllv32hi, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllw512, "V32sV32sV8s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllwi512, "V32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrav32hi, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psraw512, "V32sV32sV8s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrawi512, "V32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrldqi512_byteshift, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv32hi, "V32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlw512, "V32sV32sV8s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlwi512, "V32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varhi512, "V32sV32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_dbpsadbw128, "V8sV16cV16ci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_dbpsadbw256, "V16sV32cV32ci", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvarhi128, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permvarhi256, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv16hi, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psllv8hi, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrav16hi, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrav8hi, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv16hi, "V16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv8hi, "V8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictdi_512, "V8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictsi_512, "V16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntd_512, "V16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntq_512, "V8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictdi_128, "V2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictdi_256, "V4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictsi_128, "V4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpconflictsi_256, "V8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntd_128, "V4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntd_256, "V8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntq_128, "V2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vplzcntq_256, "V4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_insertf32x8, "V16fV16fV8fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_insertf64x2_512, "V8dV8dV2di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti32x8, "V16iV16iV8ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti64x2_512, "V8WiV8WiV2Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rangesd128_round_mask, "V2dV2dV2dV2dUcii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rangess128_round_mask, "V4fV4fV4fV4fUcii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_insertf64x2_256, "V4dV4dV2di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_inserti64x2_256, "V4WiV4WiV2Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28sd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rcp28ss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28sd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rsqrt28ss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addpd512, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addps512, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_addss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_alignd512, "V16iV16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_alignq512, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divpd512, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divps512, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpsd128_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpss128_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantsd_round_mask, "V2dV2dV2diV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantss_round_mask, "V4fV4fV4fiV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_insertf32x4, "V16fV16fV4fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_insertf64x4, "V8dV8dV4di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti32x4, "V16iV16iV4ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_inserti64x4, "V8WiV8WiV4Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_loadsd128_mask, "V2dV2dC*V2dUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadss128_mask, "V4fV4fC*V4fUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxpd512, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_maxps512, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_maxsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minpd512, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_minps512, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_minsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulpd512, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_mulps512, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_mulsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permdf512, "V8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permdi512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvardf512, "V8dV8dV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvardi512, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsf512, "V16fV16fV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarsi512, "V16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmuldq512, "V8WiV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pmuludq512, "V8WiV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prold512, "V16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prolq512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prolvd512, "V16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prolvq512, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prord512, "V16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prorq512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prorvd512, "V16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_prorvq512, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pshufd512, "V16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pslld512, "V16iV16iV4i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pslldi512, "V16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllq512, "V8WiV8WiV2Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllqi512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllv16si, "V16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psllv8di, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrad512, "V16iV16iV4i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psradi512, "V16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psraq512, "V8WiV8WiV2Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psraqi512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrav16si, "V16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrav8di, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrld512, "V16iV16iV4i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrldi512, "V16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlq512, "V8WiV8WiV2Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlqi512, "V8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv16si, "V16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_psrlv8di, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fadd_pd512, "ddV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fadd_ps512, "ffV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmax_pd512, "dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmax_ps512, "fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmin_pd512, "dV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmin_ps512, "fV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmul_pd512, "ddV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmul_ps512, "ffV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalesd_round_mask, "V2dV2dV2dV2dUcii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaless_round_mask, "V4fV4fV4fV4fUcii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_selectq_512, "V8WiUcV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f32x4, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f64x2, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i32x4, "V16iV16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i64x2, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shufpd512, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_shufps512, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storesd128_mask, "vV2d*V2dUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storess128_mask, "vV4f*V4fUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subpd512, "V8dV8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_subps512, "V16fV16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_subsd_round_mask, "V2dV2dV2dV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subss_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2vard512, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varpd512, "V8dV8dV8WiV8d", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varps512, "V16fV16fV16iV16f", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varq512, "V8WiV8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilpd512, "V8dV8di", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilps512, "V16fV16fi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarpd512, "V8dV8dV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermilvarps512, "V16fV16fV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_aesdec512, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_aesdeclast512, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_aesenc512, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_aesenclast512, "V8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_pclmulqdq512, "V8WiV8WiV8Wic", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addph512, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_addsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpph512_mask, "UiV23hV23hiUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_cmpsh_mask, "UcV8hV8hiUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_divph512, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_divsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getexpsh128_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_getmantsh_round_mask, "V8hV8hV8hiV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_loadsh128_mask, "V8hV8hC*V8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxph512, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_maxsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minph512, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_minsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_mulph512, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_mulsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fadd_ph512, "hhV23h", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmax_ph512, "hV23h", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmin_ph512, "hV23h", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmul_ph512, "hhV23h", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reduceph512_mask, "V23hV23hiV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_reducesh_mask, "V8hV8hV8hV8hUcii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleph_mask, "V23hV23hiV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_rndscalesh_round_mask, "V8hV8hV8hV8hUcii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_scalefph512_mask, "V23hV23hV23hV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_scalefsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_selectph_512, "V23hUiV23hV23h", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_selectsh_128, "V8hUcV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtph512, "V23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_storesh128_mask, "vV8h*V8hUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_subph512, "V23hV23hV23hi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_subsh_round_mask, "V8hV8hV8hV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcomish, "iV8hV8hii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtdq2ph512_mask, "V16hV16iV16hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtpd2ph512_mask, "V8hV8dV8hUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2dq512_mask, "V16iV16hV16iUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2pd512_mask, "V8dV8hV8dUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2psx512_mask, "V16fV16hV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2qq512_mask, "V8WiV8hV8WiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2udq512_mask, "V16UiV16hV16UiUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uqq512_mask, "V8UWiV8hV8UWiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2uw512_mask, "V32UsV23hV32UsUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtph2w512_mask, "V32sV23hV32sUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtps2phx512_mask, "V16hV16fV16hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtqq2ph512_mask, "V8hV8WiV8hUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsd2sh_round_mask, "V8hV8hV2dV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2sd_round_mask, "V2dV2dV8hV2dUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2si32, "iV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2si64, "LLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2ss_round_mask, "V4fV4fV8hV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2usi32, "UiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsh2usi64, "ULLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsi2sh, "V8hV8hii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtsi642sh, "V8hV8hLLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtss2sh_round_mask, "V8hV8hV4fV8hUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2dq512_mask, "V16iV16hV16iUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2qq512_mask, "V8WiV8hV8WiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2udq512_mask, "V16UiV16hV16UiUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uqq512_mask, "V8UWiV8hV8UWiUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2uw512_mask, "V32UsV23hV32UsUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttph2w512_mask, "V32sV23hV32sUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2si32, "iV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2si64, "LLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2usi32, "UiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvttsh2usi64, "ULLiV8hi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtudq2ph512_mask, "V16hV16UiV16hUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuqq2ph512_mask, "V8hV8UWiV8hUci", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtusi2sh, "V8hV8hUii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtusi642sh, "V8hV8hULLii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtuw2ph512_mask, "V23hV32UsV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtw2ph512_mask, "V23hV32sV23hUii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph512_mask, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph512_mask3, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcph512_maskz, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_maskz, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmaddcsh_round_mask3, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcph512_mask, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfcmulcsh_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph512_mask, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph512_mask3, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcph512_maskz, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_maskz, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_round_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddcsh_round_mask3, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcph512_mask, "V16fV16fV16fV16fUsi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vfmulcsh_mask, "V4fV4fV4fV4fUci", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpph128_mask, "UcV8hV8hiUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_cmpph256_mask, "UsV16hV16hiUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_maxph128, "V8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_maxph256, "V16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_minph128, "V8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_minph256, "V16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fadd_ph128, "hhV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fadd_ph256, "hhV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmax_ph128, "hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmax_ph256, "hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmin_ph128, "hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmin_ph256, "hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmul_ph128, "hhV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_reduce_fmul_ph256, "hhV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleph_128_mask, "V8hV8hiV8hUc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_rndscaleph_256_mask, "V16hV16hiV16hUs", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_selectph_128, "V8hUcV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_selectph_256, "V16hUsV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtph, "V8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_sqrtph256, "V16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph, "V8hV8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddph256, "V16hV16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph, "V8hV8hV8hV8h", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsubph256, "V16hV16hV16hV16h", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq512, "V8WiV8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq512, "V8WiV8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq128, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52huq256, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq128, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmadd52luq256, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvarqi512, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varqi512, "V64cV64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpmultishiftqb512, "V64cV64cV64c", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_permvarqi128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_permvarqi256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varqi128, "V16cV16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varqi256, "V32cV32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpmultishiftqb128, "V16cV16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpmultishiftqb256, "V32cV32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstorehi512_mask, "vV32s*V32sUi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreqi512_mask, "vV64c*V64cULLi", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldd512, "V16iV16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldq512, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvd512, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvq512, "V8WiV8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvw512, "V32sV32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldw512, "V32sV32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdd512, "V16iV16iV16ii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdq512, "V8WiV8WiV8Wii", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvd512, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvq512, "V8WiV8WiV8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvw512, "V32sV32sV32sV32s", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdw512, "V32sV32sV32si", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_alignd128, "V4iV4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_alignd256, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_alignq128, "V2WiV2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_alignq256, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_insertf32x4_256, "V8fV8fV4fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_inserti32x4_256, "V8iV8iV4ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvardf256, "V4dV4dV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_permvardi256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prold128, "V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prold256, "V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prolq128, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prolq256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prolvd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prolvd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prolvq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prolvq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prord128, "V4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prord256, "V8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prorq128, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prorq256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prorvd128, "V4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prorvd256, "V8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_prorvq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_prorvq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psraq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psraq256, "V4WiV4WiV2Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psraqi128, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psraqi256, "V4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_psravq128, "V2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psravq256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_selectq_128, "V2WiUcV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_selectq_256, "V4WiUcV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f32x4_256, "V8fV8fV8fi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_f64x2_256, "V4dV4dV4di", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i32x4_256, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_shuf_i64x2_256, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2vard128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2vard256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varpd128, "V2dV2dV2WiV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varpd256, "V4dV4dV4WiV4d", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varps128, "V4fV4fV4iV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varps256, "V8fV8fV8iV8f", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varq128, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varq256, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntb_128, "V16cV16c", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntb_256, "V32cV32c", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntw_128, "V8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntw_256, "V16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varhi128, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpermi2varhi256, "V16sV16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstorehi128_mask, "vV8s*V8sUc", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressstorehi256_mask, "vV16s*V16sUs", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreqi128_mask, "vV16c*V16cUs", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_compressstoreqi256_mask, "vV32c*V32cUi", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldd128, "V4iV4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldd256, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldq128, "V2WiV2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldq256, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvd128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvd256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvq128, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvq256, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvw128, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldvw256, "V16sV16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldw128, "V8sV8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshldw256, "V16sV16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdd128, "V4iV4iV4ii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdd256, "V8iV8iV8ii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdq128, "V2WiV2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdq256, "V4WiV4WiV4Wii", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvd128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvd256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvq128, "V2WiV2WiV2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvq256, "V4WiV4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvw128, "V8sV8sV8sV8s", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdvw256, "V16sV16sV16sV16s", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdw128, "V8sV8sV8si", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpshrdw256, "V16sV16sV16si", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusd512, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbusds512, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssd512, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpwssds512, "V16iV16iV16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vp2intersect_q_512, "vV8WiV8WiUc*Uc*", "~nV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vp2intersect_q_128, "vV2WiV2WiUc*Uc*", "~nV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vp2intersect_q_256, "vV4WiV4WiUc*Uc*", "~nV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntd_512, "V16iV16i", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntq_512, "V8WiV8Wi", "~ncV:512:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntd_128, "V4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntd_256, "V8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntq_128, "V2WiV2Wi", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpopcntq_256, "V4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbcstnebf162ps128, "V4fhC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vbcstnebf162ps256, "V8fhC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vbcstnesh2ps128, "V4fhC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vbcstnesh2ps256, "V8fhC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneebf162ps128, "V4fV8hC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneebf162ps256, "V8fV16hC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneeph2ps128, "V4fV8hC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneeph2ps256, "V8fV16hC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneobf162ps128, "V4fV8hC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneobf162ps256, "V8fV16hC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneoph2ps128, "V4fV8hC*", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vcvtneoph2ps256, "V8fV16hC*", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbssd128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbssd256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbssds128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbssds256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbsud128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbsud256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbsuds128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbsuds256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbuud128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbuud256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbuuds128, "V4iV4iV4iV4i", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpdpbuuds256, "V8iV8iV8iV8i", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_readeflags_u32, "Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_subborrow_u32, "UcUcUiUiUi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_subborrow_u64, "UcUcULLiULLiULLi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_writeeflags_u32, "vUi", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_cmpccxadd32, "iv*iii", "~n", "")
TARGET_BUILTIN(__builtin_ia32_cmpccxadd64, "LLiv*LLiLLii", "~n", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddsd, "V2dV2dV2dV2d", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vfmaddss, "V4fV4fV4fV4f", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_invpcid, "vUiv*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_directstore_u32, "vUi*Ui", "~n", "")
TARGET_BUILTIN(__builtin_ia32_directstore_u64, "vULi*ULi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_prefetchi, "vvC*Ui", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_aadd32, "vv*i", "~n", "")
TARGET_BUILTIN(__builtin_ia32_aadd64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_aand32, "vv*i", "~n", "")
TARGET_BUILTIN(__builtin_ia32_aand64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_aor32, "vv*i", "~n", "")
TARGET_BUILTIN(__builtin_ia32_aor64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_axor32, "vv*i", "~n", "")
TARGET_BUILTIN(__builtin_ia32_axor64, "vv*LLi", "~n", "")
TARGET_BUILTIN(__builtin_ia32_rdpru, "ULLii", "~nc", "")
TARGET_BUILTIN(__builtin_ia32_rdseed16_step, "UiUs*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_rdseed32_step, "UiUi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_rdseed64_step, "UiULLi*", "~n", "")
TARGET_BUILTIN(__builtin_ia32_pslldqi128_byteshift, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_psrldqi128_byteshift, "V2WiV2Wii", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_aesdec256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_aesdeclast256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_aesenc256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_aesenclast256, "V4WiV4WiV4Wi", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_pclmulqdq256, "V4WiV4WiV4Wic", "~ncV:256:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomb, "V16cV16cV16cc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomd, "V4iV4iV4ic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomq, "V2WiV2WiV2Wic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomub, "V16cV16cV16cc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomud, "V4iV4iV4ic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomuq, "V2WiV2WiV2Wic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomuw, "V8sV8sV8sc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vpcomw, "V8sV8sV8sc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotbi, "V16cV16cc", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotdi, "V4iV4ic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotqi, "V2WiV2Wic", "~ncV:128:", "")
TARGET_BUILTIN(__builtin_ia32_vprotwi, "V8sV8sc", "~ncV:128:", "")

// These are derived from Microsoft intrincis.
// https://learn.microsoft.com/en-us/cpp/intrinsics/x86-intrinsics-list?view=msvc-170
TARGET_BUILTIN(__movsb, "vUc*UcC*z", "~ncf", "")
TARGET_BUILTIN(__movsd, "vUi*UiC*z", "~ncf", "")
TARGET_BUILTIN(__movsq, "vUWi*UWiC*z", "~ncf", "")
TARGET_BUILTIN(__movsw, "vUs*UsC*z", "~ncf", "")
TARGET_BUILTIN(_mm256_castps256_ps128, "V4fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtpd_ps, "V4fV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_extractf128_ps, "V4fV8fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i64gather_ps, "V4ffC*V4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i64gather_ps, "V4fV4ffC*V4WiV4fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_add_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_add_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_addsub_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_and_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_andnot_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blend_ps, "V4fV4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blend_ps, "V4fV4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blendv_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_broadcast_ss, "V4ffC*", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_broadcastss_ps, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_castpd_ps, "V4fV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_castsi128_ps, "V4fV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmp_ps, "V4fV4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmp_ss, "V4fV4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpge_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpge_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmple_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmple_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmplt_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmplt_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpneq_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpneq_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnge_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnge_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpngt_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpngt_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnle_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnle_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnlt_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnlt_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpord_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpord_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpunord_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpunord_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvt_pi2ps, "V4fV4fV1Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvt_si2ss, "V4fV4fi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi32_ps, "V4fV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtpd_ps, "V4fV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtph_ps, "V4fV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsd_ss, "V4fV4fV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi64_ss, "V4fV4fWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi64x_ss, "V4fV4fWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_div_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_div_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_dp_ps, "V4fV4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmaddsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmaddsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsubadd_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsubadd_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_frcz_ps, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_frcz_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hadd_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsub_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i32gather_ps, "V4ffC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i64gather_ps, "V4ffC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_insert_ps, "V4fV4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_load_ps, "V4ff*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_load_ps1, "V4ff*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_load_ss, "V4ff*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadh_pi, "V4fV4fV1Wi*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadl_pi, "V4fV4fV1Wi*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadr_ps, "V4ff*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadu_ps, "V4ff*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_macc_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_macc_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maddsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i32gather_ps, "V4fV4ffC*V2WiV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i64gather_ps, "V4fV4ffC*V2WiV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maskload_ps, "V4ffC*V2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_move_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movehdup_ps, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movehl_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_moveldup_ps, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movelh_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_msub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_msub_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_msubadd_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mul_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mul_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmacc_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmacc_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmsub_ps, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmsub_ss, "V4fV4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_or_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_permute2_ps, "V4fV4fV4fV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_permute_ps, "V4fV4fi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_permutevar_ps, "V4fV4fV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rcp_ps, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rcp_ss, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_round_ps, "V4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_round_ss, "V4fV4fV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rsqrt_ps, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rsqrt_ss, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_ps, "V4fffff", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_ps1, "V4ff", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_ss, "V4ff", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setr_ps, "V4fffff", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setzero_ps, "V4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shuffle_ps, "V4fV4fV4fUi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shuffle_ps, "V4fV4fV4fUi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sqrt_ps, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sqrt_ss, "V4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sub_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sub_ss, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpackhi_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpacklo_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_xor_ps, "V4fV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm256_castpd256_pd128, "V2dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_extractf128_pd, "V2dV4diC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_add_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_add_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_addsub_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_and_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_andnot_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blend_pd, "V2dV2dV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blend_pd, "V2dV2dV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blendv_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_broadcastsd_pd, "V2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_castps_pd, "V2dV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_castsi128_pd, "V2dV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmp_pd, "V2dV2dV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmp_sd, "V2dV2dV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpge_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpge_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmple_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmple_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmplt_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmplt_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpneq_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpneq_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnge_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnge_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpngt_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpngt_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnle_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnle_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnlt_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpnlt_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpord_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpord_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpunord_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpunord_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi32_pd, "V2dV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtpi32_pd, "V2dV1Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtps_pd, "V2dV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi32_sd, "V2dV2di", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi64_sd, "V2dV2dWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi64x_sd, "V2dV2dWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtss_sd, "V2dV2dV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_div_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_div_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_dp_pd, "V2dV2dV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmadd_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmaddsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmaddsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsub_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsubadd_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fmsubadd_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmadd_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_fnmsub_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_frcz_pd, "V2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_frcz_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hadd_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsub_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i32gather_pd, "V2ddC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i64gather_pd, "V2ddC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_load1_pd, "V2dd*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_load_pd, "V2dd*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_load_sd, "V2dd*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loaddup_pd, "V2ddC*", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_loadh_pd, "V2dV2dd*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadl_pd, "V2dV2dd*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadr_pd, "V2dd*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadu_pd, "V2dd*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_macc_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_macc_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maddsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i32gather_pd, "V2dV2ddC*V2WiV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i64gather_pd, "V2dV2ddC*V2WiV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maskload_pd, "V2ddC*V2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_move_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movedup_pd, "V2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_msub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_msub_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_msubadd_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mul_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mul_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmacc_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmacc_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmsub_pd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_nmsub_sd, "V2dV2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_or_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_permute2_pd, "V2dV2dV2dV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_permute_pd, "V2dV2di", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_permutevar_pd, "V2dV2dV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_round_pd, "V2dV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_round_sd, "V2dV2dV2diC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set1_pd, "V2dd", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_pd, "V2ddd", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_sd, "V2dd", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setr_pd, "V2ddd", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setzero_pd, "V2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shuffle_pd, "V2dV2dV2di", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sqrt_pd, "V2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sqrt_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sub_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sub_sd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpackhi_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpacklo_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_xor_pd, "V2dV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm256_castsi256_si128, "V2WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtpd_epi32, "V2WiV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtps_ph, "V2WiV8fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvttpd_epi32, "V2WiV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_extractf128_si256, "V2WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_extracti128_si256, "V2WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i64gather_epi32, "V2WiV2WiiC*V4WiV2WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_abs_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_abs_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_abs_epi8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_add_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_add_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_add_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_add_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_adds_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_adds_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_adds_epu16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_adds_epu8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aesdec_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aesdeclast_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aesenc_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aesenclast_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aesimc_si128, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aesimc_si128, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aeskeygenassist_si128, "V2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_aeskeygenassist_si128, "V2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_alignr_epi8, "V2WiV2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_and_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_andnot_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_avg_epu16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_avg_epu8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blend_epi16, "V2WiV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blend_epi16, "V2WiV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blend_epi32, "V2WiV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blendv_epi8, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_blendv_epi8, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_broadcastb_epi8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_broadcastd_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_broadcastq_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_broadcastw_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_castpd_si128, "V2WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_castps_si128, "V2WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_clmulepi64_si128, "V2WiV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_clmulepi64_si128, "V2WiV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmov_si128, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpeq_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpestrm, "V2WiV2WiiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpgt_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpistrm, "V2WiV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmplt_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmplt_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmplt_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_com_epi16, "V2WiV2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_com_epi32, "V2WiV2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_com_epi8, "V2WiV2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_com_epu16, "V2WiV2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_com_epu32, "V2WiV2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_com_epu8, "V2WiV2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi16_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi16_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi32_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi8_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi8_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi8_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi8_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi8_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepi8_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu16_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu16_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu32_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu8_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu8_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu8_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu8_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu8_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtepu8_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtpd_epi32, "V2WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtps_epi32, "V2WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtps_ph, "V2WiV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi32_si128, "V2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi64_si128, "V2WiWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi64x_si128, "V2WiWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttpd_epi32, "V2WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttps_epi32, "V2WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extract_si64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extracti_si64, "V2WiV2Wiii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hadd_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hadd_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddd_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddd_epi8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddd_epu16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddd_epu8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddq_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddq_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddq_epi8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddq_epu16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddq_epu32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddq_epu8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hadds_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddw_epi8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_haddw_epu8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsub_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsub_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsubd_epi16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsubq_epi32, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsubs_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hsubw_epi8, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i32gather_epi32, "V2WiiC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i32gather_epi64, "V2WiWiC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i64gather_epi32, "V2WiiC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_i64gather_epi64, "V2WiWiC*V2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_insert_epi16, "V2WiV2Wiii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_insert_epi32, "V2WiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_insert_epi64, "V2WiV2WiWiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_insert_epi8, "V2WiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_insert_epi8, "V2WiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_insert_si64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_inserti_si64, "V2WiV2WiV2Wiii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_lddqu_si128, "V2WiV2WiC*", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_load_si128, "V2WiV2Wi*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadl_epi64, "V2WiV2Wi*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_loadu_si128, "V2WiV2Wi*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_macc_epi16, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_macc_epi32, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maccd_epi16, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_macchi_epi32, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_macclo_epi32, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maccs_epi16, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maccs_epi32, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maccsd_epi16, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maccshi_epi32, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maccslo_epi32, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_madd_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maddd_epi16, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maddsd_epi16, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maddubs_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i32gather_epi32, "V2WiV2WiiC*V2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i32gather_epi64, "V2WiV2WiWiC*V2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i64gather_epi32, "V2WiV2WiiC*V2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mask_i64gather_epi64, "V2WiV2WiWiC*V2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maskload_epi32, "V2WiiC*V2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_maskload_epi64, "V2WiWiC*V2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_epu16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_epu32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_max_epu8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_epu16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_epu32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_min_epu8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_minpos_epu16, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_move_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movpi64_epi64, "V2WiV1Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mpsadbw_epu8, "V2WiV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mul_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mul_epu32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mulhi_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mulhi_epu16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mulhrs_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mullo_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mullo_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_or_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_packs_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_packs_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_packus_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_packus_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_perm_epi8, "V2WiV2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi16, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi32, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi64, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_rot_epi8, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sad_epu8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set1_epi16, "V2Wis", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set1_epi32, "V2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set1_epi64, "V2WiV1Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set1_epi64x, "V2WiWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set1_epi8, "V2Wic", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_epi16, "V2Wissssssss", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_epi32, "V2Wiiiii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_epi64, "V2WiV1WiV1Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_epi64x, "V2WiWiWi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_set_epi8, "V2Wicccccccccccccccc", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setl_epi64, "V2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setr_epi16, "V2Wissssssss", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setr_epi32, "V2Wiiiii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setr_epi64, "V2WiV1WiV1Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setr_epi8, "V2Wicccccccccccccccc", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_setzero_si128, "V2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sha_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sha_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sha_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sha_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shl_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shl_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shl_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shl_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shuffle_epi32, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shuffle_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shufflehi_epi16, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_shufflelo_epi16, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sign_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sign_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sign_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sll_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sll_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sll_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_slli_epi16, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_slli_epi32, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_slli_epi64, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_slli_si128, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sllv_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sllv_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sra_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sra_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srai_epi16, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srai_epi32, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srav_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srl_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srl_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srl_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srli_epi16, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srli_epi32, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srli_epi64, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srli_si128, "V2WiV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srlv_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_srlv_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_stream_load_si128, "V2WiV2Wi*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_sub_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sub_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sub_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_sub_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_subs_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_subs_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_subs_epu16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_subs_epu8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpackhi_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpackhi_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpackhi_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpackhi_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpacklo_epi16, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpacklo_epi32, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpacklo_epi64, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_unpacklo_epi8, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_xor_si128, "V2WiV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm256_add_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_addsub_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_and_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_andnot_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_blend_ps, "V8fV8fV8fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_blendv_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcast_ps, "V8fV4fC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcast_ss, "V8ffC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastss_ps, "V8fV4f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castpd_ps, "V8fV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castps128_ps256, "V8fV4f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castsi256_ps, "V8fV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmp_ps, "V8fV8fV8fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi32_ps, "V8fV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtph_ps, "V8fV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_div_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_dp_ps, "V8fV8fV8fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmadd_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmadd_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmaddsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmaddsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsubadd_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsubadd_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmadd_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmadd_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_frcz_ps, "V8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hadd_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hsub_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i32gather_ps, "V8ffC*V4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_insertf128_ps, "V8fV8fV4fi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_load_ps, "V8ffC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_loadu_ps, "V8ffC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i32gather_ps, "V8fV8ffC*V4WiV8fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_maskload_ps, "V8ffC*V4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_movehdup_ps, "V8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_moveldup_ps, "V8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mul_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_or_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute2_ps, "V8fV8fV8fV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute2f128_ps, "V8fV8fV8fi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute_ps, "V8fV8fi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permutevar8x32_ps, "V8fV8fV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permutevar8x32_ps, "V8fV8fV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permutevar_ps, "V8fV8fV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_rcp_ps, "V8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_round_ps, "V8fV8fi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_rsqrt_ps, "V8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set1_ps, "V8ff", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set_ps, "V8fffffffff", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setr_ps, "V8fffffffff", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setzero_ps, "V8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_shuffle_ps, "V8fV8fV8fiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sqrt_ps, "V8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sub_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpackhi_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpacklo_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_xor_ps, "V8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_macc_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_maddsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_msub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_msubadd_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_nmacc_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_nmsub_ps, "V8fV8fV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_add_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_addsub_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_and_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_andnot_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_blend_pd, "V4dV4dV4diC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_blendv_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcast_pd, "V4dV2dC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcast_sd, "V4ddC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastsd_pd, "V4dV2d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castpd128_pd256, "V4dV2d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castps_pd, "V4dV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castsi256_pd, "V4dV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmp_pd, "V4dV4dV4diC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi32_pd, "V4dV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtps_pd, "V4dV4f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_div_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmadd_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmadd_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmaddsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmaddsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsubadd_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fmsubadd_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmadd_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmadd_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_fnmsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_frcz_pd, "V4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hadd_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hsub_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i32gather_pd, "V4ddC*V2WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i64gather_pd, "V4ddC*V4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_insertf128_pd, "V4dV4dV2di", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_load_pd, "V4ddC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_loadu_pd, "V4ddC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i32gather_pd, "V4dV4ddC*V2WiV4diC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i64gather_pd, "V4dV4ddC*V4WiV4diC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_maskload_pd, "V4ddC*V4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_movedup_pd, "V4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mul_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_or_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute2_pd, "V4dV4dV4dV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute2f128_pd, "V4dV4dV4di", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute4x64_pd, "V4dV4diC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute_pd, "V4dV4di", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permutevar_pd, "V4dV4dV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_round_pd, "V4dV4di", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set1_pd, "V4dd", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set_pd, "V4ddddd", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setr_pd, "V4ddddd", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setzero_pd, "V4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_shuffle_pd, "V4dV4dV4diC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sqrt_pd, "V4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sub_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpackhi_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpacklo_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_xor_pd, "V4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_macc_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_maddsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_msub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_msubadd_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_nmacc_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_nmsub_pd, "V4dV4dV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_abs_epi16, "V4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_abs_epi32, "V4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_abs_epi8, "V4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_add_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_add_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_add_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_add_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_adds_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_adds_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_adds_epu16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_adds_epu8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_alignr_epi8, "V4WiV4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_and_si256, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_andnot_si256, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_avg_epu16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_avg_epu8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_blend_epi16, "V4WiV4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_blend_epi32, "V4WiV4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_blendv_epi8, "V4WiV4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastb_epi8, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastb_epi8, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastd_epi32, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastq_epi64, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastsi128_si256, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_broadcastw_epi16, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castpd_si256, "V4WiV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castps_si256, "V4WiV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_castsi128_si256, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmov_si256, "V4WiV4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpeq_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpeq_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpeq_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpeq_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpgt_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpgt_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpgt_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cmpgt_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi16_epi32, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi16_epi64, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi32_epi64, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi8_epi16, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi8_epi32, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepi8_epi64, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepu16_epi32, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepu16_epi64, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepu32_epi64, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepu8_epi16, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepu8_epi32, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtepu8_epi64, "V4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvtps_epi32, "V4WiV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_cvttps_epi32, "V4WiV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hadd_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hadd_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hadds_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hsub_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hsub_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_hsubs_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i32gather_epi32, "V4WiiC*V4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i32gather_epi64, "V4WiWiC*V2WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i64gather_epi32, "V4WiiC*V4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_i64gather_epi64, "V4WiWiC*V4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_insertf128_si256, "V4WiV4WiV2Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_inserti128_si256, "V4WiV4WiV2Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_lddqu_si256, "V4WiV4Wi*", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_load_si256, "V4WiV4Wi*", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_loadu_si256, "V4WiV4Wi*", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_madd_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_maddubs_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i32gather_epi32, "V4WiV4WiiC*V4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i32gather_epi64, "V4WiV4WiWiC*V2WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mask_i64gather_epi64, "V4WiV4WiWiC*V4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_maskload_epi32, "V4WiiC*V4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_maskload_epi64, "V4WiWiC*V4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_epu16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_epu32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_max_epu8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_epu16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_epu32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_min_epu8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mpsadbw_epu8, "V4WiV4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mul_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mul_epu32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mulhi_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mulhi_epu16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mulhrs_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mullo_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_mullo_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_or_si256, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_packs_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_packs_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_packus_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_packus_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute2f128_si256, "V4WiV4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute2x128_si256, "V4WiV4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute4x64_epi64, "V4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permute4x64_epi64, "V4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_permutevar8x32_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sad_epu8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set1_epi16, "V4Wis", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set1_epi32, "V4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set1_epi64x, "V4WiWi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set1_epi8, "V4Wic", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set_epi16, "V4Wissssssssssssssss", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set_epi32, "V4Wiiiiiiiii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set_epi64x, "V4WiWiWiWiWi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_set_epi8, "V4Wicccccccccccccccccccccccccccccccc", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setr_epi16, "V4Wissssssssssssssss", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setr_epi32, "V4Wiiiiiiiii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setr_epi64x, "V4WiWiWiWiWi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setr_epi8, "V4Wicccccccccccccccccccccccccccccccc", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_setzero_si256, "V4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_shuffle_epi32, "V4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_shuffle_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_shufflehi_epi16, "V4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_shufflelo_epi16, "V4WiV4WiiC", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sign_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sign_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sign_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sll_epi16, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sll_epi32, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sll_epi64, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_slli_epi16, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_slli_epi32, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_slli_epi64, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_slli_si256, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sllv_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sllv_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sra_epi16, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sra_epi32, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srai_epi16, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srai_epi32, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srav_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srl_epi16, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srl_epi32, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srl_epi64, "V4WiV4WiV2Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srli_epi16, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srli_epi32, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srli_epi64, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srli_si256, "V4WiV4Wii", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srlv_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_srlv_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_stream_load_si256, "V4WiV4WiC*", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sub_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sub_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sub_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_sub_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_subs_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_subs_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_subs_epu16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_subs_epu8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpackhi_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpackhi_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpackhi_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpackhi_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpacklo_epi16, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpacklo_epi32, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpacklo_epi64, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_unpacklo_epi8, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_xor_si256, "V4WiV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_m_from_float, "V1Wif", "~ncfV:64:", "")
TARGET_BUILTIN(_m_from_int, "V1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_packssdw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_packsswb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_packuswb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_paddb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_paddd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_paddsb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_paddsw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_paddusb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_paddusw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_paddw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pand, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pandn, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pavgb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pavgusb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pavgw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pcmpeqb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pcmpeqd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pcmpeqw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pcmpgtb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pcmpgtd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pcmpgtw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pf2id, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pf2iw, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfacc, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfadd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfcmpeq, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfcmpge, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfcmpgt, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfmax, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfmin, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfmul, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfnacc, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfpnacc, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfrcp, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfrcpit1, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfrcpit2, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfrsqit1, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfrsqrt, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfsub, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pfsubr, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pi2fd, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pi2fw, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pinsrw, "V1WiV1Wiii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmaddwd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmaxsw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmaxub, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pminsw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pminub, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmulhrw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmulhuw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmulhw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmullw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_por, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psadbw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pshufw, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pslld, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pslldi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psllq, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psllqi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psllw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psllwi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrad, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psradi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psraw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrawi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrld, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrldi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrlq, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrlqi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrlw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psrlwi, "V1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psubb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psubd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psubsb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psubsw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psubusb, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psubusw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_psubw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pswapd, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_punpckhbw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_punpckhdq, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_punpckhwd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_punpcklbw, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_punpckldq, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_punpcklwd, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pxor, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_abs_pi16, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_abs_pi32, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_abs_pi8, "V1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_add_si64, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_alignr_pi8, "V1WiV1WiV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_cvt_ps2pi, "V1WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtpd_pi32, "V1WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtt_ps2pi, "V1WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttpd_pi32, "V1WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_hadd_pi16, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_hadd_pi32, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_hadds_pi16, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_hsub_pi16, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_hsub_pi32, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_hsubs_pi16, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_maddubs_pi16, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_movepi64_pi64, "V1WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_mul_su32, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_mulhrs_pi16, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_set1_pi16, "V1Wis", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_set1_pi32, "V1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_set1_pi8, "V1Wic", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_set_pi16, "V1Wissss", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_set_pi32, "V1Wiii", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_set_pi8, "V1Wicccccccc", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_setr_pi16, "V1Wissss", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_setr_pi32, "V1Wiii", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_setr_pi8, "V1Wicccccccc", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_setzero_si64, "V1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_shuffle_pi8, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_sign_pi16, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_sign_pi32, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_sign_pi8, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_sub_si64, "V1WiV1WiV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_InterlockedAnd8, "ccD*c", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd8_np, "cc*c", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange8, "ccD*cc", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange8, "ccD*c", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd8, "ccD*c", "~nf", "")
TARGET_BUILTIN(_InterlockedOr8, "ccD*c", "~nf", "")
TARGET_BUILTIN(_InterlockedOr8_np, "cc*c", "~nf", "")
TARGET_BUILTIN(_InterlockedXor8, "ccD*c", "~nf", "")
TARGET_BUILTIN(_InterlockedXor8_np, "cc*c", "~nf", "")
TARGET_BUILTIN(_castu64_f64, "dUWi", "~ncf", "")
TARGET_BUILTIN(_castu64_f64, "dUWi", "~ncf", "")
TARGET_BUILTIN(_mm_cvtsd_f64, "dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_castu32_f32, "fUi", "~ncf", "")
TARGET_BUILTIN(_castu32_f32, "fUi", "~ncf", "")
TARGET_BUILTIN(_m_to_float, "fV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm_cvtss_f32, "fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_div64, "iWiii*", "~nf", "")
TARGET_BUILTIN(_div64, "iWiii*", "~nf", "")
TARGET_BUILTIN(_m_pextrw, "iV1Wii", "~ncfV:64:", "")
TARGET_BUILTIN(_m_pmovmskb, "iV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_m_to_int, "iV1Wi", "~ncfV:64:", "")
TARGET_BUILTIN(_mm256_movemask_epi8, "iV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_movemask_pd, "iV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_movemask_ps, "iV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testc_pd, "iV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testc_ps, "iV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testc_si256, "iV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testnzc_pd, "iV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testnzc_ps, "iV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testnzc_si256, "iV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testz_pd, "iV4dV4d", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testz_ps, "iV8fV8f", "~ncfV:256:", "")
TARGET_BUILTIN(_mm256_testz_si256, "iV4WiV4Wi", "~ncfV:256:", "")
TARGET_BUILTIN(_mm_cmpestra, "iV2WiiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpestrc, "iV2WiiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpestri, "iV2WiiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpestro, "iV2WiiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpestrs, "iV2WiiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpestrz, "iV2WiiV2WiiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpistra, "iV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpistrc, "iV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpistri, "iV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpistro, "iV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpistrs, "iV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cmpistrz, "iV2WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comieq_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comieq_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comige_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comige_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comigt_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comigt_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comile_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comile_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comilt_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comilt_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comineq_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_comineq_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvt_ss2si, "iV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsd_si32, "iV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi128_si32, "iV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtt_ss2si, "iV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttsd_si32, "iV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extract_epi16, "iV2Wii", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extract_epi32, "iV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extract_epi8, "iV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extract_epi8, "iV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extract_ps, "iV4fiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movemask_epi8, "iV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movemask_pd, "iV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_movemask_ps, "iV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_popcnt_u32, "iUi", "~ncf", "")
TARGET_BUILTIN(_mm_popcnt_u32, "iUi", "~ncf", "")
TARGET_BUILTIN(_mm_testc_pd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testc_ps, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testc_si128, "iV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testnzc_pd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testnzc_ps, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testnzc_si128, "iV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testz_pd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testz_ps, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_testz_si128, "iV2WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomieq_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomieq_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomige_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomige_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomigt_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomigt_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomile_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomile_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomilt_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomilt_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomineq_sd, "iV2dV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_ucomineq_ss, "iV4fV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_rdrand16_step, "iUs*", "~nf", "")
TARGET_BUILTIN(_rdrand32_step, "iUi*", "~nf", "")
TARGET_BUILTIN(_rdrand32_step, "iUi*", "~nf", "")
TARGET_BUILTIN(_rdrand64_step, "iUWi*", "~nf", "")
TARGET_BUILTIN(_rdseed16_step, "iUs*", "~nf", "")
TARGET_BUILTIN(_rdseed32_step, "iUi*", "~nf", "")
TARGET_BUILTIN(_rdseed32_step, "iUi*", "~nf", "")
TARGET_BUILTIN(_rdseed64_step, "iUWi*", "~nf", "")
TARGET_BUILTIN(_sarx_i32, "iiUi", "~ncf", "")
TARGET_BUILTIN(_sarx_i32, "iiUi", "~ncf", "")
TARGET_BUILTIN(_InterlockedAddLargeStatistic, "iWiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd_HLEAcquire, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd_HLERelease, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange, "iiD*ii", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange_HLEAcquire, "iiD*ii", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange_HLERelease, "iiD*ii", "~nf", "")
TARGET_BUILTIN(_InterlockedDecrement, "iiD*", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd_HLEAcquire, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd_HLERelease, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange_HLEAcquire, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange_HLERelease, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedIncrement, "iiD*", "~nf", "")
TARGET_BUILTIN(_InterlockedOr, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedOr_HLEAcquire, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedOr_HLERelease, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedXor, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedXor_HLEAcquire, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedXor_HLERelease, "iiD*i", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd64, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd64_HLEAcquire, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd64_HLERelease, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd64_np, "WiWi*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange64, "WiWiD*WiWi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange64_HLEAcquire, "WiWiD*WiWi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange64_HLERelease, "WiWiD*WiWi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange64_np, "WiWi*WiWi", "~nf", "")
TARGET_BUILTIN(_InterlockedDecrement64, "WiWiD*", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange64, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange64_HLEAcquire, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange64_HLERelease, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd64, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd64_HLEAcquire, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd64_HLERelease, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedIncrement64, "WiWiD*", "~nf", "")
TARGET_BUILTIN(_InterlockedOr64, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedOr64_HLEAcquire, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedOr64_HLERelease, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedOr64_np, "WiWi*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedXor64, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedXor64_HLEAcquire, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedXor64_HLERelease, "WiWiD*Wi", "~nf", "")
TARGET_BUILTIN(_InterlockedXor64_np, "WiWi*Wi", "~nf", "")
TARGET_BUILTIN(__emul, "Wiii", "~ncf", "")
TARGET_BUILTIN(__ll_rshift, "WiWii", "~ncf", "")
TARGET_BUILTIN(__mulh, "WiWiWi", "~ncf", "")
TARGET_BUILTIN(_div128, "WiWiWiWiWi*", "~nf", "")
TARGET_BUILTIN(_mm_cvtsd_si64, "WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsd_si64x, "WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi128_si64, "WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtsi128_si64x, "WiV2Wi", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtss_si64, "WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvtss_si64x, "WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttsd_si64, "WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttsd_si64x, "WiV2d", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttss_si64, "WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_cvttss_si64x, "WiV4f", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_extract_epi64, "WiV2WiiC", "~ncfV:128:", "")
TARGET_BUILTIN(_mm_popcnt_u64, "WiUWi", "~ncf", "")
TARGET_BUILTIN(_mul128, "WiWiWiWi*", "~nf", "")
TARGET_BUILTIN(_sarx_i64, "WiWiUi", "~ncf", "")
TARGET_BUILTIN(_InterlockedAnd, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd_HLEAcquire, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd_HLERelease, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd_np, "LiLi*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange, "LiLiD*LiLi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange_HLEAcquire, "LiLiD*LiLi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange_HLERelease, "LiLiD*LiLi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange_np, "LiLi*LiLi", "~nf", "")
TARGET_BUILTIN(_InterlockedDecrement, "LiLiD*", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd_HLEAcquire, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd_HLERelease, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange_HLEAcquire, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange_HLERelease, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedIncrement, "LiLiD*", "~nf", "")
TARGET_BUILTIN(_InterlockedOr, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedOr_HLEAcquire, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedOr_HLERelease, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedOr_np, "LiLi*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedXor, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedXor_HLEAcquire, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedXor_HLERelease, "LiLiD*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedXor_np, "LiLi*Li", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd16, "ssD*s", "~nf", "")
TARGET_BUILTIN(_InterlockedAnd16_np, "ss*s", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange16, "ssD*ss", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange16_np, "ssD*ss", "~nf", "")
TARGET_BUILTIN(_InterlockedDecrement16, "ssD*", "~nf", "")
TARGET_BUILTIN(_InterlockedExchange16, "ssD*s", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangeAdd16, "ssD*s", "~nf", "")
TARGET_BUILTIN(_InterlockedIncrement16, "ssD*", "~nf", "")
TARGET_BUILTIN(_InterlockedOr16, "ssD*s", "~nf", "")
TARGET_BUILTIN(_InterlockedOr16_np, "ss*s", "~nf", "")
TARGET_BUILTIN(_InterlockedXor16, "ssD*s", "~nf", "")
TARGET_BUILTIN(_InterlockedXor16_np, "ss*s", "~nf", "")
TARGET_BUILTIN(__readcr0, "z", "~ncf", "")
TARGET_BUILTIN(__readcr2, "z", "~ncf", "")
TARGET_BUILTIN(__readcr3, "z", "~ncf", "")
TARGET_BUILTIN(__readcr4, "z", "~ncf", "")
TARGET_BUILTIN(__readcr8, "z", "~ncf", "")
TARGET_BUILTIN(__readdr, "zUi", "~ncf", "")
TARGET_BUILTIN(__readeflags, "z", "~ncf", "")
TARGET_BUILTIN(__readgsqword, "zUi", "~ncf", "")
TARGET_BUILTIN(__getcallerseflags, "Ui", "~ncf", "")
TARGET_BUILTIN(__indword, "UiUs", "~ncf", "")
TARGET_BUILTIN(__lzcnt, "UiUi", "~ncf", "")
TARGET_BUILTIN(__popcnt, "UiUi", "~ncf", "")
TARGET_BUILTIN(__readfsdword, "UiUi", "~ncf", "")
TARGET_BUILTIN(__readgsdword, "UiUi", "~ncf", "")
TARGET_BUILTIN(__segmentlimit, "UiUi", "~ncf", "")
TARGET_BUILTIN(_andn_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_bextr_u32, "UiUiUiUi", "~ncf", "")
TARGET_BUILTIN(_bextri_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_blcfill_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blci_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blcic_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blcmsk_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blcs_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsfill_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsi_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsic_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsmsk_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsr_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_bzhi_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_castf32_u32, "Uif", "~ncf", "")
TARGET_BUILTIN(_castf32_u32, "Uif", "~ncf", "")
TARGET_BUILTIN(_lzcnt_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_mm_crc32_u16, "UiUiUs", "~ncf", "")
TARGET_BUILTIN(_mm_crc32_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_mm_crc32_u8, "UiUiUc", "~ncf", "")
TARGET_BUILTIN(_mm_getcsr, "Ui", "~ncf", "")
TARGET_BUILTIN(_mulx_u32, "UiUiUiUi*", "~nf", "")
TARGET_BUILTIN(_pdep_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_pext_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_readfsbase_u32, "Ui", "~ncf", "")
TARGET_BUILTIN(_readgsbase_u32, "Ui", "~ncf", "")
TARGET_BUILTIN(_rorx_u32, "UiUiUiC", "~ncf", "")
TARGET_BUILTIN(_shlx_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_shrx_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_t1mskc_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_tzcnt_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_tzmsk_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_udiv64, "UiUWiUiUi*", "~nf", "")
TARGET_BUILTIN(__emulu, "UWiUiUi", "~ncf", "")
TARGET_BUILTIN(__emulu, "UWiUiUi", "~ncf", "")
TARGET_BUILTIN(__ll_lshift, "UWiUWii", "~ncf", "")
TARGET_BUILTIN(__lzcnt64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(__popcnt64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(__rdtsc, "UWi", "~ncf", "")
TARGET_BUILTIN(__rdtscp, "UWiUi*", "~nf", "")
TARGET_BUILTIN(__rdtscp, "UWiUi*", "~nf", "")
TARGET_BUILTIN(__readmsr, "UWiUi", "~ncf", "")
TARGET_BUILTIN(__readpmc, "UWiUi", "~ncf", "")
TARGET_BUILTIN(__shiftleft128, "UWiUWiUWiUc", "~ncf", "")
TARGET_BUILTIN(__shiftright128, "UWiUWiUWiUc", "~ncf", "")
TARGET_BUILTIN(__ull_rshift, "UWiUWii", "~ncf", "")
TARGET_BUILTIN(__umulh, "UWiUWiUWi", "~ncf", "")
TARGET_BUILTIN(_andn_u64, "UWiUWiUWi", "~ncf", "")
TARGET_BUILTIN(_bextr_u64, "UWiUWiUiUi", "~ncf", "")
TARGET_BUILTIN(_bextri_u64, "UWiUWiUi", "~ncf", "")
TARGET_BUILTIN(_blcfill_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blci_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blcic_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blcmsk_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blcs_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blsfill_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blsi_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blsic_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blsmsk_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_blsr_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_bzhi_u64, "UWiUWiUi", "~ncf", "")
TARGET_BUILTIN(_castf64_u64, "UWid", "~ncf", "")
TARGET_BUILTIN(_castf64_u64, "UWid", "~ncf", "")
TARGET_BUILTIN(_lzcnt_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_mm_crc32_u64, "UWiUWiUWi", "~ncf", "")
TARGET_BUILTIN(_mulx_u64, "UWiUWiUWiUWi*", "~nf", "")
TARGET_BUILTIN(_pdep_u64, "UWiUWiUWi", "~ncf", "")
TARGET_BUILTIN(_pext_u64, "UWiUWiUWi", "~ncf", "")
TARGET_BUILTIN(_readfsbase_u64, "UWi", "~ncf", "")
TARGET_BUILTIN(_readgsbase_u64, "UWi", "~ncf", "")
TARGET_BUILTIN(_rorx_u64, "UWiUWiUiC", "~ncf", "")
TARGET_BUILTIN(_shlx_u64, "UWiUWiUi", "~ncf", "")
TARGET_BUILTIN(_shrx_u64, "UWiUWiUi", "~ncf", "")
TARGET_BUILTIN(_t1mskc_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_tzcnt_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_tzmsk_u64, "UWiUWi", "~ncf", "")
TARGET_BUILTIN(_udiv128, "UWiUWiUWiUWiUWi*", "~nf", "")
TARGET_BUILTIN(_umul128, "UWiUWiUWiUWi*", "~nf", "")
TARGET_BUILTIN(_xgetbv, "UWiUi", "~ncf", "")
TARGET_BUILTIN(_xgetbv, "UWiUi", "~ncf", "")
TARGET_BUILTIN(_xbegin, "Ui", "~ncf", "")
TARGET_BUILTIN(_BitScanForward, "UcUi*Ui", "~nf", "")
TARGET_BUILTIN(_BitScanForward64, "UcUi*UWi", "~nf", "")
TARGET_BUILTIN(_BitScanReverse, "UcUi*Ui", "~nf", "")
TARGET_BUILTIN(_BitScanReverse64, "UcUi*UWi", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchange128, "UcWiD*WiWiWi*", "~nf", "")
TARGET_BUILTIN(__inbyte, "UcUs", "~ncf", "")
TARGET_BUILTIN(__lwpins32, "UcUiUiUi", "~ncf", "")
TARGET_BUILTIN(__lwpins32, "UcUiUiUi", "~ncf", "")
TARGET_BUILTIN(__lwpins64, "UcUWiUiUi", "~ncf", "")
TARGET_BUILTIN(__readfsbyte, "UcUi", "~ncf", "")
TARGET_BUILTIN(__readgsbyte, "UcUi", "~ncf", "")
TARGET_BUILTIN(__vmx_on, "UcUWi*", "~nf", "")
TARGET_BUILTIN(__vmx_vmclear, "UcUWi*", "~nf", "")
TARGET_BUILTIN(__vmx_vmlaunch, "Uc", "~ncf", "")
TARGET_BUILTIN(__vmx_vmptrld, "UcUWi*", "~nf", "")
TARGET_BUILTIN(__vmx_vmread, "Uczz*", "~nf", "")
TARGET_BUILTIN(__vmx_vmresume, "Uc", "~ncf", "")
TARGET_BUILTIN(__vmx_vmwrite, "Uczz", "~ncf", "")
TARGET_BUILTIN(_addcarry_u16, "UcUcUsUsUs*", "~nf", "")
TARGET_BUILTIN(_addcarry_u32, "UcUcUiUiUi*", "~nf", "")
TARGET_BUILTIN(_addcarry_u32, "UcUcUiUiUi*", "~nf", "")
TARGET_BUILTIN(_addcarry_u64, "UcUcUWiUWiUWi*", "~nf", "")
TARGET_BUILTIN(_addcarry_u8, "UcUcUcUcUc*", "~nf", "")
TARGET_BUILTIN(_addcarryx_u32, "UcUcUiUiUi*", "~nf", "")
TARGET_BUILTIN(_addcarryx_u32, "UcUcUiUiUi*", "~nf", "")
TARGET_BUILTIN(_addcarryx_u64, "UcUcUWiUWiUWi*", "~nf", "")
TARGET_BUILTIN(_bittest, "UciC*i", "~ncf", "")
TARGET_BUILTIN(_bittest, "UcLiC*Li", "~ncf", "")
TARGET_BUILTIN(_bittest64, "UcWiC*Wi", "~ncf", "")
TARGET_BUILTIN(_bittestandcomplement, "Uci*i", "~nf", "")
TARGET_BUILTIN(_bittestandcomplement, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_bittestandcomplement64, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_bittestandreset, "Uci*i", "~nf", "")
TARGET_BUILTIN(_bittestandreset, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_bittestandreset64, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_bittestandset, "Uci*i", "~nf", "")
TARGET_BUILTIN(_bittestandset, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_bittestandset64, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset, "Uci*i", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset64, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset64_HLEAcquire, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset64_HLERelease, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset_HLEAcquire, "Uci*i", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset_HLEAcquire, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset_HLERelease, "Uci*i", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandreset_HLERelease, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset, "Uci*i", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset64, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset64_HLEAcquire, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset64_HLERelease, "UcWi*Wi", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset_HLEAcquire, "Uci*i", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset_HLEAcquire, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset_HLERelease, "Uci*i", "~nf", "")
TARGET_BUILTIN(_interlockedbittestandset_HLERelease, "UcLi*Li", "~nf", "")
TARGET_BUILTIN(_rotl8, "UcUcUc", "~ncf", "")
TARGET_BUILTIN(_rotr8, "UcUcUc", "~ncf", "")
TARGET_BUILTIN(_subborrow_u16, "UcUcUsUsUs*", "~nf", "")
TARGET_BUILTIN(_subborrow_u32, "UcUcUiUiUi*", "~nf", "")
TARGET_BUILTIN(_subborrow_u32, "UcUcUiUiUi*", "~nf", "")
TARGET_BUILTIN(_subborrow_u64, "UcUcUWiUWiUWi*", "~nf", "")
TARGET_BUILTIN(_subborrow_u8, "UcUcUcUcUc*", "~nf", "")
TARGET_BUILTIN(_xtest, "Uc", "~ncf", "")
TARGET_BUILTIN(__getcallerseflags, "Ui", "~ncf", "")
TARGET_BUILTIN(__lzcnt, "UiUi", "~ncf", "")
TARGET_BUILTIN(__popcnt, "UiUi", "~ncf", "")
TARGET_BUILTIN(_andn_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_bextr_u32, "UiUiUiUi", "~ncf", "")
TARGET_BUILTIN(_bextri_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_blcfill_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blci_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blcic_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blcmsk_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blcs_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsfill_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsi_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsic_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsmsk_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_blsr_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_bzhi_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_lzcnt_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_mm_crc32_u16, "UiUiUs", "~ncf", "")
TARGET_BUILTIN(_mm_crc32_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_mm_crc32_u8, "UiUiUc", "~ncf", "")
TARGET_BUILTIN(_mm_getcsr, "Ui", "~ncf", "")
TARGET_BUILTIN(_mulx_u32, "UiUiUiUi*", "~nf", "")
TARGET_BUILTIN(_pdep_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_pext_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_rorx_u32, "UiUiUiC", "~ncf", "")
TARGET_BUILTIN(_shlx_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_shrx_u32, "UiUiUi", "~ncf", "")
TARGET_BUILTIN(_t1mskc_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_tzcnt_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_tzmsk_u32, "UiUi", "~ncf", "")
TARGET_BUILTIN(_udiv64, "UiUWiUiUi*", "~nf", "")
TARGET_BUILTIN(__inword, "UsUs", "~ncf", "")
TARGET_BUILTIN(__lzcnt16, "UsUs", "~ncf", "")
TARGET_BUILTIN(__popcnt16, "UsUs", "~ncf", "")
TARGET_BUILTIN(__readfsword, "UsUi", "~ncf", "")
TARGET_BUILTIN(__readgsword, "UsUi", "~ncf", "")
TARGET_BUILTIN(_rotl16, "UsUsUc", "~ncf", "")
TARGET_BUILTIN(_rotr16, "UsUsUc", "~ncf", "")
TARGET_BUILTIN(_AddressOfReturnAddress, "v*", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangePointer, "v*v*D*v*", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangePointer_HLEAcquire, "v*v*D*v*", "~nf", "")
TARGET_BUILTIN(_InterlockedExchangePointer_HLERelease, "v*v*D*v*", "~nf", "")
TARGET_BUILTIN(_ReturnAddress, "v*", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchangePointer, "v*v*D*v*v*", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchangePointer_HLEAcquire, "v*v*D*v*v*", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchangePointer_HLERelease, "v*v*D*v*v*", "~nf", "")
TARGET_BUILTIN(_InterlockedCompareExchangePointer_np, "v*v**v*v*", "~nf", "")
TARGET_BUILTIN(__slwpcb, "v*", "~nf", "")
TARGET_BUILTIN(_ReadBarrier, "v", "~ncf", "")
TARGET_BUILTIN(_ReadWriteBarrier, "v", "~ncf", "")
TARGET_BUILTIN(_Store64_HLERelease, "vWiD*Wi", "~nf", "")
TARGET_BUILTIN(_StorePointer_HLERelease, "vv*D*v*", "~nf", "")
TARGET_BUILTIN(_Store_HLERelease, "viD*i", "~nf", "")
TARGET_BUILTIN(_Store_HLERelease, "vLiD*Li", "~nf", "")
TARGET_BUILTIN(_WriteBarrier, "v", "~ncf", "")
TARGET_BUILTIN(__addfsbyte, "vUiUc", "~ncf", "")
TARGET_BUILTIN(__addfsdword, "vUiUi", "~ncf", "")
TARGET_BUILTIN(__addfsword, "vUiUs", "~ncf", "")
TARGET_BUILTIN(__addgsbyte, "vUiUc", "~ncf", "")
TARGET_BUILTIN(__addgsdword, "vUiUi", "~ncf", "")
TARGET_BUILTIN(__addgsqword, "vUiUWi", "~ncf", "")
TARGET_BUILTIN(__addgsword, "vUiUs", "~ncf", "")
TARGET_BUILTIN(__cpuid, "vi*i", "~nf", "")
TARGET_BUILTIN(__cpuidex, "vi*ii", "~nf", "")
TARGET_BUILTIN(__debugbreak, "v", "~ncf", "")
TARGET_BUILTIN(__fastfail, "vUi", "~ncf", "")
TARGET_BUILTIN(__fastfail, "vUi", "~ncf", "")
TARGET_BUILTIN(__faststorefence, "v", "~ncf", "")
TARGET_BUILTIN(__halt, "v", "~ncf", "")
TARGET_BUILTIN(__inbytestring, "vUsUc*Ui", "~nf", "")
TARGET_BUILTIN(__incfsbyte, "vUi", "~ncf", "")
TARGET_BUILTIN(__incfsdword, "vUi", "~ncf", "")
TARGET_BUILTIN(__incfsword, "vUi", "~ncf", "")
TARGET_BUILTIN(__incgsbyte, "vUi", "~ncf", "")
TARGET_BUILTIN(__incgsdword, "vUi", "~ncf", "")
TARGET_BUILTIN(__incgsqword, "vUi", "~ncf", "")
TARGET_BUILTIN(__incgsword, "vUi", "~ncf", "")
TARGET_BUILTIN(__indwordstring, "vUsUi*Ui", "~nf", "")
TARGET_BUILTIN(__int2c, "v", "~ncf", "")
TARGET_BUILTIN(__invlpg, "vv*", "~nf", "")
TARGET_BUILTIN(__inwordstring, "vUsUs*Ui", "~nf", "")
TARGET_BUILTIN(__lidt, "vv*", "~nf", "")
TARGET_BUILTIN(__llwpcb, "vv*", "~nf", "")
TARGET_BUILTIN(__lwpval32, "vUiUiUi", "~ncf", "")
TARGET_BUILTIN(__lwpval32, "vUiUiUi", "~ncf", "")
TARGET_BUILTIN(__lwpval64, "vUWiUiUi", "~ncf", "")
TARGET_BUILTIN(__mm256_stream_pd, "vd*V4d", "~nfV:256:", "")
TARGET_BUILTIN(__mm256_stream_si256, "vV4Wi*V4Wi", "~nfV:256:", "")
TARGET_BUILTIN(__movsb, "vUc*UcC*z", "~ncf", "")
TARGET_BUILTIN(__movsd, "vUi*UiC*z", "~ncf", "")
TARGET_BUILTIN(__movsw, "vUs*UsC*z", "~ncf", "")
TARGET_BUILTIN(__nop, "v", "~ncf", "")
TARGET_BUILTIN(__nvreg_restore_fence, "v", "~ncf", "")
TARGET_BUILTIN(__nvreg_save_fence, "v", "~ncf", "")
TARGET_BUILTIN(__outbyte, "vUsUc", "~ncf", "")
TARGET_BUILTIN(__outbytestring, "vUsUc*Ui", "~nf", "")
TARGET_BUILTIN(__outdword, "vUsUi", "~ncf", "")
TARGET_BUILTIN(__outdwordstring, "vUsUi*Ui", "~nf", "")
TARGET_BUILTIN(__outword, "vUsUs", "~ncf", "")
TARGET_BUILTIN(__outwordstring, "vUsUs*Ui", "~nf", "")
TARGET_BUILTIN(__sidt, "vv*", "~nf", "")
TARGET_BUILTIN(__stosb, "vUc*Ucz", "~nf", "")
TARGET_BUILTIN(__stosd, "vUi*Uiz", "~nf", "")
TARGET_BUILTIN(__stosq, "vUWi*UWiz", "~nf", "")
TARGET_BUILTIN(__stosw, "vUs*Usz", "~nf", "")
TARGET_BUILTIN(__svm_clgi, "v", "~ncf", "")
TARGET_BUILTIN(__svm_invlpga, "vv*i", "~nf", "")
TARGET_BUILTIN(__svm_skinit, "vi", "~ncf", "")
TARGET_BUILTIN(__svm_stgi, "v", "~ncf", "")
TARGET_BUILTIN(__svm_vmload, "vz", "~ncf", "")
TARGET_BUILTIN(__svm_vmrun, "vz", "~ncf", "")
TARGET_BUILTIN(__svm_vmsave, "vz", "~ncf", "")
TARGET_BUILTIN(__ud2, "v", "~ncf", "")
TARGET_BUILTIN(__vmx_off, "v", "~ncf", "")
TARGET_BUILTIN(__vmx_vmptrst, "vUWi*", "~nf", "")
TARGET_BUILTIN(__wbinvd, "v", "~ncf", "")
TARGET_BUILTIN(__writecr0, "vUi", "~ncf", "")
TARGET_BUILTIN(__writecr0, "vUWi", "~ncf", "")
TARGET_BUILTIN(__writecr3, "vUi", "~ncf", "")
TARGET_BUILTIN(__writecr3, "vUWi", "~ncf", "")
TARGET_BUILTIN(__writecr4, "vUi", "~ncf", "")
TARGET_BUILTIN(__writecr4, "vUWi", "~ncf", "")
TARGET_BUILTIN(__writecr8, "vUi", "~ncf", "")
TARGET_BUILTIN(__writecr8, "vUWi", "~ncf", "")
TARGET_BUILTIN(__writedr, "vUiUWi", "~ncf", "")
TARGET_BUILTIN(__writedr, "vUiUi", "~ncf", "")
TARGET_BUILTIN(__writeeflags, "vUWi", "~ncf", "")
TARGET_BUILTIN(__writeeflags, "vUi", "~ncf", "")
TARGET_BUILTIN(__writefsbyte, "vUiUc", "~ncf", "")
TARGET_BUILTIN(__writefsdword, "vUiUi", "~ncf", "")
TARGET_BUILTIN(__writefsword, "vUiUs", "~ncf", "")
TARGET_BUILTIN(__writegsbyte, "vUiUc", "~ncf", "")
TARGET_BUILTIN(__writegsdword, "vUiUi", "~ncf", "")
TARGET_BUILTIN(__writegsqword, "vUiUWi", "~ncf", "")
TARGET_BUILTIN(__writegsword, "vUiUs", "~ncf", "")
TARGET_BUILTIN(__writemsr, "vUiUWi", "~ncf", "")
TARGET_BUILTIN(_clac, "v", "~ncf", "")
TARGET_BUILTIN(_disable, "v", "~ncf", "")
TARGET_BUILTIN(_enable, "v", "~ncf", "")
TARGET_BUILTIN(_fxrstor, "vvC*", "~ncf", "")
TARGET_BUILTIN(_fxrstor64, "vvC*", "~ncf", "")
TARGET_BUILTIN(_fxsave, "vv*", "~nf", "")
TARGET_BUILTIN(_fxsave64, "vv*", "~nf", "")
TARGET_BUILTIN(_invpcid, "vUiv*", "~nf", "")
TARGET_BUILTIN(_invpcid, "vUiv*", "~nf", "")
TARGET_BUILTIN(_lgdt, "vv*", "~nf", "")
TARGET_BUILTIN(_m_empty, "v", "~ncf", "")
TARGET_BUILTIN(_m_femms, "v", "~ncf", "")
TARGET_BUILTIN(_m_maskmovq, "vV1WiV1Wic*", "~nfV:64:", "")
TARGET_BUILTIN(_m_prefetch, "vv*", "~nf", "")
TARGET_BUILTIN(_m_prefetchw, "vv*", "~nf", "")
TARGET_BUILTIN(_mm256_maskstore_epi32, "vi*V4WiV4Wi", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_maskstore_epi64, "vWi*V4WiV4Wi", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_maskstore_pd, "vd*V4WiV4d", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_maskstore_ps, "vf*V4WiV8f", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_store_pd, "vd*V4d", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_store_ps, "vf*V8f", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_store_si256, "vV4Wi*V4Wi", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_storeu_pd, "vd*V4d", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_storeu_ps, "vf*V8f", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_storeu_si256, "vV4Wi*V4Wi", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_stream_ps, "vf*V8f", "~nfV:256:", "")
TARGET_BUILTIN(_mm256_zeroall, "v", "~ncf", "")
TARGET_BUILTIN(_mm256_zeroupper, "v", "~ncf", "")
TARGET_BUILTIN(_mm_clflush, "vvC*", "~ncf", "")
TARGET_BUILTIN(_mm_lfence, "v", "~ncf", "")
TARGET_BUILTIN(_mm_maskmoveu_si128, "vV2WiV2Wic*", "~nfV:128:", "")
TARGET_BUILTIN(_mm_maskstore_epi32, "vi*V2WiV2Wi", "~nfV:128:", "")
TARGET_BUILTIN(_mm_maskstore_epi64, "vWi*V2WiV2Wi", "~nfV:128:", "")
TARGET_BUILTIN(_mm_maskstore_pd, "vd*V2WiV2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_maskstore_ps, "vf*V2WiV4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_mfence, "v", "~ncf", "")
TARGET_BUILTIN(_mm_monitor, "vvC*UiUi", "~ncf", "")
TARGET_BUILTIN(_mm_monitor, "vvC*UiUi", "~ncf", "")
TARGET_BUILTIN(_mm_mwait, "vUiUi", "~ncf", "")
TARGET_BUILTIN(_mm_mwait, "vUiUi", "~ncf", "")
TARGET_BUILTIN(_mm_pause, "v", "~ncf", "")
TARGET_BUILTIN(_mm_prefetch, "vc*i", "~nf", "")
TARGET_BUILTIN(_mm_setcsr, "vUi", "~ncf", "")
TARGET_BUILTIN(_mm_setcsr, "vUi", "~ncf", "")
TARGET_BUILTIN(_mm_sfence, "v", "~ncf", "")
TARGET_BUILTIN(_mm_store1_pd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_store_pd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_store_ps, "vf*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_store_ps1, "vf*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_store_sd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_store_si128, "vV2Wi*V2Wi", "~nfV:128:", "")
TARGET_BUILTIN(_mm_store_ss, "vf*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storeh_pd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storeh_pi, "vV1Wi*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storel_epi64, "vV2Wi*V2Wi", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storel_pd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storel_pi, "vV1Wi*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storer_pd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storer_ps, "vf*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storeu_pd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storeu_ps, "vf*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_storeu_si128, "vV2Wi*V2Wi", "~nfV:128:", "")
TARGET_BUILTIN(_mm_stream_pd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_stream_pi, "vV1Wi*V1Wi", "~nfV:64:", "")
TARGET_BUILTIN(_mm_stream_ps, "vf*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_mm_stream_sd, "vd*V2d", "~nfV:128:", "")
TARGET_BUILTIN(_mm_stream_si128, "vV2Wi*V2Wi", "~nfV:128:", "")
TARGET_BUILTIN(_mm_stream_si32, "vi*i", "~nf", "")
TARGET_BUILTIN(_mm_stream_si64x, "vWi*Wi", "~nf", "")
TARGET_BUILTIN(_mm_stream_ss, "vf*V4f", "~nfV:128:", "")
TARGET_BUILTIN(_rsm, "v", "~ncf", "")
TARGET_BUILTIN(_sgdt, "vv*", "~nf", "")
TARGET_BUILTIN(_stac, "v", "~ncf", "")
TARGET_BUILTIN(_writefsbase_u32, "vUi", "~ncf", "")
TARGET_BUILTIN(_writefsbase_u64, "vUWi", "~ncf", "")
TARGET_BUILTIN(_writegsbase_u32, "vUi", "~ncf", "")
TARGET_BUILTIN(_writegsbase_u64, "vUWi", "~ncf", "")
TARGET_BUILTIN(_xabort, "vUi", "~ncf", "")
TARGET_BUILTIN(_xabort, "vUi", "~ncf", "")
TARGET_BUILTIN(_xend, "v", "~ncf", "")
TARGET_BUILTIN(_xrstor, "vvC*UWi", "~ncf", "")
TARGET_BUILTIN(_xrstor64, "vvC*UWi", "~ncf", "")
TARGET_BUILTIN(_xsave, "vv*UWi", "~nf", "")
TARGET_BUILTIN(_xsave64, "vv*UWi", "~nf", "")
TARGET_BUILTIN(_xsaveopt, "vv*UWi", "~nf", "")
TARGET_BUILTIN(_xsaveopt64, "vv*UWi", "~nf", "")
TARGET_BUILTIN(_xsetbv, "vUiUWi", "~ncf", "")
TARGET_BUILTIN(_xsetbv, "vUiUWi", "~ncf", "")

#undef TARGET_BUILTIN
