# PASTA

PASTA is a C++ library that abstracts the Clang compiler toolchain, and provides
detailed access to compilation artifacts using APIs that mirror those available in Clang. PASTA
tries to achieve the following goals:

  * Provide a baseline set of APIs that is relatively stable and does not require someone to
    actually depend directly on Clang headers/libraries, thus enabling a substantially
    easier distribution model.
    
  * Properly manage memory for all objects provided through the API. One should not have to
    worry about object lifetimes when using PASTA.
    
  * Provide additional information/access. Native Clang APIs do not provide detailed token information
    of any kind. One cannot ask for the tokens associated with an AST node, for example. PASTA attempts
    to resolve this, among other similar issues.

## Getting and Building the Code

First, update aptitude and get install the baseline dependencies such is for
example `git`, `cmake`, `ninja` and your compiler of choice (remember it needs to support
C++20). It is useful to use the same compiler at every subset to avoid some
name mangling problems. If you're using macOS then we recommend installing
Homebrew, and ensuring that you have Python 3.9 installed, along with an
up-to-date `cmake` and `ninja`.

### PASTA

And finally to build PASTA itself.

#### On Linux
```shell
git clone https://github.com/trailofbits/pasta.git
mkdir -p pasta-build
cd pasta-build
cmake \
    -DCMAKE_BUILD_TYPE=Release \
    -DPASTA_ENABLE_INSTALL=ON \
    -GNinja \
    ../pasta
ninja install
```

#### On macOS

On macOS, you may need to manually specify the Clang compiler. You can't, however,
just specify `clang` or `clang++`, because then vcpkg will try to take over and produce
unusual results. Therefore, you should give the absolute path to your Clang.

```shell
git clone https://github.com/trailofbits/pasta.git
mkdir -p pasta-build
cd pasta-build
cmake \
    -DCMAKE_BUILD_TYPE=Release \
    -DCMAKE_C_COMPILER=`which clang` \
    -DCMAKE_CXX_COMPILER=`which clang++` \
    -DPASTA_ENABLE_INSTALL=ON \
    -GNinja \
    ../pasta
ninja install
```

# License

PASTA is licensed according to the [Apache 2.0](LICENSE) license. Large parts of PASTA are semi-autogenerated from Clang APIs. Clang is also licensed under Apache 2.0, with [LLVM exceptions](https://github.com/llvm/llvm-project/blob/main/clang/LICENSE.TXT).

This research was developed with funding from the Defense Advanced Research Projects Agency (DARPA). The views, opinions and/or findings expressed are those of the author and should not be interpreted as representing the official views or policies of the Department of Defense or the U.S. Government.
 
Distribution Statement A – Approved for Public Release, Distribution Unlimited
