/// State module.
pub mod state;

mod acc;
mod auroc;
mod base;
#[cfg(feature = "metrics")]
mod cpu_temp;
#[cfg(feature = "metrics")]
mod cpu_use;
#[cfg(feature = "metrics")]
mod cuda;
mod hamming;
mod learning_rate;
mod loss;
#[cfg(feature = "metrics")]
mod memory_use;

#[cfg(feature = "metrics")]
mod iteration;
#[cfg(feature = "metrics")]
mod top_k_acc;

pub use acc::*;
pub use auroc::*;
pub use base::*;
#[cfg(feature = "metrics")]
pub use cpu_temp::*;
#[cfg(feature = "metrics")]
pub use cpu_use::*;
#[cfg(feature = "metrics")]
pub use cuda::*;
pub use hamming::*;
#[cfg(feature = "metrics")]
pub use iteration::*;
pub use learning_rate::*;
pub use loss::*;
#[cfg(feature = "metrics")]
pub use memory_use::*;
#[cfg(feature = "metrics")]
pub use top_k_acc::*;

pub(crate) mod processor;
// Expose `ItemLazy` so it can be implemented for custom types
pub use processor::ItemLazy;

/// Module responsible to save and exposes data collected during training.
pub mod store;

pub(crate) mod classification;
#[cfg(feature = "metrics")]
pub use crate::metric::classification::ClassReduction;
mod confusion_stats;
pub use confusion_stats::ConfusionStatsInput;
#[cfg(feature = "metrics")]
mod precision;
#[cfg(feature = "metrics")]
pub use precision::*;
#[cfg(feature = "metrics")]
mod recall;
#[cfg(feature = "metrics")]
pub use recall::*;
