mod binary;
mod cast;
mod clamp;
mod comparison;
mod contiguous;
mod index;
mod mask;
mod unary;

pub(crate) use binary::*;
pub use cast::*;
pub use contiguous::*;
pub use mask::*;
pub(crate) use unary::*;

pub use cubecl::{Kernel, PLANE_DIM_APPROX};

/// Convolution kernels
pub mod conv;
/// Interpolation kernels
pub mod interpolate;
/// Matmul kernels
pub mod matmul;
/// Pooling kernels
pub mod pool;
/// Pseudo-random number generator kernels
pub mod prng;
/// Quantization operations
pub mod quantization;
/// Reduction algorithms
pub mod reduce;

pub(crate) use clamp::*;
pub(crate) use comparison::*;
pub(crate) use index::*;
