package com.github.torleifg.semanticsearch.book.domain;

import lombok.Getter;

import java.util.List;

public record Contributor(List<Contributor.Role> roles, String name) {

    @Getter
    public enum Role {
        ABR("abridger"),
        ACT("actor"),
        ADP("adapter"),
        RCP("addressee"),
        ANL("analyst"),
        ANM("animator"),
        ANN("annotator"),
        ANC("announcer"),
        APL("appellant"),
        APE("appellee"),
        APP("applicant"),
        ARC("architect"),
        ARR("arranger"),
        ACP("art copyist"),
        ADI("art director"),
        ART("artist"),
        ARD("artistic director"),
        ASG("assignee"),
        ASN("associated name"),
        ATT("attributed name"),
        AUC("auctioneer"),
        AUE("audio engineer"),
        AUP("audio producer"),
        AUT("author"),
        AQT("author in quotations or text abstracts"),
        AFT("author of afterword, colophon, etc."),
        AUD("author of dialog"),
        AUI("author of introduction, etc."),
        ATO("autographer"),
        ANT("bibliographic antecedent"),
        BND("binder"),
        BDD("binding designer"),
        BLW("blurb writer"),
        BKA("book artist"),
        BKD("book designer"),
        BKP("book producer"),
        BJD("bookjacket designer"),
        BPD("bookplate designer"),
        BSL("bookseller"),
        BRL("braille embosser"),
        BRD("broadcaster"),
        CLL("calligrapher"),
        COP("camera operator"),
        CTG("cartographer"),
        CAS("caster"),
        CAD("casting director"),
        CNS("censor"),
        CHR("choreographer"),
        CNG("cinematographer"),
        CLI("client"),
        COR("collection registrar"),
        COL("collector"),
        CLT("collotyper"),
        CLR("colorist"),
        CMM("commentator"),
        CWT("commentator for written text"),
        COM("compiler"),
        CPL("complainant"),
        CPT("complainant-appellant"),
        CPE("complainant-appellee"),
        CMP("composer"),
        CMT("compositor"),
        CCP("conceptor"),
        CND("conductor"),
        CON("conservator"),
        CSL("consultant"),
        CSP("consultant to a project"),
        COS("contestant"),
        COT("contestant-appellant"),
        COE("contestant-appellee"),
        CTS("contestee"),
        CTT("contestee-appellant"),
        CTE("contestee-appellee"),
        CTR("contractor"),
        CTB("contributor"),
        CPC("copyright claimant"),
        CPH("copyright holder"),
        CRR("corrector"),
        CRP("correspondent"),
        CST("costume designer"),
        COU("court governed"),
        CRT("court reporter"),
        COV("cover designer"),
        CRE("creator"),
        CUR("curator"),
        DNC("dancer"),
        DTC("data contributor"),
        DTM("data manager"),
        DTE("dedicatee"),
        DTO("dedicator"),
        DFD("defendant"),
        DFT("defendant-appellant"),
        DFE("defendant-appellee"),
        DGC("degree committee member"),
        DGG("degree granting institution"),
        DGS("degree supervisor"),
        DLN("delineator"),
        DPC("depicted"),
        DPT("depositor"),
        DSR("designer"),
        DRT("director"),
        DIS("dissertant"),
        DBP("distribution place"),
        DST("distributor"),
        DJO("dj"),
        DNR("donor"),
        DRM("draftsman"),
        DBD("dubbing director"),
        DUB("dubious author"),
        EDT("editor"),
        EDC("editor of compilation"),
        EDM("editor of moving image work"),
        EDD("editorial director"),
        ELG("electrician"),
        ELT("electrotyper"),
        ENJ("enacting jurisdiction"),
        ENG("engineer"),
        EGR("engraver"),
        ETR("etcher"),
        EVP("event place"),
        EXP("expert"),
        FAC("facsimilist"),
        FLD("field director"),
        FMD("film director"),
        FDS("film distributor"),
        FLM("film editor"),
        FMP("film producer"),
        FMK("filmmaker"),
        FPY("first party"),
        FRG("forger"),
        FMO("former owner"),
        FON("founder"),
        FND("funder"),
        GDV("game developer"),
        GIS("geographic information specialist"),
        HNR("honoree"),
        HST("host"),
        HIS("host institution"),
        ILU("illuminator"),
        ILL("illustrator"),
        INS("inscriber"),
        ITR("instrumentalist"),
        IVE("interviewee"),
        IVR("interviewer"),
        INV("inventor"),
        ISB("issuing body"),
        JUD("judge"),
        JUG("jurisdiction governed"),
        LBR("laboratory"),
        LDR("laboratory director"),
        LSA("landscape architect"),
        LED("lead"),
        LEN("lender"),
        LTR("letterer"),
        LIL("libelant"),
        LBT("librettist"),
        LSE("licensee"),
        LSO("licensor"),
        LGD("lighting designer"),
        LTG("lithographer"),
        LYR("lyricist"),
        MKA("makeup artist"),
        MFP("manufacture place"),
        MFR("manufacturer"),
        MRB("marbler"),
        MRK("markup editor"),
        MDC("metadata contact"),
        MTE("metal-engraver"),
        MTK("minute taker"),
        MXE("mixing engineer"),
        MOD("moderator"),
        MON("monitor"),
        MCP("music copyist"),
        MUP("music programmer"),
        MSD("musical director"),
        MUS("musician"),
        NRT("narrator"),
        NAN("news anchor"),
        OPN("opponent"),
        ORM("organizer"),
        ORG("originator"),
        OTH("other"),
        OWN("owner"),
        PAN("panelist"),
        PPM("papermaker"),
        PTA("patent applicant"),
        PTH("patent holder"),
        PAT("patron"),
        PRF("performer"),
        PMA("permitting agency"),
        PHT("photographer"),
        PRT("printer"),
        POP("printer of plates"),
        PRM("printmaker"),
        PRC("process contact"),
        PRO("producer"),
        PRN("production company"),
        PRS("production designer"),
        PMN("production manager"),
        PRD("production personnel"),
        PRP("production place"),
        PRG("programmer"),
        PDR("project director"),
        PFR("proofreader"),
        PRV("provider"),
        PUP("publication place"),
        PBL("publisher"),
        PBD("publishing director"),
        PPT("puppeteer"),
        RDD("radio director"),
        RPC("radio producer"),
        RAP("rapporteur"),
        RCE("recording engineer"),
        RCD("recordist"),
        RED("redaktor"),
        RXA("remix artist"),
        REN("renderer"),
        RPT("reporter"),
        RPS("repository"),
        RTH("research team head"),
        RTM("research team member"),
        RES("researcher"),
        RSP("respondent"),
        RST("respondent-appellant"),
        RSE("respondent-appellee"),
        RSF("restager"),
        RSR("restorationist"),
        REV("reviewer"),
        RBR("rubricator"),
        SCE("scenarist"),
        SAD("scientific advisor"),
        AUS("screenwriter"),
        SCR("scribe"),
        SCL("sculptor"),
        SPY("second party"),
        SEC("secretary"),
        SLL("seller"),
        STD("set designer"),
        SGN("signer"),
        SNG("singer"),
        SWD("software developer"),
        SDS("sound designer"),
        SDE("sound engineer"),
        SPK("speaker"),
        SFX("special effects provider"),
        SPN("sponsor"),
        SGD("stage director"),
        STM("stage manager"),
        STN("standards body"),
        STR("stereotyper"),
        STL("storyteller"),
        SHT("supporting host"),
        SRV("surveyor"),
        TCH("teacher"),
        TAD("technical advisor"),
        TCD("technical director"),
        TLD("television director"),
        TLG("television guest"),
        TLH("television host"),
        TLP("television producer"),
        TAU("television writer"),
        THS("thesis advisor"),
        TRC("transcriber"),
        TRL("translator"),
        TYD("type designer"),
        TYG("typographer"),
        UVP("university place"),
        VDG("videographer"),
        VFX("visual effects provider"),
        VAC("voice actor"),
        WIT("witness"),
        WDE("wood engraver"),
        WDC("woodcutter"),
        WAM("writer of accompanying material"),
        WAC("writer of added commentary"),
        WAL("writer of added lyrics"),
        WAT("writer of added text"),
        WIN("writer of introduction"),
        WPR("writer of preface"),
        WST("writer of supplementary textual content"),
        WTS("writer of television story");

        private final String term;

        Role(String term) {
            this.term = term;
        }
    }
}
