# Collecting acorns like squirrel.

![Icon](https://rawgit.com/TonnyTao/Acornote/master/Acornote_Sketch/icon.svg?a)

A note app by [Tonny&Sunm](https://tonnysunm.github.io).

We are happy to be lifelong learners, but sometime struggled in Notes, Evernote, Quizlet, Memrise and other notes app, you named it. The complicated features are not what we want. As designer and developer, why not create our own notes app, just for fun.

This repository constains design and source code:

* Sketch design, by [Sunm](https://dribbble.com/sunmlu)
* iOS app in Swift (99% finished)
* Android app in Kotlin (ongoing)

## Draft ideas
* Put context in the first place
* Learn, memorize, active or deep-learn any new things in `context`
* Context contains useful resource, such as words, sentence, audio, url, image...
* Keep this app simple
* Use the state of art, such as text pronunciation, image searching, quizlet...

## App structure
* Use Folders to represent context
* A Folder may contains a url, may be audio playable, flipable, or markable
* A Folder contains multiple items
* A item is an idea, it may be a vocabulary, an interesting sentence, a sudden inspiration...

## Folders
<img src="https://rawgit.com/TonnyTao/Acornote/master/Acornote_Sketch/folder.jpg?a" width="400">

A Folder is a context, we create folders in following situations:

* A book
* A movie or a video in YT
* Vocabulary in specific field, such as food
* A post from Medium
* Oral English expression
* An audio with transcript: ESL, BBC English,...
* Url bookmarks for Sketch, Swift,...
* Receipt
* Shopping list
* TODO list
* ...

---

## A folder for the book 'Because of Winn-Dixie'
![Items](https://rawgit.com/TonnyTao/Acornote/master/Acornote_Sketch/item.jpg)

#### Items in folder
* vocabularies with image
* native expressions with url link
* good sentences

#### Features
* Search images for vocabularies
* Click item to speak, or speak all one by one
* Flip an item, similar to quizlet
* Link to goodreads.com


## TODO
* iOS code refactor
* iOS data backup regularly
* iOS image scanner

You can read more at [Medium](https://medium.com/tonny-sunm/developing-own-app-to-take-notes-2d84413b9b32). Welcome your ideas about notes taking.


But, after I experienced Keep Notes in my new Pixel 4. I got some new ideas, so the ongoing android app probably be huge different with the almost finished iOS app. Anyway, coding is for fun.

<img src="https://rawgit.com/TonnyTao/Acornote/master/Acornote_Sketch/tonnysunm.jpg" width="400">

---
Apache License 2.0


