import { DefaultTheme } from 'styled-components';

export const proTheme: DefaultTheme = {
    textPrimary: '#EBEBEB',
    textSecondary: '#8D8D93',
    textTertiary: '#4E4E52',
    textAccent: '#FFDB29',
    textPrimaryAlternate: '#000000',

    backgroundPage: '#000000',
    backgroundTransparent: 'rgb(0 0 0 / 96%)',
    backgroundContent: '#17171A',
    backgroundContentTint: '#222224',
    backgroundContentAttention: '#2F2F33',
    backgroundOverlayStrong: 'rgba(31, 31, 31, 0.72)',
    backgroundOverlayLight: 'rgba(20, 20, 20, 0.48)',
    backgroundOverlayExtraLight: 'rgba(20, 20, 20, 0.24)',
    backgroundHighlighted: 'rgb(255 255 255 / 4%)',

    iconPrimary: '#EBEBEB',
    iconSecondary: '#8D8D93',
    iconTertiary: '#4E4E52',
    iconPrimaryAlternate: '#000000',

    buttonPrimaryBackground: '#FFDB29',
    buttonPrimaryForeground: '#000000',
    buttonSecondaryBackground: '#17171A',
    buttonSecondaryForeground: '#EBEBEB',
    buttonTertiaryBackground: '#222224',
    buttonTertiaryForeground: '#EBEBEB',
    buttonWarnBackground: '#F5A73B',
    buttonWarnForeground: '#FFFFFF',
    buttonPrimaryBackgroundDisabled: '#CCAF21',
    buttonSecondaryBackgroundDisabled: '#0E0E0F',
    buttonTertiaryBackgroundDisabled: '#18181A',
    buttonWarnBackgroundDisabled: '#C2842F',

    buttonTertiaryForegroundDisabled: 'rgba(256, 256, 256, 0.48)',
    buttonSecondaryForegroundDisabled: 'rgba(256, 256, 256, 0.48)',
    buttonPrimaryForegroundDisabled: 'rgba(0, 0, 0, 0.48)',
    buttonWarnForegroundDisabled: 'rgba(256, 256, 256, 0.48)',

    buttonPrimaryBackgroundHighlighted: '#FFDE3D',
    buttonSecondaryBackgroundHighlighted: '#202024',
    buttonTertiaryBackgroundHighlighted: '#2A2A2E',
    buttonWarnBackgroundHighlighted: '#F5AF4E',

    fieldBackground: '#17171A',
    fieldActiveBorder: '#FFDB29',
    fieldErrorBorder: '#FF4766',
    fieldErrorBackground: 'rgb(255 71 102 / 8%)',

    accentBlue: '#FFDB29',
    accentBlueConstant: '#45AEF5',
    accentGreen: '#39CC83',
    accentRed: '#FF4766',
    accentOrange: '#F5A73B',
    accentPurple: '#7665E5',

    tabBarActiveIcon: '#FFDB29',
    tabBarInactiveIcon: '#8D8D93',

    separatorCommon: 'rgb(255 255 255 / 8%)',
    separatorAlternate: 'rgb(255 255 255 / 8%)',

    gradientBackgroundTop:
        'linear-gradient(180deg, #000000 0%, rgba(0, 0, 0, 0.991353) 6.67%, rgba(0, 0, 0, 0.96449) 13.33%, rgba(0, 0, 0, 0.91834) 20%, rgba(0, 0, 0, 0.852589) 26.67%, rgba(0, 0, 0, 0.768225) 33.33%, rgba(0, 0, 0, 0.668116) 40%, rgba(0, 0, 0, 0.557309) 46.67%, rgba(0, 0, 0, 0.442691) 53.33%, rgba(0, 0, 0, 0.331884) 60%, rgba(0, 0, 0, 0.231775) 66.67%, rgba(0, 0, 0, 0.147411) 73.33%, rgba(0, 0, 0, 0.0816599) 80%, rgba(0, 0, 0, 0.03551) 86.67%, rgba(0, 0, 0, 0.0086472) 93.33%, rgba(0, 0, 0, 0) 100%)',
    gradientBackgroundBottom:
        'linear-gradient(360deg, #000 0%, rgba(0, 0, 0, 0.99) 6.67%, rgba(0, 0, 0, 0.96) 13.33%, rgba(0, 0, 0, 0.92) 20%, rgba(0, 0, 0, 0.85) 26.67%, rgba(0, 0, 0, 0.77) 33.33%, rgba(0, 0, 0, 0.67) 40%, rgba(0, 0, 0, 0.56) 46.67%, rgba(0, 0, 0, 0.44) 53.33%, rgba(0, 0, 0, 0.33) 60%, rgba(0, 0, 0, 0.23) 66.67%, rgba(0, 0, 0, 0.15) 73.33%, rgba(0, 0, 0, 0.08) 80%, rgba(0, 0, 0, 0.04) 86.67%, rgba(0, 0, 0, 0.01) 93.33%, rgba(0, 0, 0, 0.00) 100%)',
    gradientBlueTop:
        'linear-gradient(180deg, #45AEF5 0%, rgba(69, 174, 245, 0.991353) 6.67%, rgba(69, 174, 245, 0.96449) 13.33%, rgba(69, 174, 245, 0.91834) 20%, rgba(69, 174, 245, 0.852589) 26.67%, rgba(69, 174, 245, 0.768225) 33.33%, rgba(69, 174, 245, 0.668116) 40%, rgba(69, 174, 245, 0.557309) 46.67%, rgba(69, 174, 245, 0.442691) 53.33%, rgba(69, 174, 245, 0.331884) 60%, rgba(69, 174, 245, 0.231775) 66.67%, rgba(69, 174, 245, 0.147411) 73.33%, rgba(69, 174, 245, 0.0816599) 80%, rgba(69, 174, 245, 0.03551) 86.67%, rgba(69, 174, 245, 0.0086472) 93.33%, rgba(69, 174, 245, 0) 100%)',
    gradientBlueBottom:
        'linear-gradient(0deg, #45AEF5 0%, rgba(69, 174, 245, 0.991353) 6.67%, rgba(69, 174, 245, 0.96449) 13.33%, rgba(69, 174, 245, 0.91834) 20%, rgba(69, 174, 245, 0.852589) 26.67%, rgba(69, 174, 245, 0.768225) 33.33%, rgba(69, 174, 245, 0.668116) 40%, rgba(69, 174, 245, 0.557309) 46.67%, rgba(69, 174, 245, 0.442691) 53.33%, rgba(69, 174, 245, 0.331884) 60%, rgba(69, 174, 245, 0.231775) 66.67%, rgba(69, 174, 245, 0.147411) 73.33%, rgba(69, 174, 245, 0.0816599) 80%, rgba(69, 174, 245, 0.03551) 86.67%, rgba(69, 174, 245, 0.0086472) 93.33%, rgba(69, 174, 245, 0) 100%)',
    gradientGreen:
        'linear-gradient(180deg, #39CC83 0%, rgba(57, 204, 131, 0.991353) 6.67%, rgba(57, 204, 131, 0.96449) 13.33%, rgba(57, 204, 131, 0.91834) 20%, rgba(57, 204, 131, 0.852589) 26.67%, rgba(57, 204, 131, 0.768225) 33.33%, rgba(57, 204, 131, 0.668116) 40%, rgba(57, 204, 131, 0.557309) 46.67%, rgba(57, 204, 131, 0.442691) 53.33%, rgba(57, 204, 131, 0.331884) 60%, rgba(57, 204, 131, 0.231775) 66.67%, rgba(57, 204, 131, 0.147411) 73.33%, rgba(57, 204, 131, 0.0816599) 80%, rgba(57, 204, 131, 0.03551) 86.67%, rgba(57, 204, 131, 0.0086472) 93.33%, rgba(57, 204, 131, 0) 100%)',
    gradientRed:
        'linear-gradient(180deg, #FF4766 0%, rgba(255, 71, 102, 0.991353) 6.67%, rgba(255, 71, 102, 0.96449) 13.33%, rgba(255, 71, 102, 0.91834) 20%, rgba(255, 71, 102, 0.852589) 26.67%, rgba(255, 71, 102, 0.768225) 33.33%, rgba(255, 71, 102, 0.668116) 40%, rgba(255, 71, 102, 0.557309) 46.67%, rgba(255, 71, 102, 0.442691) 53.33%, rgba(255, 71, 102, 0.331884) 60%, rgba(255, 71, 102, 0.231775) 66.67%, rgba(255, 71, 102, 0.147411) 73.33%, rgba(255, 71, 102, 0.0816599) 80%, rgba(255, 71, 102, 0.03551) 86.67%, rgba(255, 71, 102, 0.0086472) 93.33%, rgba(255, 71, 102, 0) 100%)',

    constantBlack: '#000000',
    constantWhite: '#FFFFFF',
    blue: '#0077FF',
    red: '#FF3B30',

    corner3xSmall: '4px',
    corner2xSmall: '8px',
    cornerExtraSmall: '12px',
    cornerSmall: '16px',
    cornerMedium: '20px',
    cornerLarge: '24px',
    cornerFull: '100%',
    fontMono: 'ui-monospace, SF Mono, monospace, Roboto Mono, Menlo, Consolas, Courier',
    displayType: 'compact',
    os: undefined
};
