import { DefaultTheme } from 'styled-components';

export const lightTheme: DefaultTheme = {
    textPrimary: '#000000',
    textSecondary: '#72808F',
    textTertiary: '#A0A6AD',
    textAccent: '#198AFB',
    textPrimaryAlternate: '#000000',

    backgroundPage: '#F2F2F6',
    backgroundTransparent: '#F2F2F6F5',
    backgroundContent: '#FFFFFF',
    backgroundContentTint: '#F2F2F6',
    backgroundContentAttention: '#424C5C',
    backgroundOverlayStrong: '#000000B8',
    backgroundOverlayLight: ' #0000007A',
    backgroundOverlayExtraLight: '#0000003D',
    backgroundHighlighted: '#00000014',

    iconPrimary: '#000000',
    iconSecondary: '#9099A3',
    iconTertiary: '#A0A6AD',
    iconPrimaryAlternate: '#000000',

    buttonPrimaryBackground: '#198AFB',
    buttonPrimaryForeground: '#FFFFFF',
    buttonSecondaryBackground: '#E1E1E5',
    buttonSecondaryForeground: '#000000',
    buttonTertiaryBackground: '#FFFFFF',
    buttonTertiaryForeground: '#000000',
    buttonWarnBackground: '#F5A73B',
    buttonWarnForeground: '#FFFFFF',
    buttonPrimaryBackgroundDisabled: '#419EFB',
    buttonSecondaryBackgroundDisabled: '#ECECF0',
    buttonTertiaryBackgroundDisabled: '#FFFFFF',
    buttonWarnBackgroundDisabled: '#C2842F',

    buttonTertiaryForegroundDisabled: 'rgba(0, 0, 0, 0.48)',
    buttonSecondaryForegroundDisabled: 'rgba(0, 0, 0, 0.48)',
    buttonPrimaryForegroundDisabled: 'rgba(0, 0, 0, 0.48)',
    buttonWarnForegroundDisabled: 'rgba(256, 256, 256, 0.48)',

    buttonPrimaryBackgroundHighlighted: '#3297FB',
    buttonSecondaryBackgroundHighlighted: '#D7D7DB',
    buttonTertiaryBackgroundHighlighted: '#FFFFFF',
    buttonWarnBackgroundHighlighted: '#F5AF4E',

    fieldBackground: '#FFFFFF',
    fieldActiveBorder: '#198AFB',
    fieldErrorBorder: '#FF3B30',
    fieldErrorBackground: '#FF3B301F',

    accentBlue: '#198AFB',
    accentBlueConstant: '#45AEF5',
    accentGreen: '#17C26D',
    accentRed: '#FF3B30',
    accentOrange: '#FF9500',
    accentPurple: '#5856D6',

    tabBarActiveIcon: '#198AFB',
    tabBarInactiveIcon: '#878F99',

    separatorCommon: '#00000014',
    separatorAlternate: '#00000014',

    gradientBackgroundTop: 'hsba(0, 0%, 100%, 0.08)',
    gradientBackgroundBottom: 'hsba(0, 0%, 100%, 0.08)',
    gradientBlueTop:
        'linear-gradient(180deg, #198AFB 0%, rgba(69, 174, 245, 0.991353) 6.67%, rgba(69, 174, 245, 0.96449) 13.33%, rgba(69, 174, 245, 0.91834) 20%, rgba(69, 174, 245, 0.852589) 26.67%, rgba(69, 174, 245, 0.768225) 33.33%, rgba(69, 174, 245, 0.668116) 40%, rgba(69, 174, 245, 0.557309) 46.67%, rgba(69, 174, 245, 0.442691) 53.33%, rgba(69, 174, 245, 0.331884) 60%, rgba(69, 174, 245, 0.231775) 66.67%, rgba(69, 174, 245, 0.147411) 73.33%, rgba(69, 174, 245, 0.0816599) 80%, rgba(69, 174, 245, 0.03551) 86.67%, rgba(69, 174, 245, 0.0086472) 93.33%, rgba(69, 174, 245, 0) 100%)',
    gradientBlueBottom:
        'linear-gradient(0deg, #198AFB 0%, rgba(69, 174, 245, 0.991353) 6.67%, rgba(69, 174, 245, 0.96449) 13.33%, rgba(69, 174, 245, 0.91834) 20%, rgba(69, 174, 245, 0.852589) 26.67%, rgba(69, 174, 245, 0.768225) 33.33%, rgba(69, 174, 245, 0.668116) 40%, rgba(69, 174, 245, 0.557309) 46.67%, rgba(69, 174, 245, 0.442691) 53.33%, rgba(69, 174, 245, 0.331884) 60%, rgba(69, 174, 245, 0.231775) 66.67%, rgba(69, 174, 245, 0.147411) 73.33%, rgba(69, 174, 245, 0.0816599) 80%, rgba(69, 174, 245, 0.03551) 86.67%, rgba(69, 174, 245, 0.0086472) 93.33%, rgba(69, 174, 245, 0) 100%)',
    gradientGreen:
        'linear-gradient(180deg, #39CC83 0%, rgba(57, 204, 131, 0.991353) 6.67%, rgba(57, 204, 131, 0.96449) 13.33%, rgba(57, 204, 131, 0.91834) 20%, rgba(57, 204, 131, 0.852589) 26.67%, rgba(57, 204, 131, 0.768225) 33.33%, rgba(57, 204, 131, 0.668116) 40%, rgba(57, 204, 131, 0.557309) 46.67%, rgba(57, 204, 131, 0.442691) 53.33%, rgba(57, 204, 131, 0.331884) 60%, rgba(57, 204, 131, 0.231775) 66.67%, rgba(57, 204, 131, 0.147411) 73.33%, rgba(57, 204, 131, 0.0816599) 80%, rgba(57, 204, 131, 0.03551) 86.67%, rgba(57, 204, 131, 0.0086472) 93.33%, rgba(57, 204, 131, 0) 100%)',
    gradientRed:
        'linear-gradient(180deg, #FF4766 0%, rgba(255, 71, 102, 0.991353) 6.67%, rgba(255, 71, 102, 0.96449) 13.33%, rgba(255, 71, 102, 0.91834) 20%, rgba(255, 71, 102, 0.852589) 26.67%, rgba(255, 71, 102, 0.768225) 33.33%, rgba(255, 71, 102, 0.668116) 40%, rgba(255, 71, 102, 0.557309) 46.67%, rgba(255, 71, 102, 0.442691) 53.33%, rgba(255, 71, 102, 0.331884) 60%, rgba(255, 71, 102, 0.231775) 66.67%, rgba(255, 71, 102, 0.147411) 73.33%, rgba(255, 71, 102, 0.0816599) 80%, rgba(255, 71, 102, 0.03551) 86.67%, rgba(255, 71, 102, 0.0086472) 93.33%, rgba(255, 71, 102, 0) 100%)',

    constantBlack: '#000000',
    constantWhite: '#000000',
    blue: '#0077FF',
    red: '#FF3B30',

    corner3xSmall: '4px',
    corner2xSmall: '8px',
    cornerExtraSmall: '12px',
    cornerSmall: '16px',
    cornerMedium: '20px',
    cornerLarge: '24px',
    cornerFull: '100%',
    fontMono: 'ui-monospace, SF Mono, monospace, Roboto Mono, Menlo, Consolas, Courier',
    displayType: 'compact',
    os: undefined
};
