import { DefaultTheme } from 'styled-components';

export const defaultTheme: DefaultTheme = {
    textPrimary: '#EBEBEB',
    textSecondary: '#8994A3',
    textTertiary: '#556170',
    textAccent: '#45AEF5',
    textPrimaryAlternate: '#10161F',

    backgroundPage: '#10161F',
    backgroundTransparent: 'rgba(16, 22, 31, 0.92)',
    backgroundContent: '#1D2633',
    backgroundContentTint: '#2E3847',
    backgroundContentAttention: '#424C5C',
    backgroundOverlayStrong: 'rgba(0, 0, 0, 0.72)',
    backgroundOverlayLight: 'rgba(0, 0, 0, 0.48)',
    backgroundOverlayExtraLight: 'rgba(0, 0, 0, 0.24)',
    backgroundHighlighted: 'rgba(79, 90, 112, 0.24)',

    iconPrimary: '#EBEBEB',
    iconSecondary: '#8994A3',
    iconTertiary: '#556170',
    iconPrimaryAlternate: '#10161F',

    buttonPrimaryBackground: '#45AEF5',
    buttonPrimaryForeground: '#FFFFFF',
    buttonSecondaryBackground: '#1D2633',
    buttonSecondaryForeground: '#EBEBEB',
    buttonTertiaryBackground: '#2E3847',
    buttonTertiaryForeground: '#EBEBEB',
    buttonWarnBackground: '#F5A73B',
    buttonWarnForeground: '#FFFFFF',
    buttonPrimaryBackgroundDisabled: '#378AC2',
    buttonSecondaryBackgroundDisabled: '#171F29',
    buttonTertiaryBackgroundDisabled: '#28303D',
    buttonWarnBackgroundDisabled: '#C2842F',

    buttonTertiaryForegroundDisabled: 'rgba(256, 256, 256, 0.48)',
    buttonSecondaryForegroundDisabled: 'rgba(256, 256, 256, 0.48)',
    buttonPrimaryForegroundDisabled: 'rgba(256, 256, 256, 0.48)',
    buttonWarnForegroundDisabled: 'rgba(256, 256, 256, 0.48)',

    buttonPrimaryBackgroundHighlighted: 'rgba(91, 184, 246, 1)',
    buttonSecondaryBackgroundHighlighted: 'rgba(34, 44, 59, 1)',
    buttonTertiaryBackgroundHighlighted: 'rgba(54, 64, 82, 1)',
    buttonWarnBackgroundHighlighted: '#F5AF4E',

    fieldBackground: '#1D2633',
    fieldActiveBorder: '#45AEF5',
    fieldErrorBorder: '#FF4766',
    fieldErrorBackground: 'rgba(255, 71, 102, 0.08)',

    accentBlue: '#45AEF5',
    accentBlueConstant: '#45AEF5',
    accentGreen: '#39CC83',
    accentRed: '#FF4766',
    accentOrange: '#F5A73B',
    accentPurple: '#7665E5',

    tabBarActiveIcon: '#45AEF5',
    tabBarInactiveIcon: '#8994A3',

    separatorCommon: 'rgba(79, 90, 112, 0.24)',
    separatorAlternate: 'rgba(255, 255, 255, 0.04)',

    gradientBackgroundTop:
        'linear-gradient(180deg, #10161F 0%, rgba(16, 22, 31, 0.991353) 6.67%, rgba(16, 22, 31, 0.96449) 13.33%, rgba(16, 22, 31, 0.91834) 20%, rgba(16, 22, 31, 0.852589) 26.67%, rgba(16, 22, 31, 0.768225) 33.33%, rgba(16, 22, 31, 0.668116) 40%, rgba(16, 22, 31, 0.557309) 46.67%, rgba(16, 22, 31, 0.442691) 53.33%, rgba(16, 22, 31, 0.331884) 60%, rgba(16, 22, 31, 0.231775) 66.67%, rgba(16, 22, 31, 0.147411) 73.33%, rgba(16, 22, 31, 0.0816599) 80%, rgba(16, 22, 31, 0.03551) 86.67%, rgba(16, 22, 31, 0.0086472) 93.33%, rgba(16, 22, 31, 0) 100%)',
    gradientBackgroundBottom:
        'linear-gradient(360deg, #10161F 0%, rgba(16, 22, 31, 0.991353) 6.67%, rgba(16, 22, 31, 0.96449) 13.33%, rgba(16, 22, 31, 0.91834) 20%, rgba(16, 22, 31, 0.852589) 26.67%, rgba(16, 22, 31, 0.768225) 33.33%, rgba(16, 22, 31, 0.668116) 40%, rgba(16, 22, 31, 0.557309) 46.67%, rgba(16, 22, 31, 0.442691) 53.33%, rgba(16, 22, 31, 0.331884) 60%, rgba(16, 22, 31, 0.231775) 66.67%, rgba(16, 22, 31, 0.147411) 73.33%, rgba(16, 22, 31, 0.0816599) 80%, rgba(16, 22, 31, 0.03551) 86.67%, rgba(16, 22, 31, 0.0086472) 93.33%, rgba(16, 22, 31, 0) 100%)',
    gradientBlueTop:
        'linear-gradient(180deg, #45AEF5 0%, rgba(69, 174, 245, 0.991353) 6.67%, rgba(69, 174, 245, 0.96449) 13.33%, rgba(69, 174, 245, 0.91834) 20%, rgba(69, 174, 245, 0.852589) 26.67%, rgba(69, 174, 245, 0.768225) 33.33%, rgba(69, 174, 245, 0.668116) 40%, rgba(69, 174, 245, 0.557309) 46.67%, rgba(69, 174, 245, 0.442691) 53.33%, rgba(69, 174, 245, 0.331884) 60%, rgba(69, 174, 245, 0.231775) 66.67%, rgba(69, 174, 245, 0.147411) 73.33%, rgba(69, 174, 245, 0.0816599) 80%, rgba(69, 174, 245, 0.03551) 86.67%, rgba(69, 174, 245, 0.0086472) 93.33%, rgba(69, 174, 245, 0) 100%)',
    gradientBlueBottom:
        'linear-gradient(0deg, #45AEF5 0%, rgba(69, 174, 245, 0.991353) 6.67%, rgba(69, 174, 245, 0.96449) 13.33%, rgba(69, 174, 245, 0.91834) 20%, rgba(69, 174, 245, 0.852589) 26.67%, rgba(69, 174, 245, 0.768225) 33.33%, rgba(69, 174, 245, 0.668116) 40%, rgba(69, 174, 245, 0.557309) 46.67%, rgba(69, 174, 245, 0.442691) 53.33%, rgba(69, 174, 245, 0.331884) 60%, rgba(69, 174, 245, 0.231775) 66.67%, rgba(69, 174, 245, 0.147411) 73.33%, rgba(69, 174, 245, 0.0816599) 80%, rgba(69, 174, 245, 0.03551) 86.67%, rgba(69, 174, 245, 0.0086472) 93.33%, rgba(69, 174, 245, 0) 100%)',
    gradientGreen:
        'linear-gradient(180deg, #39CC83 0%, rgba(57, 204, 131, 0.991353) 6.67%, rgba(57, 204, 131, 0.96449) 13.33%, rgba(57, 204, 131, 0.91834) 20%, rgba(57, 204, 131, 0.852589) 26.67%, rgba(57, 204, 131, 0.768225) 33.33%, rgba(57, 204, 131, 0.668116) 40%, rgba(57, 204, 131, 0.557309) 46.67%, rgba(57, 204, 131, 0.442691) 53.33%, rgba(57, 204, 131, 0.331884) 60%, rgba(57, 204, 131, 0.231775) 66.67%, rgba(57, 204, 131, 0.147411) 73.33%, rgba(57, 204, 131, 0.0816599) 80%, rgba(57, 204, 131, 0.03551) 86.67%, rgba(57, 204, 131, 0.0086472) 93.33%, rgba(57, 204, 131, 0) 100%)',
    gradientRed:
        'linear-gradient(180deg, #FF4766 0%, rgba(255, 71, 102, 0.991353) 6.67%, rgba(255, 71, 102, 0.96449) 13.33%, rgba(255, 71, 102, 0.91834) 20%, rgba(255, 71, 102, 0.852589) 26.67%, rgba(255, 71, 102, 0.768225) 33.33%, rgba(255, 71, 102, 0.668116) 40%, rgba(255, 71, 102, 0.557309) 46.67%, rgba(255, 71, 102, 0.442691) 53.33%, rgba(255, 71, 102, 0.331884) 60%, rgba(255, 71, 102, 0.231775) 66.67%, rgba(255, 71, 102, 0.147411) 73.33%, rgba(255, 71, 102, 0.0816599) 80%, rgba(255, 71, 102, 0.03551) 86.67%, rgba(255, 71, 102, 0.0086472) 93.33%, rgba(255, 71, 102, 0) 100%)',

    constantBlack: '#000000',
    constantWhite: '#FFFFFF',
    blue: '#0077FF',
    red: '#FF3B30',

    corner3xSmall: '4px',
    corner2xSmall: '8px',
    cornerExtraSmall: '12px',
    cornerSmall: '16px',
    cornerMedium: '20px',
    cornerLarge: '24px',
    cornerFull: '100%',
    fontMono: 'ui-monospace, SF Mono, monospace, Roboto Mono, Menlo, Consolas, Courier',
    displayType: 'compact',
    os: undefined
};
