import { useTheme } from 'styled-components';

export const WalletIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M1.82698 4.63803C1.57654 5.12955 1.51792 5.73742 1.50419 6.75H1.5V7.8V12V16.2C1.5 17.8802 1.5 18.7202 1.82698 19.362C2.1146 19.9265 2.57354 20.3854 3.13803 20.673C3.77976 21 4.61984 21 6.3 21H17.7C19.3802 21 20.2202 21 20.862 20.673C21.4265 20.3854 21.8854 19.9265 22.173 19.362C22.5 18.7202 22.5 17.8802 22.5 16.2V11.55C22.5 9.86984 22.5 9.02976 22.173 8.38803C21.8854 7.82354 21.4265 7.3646 20.862 7.07698C20.5049 6.89506 20.0865 6.81436 19.4962 6.77855C19.4832 5.74882 19.4258 5.13415 19.173 4.63803C18.8854 4.07354 18.4265 3.6146 17.862 3.32698C17.2202 3 16.3802 3 14.7 3H6.3C4.61984 3 3.77976 3 3.13803 3.32698C2.57354 3.6146 2.1146 4.07354 1.82698 4.63803ZM17.625 6.75H3.375V6.675C3.375 6.04494 3.375 5.72991 3.49762 5.48926C3.60548 5.27758 3.77758 5.10548 3.98926 4.99762C4.22991 4.875 4.54494 4.875 5.175 4.875H15.825C16.4551 4.875 16.7701 4.875 17.0107 4.99762C17.2224 5.10548 17.3945 5.27758 17.5024 5.48926C17.625 5.72991 17.625 6.04494 17.625 6.675V6.75ZM19.125 12.75C18.5037 12.75 18 13.2537 18 13.875C18 14.4963 18.5037 15 19.125 15C19.7463 15 20.25 14.4963 20.25 13.875C20.25 13.2537 19.7463 12.75 19.125 12.75Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const LeafIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M1.79387 3.63695C1.57347 4.60707 1.5 5.91303 1.5 6.80855C1.5 14.1343 5.82234 18.9601 12.4589 18.9601C16.9771 18.9601 18.8506 16.199 19.2056 15.6766L17.8709 15.5647C19.1445 16.908 19.7567 18.4378 20.3689 20.3656C20.5159 20.8383 20.8342 21 21.177 21C21.8873 21 22.4995 20.378 22.4995 19.4951C22.4995 18.1766 20.5281 15.8383 19.5239 14.8806C15.2629 10.9006 8.66308 13.2637 7.13251 8.82346C7.0223 8.48762 7.37739 8.18912 7.708 8.52494C11.063 11.9329 15.3976 9.05976 19.5239 12.9279C19.8791 13.2513 20.2954 13.0771 20.3566 12.704C20.4055 12.4428 20.4302 11.9951 20.4302 11.5722C20.4302 6.7588 17.1118 4.40808 12.4956 4.40808C10.9283 4.40808 9.06713 4.8434 7.64678 4.8434C6.20191 4.8434 4.47543 4.76877 3.04282 3.27624C2.61426 2.84094 1.96529 2.89069 1.79387 3.63695Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const LockIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M7.04426 22.5H16.9557C18.6473 22.5 19.5 21.6277 19.5 19.7848V12.3706C19.5 10.5417 18.6473 9.66948 16.9557 9.66948H7.04426C5.35274 9.66948 4.5 10.5417 4.5 12.3706V19.7848C4.5 21.6277 5.35274 22.5 7.04426 22.5ZM6.40121 10.6402H8.37231V6.70102C8.37231 3.9717 10.1197 2.6352 11.993 2.6352C13.8802 2.6352 15.6416 3.9717 15.6416 6.70102V10.6402H17.6128V6.98237C17.6128 2.67737 14.8029 0.75 11.993 0.75C9.19709 0.75 6.40121 2.67737 6.40121 6.98237V10.6402Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const KeyIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M19.8738 4.12667C17.3626 1.61545 13.3466 1.62411 10.8424 4.12832C8.94635 6.02436 8.40487 8.80993 9.47946 11.2439L2.53918 18.1842C2.35143 18.372 2.27959 18.5685 2.27007 18.8451L2.24707 21.2191C2.25557 21.4421 2.47795 21.754 2.78138 21.7534L7.26136 21.7438C7.58273 21.743 7.80633 21.5016 7.80696 21.1982L7.79499 18.4852L11.5432 18.4771C11.8377 18.4854 12.0702 18.2529 12.062 17.9227L12.0968 14.219C15.1193 15.5065 17.9403 15.0899 19.8721 13.1581C22.3674 10.6628 22.3761 6.629 19.8738 4.12667ZM15.6882 8.31228C15.0203 7.64439 15.0405 6.57343 15.7023 5.9116C16.3731 5.24083 17.4261 5.23857 18.094 5.90646C18.753 6.56544 18.7685 7.6363 18.0978 8.30708C17.4359 8.96891 16.3472 8.97126 15.6882 8.31228Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const InboxIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M4.38679 19.5H19.6132C21.549 19.5 22.5 18.5504 22.5 16.6511V11.7334C22.5 10.8516 22.3641 10.4446 21.9566 9.89064L19.0472 5.92252C18.0169 4.50938 17.4735 4.125 15.7981 4.125H8.20188C6.53773 4.125 5.98302 4.50938 4.95282 5.92252L2.05472 9.89064C1.64717 10.4446 1.5 10.8516 1.5 11.7334V16.6511C1.5 18.5504 2.46226 19.5 4.38679 19.5ZM12.0057 14.2318C10.6811 14.2318 9.88867 13.0674 9.88867 12.0612V12.0273C9.88867 11.5977 9.6283 11.1794 9.07357 11.1794H3.63962C3.31132 11.1794 3.24339 10.9081 3.40189 10.682L6.53773 6.3182C6.94527 5.74164 7.47735 5.54945 8.1 5.54945H15.9C16.5226 5.54945 17.066 5.74164 17.4735 6.3182L20.5981 10.682C20.7452 10.9081 20.6887 11.1794 20.3603 11.1794H14.9264C14.383 11.1794 14.1226 11.5977 14.1226 12.0273V12.0612C14.1226 13.0674 13.3189 14.2318 12.0057 14.2318Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SnowflakeIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M11.9979 22.5C12.5242 22.5 12.8268 22.1451 12.8268 21.6327V19.6352L14.4057 20.5156C14.8399 20.7653 15.2873 20.7259 15.5372 20.2922C15.7346 19.9242 15.6162 19.4774 15.1688 19.2147L12.8268 17.9005V16.7703L12.5768 13.0119L15.7346 15.1014L16.7083 15.6664L16.682 18.3472C16.682 18.8598 16.9977 19.2147 17.4188 19.2147C17.9319 19.2147 18.1819 18.8466 18.1819 18.3472L18.1951 16.5075L19.9582 17.5325C20.3924 17.7953 20.8397 17.6902 21.0898 17.2565C21.3397 16.8097 21.2082 16.3498 20.774 16.1001L19.024 15.1014L20.6029 14.1683C21.024 13.9186 21.2082 13.5112 20.9712 13.0907C20.7476 12.7096 20.274 12.6176 19.8398 12.8673L17.5372 14.234L16.5504 13.6689L13.1557 12L16.5504 10.331L17.524 9.76594L19.8398 11.1326C20.274 11.3824 20.7607 11.2904 20.9712 10.9224C21.2082 10.4887 21.024 10.0813 20.6029 9.83167L19.024 8.89863L20.774 7.89987C21.2213 7.63705 21.3529 7.20336 21.0898 6.74341C20.8528 6.32288 20.4055 6.21777 19.9582 6.46747L18.1951 7.4662L18.1819 5.63955C18.1819 5.1533 17.9319 4.78538 17.4319 4.78538C16.9977 4.78538 16.682 5.14016 16.682 5.63955L16.7083 8.32039L15.7346 8.89863L12.5768 10.9881L12.8268 7.21653V6.0995L15.1688 4.78538C15.6162 4.52253 15.7346 4.07571 15.5372 3.70776C15.2873 3.27409 14.8399 3.23466 14.4057 3.4712L12.8268 4.36485V2.36734C12.8268 1.85483 12.5242 1.5 11.9979 1.5C11.511 1.5 11.1821 1.85483 11.1821 2.36734V4.36485L9.5769 3.4712C9.14271 3.23466 8.72163 3.27409 8.4585 3.70776C8.24798 4.07571 8.3927 4.52253 8.82693 4.7722L11.1821 6.0995V7.21653L11.4189 10.9881L8.2743 8.89863L7.28748 8.32039L7.31379 5.63955C7.31379 5.14016 6.99803 4.78538 6.57699 4.78538C6.07699 4.78538 5.81382 5.1533 5.81382 5.63955L5.80069 7.4662L4.05074 6.46747C3.61654 6.2309 3.14286 6.32288 2.90603 6.74341C2.64288 7.20336 2.78761 7.65019 3.22181 7.89987L4.97174 8.89863L3.39286 9.83167C2.97182 10.0813 2.78761 10.4624 3.02444 10.9224C3.23496 11.2904 3.70863 11.3824 4.15599 11.1326L6.47171 9.77907L7.44537 10.331L10.84 12L7.44537 13.6689L6.47171 14.234L4.15599 12.8673C3.7218 12.6176 3.24812 12.7096 3.05076 13.0776C2.80077 13.5375 2.97182 13.9186 3.39286 14.1683L4.97174 15.1014L3.22181 16.1001C2.78761 16.3498 2.65603 16.8229 2.90603 17.2565C3.15602 17.6902 3.61654 17.769 4.05074 17.5325L5.80069 16.5338L5.81382 18.3472C5.81382 18.8466 6.07699 19.2147 6.57699 19.2147C6.99803 19.2147 7.31379 18.8598 7.31379 18.3472L7.30064 15.6664L8.2743 15.1145L11.4189 13.0119L11.1821 16.7703V17.9005L8.82693 19.2147C8.3927 19.4774 8.24798 19.9242 8.4585 20.2922C8.72163 20.7259 9.14271 20.7653 9.5769 20.5156L11.1821 19.6352V21.6327C11.1821 22.1451 11.511 22.5 11.9979 22.5Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SparklesIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.4158 5.58939C11.557 5.58939 11.634 5.5014 11.6596 5.38827L11.6768 5.30148C11.9801 3.76575 11.9861 3.7357 13.6746 3.41481C13.8029 3.38966 13.8928 3.31425 13.8928 3.17598C13.8928 3.03772 13.8029 2.96229 13.6746 2.93716C11.9861 2.61628 11.9801 2.5862 11.6768 1.05049L11.6596 0.963687C11.634 0.837989 11.557 0.75 11.4158 0.75C11.2875 0.75 11.2104 0.837989 11.1848 0.963687L11.1597 1.08576C10.8519 2.58669 10.8453 2.61875 9.16985 2.93716C9.0415 2.96229 8.95166 3.03772 8.95166 3.17598C8.95166 3.31425 9.0415 3.38966 9.16985 3.41481C10.8453 3.73322 10.8519 3.76527 11.1597 5.26621L11.1848 5.38827C11.2104 5.5014 11.2875 5.58939 11.4158 5.58939ZM6.60354 12.4147C6.80888 12.4147 6.95004 12.2764 6.97572 12.0753C7.32098 9.45776 7.4369 9.43579 10.1925 8.91345L10.2227 8.90772C10.4152 8.88259 10.5692 8.74432 10.5692 8.5432C10.5692 8.32952 10.4152 8.19124 10.2227 8.16611C7.43774 7.81414 7.30939 7.68845 6.97572 5.01107C6.95004 4.79738 6.80888 4.65912 6.60354 4.65912C6.38535 4.65912 6.24417 4.79738 6.21851 5.02364C5.91476 7.61435 5.72334 7.65023 3.08418 8.14498L2.97152 8.16611C2.77901 8.20381 2.625 8.32952 2.625 8.5432C2.625 8.75688 2.77901 8.88259 3.02285 8.90772C5.74366 9.32252 5.9105 9.42308 6.21851 12.0502C6.24417 12.2764 6.38535 12.4147 6.60354 12.4147ZM13.957 22.7724C13.9057 23.0615 13.6875 23.2501 13.418 23.2501C13.1357 23.2501 12.9175 23.0615 12.879 22.7724C12.0961 17.5307 11.2876 16.7011 5.9743 15.9972C5.66628 15.9721 5.46094 15.7458 5.46094 15.4693C5.46094 15.1802 5.66628 14.9665 5.9743 14.9288C11.3004 14.3128 12.1218 13.4078 12.879 8.16619C12.9175 7.86452 13.1357 7.67596 13.418 7.67596C13.6875 7.67596 13.9057 7.86452 13.957 8.16619C14.7014 13.4078 15.5228 14.3128 20.849 14.9288C21.1568 14.9665 21.3751 15.1802 21.3751 15.4693C21.3751 15.7458 21.1568 15.9721 20.849 15.9972C15.5228 16.6131 14.7014 17.5307 13.957 22.7724Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SunIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M12.9557 4.43851C12.9557 4.95491 12.5241 5.39754 12.0062 5.39754C11.4759 5.39754 11.0443 4.95491 11.0443 4.43851V2.4467C11.0443 1.93033 11.4759 1.5 12.0062 1.5C12.5241 1.5 12.9557 1.93033 12.9557 2.4467V4.43851ZM18.0362 7.34015C17.6539 7.7213 17.0373 7.70901 16.6673 7.34015C16.3097 6.97131 16.3097 6.36884 16.6673 6.00001L18.0977 4.57376C18.4677 4.20492 19.0842 4.20492 19.4542 4.57376C19.8119 4.94262 19.8119 5.56968 19.4542 5.93851L18.0362 7.34015ZM19.5652 12.959C19.0473 12.959 18.6033 12.5164 18.6033 12C18.6033 11.4836 19.0473 11.041 19.5652 11.041H21.5381C22.0683 11.041 22.5 11.4836 22.5 12C22.5 12.5164 22.0683 12.959 21.5381 12.959H19.5652ZM16.6673 18.0123C16.3097 17.6434 16.3097 17.041 16.6673 16.6721C17.0373 16.3033 17.6539 16.3033 18.0237 16.6721L19.4542 18.0737C19.8119 18.4426 19.8119 19.0573 19.4542 19.4262C19.0842 19.7951 18.4677 19.8074 18.0977 19.4385L16.6673 18.0123ZM11.0443 19.5615C11.0443 19.045 11.4759 18.6025 12.0062 18.6025C12.5241 18.6025 12.9557 19.045 12.9557 19.5615V21.5533C12.9557 22.0697 12.5241 22.4999 12.0062 22.4999C11.4759 22.4999 11.0443 22.0697 11.0443 21.5533V19.5615ZM5.96388 16.6721C6.33384 16.3033 6.96272 16.3033 7.33264 16.6721C7.69026 17.041 7.69026 17.6434 7.32032 18.0123L5.90224 19.4262C5.53228 19.7951 4.91573 19.7828 4.54581 19.4139C4.18821 19.045 4.18821 18.4303 4.55813 18.0614L5.96388 16.6721ZM4.43481 11.041C4.96506 11.041 5.39665 11.4836 5.39665 12C5.39665 12.5164 4.96506 12.959 4.43481 12.959H2.46182C1.93159 12.959 1.5 12.5164 1.5 12C1.5 11.4836 1.93159 11.041 2.46182 11.041H4.43481ZM7.33264 6.00001C7.69026 6.35656 7.69026 6.9836 7.32032 7.34015C6.95039 7.70901 6.33384 7.70901 5.96388 7.34015L4.55813 5.92623C4.20053 5.56968 4.20053 4.94262 4.57046 4.57376C4.92808 4.20492 5.55695 4.21721 5.91455 4.57376L7.33264 6.00001ZM17.0255 12C17.0255 14.7541 14.7442 17.0164 12.0067 17.0164C9.25685 17.0164 6.97559 14.7541 6.97559 12C6.97559 9.24594 9.25685 6.98364 12.0067 6.98364C14.7442 6.98364 17.0255 9.24594 17.0255 12Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const HareIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M12.5439 19.5858C13.0784 19.5858 13.5172 19.3355 14.5286 19.3355C15.5306 19.3355 15.7882 19.5858 16.523 19.5858C17.6298 19.5858 18.2024 19.1238 18.2024 18.2958C18.2024 16.9288 16.8092 16.0528 14.5191 16.0528C13.3932 16.0528 12.897 16.1491 12.2672 16.3127L11.4466 14.4259C10.6642 12.6739 9.39507 11.4898 7.55347 11.4898H6.66607C6.37025 11.4898 6.16033 11.355 6.16033 11.047C6.16033 10.5657 6.7901 10.4405 7.48667 10.4405C9.70041 10.4405 11.3321 11.6727 12.334 14.1371L12.8397 15.3886C13.3455 15.2827 13.8989 15.2346 14.4428 15.2346C14.8912 15.2346 15.3207 15.2635 15.75 15.3212C16.1985 14.9843 16.7233 14.6473 17.5057 14.3874C18.3456 14.9169 19.2425 15.2538 20.2157 15.2538C22.3149 15.2538 23.25 14.8014 23.25 12.7702C23.25 10.4405 21.628 8.67883 19.2806 8.6307L17.2481 5.95451C16.1031 4.45275 14.7576 3.75 13.4409 3.75C12.3436 3.75 10.6737 4.39499 10.6737 5.2999C10.6737 5.90636 11.9237 6.79201 12.8493 7.37923L17.1432 10.0747C16.8855 10.3057 16.6089 10.4694 16.2367 10.4694C15.6356 10.4694 14.9868 10.0747 14.0803 9.54524C11.7615 8.19751 9.97713 6.94605 7.57254 6.94605C5.07255 6.94605 3.17368 8.39966 2.16222 11.2492C1.36069 11.2492 0.75 11.7882 0.75 12.568C0.75 13.444 1.44657 14.0024 2.38168 14.0024C3.48856 15.5522 5.30154 16.1587 7.40079 16.1587C7.5153 16.1587 7.6298 16.1491 7.7443 16.1491L10.7977 18.7675C11.5897 19.4895 11.9714 19.5858 12.5439 19.5858ZM7.19087 20.25C8.66033 20.25 9.52866 19.9516 10.2252 19.451L7.91605 17.4679C7.81108 17.4775 7.68705 17.4871 7.53437 17.4871C7.13361 17.4871 6.63744 17.3813 5.94086 17.3813C5.10115 17.3813 4.54772 17.8434 4.54772 18.5461C4.54772 19.5762 5.60689 20.25 7.19087 20.25ZM20.0727 12.4428C19.7196 12.4428 19.4524 12.1541 19.4524 11.8075C19.4524 11.4513 19.7291 11.1432 20.0821 11.1432C20.4447 11.1432 20.7119 11.4224 20.7119 11.769C20.7119 12.1252 20.4352 12.4428 20.0727 12.4428Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const FlashIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M5.25 13.1338C5.25 13.5472 5.58422 13.8543 6.01393 13.8543H11.2778L8.5086 21.2952C8.11471 22.3699 9.23674 22.9488 9.95289 22.0747L18.4874 11.5276C18.6545 11.3032 18.75 11.1024 18.75 10.8661C18.75 10.4528 18.4277 10.1457 17.9861 10.1457H12.7221L15.4914 2.70481C15.8972 1.63 14.7633 1.05129 14.0471 1.92528L5.51259 12.4724C5.34548 12.6968 5.25 12.8976 5.25 13.1338Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const BankCardIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M5.17928 17.2322C4.65824 17.2322 4.3071 16.855 4.3071 16.3196V14.5553C4.3071 14.0199 4.65824 13.6427 5.17928 13.6427H7.35403C7.87506 13.6427 8.22618 14.0199 8.22618 14.5553V16.3196C8.22618 16.855 7.87506 17.2322 7.35403 17.2322H5.17928ZM1.49805 9.91922V7.72894H22.498V9.91922H1.49805ZM4.38639 20.25H19.6097C21.5465 20.25 22.498 19.24 22.498 17.1957V6.80418C22.498 4.75994 21.5465 3.75 19.6097 3.75H4.38639C2.46082 3.75 1.49805 4.75994 1.49805 6.80418V17.1957C1.49805 19.24 2.46082 20.25 4.38639 20.25Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const GearIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M11.9941 21.033C12.2078 21.033 12.4214 21.0211 12.6351 21.0093L13.1693 22.0308C13.288 22.2683 13.5373 22.387 13.8104 22.3396C14.0715 22.2802 14.2733 22.0783 14.2971 21.805L14.4751 20.6885C14.8906 20.5816 15.2824 20.4154 15.686 20.261L16.517 20.9974C16.7069 21.1756 17.0037 21.2349 17.253 21.0925C17.4785 20.9498 17.5973 20.6766 17.5261 20.4154L17.3004 19.3226C17.6329 19.0612 17.9772 18.788 18.274 18.503L19.3068 18.9306C19.5915 19.0494 19.8527 18.9662 20.0427 18.7406C20.197 18.5387 20.2207 18.2536 20.0902 18.0279L19.4847 17.0658C19.7222 16.7095 19.924 16.3413 20.1258 15.9374L21.2536 15.9849C21.5148 15.9968 21.776 15.8543 21.8589 15.5811C21.9539 15.3316 21.8471 15.0585 21.6453 14.8922L20.7669 14.1914C20.8737 13.7875 20.9449 13.3599 20.9805 12.9204L22.037 12.576C22.3219 12.481 22.5 12.279 22.5 11.994C22.5 11.7089 22.3219 11.507 22.037 11.412L20.9805 11.0675C20.9449 10.628 20.8737 10.2123 20.7669 9.79658L21.6453 9.09579C21.8471 8.92949 21.9539 8.66818 21.8589 8.41875C21.776 8.14556 21.5148 8.00303 21.2536 8.0149L20.1258 8.05054C19.924 7.64668 19.7222 7.29036 19.4847 6.92214L20.0902 5.96004C20.2207 5.74623 20.197 5.46116 20.0427 5.25924C19.8527 5.03356 19.5915 4.9623 19.3186 5.0692L18.274 5.48493C17.9772 5.21173 17.6329 4.92666 17.3004 4.67723L17.5261 3.58447C17.5853 3.2994 17.4785 3.03809 17.253 2.90744C17.0037 2.7649 16.7069 2.80054 16.517 3.00246L15.686 3.72701C15.2824 3.5726 14.8906 3.41818 14.4751 3.2994L14.2971 2.19477C14.2733 1.92158 14.0715 1.71965 13.8104 1.66026C13.5373 1.61275 13.288 1.73153 13.1693 1.95721L12.6351 2.9787C12.4214 2.96683 12.2078 2.95495 11.9941 2.95495C11.7685 2.95495 11.5667 2.96683 11.3412 2.9787L10.807 1.95721C10.6883 1.73153 10.439 1.61275 10.1659 1.66026C9.90476 1.71965 9.72669 1.92158 9.6792 2.19477L9.50113 3.2994C9.09752 3.41818 8.69391 3.5726 8.30215 3.72701L7.47118 3.00246C7.26937 2.80054 6.98447 2.7649 6.72329 2.90744C6.49774 3.03809 6.40277 3.2994 6.46212 3.58447L6.67581 4.67723C6.35529 4.92666 5.99916 5.21173 5.70237 5.48493L4.65771 5.0692C4.39655 4.9623 4.1354 5.03356 3.94546 5.25924C3.79112 5.46116 3.75552 5.74623 3.89796 5.96004L4.49152 6.92214C4.26597 7.29036 4.06416 7.64668 3.85049 8.05054L2.72273 8.0149C2.47343 8.00303 2.21227 8.14556 2.12917 8.41875C2.04607 8.66818 2.12917 8.92949 2.33098 9.09579L3.20944 9.79658C3.10261 10.2123 3.03137 10.628 3.00763 11.0675L1.92736 11.412C1.65432 11.4951 1.5 11.7089 1.5 11.994C1.5 12.279 1.65432 12.4928 1.92736 12.576L3.00763 12.9204C3.03137 13.3599 3.10261 13.7875 3.20944 14.1914L2.33098 14.8922C2.12917 15.0585 2.04607 15.3316 2.12917 15.5811C2.21227 15.8543 2.47343 15.9968 2.72273 15.9849L3.85049 15.9374C4.06416 16.3413 4.26597 16.7095 4.49152 17.0658L3.89796 18.0279C3.75552 18.2536 3.79112 18.5387 3.94546 18.7406C4.1354 18.9662 4.39655 19.0494 4.66959 18.9306L5.70237 18.503C5.99916 18.788 6.35529 19.0612 6.67581 19.3226L6.46212 20.4154C6.41465 20.6766 6.49774 20.9498 6.72329 21.0925C6.98447 21.2349 7.26937 21.1756 7.47118 20.9974L8.30215 20.261C8.69391 20.4154 9.09752 20.5816 9.50113 20.6885L9.6792 21.805C9.72669 22.0783 9.90476 22.2802 10.1659 22.3396C10.439 22.387 10.6883 22.2683 10.807 22.0308L11.3412 21.0093C11.5667 21.0211 11.7685 21.033 11.9941 21.033ZM11.9941 19.3226C7.89854 19.3226 4.76456 16.0681 4.76456 12.0059C4.76456 7.93175 7.89854 4.66536 11.9941 4.66536C16.0896 4.66536 19.2355 7.93175 19.2355 12.0059C19.2355 16.0681 16.0896 19.3226 11.9941 19.3226ZM10.249 10.5449L11.4955 9.76095L8.42087 4.48719L7.11504 5.21173L10.249 10.5449ZM14.1546 12.7185H20.2802V11.2694H14.1546V12.7185ZM11.4836 14.2745L10.2609 13.455L7.0082 18.7643L8.29028 19.5126L11.4836 14.2745ZM11.9585 14.5715C13.383 14.5715 14.5226 13.4312 14.5226 12.0177C14.5226 10.6043 13.383 9.45211 11.9585 9.45211C10.5458 9.45211 9.41804 10.6043 9.41804 12.0177C9.41804 13.4312 10.5458 14.5715 11.9585 14.5715ZM11.9585 12.9917C11.4124 12.9917 10.9969 12.576 10.9969 12.0177C10.9969 11.4595 11.4124 11.0319 11.9585 11.0319C12.5164 11.0319 12.9438 11.4595 12.9438 12.0177C12.9438 12.576 12.5164 12.9917 11.9585 12.9917Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const HandIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M5.25 15.6033C5.25 19.8703 8.04175 22.5 11.97 22.5C15.0705 22.5 16.8864 21.2719 18.1958 18.9524C19.0111 17.5384 19.6164 15.7646 20.2587 13.6683C20.5552 12.7256 21 11.51 21 10.9642C21 10.4309 20.6047 10.0587 20.0241 10.0587C19.3447 10.0587 18.9741 10.4929 18.4676 11.51L17.0964 14.3133C16.9729 14.5862 16.837 14.7102 16.6888 14.7102C16.5282 14.7102 16.417 14.611 16.417 14.3009V3.90636C16.417 3.29857 15.9353 2.81482 15.33 2.81482C14.737 2.81482 14.2429 3.29857 14.2429 3.90636V11.3736C13.9959 11.2867 13.7241 11.2123 13.4276 11.1627V2.59155C13.4276 1.99616 12.9335 1.5 12.3406 1.5C11.7353 1.5 11.2535 1.99616 11.2535 2.59155V11.0635C10.9694 11.0883 10.6976 11.1255 10.4135 11.1751V3.36061C10.4135 2.7528 9.93174 2.26905 9.32646 2.26905C8.73352 2.26905 8.2394 2.7528 8.2394 3.36061V11.8573C7.95528 12.0062 7.68352 12.1674 7.41175 12.3287V6.41198C7.41175 5.81659 6.92999 5.32043 6.33705 5.32043C5.73176 5.32043 5.25 5.81659 5.25 6.41198V15.6033Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const GlassCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.5 12C22.5 17.7379 17.7278 22.5 11.9935 22.5C6.27214 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25914 1.5 11.9805 1.5C17.7148 1.5 22.5 6.26208 22.5 12ZM6.44117 10.803C6.44117 13.236 8.44366 15.2397 10.8752 15.2397C11.7074 15.2397 12.4746 15.0056 13.1378 14.6152L15.7254 17.1784C15.9594 17.4256 16.2195 17.5427 16.5576 17.5427C17.1167 17.5427 17.5198 17.1134 17.5198 16.5148C17.5198 16.2546 17.3898 15.9944 17.2077 15.8122L14.6071 13.197C15.0492 12.5074 15.3093 11.6747 15.3093 10.803C15.3093 8.34386 13.3198 6.35315 10.8752 6.35315C8.44366 6.35315 6.44117 8.35687 6.44117 10.803ZM13.6709 10.803C13.6709 12.3383 12.4096 13.6134 10.8752 13.6134C9.32785 13.6134 8.06655 12.3383 8.06655 10.803C8.06655 9.26764 9.32785 7.99256 10.8752 7.99256C12.4096 7.99256 13.6709 9.25463 13.6709 10.803Z"
                fill="currentColor"
            />
        </svg>
    );
};
export const FlashCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.4998 12C22.4998 17.7379 17.7277 22.5 11.9934 22.5C6.2721 22.5 1.5 17.7379 1.5 12C1.5 6.26207 6.25908 1.5 11.9804 1.5C17.7147 1.5 22.4998 6.26207 22.4998 12ZM13.2807 5.10408L7.58539 12.2472C7.46836 12.3773 7.40334 12.5465 7.40334 12.6896C7.40334 12.9758 7.63741 13.197 7.92346 13.197H11.4473L9.57485 18.2194C9.30179 18.948 10.082 19.3382 10.5631 18.7528L16.2584 11.5966C16.3754 11.4665 16.4404 11.2974 16.4404 11.1673C16.4404 10.868 16.2064 10.6598 15.9203 10.6598H12.3965L14.2689 5.63755C14.542 4.90893 13.7618 4.5186 13.2807 5.10408Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const DollarCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.4998 12C22.4998 17.7379 17.7277 22.5 11.9934 22.5C6.2721 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25908 1.5 11.9804 1.5C17.7147 1.5 22.4998 6.26208 22.4998 12ZM11.4473 6.47024V7.19887C9.83492 7.39404 8.70364 8.39589 8.70364 9.87917C8.70364 11.2713 9.62686 12.0911 11.3953 12.5074L11.4473 12.5334V15.4869C10.5761 15.3438 10.108 14.8624 9.92595 14.2379C9.78291 13.8346 9.53583 13.6654 9.19776 13.6654C8.79467 13.6654 8.50861 13.9516 8.50861 14.355C8.50861 14.4721 8.53462 14.5892 8.54762 14.6933C8.87269 15.9163 10.069 16.671 11.4473 16.8141V17.5427C11.4473 17.868 11.6813 18.1022 12.0064 18.1022C12.3185 18.1022 12.5525 17.868 12.5525 17.5427V16.8271C14.1649 16.671 15.4652 15.7342 15.4652 14.0688C15.4652 12.5855 14.503 11.6877 12.6566 11.3754L12.5525 11.3624V8.56505C13.2157 8.69517 13.6708 9.0985 13.9049 9.77508C14.0219 10.1264 14.2559 10.3476 14.633 10.3476C15.0361 10.3476 15.3222 10.0613 15.3222 9.65796C15.3222 9.54088 15.2962 9.42377 15.2701 9.30668C14.9711 8.14869 13.9049 7.36802 12.5525 7.19887V6.47024C12.5525 6.14497 12.3185 5.9238 12.0064 5.9238C11.6813 5.9238 11.4473 6.14497 11.4473 6.47024ZM12.7736 12.8717C13.7098 13.1319 13.9959 13.5483 13.9959 14.1598C13.9959 14.8364 13.5667 15.3569 12.5525 15.4869V12.8067L12.7736 12.8717ZM11.4473 11.0632L11.3693 11.0502C10.5241 10.7639 10.173 10.3736 10.173 9.80109C10.173 9.2286 10.6281 8.72118 11.4473 8.56505V11.0632Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const EuroCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.4998 12C22.4998 17.7379 17.7277 22.5 11.9934 22.5C6.2721 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25908 1.5 11.9804 1.5C17.7147 1.5 22.4998 6.26208 22.4998 12ZM8.15751 10.2695H7.13029C6.80522 10.2695 6.57115 10.5037 6.57115 10.842C6.57115 11.1543 6.80522 11.4275 7.13029 11.4275H7.98849C7.97548 11.6096 7.96248 11.8048 7.96248 12.013C7.96248 12.1951 7.96248 12.3643 7.97548 12.5334H7.13029C6.80522 12.5334 6.57115 12.7676 6.57115 13.1059C6.57115 13.4182 6.80522 13.6784 7.13029 13.6784H8.14453C8.62565 15.7732 10.043 17.2304 12.2795 17.2304C14.0869 17.2304 15.5562 16.4758 16.1413 14.9015C16.2064 14.7193 16.2454 14.5372 16.2454 14.342C16.2454 13.9126 15.9723 13.6264 15.5172 13.6264C15.1271 13.6264 14.8931 13.8215 14.763 14.2379C14.425 15.2788 13.3977 15.7862 12.3315 15.7862C11.0572 15.7862 10.199 14.9145 9.82189 13.6784H12.4355C12.7606 13.6784 12.9946 13.4182 12.9946 13.1059C12.9946 12.7676 12.7606 12.5334 12.4355 12.5334H9.58785C9.57485 12.3643 9.56185 12.1821 9.56185 12.013C9.56185 11.8048 9.57485 11.6096 9.58785 11.4275H12.4355C12.7606 11.4275 12.9946 11.1543 12.9946 10.842C12.9946 10.5037 12.7606 10.2695 12.4355 10.2695H9.84792C10.238 9.08549 11.0832 8.25278 12.3315 8.25278C13.3067 8.25278 14.3209 8.74721 14.672 9.80109C14.815 10.2695 15.0231 10.4126 15.4392 10.4126C15.8813 10.4126 16.1674 10.1264 16.1674 9.697C16.1674 9.50185 16.1284 9.33269 16.0633 9.15053C15.5172 7.6933 13.9959 6.80854 12.2795 6.80854C10.186 6.80854 8.69064 8.1617 8.15751 10.2695Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SterlingCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.4998 12C22.4998 17.7379 17.7277 22.5 11.9934 22.5C6.2721 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25908 1.5 11.9804 1.5C17.7147 1.5 22.4998 6.26208 22.4998 12ZM9.41883 9.9182C9.41883 10.3085 9.47084 10.6989 9.56185 11.0892H8.61262C8.23553 11.0892 7.96248 11.3364 7.96248 11.7137C7.96248 12.0911 8.23553 12.3513 8.61262 12.3513H9.8739C9.95193 12.6896 10.0039 13.0279 10.0039 13.3271C10.0039 14.4851 9.30179 15.1747 8.59963 15.4089C8.15751 15.539 7.97548 15.7732 7.97548 16.1635C7.97548 16.5929 8.26157 16.8661 8.67766 16.8661H15.1531C15.5692 16.8661 15.8683 16.5929 15.8683 16.1635C15.8683 15.7602 15.5692 15.4739 15.1531 15.4739H10.6411C11.1742 15.0056 11.5253 14.1728 11.5253 13.2621C11.5253 12.9238 11.4993 12.6245 11.4343 12.3513H13.9959C14.386 12.3513 14.659 12.0911 14.659 11.7137C14.659 11.3364 14.386 11.0892 13.9959 11.0892H11.1352C11.0572 10.7119 10.9662 10.3085 10.9662 9.81411C10.9662 8.68214 11.8114 7.9405 13.1377 7.9405C13.9699 7.9405 14.412 8.14869 14.724 8.14869C15.1661 8.14869 15.3742 7.90146 15.3742 7.52414C15.3742 7.19887 15.2051 6.95167 14.7891 6.78251C14.2429 6.58735 13.6448 6.54832 13.0336 6.54832C10.8361 6.54832 9.41883 7.83642 9.41883 9.9182Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const YuanCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.4998 12C22.4998 17.7379 17.7277 22.5 11.9934 22.5C6.2721 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25908 1.5 11.9804 1.5C17.7147 1.5 22.4998 6.26208 22.4998 12ZM8.0405 7.38103C8.0405 7.56318 8.07952 7.6933 8.18354 7.87546L10.7321 12.013H9.31479C8.97672 12.013 8.74266 12.2732 8.74266 12.5985C8.74266 12.9238 8.9897 13.171 9.31479 13.171H11.2522V13.9647H9.31479C8.97672 13.9647 8.74266 14.2119 8.74266 14.5372C8.74266 14.8754 8.9897 15.1096 9.31479 15.1096H11.2522V16.5148C11.2522 16.9963 11.5643 17.3215 11.9934 17.3215C12.4355 17.3215 12.7476 17.0093 12.7476 16.5279V15.1096H14.685C15.0231 15.1096 15.2442 14.8754 15.2442 14.5372C15.2442 14.2119 15.0231 13.9647 14.685 13.9647H12.7476V13.171H14.685C15.0231 13.171 15.2442 12.9238 15.2442 12.5985C15.2442 12.2732 15.0231 12.013 14.685 12.013H13.2807L15.8293 7.88847C15.9333 7.7063 15.9723 7.57618 15.9723 7.39404C15.9723 7.00371 15.6472 6.69143 15.2181 6.69143C14.9321 6.69143 14.711 6.82155 14.542 7.08179L12.0064 11.4275L9.47084 7.06875C9.30179 6.79552 9.08072 6.67844 8.79467 6.67844C8.36557 6.67844 8.0405 6.9907 8.0405 7.38103Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const RubleCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.4998 12C22.4998 17.7379 17.7277 22.5 11.9934 22.5C6.2721 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25908 1.5 11.9804 1.5C17.7147 1.5 22.4998 6.26208 22.4998 12ZM10.212 7.08179C9.73088 7.08179 9.43183 7.39404 9.43183 7.86245V12.4033H8.50861C8.15751 12.4033 7.93648 12.6505 7.93648 12.9758C7.93648 13.3141 8.15751 13.5613 8.50861 13.5613H9.43183V14.5632H8.52161C8.17054 14.5632 7.94948 14.8104 7.94948 15.1357C7.94948 15.4739 8.17054 15.7082 8.52161 15.7082H9.43183V16.6319C9.43183 17.0873 9.7569 17.4126 10.225 17.4126C10.6671 17.4126 10.9792 17.0873 10.9792 16.6319V15.7082H13.4367C13.7748 15.7082 14.0089 15.4739 14.0089 15.1357C14.0089 14.8104 13.7748 14.5632 13.4367 14.5632H10.9792V13.5613H12.7476C14.75 13.5613 16.0373 12.1951 16.0373 10.3216C16.0373 8.46094 14.763 7.08179 12.7606 7.08179H10.212ZM14.464 10.3346C14.464 11.4665 13.8008 12.1951 12.4615 12.1951L10.9922 12.1691V8.49998H12.4615C13.8138 8.49998 14.464 9.20257 14.464 10.3346Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const RupeeCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.5 12C22.5 17.7379 17.7278 22.5 11.9935 22.5C6.27214 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25914 1.5 11.9805 1.5C17.7148 1.5 22.5 6.26208 22.5 12ZM12.8257 7.09479C12.4876 7.09479 12.1365 7.09479 11.7984 7.09479H8.93776C8.56068 7.09479 8.2486 7.40706 8.2486 7.79739C8.2486 8.1747 8.56068 8.513 8.93776 8.513H10.7192C11.6684 8.513 12.3056 8.90333 12.5266 9.61894H8.92476C8.61269 9.61894 8.35263 9.85314 8.35263 10.1914C8.35263 10.5167 8.61269 10.7769 8.92476 10.7769H12.5656C12.3576 11.5446 11.7204 11.9349 10.7192 11.9349H9.21082C8.7037 11.9349 8.33963 12.2472 8.33963 12.7546C8.33963 13.158 8.54768 13.3531 8.76873 13.5743L12.5136 17.0873C12.7737 17.3475 12.9687 17.4126 13.2288 17.4126C13.6189 17.4126 13.9439 17.1654 13.9439 16.723C13.9439 16.4888 13.7879 16.2806 13.6319 16.1115L10.6672 13.3401H10.8492C12.9167 13.3401 13.9439 12.0911 14.165 10.7769H15.1922C15.5303 10.7769 15.7514 10.5167 15.7514 10.1914C15.7514 9.85314 15.5303 9.61894 15.1922 9.61894H14.191C14.1 9.08549 13.9179 8.6301 13.6059 8.25278H15.1272C15.4653 8.25278 15.6994 7.97953 15.6994 7.66727C15.6994 7.32898 15.4653 7.09479 15.1272 7.09479H12.8257Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const HashCircleIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            color={theme.iconPrimary}
        >
            <path
                d="M22.5 12C22.5 17.7379 17.7278 22.5 11.9935 22.5C6.27214 22.5 1.5 17.7379 1.5 12C1.5 6.26208 6.25914 1.5 11.9805 1.5C17.7148 1.5 22.5 6.26208 22.5 12ZM13.9049 7.21189L13.4628 9.31968H11.5904L11.9675 7.44608C12.0715 6.96467 11.7334 6.53531 11.2393 6.53531C10.7712 6.53531 10.4721 6.78253 10.3811 7.21189L9.939 9.31968H8.89875C8.43064 9.31968 8.09257 9.67099 8.09257 10.1264C8.09257 10.5297 8.37863 10.829 8.76873 10.829H9.61392L9.19782 12.8717H8.14458C7.67647 12.8717 7.33838 13.223 7.33838 13.6784C7.33838 14.0948 7.63745 14.381 8.02756 14.381H8.88575L8.45665 16.3717C8.37863 16.8661 8.72971 17.2825 9.21082 17.2825C9.67894 17.2825 9.96501 17.0353 10.056 16.5929L10.5241 14.394H12.3966L11.9935 16.3717C11.8895 16.8661 12.2275 17.2825 12.7087 17.2825C13.1898 17.2825 13.5019 17.0353 13.5929 16.5929L14.048 14.381H15.1012C15.5563 14.381 15.8944 14.0297 15.8944 13.5743C15.8944 13.184 15.6083 12.8717 15.2183 12.8717H14.3731L14.8022 10.829H15.8424C16.3105 10.829 16.6486 10.4777 16.6486 10.0223C16.6486 9.61894 16.3625 9.31968 15.9724 9.31968H15.1142L15.5173 7.44608C15.5953 6.95167 15.2443 6.53531 14.7631 6.53531C14.295 6.53531 13.996 6.78253 13.9049 7.21189ZM12.7867 13.0279H10.7322L11.2133 10.6989H13.2808L12.7867 13.0279Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const emojiIcons = [
    {
        name: 'custom:wallet',
        icon: WalletIcon
    },
    {
        name: 'custom:leaf',
        icon: LeafIcon
    },
    {
        name: 'custom:lock',
        icon: LockIcon
    },
    {
        name: 'custom:key',
        icon: KeyIcon
    },
    {
        name: 'custom:inbox',
        icon: InboxIcon
    },
    {
        name: 'custom:snowflake',
        icon: SnowflakeIcon
    },
    {
        name: 'custom:sparkles',
        icon: SparklesIcon
    },
    {
        name: 'custom:sun',
        icon: SunIcon
    },
    {
        name: 'custom:hare',
        icon: HareIcon
    },
    {
        name: 'custom:flash',
        icon: FlashIcon
    },
    {
        name: 'custom:bankcard',
        icon: BankCardIcon
    },
    {
        name: 'custom:gear',
        icon: GearIcon
    },
    {
        name: 'custom:hand',
        icon: HandIcon
    },
    {
        name: 'custom:glass_circle',
        icon: GlassCircleIcon
    },
    {
        name: 'custom:flash_circle',
        icon: FlashCircleIcon
    },
    {
        name: 'custom:dollar_circle',
        icon: DollarCircleIcon
    },
    {
        name: 'custom:euro_circle',
        icon: EuroCircleIcon
    },
    {
        name: 'custom:sterling_circle',
        icon: SterlingCircleIcon
    },
    {
        name: 'custom:yuan_circle',
        icon: YuanCircleIcon
    },
    {
        name: 'custom:ruble_circle',
        icon: RubleCircleIcon
    },
    {
        name: 'custom:rupee_circle',
        icon: RupeeCircleIcon
    },
    {
        name: 'custom:hash_circle',
        icon: HashCircleIcon
    }
];
