import { FC } from 'react';

export const WalletsIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.6886 3.50061L16.3141 3.50061C17.6812 3.49781 18.3647 3.49641 18.9765 3.69463C19.5178 3.87001 20.016 4.15763 20.4385 4.5387C20.916 4.9694 21.2566 5.56208 21.9377 6.74744L24.2505 10.7532C24.9364 11.9357 25.2794 12.527 25.4136 13.1559C25.5324 13.7124 25.5324 14.2876 25.4136 14.8441C25.2794 15.473 24.9364 16.0642 24.2505 17.2467L21.9377 21.2526C21.2566 22.4379 20.916 23.0306 20.4385 23.4613C20.016 23.8424 19.5178 24.13 18.9765 24.3054C18.3647 24.5036 17.6812 24.5022 16.3141 24.4994H11.6886C10.3215 24.5022 9.63798 24.5036 9.0262 24.3054C8.48492 24.13 7.98674 23.8424 7.56422 23.4613C7.08667 23.0306 6.7461 22.4379 6.06497 21.2526L3.75226 17.2468C3.06628 16.0643 2.72329 15.473 2.58907 14.8441C2.47031 14.2876 2.47031 13.7124 2.58907 13.1559C2.72329 12.527 3.06628 11.9357 3.75226 10.7532L6.06497 6.74744C6.7461 5.56208 7.08667 4.96941 7.56422 4.53871C7.98674 4.15763 8.48492 3.87001 9.0262 3.69463C9.63798 3.49641 10.3215 3.49781 11.6886 3.50061ZM14 18C16.2091 18 18 16.2091 18 14C18 11.7909 16.2091 10 14 10C11.7909 10 9.99999 11.7909 9.99999 14C9.99999 16.2091 11.7909 18 14 18Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                d="M18 14C18 16.2091 16.2091 18 14 18C11.7909 18 10 16.2091 10 14C10 11.7909 11.7909 10 14 10C16.2091 10 18 11.7909 18 14Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SubscriptionIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                opacity="0.32"
                d="M12.5235 10.5497C13.1088 9.14264 13.4014 8.43911 13.8816 8.37157C13.9601 8.36052 14.0398 8.36052 14.1184 8.37157C14.5986 8.43911 14.8912 9.14264 15.4764 10.5497C15.6472 10.9603 15.7326 11.1655 15.8936 11.2994C15.922 11.323 15.9519 11.3447 15.9831 11.3644C16.1602 11.4763 16.3818 11.494 16.8251 11.5296C18.3441 11.6513 19.1036 11.7122 19.3163 12.1481C19.351 12.2193 19.3757 12.2951 19.3894 12.3733C19.4736 12.8508 18.8949 13.3465 17.7376 14.3379C17.3999 14.6272 17.231 14.7718 17.1535 14.9664C17.1398 15.0007 17.1284 15.0358 17.1193 15.0716C17.0677 15.2746 17.1193 15.4908 17.2224 15.9234C17.576 17.4057 17.7528 18.1469 17.404 18.4838C17.347 18.5389 17.2825 18.5857 17.2125 18.6229C16.7843 18.8505 16.134 18.4534 14.8335 17.659C14.454 17.4272 14.2643 17.3114 14.0553 17.2977C14.0185 17.2953 13.9815 17.2953 13.9447 17.2977C13.7357 17.3114 13.5459 17.4272 13.1665 17.659C11.8659 18.4534 11.2157 18.8505 10.7875 18.6229C10.7175 18.5857 10.653 18.5389 10.5959 18.4838C10.2471 18.1469 10.4239 17.4057 10.7775 15.9234C10.8807 15.4908 10.9323 15.2746 10.8807 15.0716C10.8716 15.0358 10.8601 15.0007 10.8465 14.9664C10.7689 14.7718 10.6001 14.6272 10.2624 14.3379C9.10503 13.3465 8.52636 12.8508 8.61051 12.3733C8.62428 12.2951 8.64891 12.2193 8.68368 12.1481C8.89631 11.7122 9.65583 11.6513 11.1749 11.5296C11.6181 11.494 11.8397 11.4763 12.0168 11.3644C12.048 11.3447 12.0779 11.323 12.1063 11.2994C12.2674 11.1655 12.3528 10.9603 12.5235 10.5497Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M3.32698 6.63803C3 7.27976 3 8.11984 3 9.8V10.126C4.72523 10.5701 6 12.1362 6 14C6 15.8638 4.72523 17.4299 3 17.874V18.2C3 19.8802 3 20.7202 3.32698 21.362C3.6146 21.9265 4.07354 22.3854 4.63803 22.673C5.27976 23 6.11984 23 7.8 23H20.2C21.8802 23 22.7202 23 23.362 22.673C23.9265 22.3854 24.3854 21.9265 24.673 21.362C25 20.7202 25 19.8802 25 18.2V17.874C23.2748 17.4299 22 15.8638 22 14C22 12.1362 23.2748 10.5701 25 10.126V9.8C25 8.11984 25 7.27976 24.673 6.63803C24.3854 6.07354 23.9265 5.6146 23.362 5.32698C22.7202 5 21.8802 5 20.2 5H7.8C6.11984 5 5.27976 5 4.63803 5.32698C4.07354 5.6146 3.6146 6.07354 3.32698 6.63803ZM13.8816 8.37163C13.4014 8.43917 13.1088 9.1427 12.5235 10.5498C12.3528 10.9603 12.2674 11.1656 12.1063 11.2995C12.0779 11.3231 12.048 11.3448 12.0168 11.3645C11.8397 11.4763 11.6181 11.4941 11.1749 11.5296C9.65583 11.6514 8.89631 11.7123 8.68368 12.1481C8.64891 12.2194 8.62428 12.2952 8.61051 12.3733C8.52636 12.8509 9.10503 13.3466 10.2624 14.338C10.6001 14.6273 10.7689 14.7719 10.8465 14.9665C10.8601 15.0007 10.8716 15.0359 10.8807 15.0717C10.9323 15.2747 10.8807 15.4909 10.7775 15.9234C10.4239 17.4058 10.2471 18.1469 10.5959 18.4838C10.653 18.5389 10.7175 18.5858 10.7875 18.623C11.2157 18.8506 11.8659 18.4534 13.1665 17.6591C13.5459 17.4273 13.7357 17.3114 13.9447 17.2978C13.9815 17.2954 14.0185 17.2954 14.0553 17.2978C14.2643 17.3114 14.454 17.4273 14.8335 17.6591C16.134 18.4534 16.7843 18.8506 17.2125 18.623C17.2825 18.5858 17.347 18.5389 17.404 18.4838C17.7528 18.1469 17.576 17.4058 17.2224 15.9234C17.1193 15.4909 17.0677 15.2746 17.1193 15.0717C17.1284 15.0359 17.1398 15.0007 17.1535 14.9665C17.231 14.7719 17.3999 14.6273 17.7376 14.338C18.8949 13.3466 19.4736 12.8509 19.3894 12.3733C19.3757 12.2952 19.351 12.2194 19.3163 12.1481C19.1036 11.7123 18.3441 11.6514 16.8251 11.5296C16.3818 11.4941 16.1602 11.4763 15.9831 11.3645C15.9519 11.3448 15.922 11.3231 15.8936 11.2995C15.7326 11.1656 15.6472 10.9603 15.4764 10.5498C14.8912 9.1427 14.5986 8.43917 14.1184 8.37163C14.0398 8.36058 13.9601 8.36058 13.8816 8.37163Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const RecoveryPhraseIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                opacity="0.32"
                d="M12.5 10.001C12.5 11.3817 11.3807 12.501 10 12.501C8.61929 12.501 7.5 11.3817 7.5 10.001C7.5 8.62026 8.61929 7.50098 10 7.50098C11.3807 7.50098 12.5 8.62026 12.5 10.001Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19 11.001C19 12.0397 18.802 13.0322 18.4418 13.9428L24.0627 19.5637C24.4086 19.9096 24.5816 20.0826 24.7053 20.2844C24.8149 20.4634 24.8957 20.6584 24.9447 20.8625C25 21.0927 25 21.3373 25 21.8265V25.001H20.5V23.501H19V22.001H17.5V20.501H16L13.9418 18.4428C13.0312 18.803 12.0387 19.001 11 19.001C6.58172 19.001 3 15.4193 3 11.001C3 6.5827 6.58172 3.00098 11 3.00098C15.4183 3.00098 19 6.5827 19 11.001ZM10 12.501C11.3807 12.501 12.5 11.3817 12.5 10.001C12.5 8.62026 11.3807 7.50098 10 7.50098C8.61929 7.50098 7.5 8.62026 7.5 10.001C7.5 11.3817 8.61929 12.501 10 12.501Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SettingsProIcon: FC<{ size?: number }> = ({ size = 28 }) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width={size}
            height={size}
            viewBox="0 0 28 28"
            fill="none"
        >
            <path opacity="0.5" d="M14 13.5L26.5 8L14 27.5V13.5Z" fill="currentColor" />
            <path opacity="0.75" d="M13.9999 13.5L1.5 8L13.9999 27.5V13.5Z" fill="currentColor" />
            <path d="M14 13.5L1.5 8L14 2.5L26.5 8L14 13.5Z" fill="currentColor" />
        </svg>
    );
};

export const LocalizationIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                d="M16.9429 20.9214C16.4787 21.2508 15.9883 21.4155 15.4717 21.4155C14.8802 21.4155 14.431 21.262 14.124 20.9551C13.8245 20.6481 13.6149 20.2588 13.4951 19.7871C13.3828 19.3079 13.3192 18.81 13.3042 18.2934C13.2967 17.7768 13.293 17.3089 13.293 16.8896C13.293 16.3506 13.1021 15.9088 12.7202 15.5644C12.3459 15.2125 11.8667 15.0366 11.2827 15.0366C10.3319 15.0366 9.5944 14.7783 9.07031 14.2617C8.54622 13.7451 8.28418 13.0264 8.28418 12.1055C8.28418 11.3942 8.49381 10.7428 8.91309 10.1514C9.33236 9.55988 9.89014 9.08446 10.5864 8.72508C11.2902 8.36571 12.0614 8.18602 12.8999 8.18602C13.2743 8.18602 13.6486 8.23843 14.0229 8.34325C14.4048 8.44058 14.7492 8.53791 15.0562 8.63524C15.3706 8.73257 15.6139 8.78123 15.7861 8.78123C15.9359 8.78123 16.0519 8.70262 16.1343 8.54539C16.2166 8.38068 16.2578 8.18228 16.2578 7.95018C16.2578 7.78547 16.1792 7.60204 16.022 7.39989C15.8722 7.19025 15.6813 7.01431 15.4492 6.87206C15.2171 6.72232 14.9813 6.64745 14.7417 6.64745C14.6743 6.64745 14.6219 6.66616 14.5845 6.7036C14.5545 6.73355 14.5321 6.78595 14.5171 6.86082C14.5096 7.02554 14.4572 7.16405 14.3599 7.27635C14.27 7.38117 14.1315 7.43358 13.9443 7.43358C13.6673 7.43358 13.4277 7.37368 13.2256 7.25389C13.0234 7.12661 12.8363 6.99933 12.6641 6.87206C12.4993 6.74478 12.3346 6.68114 12.1699 6.68114C12.0052 6.68114 11.8704 6.75226 11.7656 6.89452C11.6608 7.03677 11.5485 7.20148 11.4287 7.38866C11.3164 7.57583 11.1667 7.74054 10.9795 7.8828C10.7998 8.02505 10.5452 8.09618 10.2158 8.09618C9.90885 8.09618 9.66553 8.01008 9.48584 7.83788C9.30615 7.66567 9.21631 7.44107 9.21631 7.16405C9.21631 6.93944 9.2762 6.74103 9.396 6.56883C9.51579 6.39663 9.6543 6.22069 9.81152 6.041C9.97624 5.85383 10.1185 5.6367 10.2383 5.38963C10.3581 5.14256 10.418 4.8356 10.418 4.46873C10.418 4.09439 10.5677 3.72378 10.8672 3.35692C10.914 3.29845 10.9738 3.22515 11.0414 3.14307C6.26348 4.44202 2.75 8.81069 2.75 14C2.75 20.2132 7.7868 25.25 14 25.25C19.8771 25.25 24.7016 20.7434 25.2064 14.9973C24.8498 14.9552 24.2583 14.4242 24.0068 14.0146C23.7523 13.5879 23.5501 13.1387 23.4004 12.667C23.2507 12.1953 23.1196 11.7947 23.0073 11.4653C22.9025 11.1284 22.779 10.9599 22.6367 10.9599C22.5544 10.9599 22.487 10.9936 22.4346 11.061C22.3822 11.1284 22.3185 11.1958 22.2437 11.2632C22.1688 11.3231 22.0565 11.353 21.9067 11.353C21.7345 11.353 21.5361 11.2744 21.3115 11.1172C21.0944 10.9599 20.8698 10.7803 20.6377 10.5781C20.4131 10.3685 20.1997 10.185 19.9976 10.0278C19.8029 9.87059 19.6419 9.79198 19.5146 9.79198C19.3724 9.79198 19.2414 9.85936 19.1216 9.99413C19.0093 10.1289 18.9531 10.2861 18.9531 10.4658C18.9531 10.6081 19.0692 10.7615 19.3013 10.9263C19.5334 11.091 19.7992 11.2744 20.0986 11.4765C20.4056 11.6712 20.6751 11.8808 20.9072 12.1055C21.1393 12.3226 21.2554 12.5547 21.2554 12.8017C21.2554 13.1237 21.1543 13.4306 20.9521 13.7226C20.7575 14.0146 20.5591 14.2729 20.3569 14.4975C20.1623 14.7222 20.0649 14.9018 20.0649 15.0366C20.0649 15.3211 20.0837 15.6805 20.1211 16.1147C20.166 16.5415 20.0462 16.987 19.7617 17.4512C19.6494 17.6383 19.4585 17.9453 19.189 18.3721C18.9269 18.7988 18.605 19.248 18.2231 19.7197C17.8413 20.1839 17.4146 20.5845 16.9429 20.9214Z"
                fill="currentColor"
            />
            <path
                d="M17.8076 6.23192C17.9349 6.15705 18.0996 6.11961 18.3018 6.11961C18.4215 6.11961 18.5413 6.16079 18.6611 6.24315C18.7884 6.31802 18.9531 6.35545 19.1553 6.35545C19.2826 6.35545 19.3874 6.30679 19.4697 6.20946C19.5521 6.10464 19.5933 5.97736 19.5933 5.82762C19.5933 5.56558 19.4622 5.34471 19.2002 5.16502C18.9382 4.98534 18.6087 4.89549 18.2119 4.89549C17.7477 4.89549 17.3883 4.97036 17.1338 5.1201C16.8792 5.26235 16.752 5.46825 16.752 5.73778C16.752 5.91747 16.8081 6.06346 16.9204 6.17577C17.0402 6.28058 17.1862 6.33299 17.3584 6.33299C17.5381 6.33299 17.6878 6.2993 17.8076 6.23192Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.9429 20.9214C16.4787 21.2508 15.9883 21.4155 15.4717 21.4155C14.8802 21.4155 14.431 21.2621 14.124 20.9551C13.8245 20.6481 13.6149 20.2588 13.4951 19.7871C13.3828 19.308 13.3192 18.8101 13.3042 18.2935C13.2967 17.7769 13.293 17.3089 13.293 16.8897C13.293 16.3506 13.1021 15.9089 12.7202 15.5645C12.3459 15.2126 11.8667 15.0366 11.2827 15.0366C10.3319 15.0366 9.5944 14.7783 9.07031 14.2617C8.54622 13.7451 8.28418 13.0264 8.28418 12.1055C8.28418 11.3942 8.49382 10.7429 8.91309 10.1514C9.33236 9.55991 9.89014 9.08449 10.5864 8.72511C11.2902 8.36574 12.0614 8.18605 12.8999 8.18605C13.2743 8.18605 13.6486 8.23846 14.0229 8.34328C14.4048 8.44061 14.7492 8.53794 15.0562 8.63527C15.3706 8.7326 15.6139 8.78126 15.7861 8.78126C15.9359 8.78126 16.0519 8.70265 16.1343 8.54542C16.2166 8.38071 16.2578 8.1823 16.2578 7.95021C16.2578 7.7855 16.1792 7.60206 16.022 7.39992C15.8722 7.19028 15.6813 7.01434 15.4492 6.87208C15.2171 6.72234 14.9813 6.64747 14.7417 6.64747C14.6743 6.64747 14.6219 6.66619 14.5845 6.70363C14.5545 6.73357 14.5321 6.78598 14.5171 6.86085C14.5096 7.02557 14.4572 7.16408 14.3599 7.27638C14.27 7.3812 14.1315 7.43361 13.9443 7.43361C13.6673 7.43361 13.4277 7.37371 13.2256 7.25392C13.0234 7.12664 12.8363 6.99936 12.6641 6.87208C12.4993 6.7448 12.3346 6.68117 12.1699 6.68117C12.0052 6.68117 11.8704 6.75229 11.7656 6.89454C11.6608 7.0368 11.5485 7.20151 11.4287 7.38869C11.3164 7.57586 11.1667 7.74057 10.9795 7.88283C10.7998 8.02508 10.5452 8.0962 10.2158 8.0962C9.90885 8.0962 9.66553 8.0101 9.48584 7.8379C9.30615 7.6657 9.21631 7.44109 9.21631 7.16408C9.21631 6.93947 9.2762 6.74106 9.396 6.56886C9.51579 6.39666 9.6543 6.22072 9.81152 6.04103C9.97624 5.85385 10.1185 5.63673 10.2383 5.38966C10.3581 5.14259 10.418 4.83562 10.418 4.46876C10.418 4.09441 10.5677 3.72381 10.8672 3.35695C10.914 3.29848 10.9738 3.22517 11.0414 3.1431C11.9841 2.88679 12.9761 2.75 14 2.75C20.2132 2.75 25.25 7.7868 25.25 14C25.25 14.3361 25.2353 14.6687 25.2064 14.9973C24.8498 14.9552 24.2583 14.4242 24.0068 14.0147C23.7523 13.5879 23.5501 13.1387 23.4004 12.667C23.2507 12.1953 23.1196 11.7948 23.0073 11.4653C22.9025 11.1284 22.779 10.96 22.6367 10.96C22.5544 10.96 22.487 10.9937 22.4346 11.061C22.3822 11.1284 22.3185 11.1958 22.2437 11.2632C22.1688 11.3231 22.0565 11.353 21.9067 11.353C21.7345 11.353 21.5361 11.2744 21.3115 11.1172C21.0944 10.96 20.8698 10.7803 20.6377 10.5781C20.4131 10.3685 20.1997 10.1851 19.9976 10.0278C19.8029 9.87062 19.6419 9.79201 19.5146 9.79201C19.3724 9.79201 19.2414 9.85939 19.1216 9.99415C19.0093 10.1289 18.9531 10.2861 18.9531 10.4658C18.9531 10.6081 19.0692 10.7616 19.3013 10.9263C19.5334 11.091 19.7992 11.2744 20.0986 11.4766C20.4056 11.6712 20.6751 11.8809 20.9072 12.1055C21.1393 12.3226 21.2554 12.5547 21.2554 12.8018C21.2554 13.1237 21.1543 13.4307 20.9521 13.7227C20.7575 14.0147 20.5591 14.273 20.3569 14.4976C20.1623 14.7222 20.0649 14.9019 20.0649 15.0366C20.0649 15.3211 20.0837 15.6805 20.1211 16.1148C20.166 16.5415 20.0462 16.987 19.7617 17.4512C19.6494 17.6384 19.4585 17.9453 19.189 18.3721C18.9269 18.7988 18.605 19.2481 18.2231 19.7197C17.8413 20.1839 17.4146 20.5845 16.9429 20.9214ZM17.8076 6.23195C17.9349 6.15708 18.0996 6.11964 18.3018 6.11964C18.4215 6.11964 18.5413 6.16082 18.6611 6.24318C18.7884 6.31805 18.9531 6.35548 19.1553 6.35548C19.2826 6.35548 19.3874 6.30682 19.4697 6.20949C19.5521 6.10467 19.5933 5.97739 19.5933 5.82765C19.5933 5.5656 19.4622 5.34474 19.2002 5.16505C18.9382 4.98536 18.6087 4.89552 18.2119 4.89552C17.7477 4.89552 17.3883 4.97039 17.1338 5.12013C16.8792 5.26238 16.752 5.46827 16.752 5.7378C16.752 5.91749 16.8081 6.06349 16.9204 6.17579C17.0402 6.28061 17.1862 6.33302 17.3584 6.33302C17.5381 6.33302 17.6878 6.29933 17.8076 6.23195Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const ListOfTokensIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 25.2529C20.2132 25.2529 25.25 20.2161 25.25 14.0029C25.25 7.78973 20.2132 2.75293 14 2.75293C7.7868 2.75293 2.75 7.78973 2.75 14.0029C2.75 20.2161 7.7868 25.2529 14 25.2529ZM13.8816 8.37456C13.4014 8.4421 13.1088 9.14563 12.5235 10.5527C12.3528 10.9633 12.2674 11.1685 12.1063 11.3024C12.0779 11.326 12.048 11.3477 12.0168 11.3674C11.8397 11.4793 11.6181 11.497 11.1749 11.5326C9.65583 11.6543 8.89631 11.7152 8.68368 12.1511C8.64891 12.2223 8.62428 12.2981 8.61051 12.3762C8.52636 12.8538 9.10503 13.3495 10.2624 14.3409C10.6001 14.6302 10.7689 14.7748 10.8465 14.9694C10.8601 15.0037 10.8716 15.0388 10.8807 15.0746C10.9323 15.2776 10.8807 15.4938 10.7775 15.9264C10.4239 17.4087 10.2471 18.1498 10.5959 18.4867C10.653 18.5419 10.7175 18.5887 10.7875 18.6259C11.2157 18.8535 11.8659 18.4564 13.1665 17.662C13.5459 17.4302 13.7357 17.3144 13.9447 17.3007C13.9815 17.2983 14.0185 17.2983 14.0553 17.3007C14.2643 17.3144 14.454 17.4302 14.8335 17.662C16.134 18.4564 16.7843 18.8535 17.2125 18.6259C17.2825 18.5887 17.347 18.5419 17.404 18.4867C17.7528 18.1498 17.576 17.4087 17.2224 15.9264C17.1193 15.4938 17.0677 15.2776 17.1193 15.0746C17.1284 15.0388 17.1398 15.0037 17.1535 14.9694C17.231 14.7748 17.3999 14.6302 17.7376 14.3409C18.8949 13.3495 19.4736 12.8538 19.3894 12.3762C19.3757 12.2981 19.351 12.2223 19.3163 12.1511C19.1036 11.7152 18.3441 11.6543 16.8251 11.5326C16.3818 11.497 16.1602 11.4793 15.9831 11.3674C15.9519 11.3477 15.922 11.326 15.8936 11.3024C15.7326 11.1685 15.6472 10.9633 15.4764 10.5527C14.8912 9.14563 14.5986 8.4421 14.1184 8.37456C14.0398 8.36351 13.9601 8.36351 13.8816 8.37456Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                d="M12.521 10.5495C13.1063 9.1424 13.3989 8.43886 13.8791 8.37132C13.9576 8.36028 14.0373 8.36028 14.1159 8.37132C14.5961 8.43886 14.8887 9.1424 15.4739 10.5495C15.6447 10.96 15.7301 11.1653 15.8911 11.2992C15.9195 11.3228 15.9494 11.3445 15.9806 11.3642C16.1577 11.476 16.3793 11.4938 16.8226 11.5293C18.3416 11.6511 19.1011 11.712 19.3138 12.1478C19.3485 12.2191 19.3732 12.2949 19.3869 12.373C19.4711 12.8506 18.8924 13.3463 17.7351 14.3377C17.3974 14.6269 17.2285 14.7716 17.151 14.9661C17.1373 15.0004 17.1259 15.0356 17.1168 15.0714C17.0652 15.2743 17.1168 15.4906 17.2199 15.9231C17.5735 17.4054 17.7503 18.1466 17.4015 18.4835C17.3445 18.5386 17.28 18.5855 17.21 18.6227C16.7818 18.8503 16.1315 18.4531 14.831 17.6588C14.4515 17.427 14.2618 17.3111 14.0528 17.2975C14.0159 17.2951 13.979 17.2951 13.9422 17.2975C13.7332 17.3111 13.5434 17.427 13.164 17.6588C11.8634 18.4531 11.2132 18.8503 10.785 18.6227C10.715 18.5855 10.6505 18.5386 10.5934 18.4835C10.2446 18.1466 10.4214 17.4054 10.775 15.9231C10.8782 15.4906 10.9298 15.2743 10.8782 15.0714C10.8691 15.0356 10.8576 15.0004 10.844 14.9661C10.7664 14.7716 10.5976 14.6269 10.2599 14.3377C9.10253 13.3463 8.52385 12.8506 8.60801 12.373C8.62177 12.2949 8.6464 12.2191 8.68118 12.1478C8.89381 11.712 9.65333 11.6511 11.1724 11.5293C11.6156 11.4938 11.8372 11.476 12.0143 11.3642C12.0455 11.3445 12.0754 11.3228 12.1038 11.2992C12.2649 11.1653 12.3503 10.96 12.521 10.5495Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SecurityIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M17.3734 3.35929C15.7238 2.452 14.899 1.99836 14 1.99836C13.101 1.99836 12.2762 2.452 10.6266 3.35929L6.07232 5.86413C5.062 6.41981 4.55684 6.69764 4.27842 7.16853C4 7.63941 4 8.21594 4 9.36899V15.5039C4 21.0783 8.99721 24.0632 13.0827 25.2605C13.6822 25.4362 14.3178 25.4362 14.9173 25.2605C19.0028 24.0632 24 21.0783 24 15.5039V9.36899C24 8.21594 24 7.63941 23.7216 7.16853C23.4432 6.69764 22.938 6.41981 21.9277 5.86413L17.3734 3.35929ZM18.5607 13.0646C19.1464 12.4788 19.1464 11.529 18.5607 10.9432C17.9749 10.3575 17.0251 10.3575 16.4393 10.9432L12.5 14.8826L11.0607 13.4432C10.4749 12.8575 9.52513 12.8575 8.93934 13.4432C8.35355 14.029 8.35355 14.9788 8.93934 15.5646L11.4393 18.0646C12.0251 18.6504 12.9749 18.6504 13.5607 18.0646L18.5607 13.0646Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.5607 10.9432C19.1464 11.529 19.1464 12.4788 18.5607 13.0646L13.5607 18.0646C12.9749 18.6504 12.0251 18.6504 11.4393 18.0646L8.93934 15.5646C8.35355 14.9788 8.35355 14.029 8.93934 13.4432C9.52513 12.8575 10.4749 12.8575 11.0607 13.4432L12.5 14.8826L16.4393 10.9432C17.0251 10.3575 17.9749 10.3575 18.5607 10.9432Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const ThemeIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                opacity="0.32"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 22.2549C18.5563 22.2549 22.25 18.5612 22.25 14.0049C22.25 9.44853 18.5563 5.75488 14 5.75488V22.2549Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 25.2549C20.2132 25.2549 25.25 20.2181 25.25 14.0049C25.25 7.79168 20.2132 2.75488 14 2.75488C7.7868 2.75488 2.75 7.79168 2.75 14.0049C2.75 20.2181 7.7868 25.2549 14 25.2549ZM22.25 14.0049C22.25 18.5612 18.5563 22.2549 14 22.2549V5.75488C18.5563 5.75488 22.25 9.44853 22.25 14.0049Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const LogOutIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                opacity="0.32"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10 5.60459C10 5.17777 10 4.81615 10.0083 4.5061H7.2C6.0799 4.5061 5.51984 4.5061 5.09202 4.72409C4.71569 4.91584 4.40973 5.2218 4.21799 5.59812C4 6.02595 4 6.586 4 7.7061V20.3061C4 21.4262 4 21.9863 4.21799 22.4141C4.40973 22.7904 4.71569 23.0964 5.09202 23.2881C5.51984 23.5061 6.0799 23.5061 7.2 23.5061H10.0083C10 23.1961 10 22.8344 10 22.4076V5.60459ZM14.75 15.7561C15.7165 15.7561 16.5 14.9726 16.5 14.0061C16.5 13.0396 15.7165 12.2561 14.75 12.2561C13.7835 12.2561 13 13.0396 13 14.0061C13 14.9726 13.7835 15.7561 14.75 15.7561Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.2895 3.03122C10 3.50899 10 4.2075 10 5.60453V22.4076C10 23.8046 10 24.5031 10.2895 24.9809C10.5432 25.3996 10.9417 25.7107 11.4094 25.8553C11.9431 26.0203 12.6208 25.8508 13.9761 25.512L21.5761 23.612C22.4428 23.3954 22.8761 23.287 23.1988 23.0454C23.4834 22.8323 23.7061 22.5471 23.8439 22.2192C24 21.8476 24 21.4009 24 20.5076V7.50453C24 6.6112 24 6.16453 23.8439 5.79292C23.7061 5.46504 23.4834 5.17983 23.1988 4.96667C22.8761 4.72507 22.4428 4.61674 21.5761 4.40008L13.9761 2.50008C12.6208 2.16125 11.9431 1.99183 11.4094 2.15678C10.9417 2.30135 10.5432 2.61248 10.2895 3.03122ZM14.75 15.756C15.7165 15.756 16.5 14.9725 16.5 14.006C16.5 13.0395 15.7165 12.256 14.75 12.256C13.7835 12.256 13 13.0395 13 14.006C13 14.9725 13.7835 15.756 14.75 15.756Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const RateThisAppIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                d="M15.405 3.76419C14.9191 2.46467 13.0809 2.46467 12.595 3.76419L10.8915 8.31988C10.6807 8.88365 10.1533 9.26682 9.55201 9.29309L4.69288 9.50542C3.30681 9.56598 2.73879 11.3142 3.82455 12.1779L7.63086 15.2058C8.1019 15.5805 8.30334 16.2004 8.14251 16.7805L6.84289 21.4674C6.47217 22.8043 7.95925 23.8847 9.11621 23.119L13.1721 20.4347L20.3691 15.2058L24.1754 12.1779C25.2612 11.3142 24.6932 9.56598 23.3071 9.50542L18.448 9.29309C17.8467 9.26682 17.3193 8.88365 17.1085 8.31988L15.405 3.76419Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                d="M21.1107 14.6159L20.8353 14.835C20.3858 15.1925 20.1611 15.3713 20.0226 15.5982C19.9002 15.7987 19.8266 16.0252 19.8078 16.2594C19.7865 16.5244 19.8632 16.8011 20.0166 17.3545L20.514 19.148C21.0445 21.0613 21.3097 22.0179 21.0575 22.5305C20.839 22.9746 20.4155 23.2823 19.9256 23.3529C19.3602 23.4344 18.5323 22.8865 16.8767 21.7907L15.3246 20.7635C14.8457 20.4465 14.6062 20.288 14.3476 20.2264C14.1191 20.172 13.8809 20.172 13.6524 20.2264C13.3938 20.288 13.1543 20.4465 12.6754 20.7635L12.5723 20.8317L11.5 20.0068L21 14.0068L21.1107 14.6159Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const ContactSupportIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                d="M3 8.00783V16.6078C3 18.848 3 19.9681 3.43597 20.8238C3.81947 21.5764 4.43139 22.1884 5.18404 22.5719C6.03969 23.0078 7.15979 23.0078 9.4 23.0078H18.6C20.8402 23.0078 21.9603 23.0078 22.816 22.5719C23.5686 22.1884 24.1805 21.5764 24.564 20.8238C25 19.9681 25 18.848 25 16.6078V8.00781L16.5233 13.0168C15.6051 13.5593 15.1461 13.8306 14.6568 13.9367C14.224 14.0305 13.776 14.0305 13.3432 13.9367C12.8539 13.8306 12.3949 13.5593 11.4767 13.0168L3 8.00783Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                d="M3 8.00777L11.4767 2.99881C12.3949 2.45626 12.8539 2.18499 13.3432 2.07892C13.776 1.98509 14.224 1.98509 14.6568 2.07892C15.1461 2.18499 15.6051 2.45626 16.5233 2.99881L25 8.00777L16.5233 13.0167C15.6051 13.5593 15.1461 13.8306 14.6568 13.9366C14.224 14.0305 13.776 14.0305 13.3432 13.9366C12.8539 13.8306 12.3949 13.5593 11.4767 13.0167L3 8.00777Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const TelegramIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                opacity="0.32"
                d="M22 10.0088L15.0976 18.1116C13.0602 20.5034 12.0414 21.6993 10.8949 21.4765C9.74832 21.2537 9.25153 19.7634 8.25794 16.7826L7.5 14.5088L22 6.00879V10.0088Z"
                fill="currentColor"
            />
            <path
                d="M23.8107 9.42676L21.4953 19.9747C21.0468 22.0178 20.8225 23.0394 20.0576 23.3252C19.2927 23.6111 18.4535 22.987 16.7749 21.7389L11.7129 17.9748C11.2667 17.643 11.0435 17.4771 11.0306 17.2433C11.0176 17.0094 11.221 16.8199 11.6279 16.4408L15.7591 12.5912C17.9128 10.5844 18.9897 9.58093 18.7914 9.32802C18.5932 9.07511 17.3616 9.8812 14.8986 11.4934L8.79029 15.4915C8.40176 15.7458 8.2075 15.873 7.98538 15.9039C7.76326 15.9348 7.54164 15.8656 7.09842 15.7271L6.89854 15.6646C4.03251 14.769 2.59949 14.3212 2.57267 13.4313C2.54585 12.5414 3.9493 12.0081 6.75619 10.9415L19.8148 5.97919C22.1004 5.11068 23.2431 4.67642 23.9201 5.26046C24.597 5.84451 24.3349 7.0386 23.8107 9.42676Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const LegalDocumentsIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4.43597 5.19478C4 6.05043 4 7.17053 4 9.41074V18.6107C4 20.851 4 21.9711 4.43597 22.8267C4.81947 23.5794 5.43139 24.1913 6.18404 24.5748C7.03969 25.0107 8.15979 25.0107 10.4 25.0107H17.6C19.8402 25.0107 20.9603 25.0107 21.816 24.5748C22.5686 24.1913 23.1805 23.5794 23.564 22.8267C24 21.9711 24 20.851 24 18.6107V11.0107H20.8C19.1198 11.0107 18.2798 11.0107 17.638 10.6838C17.0735 10.3961 16.6146 9.9372 16.327 9.37271C16 8.73098 16 7.8909 16 6.21074V3.01074H10.4C8.15979 3.01074 7.03969 3.01074 6.18404 3.44672C5.43139 3.83021 4.81947 4.44213 4.43597 5.19478ZM7 20.5107C7 19.6823 7.67157 19.0107 8.5 19.0107H15.5C16.3284 19.0107 17 19.6823 17 20.5107C17 21.3392 16.3284 22.0107 15.5 22.0107H8.5C7.67157 22.0107 7 21.3392 7 20.5107ZM8.5 14.0107C7.67157 14.0107 7 14.6823 7 15.5107C7 16.3392 7.67157 17.0107 8.5 17.0107H11.5C12.3284 17.0107 13 16.3392 13 15.5107C13 14.6823 12.3284 14.0107 11.5 14.0107H8.5Z"
                fill="currentColor"
            />
            <g opacity="0.32">
                <path
                    d="M16 3.01074L24 11.0107H20.8C19.1198 11.0107 18.2798 11.0107 17.638 10.6838C17.0735 10.3961 16.6146 9.9372 16.327 9.37271C16 8.73098 16 7.8909 16 6.21074V3.01074Z"
                    fill="currentColor"
                />
                <path
                    d="M7 15.5107C7 14.6823 7.67157 14.0107 8.5 14.0107H11.5C12.3284 14.0107 13 14.6823 13 15.5107C13 16.3392 12.3284 17.0107 11.5 17.0107H8.5C7.67157 17.0107 7 16.3392 7 15.5107Z"
                    fill="currentColor"
                />
                <path
                    d="M7 20.5107C7 19.6823 7.67157 19.0107 8.5 19.0107H15.5C16.3284 19.0107 17 19.6823 17 20.5107C17 21.3392 16.3284 22.0107 15.5 22.0107H8.5C7.67157 22.0107 7 21.3392 7 20.5107Z"
                    fill="currentColor"
                />
            </g>
        </svg>
    );
};

export const DeleteAccountIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M2.5 6.51099C2.5 5.68256 3.17157 5.01099 4 5.01099H24C24.8284 5.01099 25.5 5.68256 25.5 6.51099C25.5 7.33941 24.8284 8.01099 24 8.01099H23L22.3544 18.9868C22.2296 21.1072 22.1673 22.1674 21.7147 22.972C21.3163 23.6802 20.7117 24.2504 19.9812 24.6065C19.1515 25.011 18.0895 25.011 15.9654 25.011H12.0346C9.91054 25.011 8.84851 25.011 8.01876 24.6065C7.28832 24.2504 6.68366 23.6802 6.28528 22.972C5.83273 22.1674 5.77037 21.1072 5.64564 18.9868L5 8.01099H4C3.17157 8.01099 2.5 7.33941 2.5 6.51099ZM10.1178 10.0136C9.29078 10.0622 8.6598 10.7721 8.70844 11.5991L9.17903 19.5991C9.22768 20.4261 9.93753 21.057 10.7645 21.0084C11.5915 20.9597 12.2225 20.2499 12.1739 19.4229L11.7033 11.4229C11.6546 10.5959 10.9448 9.96491 10.1178 10.0136ZM17.8822 10.0136C18.7092 10.0622 19.3402 10.7721 19.2915 11.5991L18.8209 19.5991C18.7723 20.4261 18.0624 21.057 17.2354 21.0084C16.4084 20.9597 15.7775 20.2499 15.8261 19.4229L16.2967 11.4229C16.3453 10.5959 17.0552 9.96491 17.8822 10.0136Z"
                fill="currentColor"
            />
            <g opacity="0.32">
                <path
                    d="M14 2.01099C12.3431 2.01099 11 3.35413 11 5.01099C11 6.66784 12.3431 8.01099 14 8.01099C15.6569 8.01099 17 6.66784 17 5.01099C17 3.35413 15.6569 2.01099 14 2.01099Z"
                    fill="currentColor"
                />
                <path
                    d="M10.1178 10.0136C9.29078 10.0623 8.6598 10.7721 8.70844 11.5991L9.17903 19.5991C9.22768 20.4261 9.93753 21.0571 10.7645 21.0084C11.5915 20.9598 12.2225 20.2499 12.1739 19.4229L11.7033 11.4229C11.6546 10.596 10.9448 9.96497 10.1178 10.0136Z"
                    fill="currentColor"
                />
                <path
                    d="M17.8822 10.0136C18.7092 10.0623 19.3402 10.7721 19.2915 11.5991L18.8209 19.5991C18.7723 20.4261 18.0624 21.0571 17.2354 21.0084C16.4084 20.9598 15.7775 20.2499 15.8261 19.4229L16.2967 11.4229C16.3453 10.596 17.0552 9.96497 17.8822 10.0136Z"
                    fill="currentColor"
                />
            </g>
        </svg>
    );
};

export const SetUpWalletIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 28"
            fill="none"
        >
            <mask id="path-1-inside-1_2111_28186" fill="white">
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M14 25.251C20.2132 25.251 25.25 20.2142 25.25 14.001C25.25 7.78777 20.2132 2.75098 14 2.75098C7.7868 2.75098 2.75 7.78777 2.75 14.001C2.75 20.2142 7.7868 25.251 14 25.251ZM15.5 9.00098C15.5 8.17255 14.8284 7.50098 14 7.50098C13.1716 7.50098 12.5 8.17255 12.5 9.00098V12.501H9C8.17157 12.501 7.5 13.1726 7.5 14.001C7.5 14.8294 8.17157 15.501 9 15.501H12.5V19.001C12.5 19.8294 13.1716 20.501 14 20.501C14.8284 20.501 15.5 19.8294 15.5 19.001V15.501H19C19.8284 15.501 20.5 14.8294 20.5 14.001C20.5 13.1726 19.8284 12.501 19 12.501H15.5V9.00098Z"
                />
            </mask>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 25.251C20.2132 25.251 25.25 20.2142 25.25 14.001C25.25 7.78777 20.2132 2.75098 14 2.75098C7.7868 2.75098 2.75 7.78777 2.75 14.001C2.75 20.2142 7.7868 25.251 14 25.251ZM15.5 9.00098C15.5 8.17255 14.8284 7.50098 14 7.50098C13.1716 7.50098 12.5 8.17255 12.5 9.00098V12.501H9C8.17157 12.501 7.5 13.1726 7.5 14.001C7.5 14.8294 8.17157 15.501 9 15.501H12.5V19.001C12.5 19.8294 13.1716 20.501 14 20.501C14.8284 20.501 15.5 19.8294 15.5 19.001V15.501H19C19.8284 15.501 20.5 14.8294 20.5 14.001C20.5 13.1726 19.8284 12.501 19 12.501H15.5V9.00098Z"
                fill="currentColor"
            />
            <path
                d="M12.5 12.501V13.501H13.5V12.501H12.5ZM12.5 15.501H13.5V14.501H12.5V15.501ZM15.5 15.501V14.501H14.5V15.501H15.5ZM15.5 12.501H14.5V13.501H15.5V12.501ZM24.25 14.001C24.25 19.6619 19.6609 24.251 14 24.251V26.251C20.7655 26.251 26.25 20.7665 26.25 14.001H24.25ZM14 3.75098C19.6609 3.75098 24.25 8.34006 24.25 14.001H26.25C26.25 7.23549 20.7655 1.75098 14 1.75098V3.75098ZM3.75 14.001C3.75 8.34006 8.33908 3.75098 14 3.75098V1.75098C7.23451 1.75098 1.75 7.23549 1.75 14.001H3.75ZM14 24.251C8.33908 24.251 3.75 19.6619 3.75 14.001H1.75C1.75 20.7665 7.23451 26.251 14 26.251V24.251ZM14 8.50098C14.2761 8.50098 14.5 8.72483 14.5 9.00098H16.5C16.5 7.62026 15.3807 6.50098 14 6.50098V8.50098ZM13.5 9.00098C13.5 8.72483 13.7239 8.50098 14 8.50098V6.50098C12.6193 6.50098 11.5 7.62026 11.5 9.00098H13.5ZM13.5 12.501V9.00098H11.5V12.501H13.5ZM9 13.501H12.5V11.501H9V13.501ZM8.5 14.001C8.5 13.7248 8.72386 13.501 9 13.501V11.501C7.61929 11.501 6.5 12.6203 6.5 14.001H8.5ZM9 14.501C8.72386 14.501 8.5 14.2771 8.5 14.001H6.5C6.5 15.3817 7.61929 16.501 9 16.501V14.501ZM12.5 14.501H9V16.501H12.5V14.501ZM13.5 19.001V15.501H11.5V19.001H13.5ZM14 19.501C13.7239 19.501 13.5 19.2771 13.5 19.001H11.5C11.5 20.3817 12.6193 21.501 14 21.501V19.501ZM14.5 19.001C14.5 19.2771 14.2761 19.501 14 19.501V21.501C15.3807 21.501 16.5 20.3817 16.5 19.001H14.5ZM14.5 15.501V19.001H16.5V15.501H14.5ZM19 14.501H15.5V16.501H19V14.501ZM19.5 14.001C19.5 14.2771 19.2761 14.501 19 14.501V16.501C20.3807 16.501 21.5 15.3817 21.5 14.001H19.5ZM19 13.501C19.2761 13.501 19.5 13.7248 19.5 14.001H21.5C21.5 12.6203 20.3807 11.501 19 11.501V13.501ZM15.5 13.501H19V11.501H15.5V13.501ZM14.5 9.00098V12.501H16.5V9.00098H14.5Z"
                fill="currentColor"
                mask="url(#path-1-inside-1_2111_28186)"
            />
            <path
                opacity="0.32"
                d="M14 14.001H19M14 14.001H9M14 14.001V9.00098M14 14.001V19.001"
                stroke="currentColor"
                strokeWidth="3"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
        </svg>
    );
};

export const LockIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 28"
            fill="none"
        >
            <g opacity="0.32">
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M18 8V10H21V8C21 4.13401 17.866 1 14 1C10.134 1 7 4.13401 7 8V10H10V8C10 5.79086 11.7909 4 14 4C16.2091 4 18 5.79086 18 8Z"
                    fill="currentColor"
                />
                <path
                    d="M14 14C13.1716 14 12.5 14.6716 12.5 15.5V17.5C12.5 18.3284 13.1716 19 14 19C14.8284 19 15.5 18.3284 15.5 17.5V15.5C15.5 14.6716 14.8284 14 14 14Z"
                    fill="currentColor"
                />
            </g>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M3 16.4C3 14.1598 3 13.0397 3.43597 12.184C3.81947 11.4314 4.43139 10.8195 5.18404 10.436C6.03969 10 7.15979 10 9.4 10H18.6C20.8402 10 21.9603 10 22.816 10.436C23.5686 10.8195 24.1805 11.4314 24.564 12.184C25 13.0397 25 14.1598 25 16.4V18.6C25 20.8402 25 21.9603 24.564 22.816C24.1805 23.5686 23.5686 24.1805 22.816 24.564C21.9603 25 20.8402 25 18.6 25H9.4C7.15979 25 6.03969 25 5.18404 24.564C4.43139 24.1805 3.81947 23.5686 3.43597 22.816C3 21.9603 3 20.8402 3 18.6V16.4ZM14 14C13.1716 14 12.5 14.6716 12.5 15.5V17.5C12.5 18.3284 13.1716 19 14 19C14.8284 19 15.5 18.3284 15.5 17.5V15.5C15.5 14.6716 14.8284 14 14 14Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const KeyIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="1.75rem"
            height="1.75rem"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                opacity="0.32"
                d="M12.5 10.001C12.5 11.3817 11.3807 12.501 10 12.501C8.61929 12.501 7.5 11.3817 7.5 10.001C7.5 8.62026 8.61929 7.50098 10 7.50098C11.3807 7.50098 12.5 8.62026 12.5 10.001Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M19 11.001C19 12.0397 18.802 13.0322 18.4418 13.9428L24.0627 19.5637C24.4086 19.9096 24.5816 20.0826 24.7053 20.2844C24.8149 20.4634 24.8957 20.6584 24.9447 20.8625C25 21.0927 25 21.3373 25 21.8265V25.001H20.5V23.501H19V22.001H17.5V20.501H16L13.9418 18.4428C13.0312 18.803 12.0387 19.001 11 19.001C6.58172 19.001 3 15.4193 3 11.001C3 6.5827 6.58172 3.00098 11 3.00098C15.4183 3.00098 19 6.5827 19 11.001ZM10 12.501C11.3807 12.501 12.5 11.3817 12.5 10.001C12.5 8.62026 11.3807 7.50098 10 7.50098C8.61929 7.50098 7.5 8.62026 7.5 10.001C7.5 11.3817 8.61929 12.501 10 12.501Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const AppsIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
        >
            <rect
                opacity="0.32"
                x="13.6367"
                y="8.00598"
                width="9"
                height="9"
                rx="2.75"
                transform="rotate(-45 13.6367 8.00598)"
                fill="currentColor"
            />
            <path
                d="M3.5 7.90598C3.5 6.36584 3.5 5.59576 3.79973 5.00751C4.06338 4.49006 4.48408 4.06937 5.00153 3.80571C5.58978 3.50598 6.35986 3.50598 7.9 3.50598H8.1C9.64014 3.50598 10.4102 3.50598 10.9985 3.80571C11.5159 4.06937 11.9366 4.49006 12.2003 5.00751C12.5 5.59576 12.5 6.36584 12.5 7.90598V8.10598C12.5 9.64613 12.5 10.4162 12.2003 11.0045C11.9366 11.5219 11.5159 11.9426 10.9985 12.2062C10.4102 12.506 9.64014 12.506 8.1 12.506H7.9C6.35986 12.506 5.58978 12.506 5.00153 12.2062C4.48408 11.9426 4.06338 11.5219 3.79973 11.0045C3.5 10.4162 3.5 9.64613 3.5 8.10598V7.90598Z"
                fill="currentColor"
            />
            <path
                d="M3.5 19.906C3.5 18.3658 3.5 17.5958 3.79973 17.0075C4.06338 16.4901 4.48408 16.0694 5.00153 15.8057C5.58978 15.506 6.35986 15.506 7.9 15.506H8.1C9.64014 15.506 10.4102 15.506 10.9985 15.8057C11.5159 16.0694 11.9366 16.4901 12.2003 17.0075C12.5 17.5958 12.5 18.3658 12.5 19.906V20.106C12.5 21.6461 12.5 22.4162 12.2003 23.0045C11.9366 23.5219 11.5159 23.9426 10.9985 24.2062C10.4102 24.506 9.64014 24.506 8.1 24.506H7.9C6.35986 24.506 5.58978 24.506 5.00153 24.2062C4.48408 23.9426 4.06338 23.5219 3.79973 23.0045C3.5 22.4162 3.5 21.6461 3.5 20.106V19.906Z"
                fill="currentColor"
            />
            <path
                d="M15.7997 17.0075C15.5 17.5958 15.5 18.3658 15.5 19.906V20.106C15.5 21.6461 15.5 22.4162 15.7997 23.0045C16.0634 23.5219 16.4841 23.9426 17.0015 24.2062C17.5898 24.506 18.3599 24.506 19.9 24.506H20.1C21.6401 24.506 22.4102 24.506 22.9985 24.2062C23.5159 23.9426 23.9366 23.5219 24.2003 23.0045C24.5 22.4162 24.5 21.6461 24.5 20.106V19.906C24.5 18.3658 24.5 17.5958 24.2003 17.0075C23.9366 16.4901 23.5159 16.0694 22.9985 15.8057C22.4102 15.506 21.6401 15.506 20.1 15.506H19.9C18.3599 15.506 17.5898 15.506 17.0015 15.8057C16.4841 16.0694 16.0634 16.4901 15.7997 17.0075Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SaleBadgeIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.6515 4H16C18.8003 4 20.2004 4 21.27 4.54497C22.2108 5.02433 22.9757 5.78924 23.4551 6.73005C24 7.79961 24 9.19974 24 12V12.3496C24 13.3277 24 13.8168 23.8895 14.2771C23.7916 14.6852 23.63 15.0753 23.4108 15.4331C23.1635 15.8367 22.8177 16.1826 22.1262 16.8744L17.0287 21.9733C15.4446 23.5578 14.6526 24.35 13.7392 24.6469C12.9358 24.908 12.0704 24.9081 11.2669 24.647C10.3535 24.3503 9.56136 23.5582 7.9771 21.9739L6.02807 20.0249C4.44419 18.441 3.65226 17.6491 3.35549 16.7358C3.09445 15.9325 3.09439 15.0672 3.35532 14.2639C3.65196 13.3507 4.44378 12.5586 6.02743 10.9745L11.1254 5.87514C11.8172 5.18312 12.1632 4.83709 12.5669 4.58964C12.9248 4.37025 13.3151 4.20858 13.7233 4.11056C14.1837 4 14.673 4 15.6515 4ZM19.25 10.5C20.2165 10.5 21 9.7165 21 8.75C21 7.7835 20.2165 7 19.25 7C18.2835 7 17.5 7.7835 17.5 8.75C17.5 9.7165 18.2835 10.5 19.25 10.5Z"
                fill="currentColor"
            />
            <circle opacity="0.32" cx="19.25" cy="8.75" r="1.75" fill="currentColor" />
        </svg>
    );
};

export const BatteryIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 0C12.2271 0 10.7621 1.31816 10.5316 3.02788C8.64901 3.09052 7.47077 3.294 6.56107 3.95493C6.1366 4.26333 5.76331 4.63662 5.45492 5.06109C4.5 6.37542 4.5 8.25028 4.5 12V18C4.5 21.7497 4.5 23.6246 5.45492 24.9389C5.76331 25.3634 6.1366 25.7367 6.56107 26.0451C7.8754 27 9.75027 27 13.5 27H14.5C18.2497 27 20.1246 27 21.4389 26.0451C21.8634 25.7367 22.2367 25.3634 22.5451 24.9389C23.5 23.6246 23.5 21.7497 23.5 18V12C23.5 8.25029 23.5 6.37542 22.5451 5.06109C22.2367 4.63662 21.8634 4.26333 21.4389 3.95493C20.5292 3.294 19.351 3.09052 17.4684 3.02788C17.2379 1.31816 15.7729 0 14 0ZM7.71799 17.092C7.5 17.5198 7.5 18.0799 7.5 19.2L7.5 20.8C7.5 21.9201 7.5 22.4802 7.71799 22.908C7.90973 23.2843 8.21569 23.5903 8.59202 23.782C9.01984 24 9.5799 24 10.7 24H17.3C18.4201 24 18.9802 24 19.408 23.782C19.7843 23.5903 20.0903 23.2843 20.282 22.908C20.5 22.4802 20.5 21.9201 20.5 20.8V19.2C20.5 18.0799 20.5 17.5198 20.282 17.092C20.0903 16.7157 19.7843 16.4097 19.408 16.218C18.9802 16 18.4201 16 17.3 16H10.7C9.5799 16 9.01984 16 8.59202 16.218C8.21569 16.4097 7.90973 16.7157 7.71799 17.092Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                d="M7.5 19.2C7.5 18.0799 7.5 17.5198 7.71799 17.092C7.90973 16.7157 8.21569 16.4097 8.59202 16.218C9.01984 16 9.5799 16 10.7 16H17.3C18.4201 16 18.9802 16 19.408 16.218C19.7843 16.4097 20.0903 16.7157 20.282 17.092C20.5 17.5198 20.5 18.0799 20.5 19.2V20.8C20.5 21.9201 20.5 22.4802 20.282 22.908C20.0903 23.2843 19.7843 23.5903 19.408 23.782C18.9802 24 18.4201 24 17.3 24H10.7C9.5799 24 9.01984 24 8.59202 23.782C8.21569 23.5903 7.90973 23.2843 7.71799 22.908C7.5 22.4802 7.5 21.9201 7.5 20.8V19.2Z"
                fill="currentColor"
            />
        </svg>
    );
};
