import { FC } from 'react';
import { useTheme } from 'styled-components';

export const LedgerOpenTonIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="368"
            height="59"
            viewBox="0 0 368 59"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                opacity="0.64"
                d="M118 9.4C118 7.15979 118 6.03968 118.436 5.18404C118.819 4.43139 119.431 3.81947 120.184 3.43597C121.04 3 122.16 3 124.4 3H286C301.464 3 314 15.536 314 31C314 46.464 301.464 59 286 59H124.4C122.16 59 121.04 59 120.184 58.564C119.431 58.1805 118.819 57.5686 118.436 56.816C118 55.9603 118 54.8402 118 52.6V9.4Z"
                fill={theme.iconTertiary}
            />
            <path
                d="M368 59L287 59C271.536 59 259 46.464 259 31C259 15.536 271.536 3 287 3L368 3.00001L368 59Z"
                fill={theme.iconTertiary}
            />
            <circle cx="287" cy="31" r="14" fill={theme.backgroundContent} />
            <path
                opacity="0.32"
                d="M138.163 0.819014C138 1.13988 138 1.55992 138 2.4V3H156V2.4C156 1.55992 156 1.13988 155.837 0.819014C155.693 0.536771 155.463 0.3073 155.181 0.16349C154.86 0 154.44 0 153.6 0H140.4C139.56 0 139.14 0 138.819 0.16349C138.537 0.3073 138.307 0.536771 138.163 0.819014Z"
                fill={theme.iconTertiary}
            />
            <path
                opacity="0.32"
                d="M212.163 0.819014C212 1.13988 212 1.55992 212 2.4V3H230V2.4C230 1.55992 230 1.13988 229.837 0.819014C229.693 0.536771 229.463 0.3073 229.181 0.16349C228.86 0 228.44 0 227.6 0H214.4C213.56 0 213.14 0 212.819 0.16349C212.537 0.3073 212.307 0.536771 212.163 0.819014Z"
                fill={theme.iconTertiary}
            />
            <path
                d="M138 19.2C138 18.0799 138 17.5198 138.218 17.092C138.41 16.7157 138.716 16.4097 139.092 16.218C139.52 16 140.08 16 141.2 16H226.8C227.92 16 228.48 16 228.908 16.218C229.284 16.4097 229.59 16.7157 229.782 17.092C230 17.5198 230 18.0799 230 19.2V42.8C230 43.9201 230 44.4802 229.782 44.908C229.59 45.2843 229.284 45.5903 228.908 45.782C228.48 46 227.92 46 226.8 46H141.2C140.08 46 139.52 46 139.092 45.782C138.716 45.5903 138.41 45.2843 138.218 44.908C138 44.4802 138 43.9201 138 42.8V19.2Z"
                fill={theme.backgroundContent}
            />
            <path
                d="M154.938 35H153.719V27.6289H151.205V26.5449H157.451V27.6289H154.938V35ZM164.887 31.4434C164.887 33.7871 163.697 35.1758 161.746 35.1758C159.795 35.1758 158.605 33.7871 158.605 31.4434V30.1016C158.605 27.7578 159.795 26.3691 161.746 26.3691C163.697 26.3691 164.887 27.7578 164.887 30.1016V31.4434ZM161.746 34.0625C162.953 34.0625 163.656 33.1367 163.656 31.4375V30.1074C163.656 28.4082 162.953 27.4824 161.746 27.4824C160.539 27.4824 159.836 28.4082 159.836 30.1074V31.4375C159.836 33.1367 160.539 34.0625 161.746 34.0625ZM167.389 35H166.305V26.5449H167.441L170.852 32.8672H170.939V26.5449H172.023V35H170.898L167.477 28.6602H167.389V35ZM183.789 32.1523V34.0977H185.729V35H181.381V34.0977H182.646V29.5156H181.258V28.6133H183.783V30.2422H183.947C184.199 29.041 184.943 28.4492 186.168 28.4492C186.531 28.4492 186.877 28.4961 187.088 28.584V29.873C186.801 29.7676 186.385 29.6914 186.033 29.6914C184.592 29.6914 183.789 30.5879 183.789 32.1523ZM193.041 33.3125H194.166C193.996 34.3848 192.941 35.123 191.564 35.123C189.771 35.123 188.746 34.0684 188.746 32.252V31.2793C188.746 29.5977 189.842 28.4902 191.5 28.4902C193.17 28.4902 194.184 29.5918 194.184 31.4082V32.0996H189.9V32.3867C189.9 33.4648 190.551 34.1562 191.559 34.1562C192.314 34.1562 192.883 33.834 193.041 33.3125ZM191.488 29.4512C190.498 29.4512 189.9 30.1309 189.9 31.2734H193.029C193.029 30.1367 192.455 29.4512 191.488 29.4512ZM198.127 35.1055C196.908 35.1055 196.1 34.3379 196.1 33.1836C196.1 32.0469 196.92 31.3789 198.408 31.291L200.084 31.2031V30.6406C200.084 29.9082 199.627 29.498 198.807 29.498C198.127 29.498 197.641 29.791 197.488 30.2949H196.34C196.457 29.2402 197.459 28.5254 198.83 28.5254C200.371 28.5254 201.25 29.2988 201.25 30.6406V35.0059H200.131V34.0742H200.02C199.715 34.7305 199.029 35.1055 198.127 35.1055ZM198.49 34.127C199.404 34.127 200.084 33.5234 200.084 32.709V32.0352L198.566 32.1113C197.717 32.1582 197.271 32.5098 197.271 33.1309C197.271 33.7461 197.74 34.127 198.49 34.127ZM205.762 35.1055C204.291 35.1055 203.354 34.0566 203.354 32.3867V31.2266C203.354 29.5566 204.291 28.5078 205.762 28.5078C206.682 28.5078 207.355 28.9121 207.613 29.627H207.725V26.123H208.932V35H207.754V33.9922H207.643C207.338 34.7129 206.682 35.1055 205.762 35.1055ZM206.148 34.0625C207.133 34.0625 207.754 33.3711 207.754 32.2754V31.3203C207.754 30.2188 207.133 29.5273 206.148 29.5273C205.164 29.5273 204.543 30.2246 204.543 31.3203V32.2754C204.543 33.3711 205.164 34.0625 206.148 34.0625ZM211.85 37.2852C211.668 37.2852 211.445 37.2734 211.369 37.2676V36.2773C211.434 36.2891 211.627 36.2949 211.721 36.2949C212.336 36.2949 212.67 36.0371 212.904 35.3633L213.004 35.0469L210.678 28.6133H211.967L213.648 33.8398H213.73L215.4 28.6133H216.648L214.305 35.1934C213.748 36.7812 213.15 37.2852 211.85 37.2852Z"
                fill={theme.iconSecondary}
            />
            <path
                opacity="0.2"
                d="M82 25.4C82 23.1598 82 22.0397 82.436 21.184C82.8195 20.4314 83.4314 19.8195 84.184 19.436C85.0397 19 86.1598 19 88.4 19H118V43H88.4C86.1598 43 85.0397 43 84.184 42.564C83.4314 42.1805 82.8195 41.5686 82.436 40.816C82 39.9603 82 38.8402 82 36.6V25.4Z"
                fill={theme.iconSecondary}
            />
            <path
                opacity="0.16"
                d="M75 27.2C75 26.0799 75 25.5198 75.218 25.092C75.4097 24.7157 75.7157 24.4097 76.092 24.218C76.5198 24 77.0799 24 78.2 24H82V38H78.2C77.0799 38 76.5198 38 76.092 37.782C75.7157 37.5903 75.4097 37.2843 75.218 36.908C75 36.4802 75 35.9201 75 34.8V27.2Z"
                fill={theme.iconSecondary}
            />
            <path opacity="0.12" d="M0 27H75V35H0V27Z" fill={theme.iconSecondary} />
            <path
                opacity="0.44"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M287 45C294.732 45 301 38.732 301 31C301 23.268 294.732 17 287 17C279.268 17 273 23.268 273 31C273 38.732 279.268 45 287 45ZM287 47C295.837 47 303 39.8366 303 31C303 22.1634 295.837 15 287 15C278.163 15 271 22.1634 271 31C271 39.8366 278.163 47 287 47Z"
                fill={theme.iconSecondary}
            />
        </svg>
    );
};

export const LedgerConnectDeviceIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="368"
            height="59"
            viewBox="0 0 368 59"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                opacity="0.64"
                d="M118 9.4C118 7.15979 118 6.03968 118.436 5.18404C118.819 4.43139 119.431 3.81947 120.184 3.43597C121.04 3 122.16 3 124.4 3H286C301.464 3 314 15.536 314 31C314 46.464 301.464 59 286 59H124.4C122.16 59 121.04 59 120.184 58.564C119.431 58.1805 118.819 57.5686 118.436 56.816C118 55.9603 118 54.8402 118 52.6V9.4Z"
                fill={theme.iconTertiary}
            />
            <path
                d="M368 59L287 59C271.536 59 259 46.464 259 31C259 15.536 271.536 3 287 3L368 3.00001L368 59Z"
                fill={theme.iconTertiary}
            />
            <circle cx="287" cy="31" r="14" fill={theme.backgroundContent} />
            <path
                opacity="0.32"
                d="M138.163 0.819014C138 1.13988 138 1.55992 138 2.4V3H156V2.4C156 1.55992 156 1.13988 155.837 0.819014C155.693 0.536771 155.463 0.3073 155.181 0.16349C154.86 0 154.44 0 153.6 0H140.4C139.56 0 139.14 0 138.819 0.16349C138.537 0.3073 138.307 0.536771 138.163 0.819014Z"
                fill={theme.iconTertiary}
            />
            <path
                opacity="0.32"
                d="M212.163 0.819014C212 1.13988 212 1.55992 212 2.4V3H230V2.4C230 1.55992 230 1.13988 229.837 0.819014C229.693 0.536771 229.463 0.3073 229.181 0.16349C228.86 0 228.44 0 227.6 0H214.4C213.56 0 213.14 0 212.819 0.16349C212.537 0.3073 212.307 0.536771 212.163 0.819014Z"
                fill={theme.iconTertiary}
            />
            <path
                opacity="0.44"
                d="M138 19.2C138 18.0799 138 17.5198 138.218 17.092C138.41 16.7157 138.716 16.4097 139.092 16.218C139.52 16 140.08 16 141.2 16H226.8C227.92 16 228.48 16 228.908 16.218C229.284 16.4097 229.59 16.7157 229.782 17.092C230 17.5198 230 18.0799 230 19.2V42.8C230 43.9201 230 44.4802 229.782 44.908C229.59 45.2843 229.284 45.5903 228.908 45.782C228.48 46 227.92 46 226.8 46H141.2C140.08 46 139.52 46 139.092 45.782C138.716 45.5903 138.41 45.2843 138.218 44.908C138 44.4802 138 43.9201 138 42.8V19.2Z"
                fill={theme.backgroundContent}
            />
            <path
                opacity="0.2"
                d="M29 25.4C29 23.1598 29 22.0397 29.436 21.184C29.8195 20.4314 30.4314 19.8195 31.184 19.436C32.0397 19 33.1598 19 35.4 19H65V43H35.4C33.1598 43 32.0397 43 31.184 42.564C30.4314 42.1805 29.8195 41.5686 29.436 40.816C29 39.9603 29 38.8402 29 36.6V25.4Z"
                fill={theme.iconSecondary}
            />
            <path
                opacity="0.16"
                d="M22 27.2C22 26.0799 22 25.5198 22.218 25.092C22.4097 24.7157 22.7157 24.4097 23.092 24.218C23.5198 24 24.0799 24 25.2 24H29V38H25.2C24.0799 38 23.5198 38 23.092 37.782C22.7157 37.5903 22.4097 37.2843 22.218 36.908C22 36.4802 22 35.9201 22 34.8V27.2Z"
                fill={theme.iconSecondary}
            />
            <path opacity="0.12" d="M0 27H22V35H0V27Z" fill={theme.iconSecondary} />
            <path
                opacity="0.12"
                d="M65 21H74.8C75.9201 21 76.4802 21 76.908 21.218C77.2843 21.4097 77.5903 21.7157 77.782 22.092C78 22.5198 78 23.0799 78 24.2V37.8C78 38.9201 78 39.4802 77.782 39.908C77.5903 40.2843 77.2843 40.5903 76.908 40.782C76.4802 41 75.9201 41 74.8 41H65V21Z"
                fill={theme.iconSecondary}
            />
            <path
                d="M92.75 30.25C92.3358 30.25 92 30.5858 92 31C92 31.4142 92.3358 31.75 92.75 31.75H101.439L98.7197 34.4697C98.4268 34.7626 98.4268 35.2374 98.7197 35.5303C99.0126 35.8232 99.4874 35.8232 99.7803 35.5303L103.78 31.5303C104.073 31.2374 104.073 30.7626 103.78 30.4697L99.7803 26.4697C99.4874 26.1768 99.0126 26.1768 98.7197 26.4697C98.4268 26.7626 98.4268 27.2374 98.7197 27.5303L101.439 30.25H92.75Z"
                fill={theme.iconSecondary}
            />
            <path
                opacity="0.44"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M287 45C294.732 45 301 38.732 301 31C301 23.268 294.732 17 287 17C279.268 17 273 23.268 273 31C273 38.732 279.268 45 287 45ZM287 47C295.837 47 303 39.8366 303 31C303 22.1634 295.837 15 287 15C278.163 15 271 22.1634 271 31C271 39.8366 278.163 47 287 47Z"
                fill={theme.iconSecondary}
            />
        </svg>
    );
};

export const LedgerConfirmTxIcon = () => {
    const theme = useTheme();
    return (
        <svg
            width="368"
            height="59"
            viewBox="0 0 368 59"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
        >
            <path
                opacity="0.64"
                d="M118 9.4C118 7.15979 118 6.03968 118.436 5.18404C118.819 4.43139 119.431 3.81947 120.184 3.43597C121.04 3 122.16 3 124.4 3H286C301.464 3 314 15.536 314 31C314 46.464 301.464 59 286 59H124.4C122.16 59 121.04 59 120.184 58.564C119.431 58.1805 118.819 57.5686 118.436 56.816C118 55.9603 118 54.8402 118 52.6V9.4Z"
                fill={theme.iconTertiary}
            />
            <path
                d="M368 59L287 59C271.536 59 259 46.464 259 31C259 15.536 271.536 3 287 3L368 3.00001L368 59Z"
                fill={theme.iconTertiary}
            />
            <circle cx="287" cy="31" r="14" fill={theme.backgroundContent} />
            <path
                opacity="0.32"
                d="M138.163 0.819014C138 1.13988 138 1.55992 138 2.4V3H156V2.4C156 1.55992 156 1.13988 155.837 0.819014C155.693 0.536771 155.463 0.3073 155.181 0.16349C154.86 0 154.44 0 153.6 0H140.4C139.56 0 139.14 0 138.819 0.16349C138.537 0.3073 138.307 0.536771 138.163 0.819014Z"
                fill={theme.iconTertiary}
            />
            <path
                opacity="0.32"
                d="M212.163 0.819014C212 1.13988 212 1.55992 212 2.4V3H230V2.4C230 1.55992 230 1.13988 229.837 0.819014C229.693 0.536771 229.463 0.3073 229.181 0.16349C228.86 0 228.44 0 227.6 0H214.4C213.56 0 213.14 0 212.819 0.16349C212.537 0.3073 212.307 0.536771 212.163 0.819014Z"
                fill={theme.iconTertiary}
            />
            <path
                d="M138 19.2C138 18.0799 138 17.5198 138.218 17.092C138.41 16.7157 138.716 16.4097 139.092 16.218C139.52 16 140.08 16 141.2 16H226.8C227.92 16 228.48 16 228.908 16.218C229.284 16.4097 229.59 16.7157 229.782 17.092C230 17.5198 230 18.0799 230 19.2V42.8C230 43.9201 230 44.4802 229.782 44.908C229.59 45.2843 229.284 45.5903 228.908 45.782C228.48 46 227.92 46 226.8 46H141.2C140.08 46 139.52 46 139.092 45.782C138.716 45.5903 138.41 45.2843 138.218 44.908C138 44.4802 138 43.9201 138 42.8V19.2Z"
                fill={theme.backgroundContent}
            />
            <path
                d="M165.684 31.7012H163.955V35H162.742V26.5449H165.648C167.377 26.5449 168.443 27.5293 168.443 29.1289C168.443 30.2305 167.84 31.1445 166.891 31.4727L168.602 35H167.23L165.684 31.7012ZM163.955 27.582V30.7168H165.479C166.586 30.7168 167.213 30.1484 167.213 29.1523C167.213 28.1562 166.592 27.582 165.52 27.582H163.955ZM174.496 33.3125H175.621C175.451 34.3848 174.396 35.123 173.02 35.123C171.227 35.123 170.201 34.0684 170.201 32.252V31.2793C170.201 29.5977 171.297 28.4902 172.955 28.4902C174.625 28.4902 175.639 29.5918 175.639 31.4082V32.0996H171.355V32.3867C171.355 33.4648 172.006 34.1562 173.014 34.1562C173.77 34.1562 174.338 33.834 174.496 33.3125ZM172.943 29.4512C171.953 29.4512 171.355 30.1309 171.355 31.2734H174.484C174.484 30.1367 173.91 29.4512 172.943 29.4512ZM177.332 28.6133H178.592L180.262 33.7988H180.344L182.002 28.6133H183.25L180.947 35H179.641L177.332 28.6133ZM187.814 27.1191C187.293 27.1191 186.906 26.7559 186.906 26.252C186.906 25.7422 187.293 25.3789 187.814 25.3789C188.342 25.3789 188.723 25.7422 188.723 26.252C188.723 26.7559 188.342 27.1191 187.814 27.1191ZM190.51 35H185.148V34.0508H187.299V29.5625H185.195V28.6133H188.447V34.0508H190.51V35ZM196.75 33.3125H197.875C197.705 34.3848 196.65 35.123 195.273 35.123C193.48 35.123 192.455 34.0684 192.455 32.252V31.2793C192.455 29.5977 193.551 28.4902 195.209 28.4902C196.879 28.4902 197.893 29.5918 197.893 31.4082V32.0996H193.609V32.3867C193.609 33.4648 194.26 34.1562 195.268 34.1562C196.023 34.1562 196.592 33.834 196.75 33.3125ZM195.197 29.4512C194.207 29.4512 193.609 30.1309 193.609 31.2734H196.738C196.738 30.1367 196.164 29.4512 195.197 29.4512ZM206.025 28.6133L204.678 35H203.594L202.58 30.2129H202.516L201.496 35H200.412L199.064 28.6133H200.201L200.957 33.5645H201.092L202.023 28.625H203.066L203.998 33.5645H204.133L204.889 28.6133H206.025Z"
                fill={theme.iconSecondary}
            />
            <path
                d="M165.684 31.7012H163.955V35H162.742V26.5449H165.648C167.377 26.5449 168.443 27.5293 168.443 29.1289C168.443 30.2305 167.84 31.1445 166.891 31.4727L168.602 35H167.23L165.684 31.7012ZM163.955 27.582V30.7168H165.479C166.586 30.7168 167.213 30.1484 167.213 29.1523C167.213 28.1562 166.592 27.582 165.52 27.582H163.955Z"
                fill={theme.iconSecondary}
            />
            <path
                d="M174.496 33.3125H175.621C175.451 34.3848 174.396 35.123 173.02 35.123C171.227 35.123 170.201 34.0684 170.201 32.252V31.2793C170.201 29.5977 171.297 28.4902 172.955 28.4902C174.625 28.4902 175.639 29.5918 175.639 31.4082V32.0996H171.355V32.3867C171.355 33.4648 172.006 34.1562 173.014 34.1562C173.77 34.1562 174.338 33.834 174.496 33.3125ZM172.943 29.4512C171.953 29.4512 171.355 30.1309 171.355 31.2734H174.484C174.484 30.1367 173.91 29.4512 172.943 29.4512Z"
                fill={theme.iconSecondary}
            />
            <path
                d="M177.332 28.6133H178.592L180.262 33.7988H180.344L182.002 28.6133H183.25L180.947 35H179.641L177.332 28.6133Z"
                fill={theme.iconSecondary}
            />
            <path
                d="M187.814 27.1191C187.293 27.1191 186.906 26.7559 186.906 26.252C186.906 25.7422 187.293 25.3789 187.814 25.3789C188.342 25.3789 188.723 25.7422 188.723 26.252C188.723 26.7559 188.342 27.1191 187.814 27.1191ZM190.51 35H185.148V34.0508H187.299V29.5625H185.195V28.6133H188.447V34.0508H190.51V35Z"
                fill={theme.iconSecondary}
            />
            <path
                d="M196.75 33.3125H197.875C197.705 34.3848 196.65 35.123 195.273 35.123C193.48 35.123 192.455 34.0684 192.455 32.252V31.2793C192.455 29.5977 193.551 28.4902 195.209 28.4902C196.879 28.4902 197.893 29.5918 197.893 31.4082V32.0996H193.609V32.3867C193.609 33.4648 194.26 34.1562 195.268 34.1562C196.023 34.1562 196.592 33.834 196.75 33.3125ZM195.197 29.4512C194.207 29.4512 193.609 30.1309 193.609 31.2734H196.738C196.738 30.1367 196.164 29.4512 195.197 29.4512Z"
                fill={theme.iconSecondary}
            />
            <path
                d="M206.025 28.6133L204.678 35H203.594L202.58 30.2129H202.516L201.496 35H200.412L199.064 28.6133H200.201L200.957 33.5645H201.092L202.023 28.625H203.066L203.998 33.5645H204.133L204.889 28.6133H206.025Z"
                fill={theme.iconSecondary}
            />
            <path
                opacity="0.2"
                d="M82 25.4C82 23.1598 82 22.0397 82.436 21.184C82.8195 20.4314 83.4314 19.8195 84.184 19.436C85.0397 19 86.1598 19 88.4 19H118V43H88.4C86.1598 43 85.0397 43 84.184 42.564C83.4314 42.1805 82.8195 41.5686 82.436 40.816C82 39.9603 82 38.8402 82 36.6V25.4Z"
                fill={theme.iconSecondary}
            />
            <path
                opacity="0.16"
                d="M75 27.2C75 26.0799 75 25.5198 75.218 25.092C75.4097 24.7157 75.7157 24.4097 76.092 24.218C76.5198 24 77.0799 24 78.2 24H82V38H78.2C77.0799 38 76.5198 38 76.092 37.782C75.7157 37.5903 75.4097 37.2843 75.218 36.908C75 36.4802 75 35.9201 75 34.8V27.2Z"
                fill={theme.iconSecondary}
            />
            <path opacity="0.12" d="M0 27H75V35H0V27Z" fill={theme.iconSecondary} />
            <path
                opacity="0.44"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M287 45C294.732 45 301 38.732 301 31C301 23.268 294.732 17 287 17C279.268 17 273 23.268 273 31C273 38.732 279.268 45 287 45ZM287 47C295.837 47 303 39.8366 303 31C303 22.1634 295.837 15 287 15C278.163 15 271 22.1634 271 31C271 39.8366 278.163 47 287 47Z"
                fill={theme.iconSecondary}
            />
        </svg>
    );
};

export const LedgerIcon: FC<{ step: 'connect' | 'open-ton' | 'confirm-tx' }> = ({ step }) => {
    if (step === 'connect') {
        return <LedgerConnectDeviceIcon />;
    }

    if (step === 'open-ton') {
        return <LedgerOpenTonIcon />;
    }

    return <LedgerConfirmTxIcon />;
};
