import { FC } from 'react';

export const WalletPlusIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
            className={className}
        >
            <mask id="path-1-inside-1_44183_44828" fill="white">
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M14 4C14.5523 4 15 4.44772 15 5V13H23C23.5523 13 24 13.4477 24 14C24 14.5523 23.5523 15 23 15H15V23C15 23.5523 14.5523 24 14 24C13.4477 24 13 23.5523 13 23V15H5C4.44772 15 4 14.5523 4 14C4 13.4477 4.44772 13 5 13H13V5C13 4.44772 13.4477 4 14 4Z"
                />
            </mask>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 4C14.5523 4 15 4.44772 15 5V13H23C23.5523 13 24 13.4477 24 14C24 14.5523 23.5523 15 23 15H15V23C15 23.5523 14.5523 24 14 24C13.4477 24 13 23.5523 13 23V15H5C4.44772 15 4 14.5523 4 14C4 13.4477 4.44772 13 5 13H13V5C13 4.44772 13.4477 4 14 4Z"
                fill="white"
            />
            <path
                d="M15 13H14V14H15V13ZM15 15V14H14V15H15ZM13 15H14V14H13V15ZM13 13V14H14V13H13ZM16 5C16 3.89543 15.1046 3 14 3V5H16ZM16 13V5H14V13H16ZM23 12H15V14H23V12ZM25 14C25 12.8954 24.1046 12 23 12V14H25ZM23 16C24.1046 16 25 15.1046 25 14H23V16ZM15 16H23V14H15V16ZM16 23V15H14V23H16ZM14 25C15.1046 25 16 24.1046 16 23H14V25ZM12 23C12 24.1046 12.8954 25 14 25V23H12ZM12 15V23H14V15H12ZM5 16H13V14H5V16ZM3 14C3 15.1046 3.89543 16 5 16V14H3ZM5 12C3.89543 12 3 12.8954 3 14H5V12ZM13 12H5V14H13V12ZM12 5V13H14V5H12ZM14 3C12.8954 3 12 3.89543 12 5H14V3Z"
                fill="currentColor"
                mask="url(#path-1-inside-1_44183_44828)"
            />
        </svg>
    );
};

export const WalletImportIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
            className={className}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M3 11C3 8.19974 3 6.79961 3.54497 5.73005C4.02434 4.78924 4.78924 4.02433 5.73005 3.54497C6.79961 3 8.19974 3 11 3H17C19.8003 3 21.2004 3 22.27 3.54497C23.2108 4.02433 23.9757 4.78924 24.455 5.73005C25 6.79961 25 8.19974 25 11V17C25 19.8003 25 21.2004 24.455 22.27C23.9757 23.2108 23.2108 23.9757 22.27 24.455C21.2004 25 19.8003 25 17 25H11C8.19974 25 6.79961 25 5.73005 24.455C4.78924 23.9757 4.02434 23.2108 3.54497 22.27C3 21.2004 3 19.8003 3 17V14V11ZM5 15L15.5858 15L12.2929 18.2929C11.9024 18.6834 11.9024 19.3166 12.2929 19.7071C12.6834 20.0976 13.3166 20.0976 13.7071 19.7071L18.7071 14.7071C19.0976 14.3166 19.0976 13.6834 18.7071 13.2929L13.7071 8.29289C13.3166 7.90237 12.6834 7.90237 12.2929 8.29289C11.9024 8.68342 11.9024 9.31658 12.2929 9.70711L15.5858 13L5 13V9.8C5 8.11984 5 7.27976 5.32698 6.63803C5.6146 6.07354 6.07354 5.6146 6.63803 5.32698C7.27977 5 8.11984 5 9.8 5H18.2C19.8802 5 20.7202 5 21.362 5.32698C21.9265 5.6146 22.3854 6.07354 22.673 6.63803C23 7.27976 23 8.11984 23 9.8V18.2C23 19.8802 23 20.7202 22.673 21.362C22.3854 21.9265 21.9265 22.3854 21.362 22.673C20.7202 23 19.8802 23 18.2 23H9.8C8.11984 23 7.27977 23 6.63803 22.673C6.07354 22.3854 5.6146 21.9265 5.32698 21.362C5 20.7202 5 19.8802 5 18.2V15Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const WalletMagnifyingGlassIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
            className={className}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M20 12.5C20 16.6421 16.6421 20 12.5 20C8.35786 20 5 16.6421 5 12.5C5 8.35786 8.35786 5 12.5 5C16.6421 5 20 8.35786 20 12.5ZM18.4733 19.8875C16.8415 21.2086 14.7631 22 12.5 22C7.25329 22 3 17.7467 3 12.5C3 7.25329 7.25329 3 12.5 3C17.7467 3 22 7.25329 22 12.5C22 14.7631 21.2086 16.8415 19.8875 18.4733L24.7071 23.2929C25.0976 23.6834 25.0976 24.3166 24.7071 24.7071C24.3166 25.0976 23.6834 25.0976 23.2929 24.7071L18.4733 19.8875Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const WalletPencilIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
            strokeWidth="0.1"
            className={className}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.1493 5.8386L5.80287 16.185C5.18176 16.8061 4.8712 17.1167 4.64061 17.4734C4.37775 17.8801 4.19092 18.3312 4.08922 18.8046C4 19.2199 4 19.6591 4 20.5375C4 21.668 4 22.2332 4.1985 22.6739C4.42409 23.1748 4.82511 23.5758 5.32596 23.8014C5.76666 23.9999 6.3319 23.9999 7.46239 23.9999C8.34076 23.9999 8.77995 23.9999 9.19527 23.9107C9.66872 23.809 10.1198 23.6222 10.5265 23.3593C10.8832 23.1287 11.1938 22.8181 11.8149 22.197L22.1613 11.8506C23.1512 10.8607 23.6461 10.3658 23.8551 9.8048C24.0859 9.18547 24.0859 8.50375 23.8551 7.88442C23.6461 7.3234 23.1512 6.82847 22.1613 5.8386C21.1714 4.84874 20.6765 4.35379 20.1155 4.14476C19.4962 3.91399 18.8144 3.91399 18.1951 4.14476C17.6341 4.35379 17.1392 4.84873 16.1493 5.8386ZM5.99489 20.2407C6.00138 19.5968 6.00462 19.2748 6.10302 18.9781C6.13557 18.8799 6.17569 18.7844 6.22302 18.6925C6.36606 18.4145 6.59373 18.1868 7.04906 17.7315L15.7744 9.00569L18.9671 12.1985L10.2232 20.9587C9.78926 21.3935 9.57227 21.6109 9.30838 21.7515C9.22102 21.798 9.13033 21.838 9.03706 21.8711C8.75528 21.9711 8.44843 21.9848 7.83473 22.012L6.92561 22.0523C6.53209 22.0697 6.33533 22.0784 6.19681 21.9825C6.15218 21.9516 6.11288 21.9136 6.08046 21.8701C5.97984 21.7349 5.98182 21.538 5.98579 21.1441L5.99489 20.2407ZM20.38 10.7829L21.4017 9.75929C21.7989 9.36144 21.9974 9.16251 22.0354 8.92191C22.0476 8.8442 22.0476 8.76505 22.0352 8.68735C21.997 8.44679 21.7982 8.24811 21.4006 7.85074L20.1189 6.56972C19.7211 6.1722 19.5223 5.97343 19.2816 5.93536C19.2039 5.92307 19.1247 5.92308 19.047 5.9354C18.8064 5.97354 18.6075 6.17236 18.2099 6.57L17.1885 7.59144L20.38 10.7829Z"
                fill="currentColor"
            />
            <path
                d="M15 22.9999C15 22.4476 15.4477 21.9999 16 21.9999H23C23.5523 21.9999 24 22.4476 24 22.9999C24 23.5522 23.5523 23.9999 23 23.9999H16C15.4477 23.9999 15 23.5522 15 22.9999Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M16.1493 5.8386L5.80287 16.185C5.18176 16.8061 4.8712 17.1167 4.64061 17.4734C4.37775 17.8801 4.19092 18.3312 4.08922 18.8046C4 19.2199 4 19.6591 4 20.5375C4 21.668 4 22.2332 4.1985 22.6739C4.42409 23.1748 4.82511 23.5758 5.32596 23.8014C5.76666 23.9999 6.3319 23.9999 7.46239 23.9999C8.34076 23.9999 8.77995 23.9999 9.19527 23.9107C9.66872 23.809 10.1198 23.6222 10.5265 23.3593C10.8832 23.1287 11.1938 22.8181 11.8149 22.197L22.1613 11.8506C23.1512 10.8607 23.6461 10.3658 23.8551 9.8048C24.0859 9.18547 24.0859 8.50375 23.8551 7.88442C23.6461 7.3234 23.1512 6.82847 22.1613 5.8386C21.1714 4.84874 20.6765 4.35379 20.1155 4.14476C19.4962 3.91399 18.8144 3.91399 18.1951 4.14476C17.6341 4.35379 17.1392 4.84873 16.1493 5.8386ZM5.99489 20.2407C6.00138 19.5968 6.00462 19.2748 6.10302 18.9781C6.13557 18.8799 6.17569 18.7844 6.22302 18.6925C6.36606 18.4145 6.59373 18.1868 7.04906 17.7315L15.7744 9.00569L18.9671 12.1985L10.2232 20.9587C9.78926 21.3935 9.57227 21.6109 9.30838 21.7515C9.22102 21.798 9.13033 21.838 9.03706 21.8711C8.75528 21.9711 8.44843 21.9848 7.83473 22.012L6.92561 22.0523C6.53209 22.0697 6.33533 22.0784 6.19681 21.9825C6.15218 21.9516 6.11288 21.9136 6.08046 21.8701C5.97984 21.7349 5.98182 21.538 5.98579 21.1441L5.99489 20.2407ZM20.38 10.7829L21.4017 9.75929C21.7989 9.36144 21.9974 9.16251 22.0354 8.92191C22.0476 8.8442 22.0476 8.76505 22.0352 8.68735C21.997 8.44679 21.7982 8.24811 21.4006 7.85074L20.1189 6.56972C19.7211 6.1722 19.5223 5.97343 19.2816 5.93536C19.2039 5.92307 19.1247 5.92308 19.047 5.9354C18.8064 5.97354 18.6075 6.17236 18.2099 6.57L17.1885 7.59144L20.38 10.7829Z"
                stroke="currentColor"
            />
            <path
                d="M15 22.9999C15 22.4476 15.4477 21.9999 16 21.9999H23C23.5523 21.9999 24 22.4476 24 22.9999C24 23.5522 23.5523 23.9999 23 23.9999H16C15.4477 23.9999 15 23.5522 15 22.9999Z"
                stroke="currentColor"
            />
        </svg>
    );
};

export const WalletTestnetIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <svg
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            className={className}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 3.5C13.1716 3.5 12.5 4.17157 12.5 5C12.5 5.82843 13.1716 6.5 14 6.5C14.8284 6.5 15.5 5.82843 15.5 5C15.5 4.17157 14.8284 3.5 14 3.5ZM7.63812 6.32697C8.25979 6.01021 9.0676 6.00031 10.6449 6C11.0752 7.44574 12.4145 8.5 14 8.5C15.5855 8.5 16.9248 7.44574 17.3551 6C18.9325 6.00031 19.7404 6.0102 20.3621 6.32697C20.9265 6.61459 21.3855 7.07353 21.6731 7.63802C21.9899 8.2597 21.9998 9.06752 22.0001 10.6449C20.5543 11.0752 19.5 12.4145 19.5 14C19.5 15.5855 20.5543 16.9248 22.0001 17.3551C21.9998 18.9325 21.9899 19.7403 21.6731 20.362C21.3855 20.9264 20.9265 21.3854 20.3621 21.673C19.7404 21.9898 18.9325 21.9997 17.3551 22C16.9248 20.5542 15.5855 19.5 14 19.5C12.4145 19.5 11.0752 20.5542 10.6449 22C9.0676 21.9997 8.25979 21.9898 7.63812 21.673C7.07363 21.3854 6.61469 20.9264 6.32707 20.362C6.01031 19.7403 6.00041 18.9324 6.0001 17.355C7.44579 16.9247 8.5 15.5855 8.5 14C8.5 12.4145 7.44579 11.0753 6.0001 10.645C6.00041 9.06754 6.01031 8.25971 6.32707 7.63802C6.61469 7.07353 7.07363 6.61459 7.63812 6.32697ZM10.6441 23.997C8.71654 23.9831 7.61118 23.9039 6.73014 23.455C5.78933 22.9757 5.02443 22.2108 4.54506 21.2699C4.09614 20.3889 4.01702 19.2835 4.00307 17.356C2.55575 16.9267 1.5 15.5866 1.5 14C1.5 12.4134 2.55575 11.0733 4.00307 10.644C4.01702 8.71647 4.09614 7.61109 4.54506 6.73004C5.02443 5.78923 5.78933 5.02432 6.73014 4.54496C7.61119 4.09604 8.71654 4.01692 10.6441 4.00297C11.0734 2.5557 12.4134 1.5 14 1.5C15.5866 1.5 16.9266 2.5557 17.3559 4.00297C19.2836 4.01692 20.389 4.09603 21.27 4.54496C22.2109 5.02432 22.9758 5.78923 23.4551 6.73004C23.904 7.6111 23.9832 8.71649 23.9971 10.6441C25.4443 11.0734 26.5 12.4134 26.5 14C26.5 15.5866 25.4443 16.9266 23.9971 17.3559C23.9832 19.2835 23.904 20.3889 23.4551 21.2699C22.9758 22.2108 22.2109 22.9757 21.27 23.455C20.389 23.904 19.2836 23.9831 17.3559 23.997C16.9266 25.4443 15.5866 26.5 14 26.5C12.4134 26.5 11.0734 25.4443 10.6441 23.997ZM23 12.5C22.1716 12.5 21.5 13.1716 21.5 14C21.5 14.8284 22.1716 15.5 23 15.5C23.8284 15.5 24.5 14.8284 24.5 14C24.5 13.1716 23.8284 12.5 23 12.5ZM3.5 14C3.5 13.1716 4.17157 12.5 5 12.5C5.82843 12.5 6.5 13.1716 6.5 14C6.5 14.8284 5.82843 15.5 5 15.5C4.17157 15.5 3.5 14.8284 3.5 14ZM12.5 23C12.5 22.1716 13.1716 21.5 14 21.5C14.8284 21.5 15.5 22.1716 15.5 23C15.5 23.8284 14.8284 24.5 14 24.5C13.1716 24.5 12.5 23.8284 12.5 23Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const WalletSignerIcon: FC<{ className?: string; size?: number }> = ({
    className,
    size = 28
}) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width={size}
            height={size}
            viewBox="0 0 28 28"
            fill="none"
            className={className}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M2 22.0836C2.00192 22.1679 2.01463 22.2533 2.03907 22.3382C2.19193 22.8689 2.74608 23.1752 3.27679 23.0223C5.92646 22.2591 8.13577 21.0793 9.9304 19.6599C11.2697 20.6408 12.9152 21.3506 14.8821 21.6659C16.1461 21.8685 17.297 21.9021 18.3317 21.7992C19.4309 23.878 21.4878 25.7058 24.7519 26.5419C25.2869 26.6789 25.8317 26.3563 25.9687 25.8212C25.9882 25.7454 25.9983 25.6693 26 25.5943V25.5505C25.9904 25.1134 25.6925 24.7182 25.2481 24.6044C22.8506 23.9903 21.3056 22.7697 20.3979 21.3727C22.2868 20.7534 23.6119 19.5958 24.343 18.2395C24.9794 17.0591 25.1518 15.7263 24.7717 14.5795C24.3785 13.3932 23.4112 12.4857 21.9995 12.2639C20.427 12.0168 19.1557 12.8269 18.3733 14.0037C17.6045 15.1599 17.2438 16.7297 17.3502 18.3409C17.3831 18.839 17.4608 19.3451 17.5866 19.8499C16.8729 19.8784 16.0787 19.8321 15.1986 19.6911C13.716 19.4534 12.4818 18.9585 11.4654 18.2914C13.5028 16.2448 14.8306 13.8753 15.5081 11.5908C16.1777 9.33274 16.2287 7.09667 15.6308 5.31882C15.0238 3.51353 13.7046 2.11435 11.7017 1.87762C9.93948 1.66934 8.46485 2.36103 7.39978 3.55043C6.35967 4.71196 5.71493 6.33176 5.45073 8.06831C4.94815 11.3718 5.77672 15.4306 8.41562 18.3029C6.86859 19.4717 4.98026 20.4504 2.72321 21.1005C2.29259 21.2245 2.00972 21.6127 2 22.0383V22.0836ZM9.93147 16.9962C11.8013 15.1587 12.9944 13.0329 13.5906 11.0222C14.1756 9.04971 14.1697 7.24843 13.7352 5.9563C13.3099 4.69161 12.5192 3.98818 11.4669 3.8638C10.4288 3.7411 9.57503 4.11932 8.88972 4.88463C8.17945 5.67781 7.65188 6.89751 7.42798 8.36913C6.99585 11.2095 7.74208 14.646 9.93147 16.9962ZM19.5717 19.5374C21.1505 19.0703 22.1123 18.1627 22.5826 17.2904C23.0036 16.5093 23.0518 15.7474 22.8733 15.2088C22.7079 14.7098 22.3372 14.3415 21.6891 14.2396C21.0775 14.1435 20.5058 14.4086 20.0387 15.1111C19.558 15.8341 19.2626 16.9475 19.3459 18.2091C19.3745 18.6432 19.4478 19.0901 19.5717 19.5374Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const WalletLedgerIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
            className={className}
        >
            <mask id="path-1-inside-1_44183_36206" fill="white">
                <path
                    fillRule="evenodd"
                    clipRule="evenodd"
                    d="M4 3H2V5V9.5H4V5H10.5V3H4ZM24 3H26V5V9.5H24V5H17.5V3H24ZM26 25H24H17.5V23H24V18.5H26V23V25ZM4 25H2V23V18.5H4V23H10.5V25H4ZM11 9.5H13V16.5H17.5V18.5H13H11V16.5V9.5Z"
                />
            </mask>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M4 3H2V5V9.5H4V5H10.5V3H4ZM24 3H26V5V9.5H24V5H17.5V3H24ZM26 25H24H17.5V23H24V18.5H26V23V25ZM4 25H2V23V18.5H4V23H10.5V25H4ZM11 9.5H13V16.5H17.5V18.5H13H11V16.5V9.5Z"
                fill="white"
            />
            <path
                d="M2 3V2H1V3H2ZM2 9.5H1V10.5H2V9.5ZM4 9.5V10.5H5V9.5H4ZM4 5V4H3V5H4ZM10.5 5V6H11.5V5H10.5ZM10.5 3H11.5V2H10.5V3ZM26 3H27V2H26V3ZM26 9.5V10.5H27V9.5H26ZM24 9.5H23V10.5H24V9.5ZM24 5H25V4H24V5ZM17.5 5H16.5V6H17.5V5ZM17.5 3V2H16.5V3H17.5ZM26 25V26H27V25H26ZM17.5 25H16.5V26H17.5V25ZM17.5 23V22H16.5V23H17.5ZM24 23V24H25V23H24ZM24 18.5V17.5H23V18.5H24ZM26 18.5H27V17.5H26V18.5ZM2 25H1V26H2V25ZM2 18.5V17.5H1V18.5H2ZM4 18.5H5V17.5H4V18.5ZM4 23H3V24H4V23ZM10.5 23H11.5V22H10.5V23ZM10.5 25V26H11.5V25H10.5ZM13 9.5H14V8.5H13V9.5ZM11 9.5V8.5H10V9.5H11ZM13 16.5H12V17.5H13V16.5ZM17.5 16.5H18.5V15.5H17.5V16.5ZM17.5 18.5V19.5H18.5V18.5H17.5ZM11 18.5H10V19.5H11V18.5ZM2 4H4V2H2V4ZM3 5V3H1V5H3ZM3 9.5V5H1V9.5H3ZM4 8.5H2V10.5H4V8.5ZM3 5V9.5H5V5H3ZM10.5 4H4V6H10.5V4ZM9.5 3V5H11.5V3H9.5ZM4 4H10.5V2H4V4ZM26 2H24V4H26V2ZM27 5V3H25V5H27ZM27 9.5V5H25V9.5H27ZM24 10.5H26V8.5H24V10.5ZM23 5V9.5H25V5H23ZM17.5 6H24V4H17.5V6ZM16.5 3V5H18.5V3H16.5ZM24 2H17.5V4H24V2ZM24 26H26V24H24V26ZM17.5 26H24V24H17.5V26ZM16.5 23V25H18.5V23H16.5ZM24 22H17.5V24H24V22ZM23 18.5V23H25V18.5H23ZM26 17.5H24V19.5H26V17.5ZM27 23V18.5H25V23H27ZM27 25V23H25V25H27ZM2 26H4V24H2V26ZM1 23V25H3V23H1ZM1 18.5V23H3V18.5H1ZM4 17.5H2V19.5H4V17.5ZM5 23V18.5H3V23H5ZM10.5 22H4V24H10.5V22ZM11.5 25V23H9.5V25H11.5ZM4 26H10.5V24H4V26ZM13 8.5H11V10.5H13V8.5ZM14 16.5V9.5H12V16.5H14ZM17.5 15.5H13V17.5H17.5V15.5ZM18.5 18.5V16.5H16.5V18.5H18.5ZM13 19.5H17.5V17.5H13V19.5ZM11 19.5H13V17.5H11V19.5ZM10 16.5V18.5H12V16.5H10ZM10 9.5V16.5H12V9.5H10Z"
                fill="currentColor"
                mask="url(#path-1-inside-1_44183_36206)"
            />
        </svg>
    );
};

export const WalletKeystoneIcon: FC<{ className?: string; size?: number }> = ({
    className,
    size = 28
}) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width={size}
            height={size}
            viewBox="0 0 28 28"
            fill="none"
            className={className}
        >
            <path opacity="0.32" d="M8 20H2L4 3H16L8 20Z" fill="currentColor" />
            <path d="M24 25H12L20 8H26L24 25Z" fill="currentColor" />
        </svg>
    );
};
