import { ActionStatusEnum } from '@tonkeeper/core/dist/tonApiV2';
import React, { FC, PropsWithChildren } from 'react';
import styled from 'styled-components';

const ActivityIconWrapper = styled.span`
    display: flex;
    width: 44px;
    height: 44px;

    border-radius: ${props => props.theme.cornerFull};
    color: ${props => props.theme.iconSecondary};
    background: ${props => props.theme.backgroundContentTint};

    display: flex;
    justify-content: center;
    align-items: center;
`;

export const ActivityIcon: FC<PropsWithChildren<{ status?: ActionStatusEnum }>> = ({
    status,
    children
}) => {
    return (
        <ActivityIconWrapper>{status === 'failed' ? <FailedIcon /> : children}</ActivityIconWrapper>
    );
};

const FailedIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 25.25C20.2132 25.25 25.25 20.2132 25.25 14C25.25 7.7868 20.2132 2.75 14 2.75C7.7868 2.75 2.75 7.7868 2.75 14C2.75 20.2132 7.7868 25.25 14 25.25ZM12.3528 8.74698C12.297 7.79921 13.0506 7 14 7C14.9494 7 15.703 7.79921 15.6472 8.74698L15.3234 14.2522C15.2822 14.9529 14.7019 15.5 14 15.5C13.2981 15.5 12.7178 14.9529 12.6766 14.2522L12.3528 8.74698ZM15.75 19.25C15.75 20.2165 14.9665 21 14 21C13.0335 21 12.25 20.2165 12.25 19.25C12.25 18.2835 13.0335 17.5 14 17.5C14.9665 17.5 15.75 18.2835 15.75 19.25Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 7C13.0506 7 12.297 7.79921 12.3528 8.74698L12.6766 14.2522C12.7178 14.9529 13.2981 15.5 14 15.5C14.7019 15.5 15.2822 14.9529 15.3234 14.2522L15.6472 8.74698C15.703 7.79921 14.9494 7 14 7ZM14 21C14.9665 21 15.75 20.2165 15.75 19.25C15.75 18.2835 14.9665 17.5 14 17.5C13.0335 17.5 12.25 18.2835 12.25 19.25C12.25 20.2165 13.0335 21 14 21Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SentIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                opacity="0.32"
                d="M8.06272 16.9373C8.40862 16.5914 8.58157 16.4184 8.78341 16.2947C8.96235 16.1851 9.15744 16.1043 9.36151 16.0553C9.59169 16 9.83628 16 10.3255 16H17.6745C18.1637 16 18.4083 16 18.6384 16.0553C18.8425 16.1043 19.0376 16.1851 19.2165 16.2947C19.4184 16.4184 19.5913 16.5914 19.9372 16.9373L24.2686 21.2686C25.1254 22.1254 25.5537 22.5538 25.5827 22.9215C25.6078 23.2407 25.4786 23.5525 25.2352 23.7604C24.9547 24 24.3489 24 23.1372 24H4.86272C3.65109 24 3.04527 24 2.76474 23.7604C2.52133 23.5525 2.39216 23.2407 2.41727 22.9215C2.44622 22.5538 2.87459 22.1254 3.73135 21.2686L8.06272 16.9373Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.0607 2.93934C14.4749 2.35355 13.5251 2.35355 12.9393 2.93934L7.43934 8.43934C6.85355 9.02513 6.85355 9.97487 7.43934 10.5607C8.02513 11.1464 8.97487 11.1464 9.56066 10.5607L12.5 7.62132V19C12.5 19.8284 13.1716 20.5 14 20.5C14.8284 20.5 15.5 19.8284 15.5 19V7.62132L18.4393 10.5607C19.0251 11.1464 19.9749 11.1464 20.5607 10.5607C21.1464 9.97487 21.1464 9.02513 20.5607 8.43934L15.0607 2.93934Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const ReceiveIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="28"
            viewBox="0 0 28 28"
            fill="none"
        >
            <path
                opacity="0.32"
                d="M8.06272 16.9373C8.40862 16.5914 8.58157 16.4184 8.78341 16.2947C8.96235 16.1851 9.15744 16.1043 9.36151 16.0553C9.59169 16 9.83628 16 10.3255 16H17.6745C18.1637 16 18.4083 16 18.6384 16.0553C18.8425 16.1043 19.0376 16.1851 19.2165 16.2947C19.4184 16.4184 19.5913 16.5914 19.9372 16.9373L24.2686 21.2686C25.1254 22.1254 25.5537 22.5538 25.5827 22.9215C25.6078 23.2407 25.4786 23.5525 25.2352 23.7604C24.9547 24 24.3489 24 23.1372 24H4.86272C3.65109 24 3.04527 24 2.76474 23.7604C2.52133 23.5525 2.39216 23.2407 2.41727 22.9215C2.44622 22.5538 2.87459 22.1254 3.73135 21.2686L8.06272 16.9373Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.0607 20.0607C14.4749 20.6464 13.5251 20.6464 12.9393 20.0607L7.43934 14.5607C6.85355 13.9749 6.85355 13.0251 7.43934 12.4393C8.02513 11.8536 8.97487 11.8536 9.56066 12.4393L12.5 15.3787V4C12.5 3.17157 13.1716 2.5 14 2.5C14.8284 2.5 15.5 3.17157 15.5 4V15.3787L18.4393 12.4393C19.0251 11.8536 19.9749 11.8536 20.5607 12.4393C21.1464 13.0251 21.1464 13.9749 20.5607 14.5607L15.0607 20.0607Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const ContractDeployIcon: FC<{ className?: string }> = ({ className }) => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="29"
            viewBox="0 0 28 29"
            fill="none"
            className={className}
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.6886 3.5094L16.3141 3.5094C17.6812 3.5066 18.3647 3.50519 18.9765 3.70342C19.5178 3.8788 20.016 4.16642 20.4385 4.54749C20.916 4.97819 21.2566 5.57087 21.9377 6.75623L24.2505 10.762C24.9364 11.9445 25.2794 12.5358 25.4136 13.1647C25.5324 13.7212 25.5324 14.2964 25.4136 14.8529C25.2794 15.4818 24.9364 16.073 24.2505 17.2555L21.9377 21.2614C21.2566 22.4467 20.916 23.0394 20.4385 23.4701C20.016 23.8512 19.5178 24.1388 18.9765 24.3142C18.3647 24.5124 17.6812 24.511 16.3141 24.5082H11.6886C10.3215 24.511 9.63798 24.5124 9.0262 24.3142C8.48492 24.1388 7.98674 23.8512 7.56422 23.4701C7.08667 23.0394 6.7461 22.4467 6.06497 21.2614L3.75226 17.2556C3.06628 16.0731 2.72329 15.4818 2.58907 14.8529C2.47031 14.2964 2.47031 13.7212 2.58907 13.1647C2.72329 12.5358 3.06628 11.9445 3.75226 10.762L6.06497 6.75623C6.7461 5.57087 7.08667 4.97819 7.56422 4.54749C7.98674 4.16642 8.48492 3.8788 9.0262 3.70342C9.63798 3.50519 10.3215 3.5066 11.6886 3.5094ZM14 18.0088C16.2091 18.0088 18 16.2179 18 14.0088C18 11.7997 16.2091 10.0088 14 10.0088C11.7909 10.0088 9.99999 11.7997 9.99999 14.0088C9.99999 16.2179 11.7909 18.0088 14 18.0088Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                d="M18 14.0088C18 16.2179 16.2091 18.0088 14 18.0088C11.7909 18.0088 10 16.2179 10 14.0088C10 11.7996 11.7909 10.0088 14 10.0088C16.2091 10.0088 18 11.7996 18 14.0088Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SubscribeIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="29"
            viewBox="0 0 28 29"
            fill="none"
        >
            <g opacity="0.32">
                <path
                    d="M14 1.00586C13.1716 1.00586 12.5 1.67743 12.5 2.50586V4.50586C12.5 5.33429 13.1716 6.00586 14 6.00586C14.8284 6.00586 15.5 5.33429 15.5 4.50586V2.50586C15.5 1.67743 14.8284 1.00586 14 1.00586Z"
                    fill="currentColor"
                />
                <path
                    d="M14 25.0059C16.2091 25.0059 18 23.215 18 21.0059C18 18.7967 16.2091 17.0059 14 17.0059C11.7909 17.0059 10 18.7967 10 21.0059C10 23.215 11.7909 25.0059 14 25.0059Z"
                    fill="currentColor"
                />
            </g>
            <path
                d="M21.9999 11.0183V15.5059L23.7454 18.4981C24.5232 19.8314 23.5615 21.5059 22.0179 21.5059H5.98202C4.43844 21.5059 3.47669 19.8314 4.25446 18.4981L5.99993 15.5059V11.0059C5.99993 6.58758 9.58167 3.00586 13.9999 3.00586C18.4182 3.00586 21.9999 6.58758 21.9999 11.0059C21.9999 11.01 21.9999 11.0142 21.9999 11.0183Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const UnsubscribeIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="29"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                opacity="0.32"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14 16.1282L19.9393 22.0675C20.5251 22.6533 21.4749 22.6533 22.0607 22.0675C22.6464 21.4817 22.6464 20.532 22.0607 19.9462L16.1213 14.0068L14 16.1282Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M5.93934 5.94618C6.52513 5.36039 7.47487 5.36039 8.06066 5.94618L14 11.8855L19.9393 5.94618C20.5251 5.36039 21.4749 5.36039 22.0607 5.94618C22.6464 6.53196 22.6464 7.48171 22.0607 8.0675L8.06066 22.0675C7.47487 22.6533 6.52513 22.6533 5.93934 22.0675C5.35355 21.4817 5.35355 20.532 5.93934 19.9462L11.8787 14.0068L5.93934 8.0675C5.35355 7.48171 5.35355 6.53196 5.93934 5.94618Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const CreateWalletIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="29"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                d="M23.0607 9.56847C23.6464 8.98269 23.6464 8.03294 23.0607 7.44715C22.4749 6.86137 21.5251 6.86137 20.9393 7.44715L10.5 17.8865L7.06066 14.4472C6.47487 13.8614 5.52513 13.8614 4.93934 14.4472C4.35355 15.0329 4.35355 15.9827 4.93934 16.5685L9.43934 21.0685C10.0251 21.6543 10.9749 21.6543 11.5607 21.0685L23.0607 9.56847Z"
                fill="currentColor"
            />
        </svg>
    );
};

export const SwapIcon = () => {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            width="28"
            height="29"
            viewBox="0 0 28 29"
            fill="none"
        >
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M21.5607 22.5773C20.9749 23.163 20.0251 23.163 19.4393 22.5773L14.9393 18.0773C14.3536 17.4915 14.3536 16.5417 14.9393 15.9559C15.5251 15.3702 16.4749 15.3702 17.0607 15.9559L19 17.8953V8.5166C19 7.68817 19.6716 7.0166 20.5 7.0166C21.3284 7.0166 22 7.68817 22 8.5166V17.8953L23.9393 15.9559C24.5251 15.3702 25.4749 15.3702 26.0607 15.9559C26.6464 16.5417 26.6464 17.4915 26.0607 18.0773L21.5607 22.5773Z"
                fill="currentColor"
            />
            <path
                opacity="0.32"
                fillRule="evenodd"
                clipRule="evenodd"
                d="M8.56066 5.45594C7.97487 4.87015 7.02513 4.87015 6.43934 5.45594L1.93934 9.95594C1.35355 10.5417 1.35355 11.4915 1.93934 12.0773C2.52513 12.663 3.47487 12.663 4.06066 12.0773L6 10.1379L6 19.5166C6 20.345 6.67157 21.0166 7.5 21.0166C8.32843 21.0166 9 20.345 9 19.5166V10.1379L10.9393 12.0773C11.5251 12.663 12.4749 12.663 13.0607 12.0773C13.6464 11.4915 13.6464 10.5417 13.0607 9.95594L8.56066 5.45594Z"
                fill="currentColor"
            />
        </svg>
    );
};
