/* tslint:disable */
/* eslint-disable */
/**
 * gasless TRON service REST api
 * Service to publish TRON transactions
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  EstimatePayload,
  GetEstimationRequest,
  GetSettings401Response,
  PublishPayload,
  PublishTransactionRequest,
  TronBalances,
  TronEvent,
  TronEvents,
  TronSettings,
  TronWallet,
} from '../models/index';
import {
    EstimatePayloadFromJSON,
    EstimatePayloadToJSON,
    GetEstimationRequestFromJSON,
    GetEstimationRequestToJSON,
    GetSettings401ResponseFromJSON,
    GetSettings401ResponseToJSON,
    PublishPayloadFromJSON,
    PublishPayloadToJSON,
    PublishTransactionRequestFromJSON,
    PublishTransactionRequestToJSON,
    TronBalancesFromJSON,
    TronBalancesToJSON,
    TronEventFromJSON,
    TronEventToJSON,
    TronEventsFromJSON,
    TronEventsToJSON,
    TronSettingsFromJSON,
    TronSettingsToJSON,
    TronWalletFromJSON,
    TronWalletToJSON,
} from '../models/index';

export interface GetEstimationOperationRequest {
    ownerAddress: string;
    getEstimationRequest: GetEstimationRequest;
}

export interface GetTransactionRequest {
    transactionHash: string;
}

export interface GetTransactionsRequest {
    ownerAddress: string;
    fingerprint?: string;
    limit?: number;
    offset?: number;
    minTimestamp?: number;
    maxTimestamp?: number;
}

export interface GetWalletRequest {
    ownerAddress: string;
}

export interface GetWalletBalancesRequest {
    walletAddress: string;
}

export interface PublishTransactionOperationRequest {
    ownerAddress: string;
    publishTransactionRequest: PublishTransactionRequest;
}

/**
 * TronApi - interface
 * 
 * @export
 * @interface TronApiInterface
 */
export interface TronApiInterface {
    /**
     * Get transaction estimate
     * @param {string} ownerAddress owner address
     * @param {GetEstimationRequest} getEstimationRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TronApiInterface
     */
    getEstimationRaw(requestParameters: GetEstimationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<EstimatePayload>>;

    /**
     * Get transaction estimate
     */
    getEstimation(requestParameters: GetEstimationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<EstimatePayload>;

    /**
     * Get service configuration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TronApiInterface
     */
    getSettingsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronSettings>>;

    /**
     * Get service configuration
     */
    getSettings(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronSettings>;

    /**
     * Get transaction data
     * @param {string} transactionHash transaction hash
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TronApiInterface
     */
    getTransactionRaw(requestParameters: GetTransactionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronEvent>>;

    /**
     * Get transaction data
     */
    getTransaction(requestParameters: GetTransactionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronEvent>;

    /**
     * Get list of transactions
     * @param {string} ownerAddress owner address
     * @param {string} [fingerprint] 
     * @param {number} [limit] 
     * @param {number} [offset] 
     * @param {number} [minTimestamp] 
     * @param {number} [maxTimestamp] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TronApiInterface
     */
    getTransactionsRaw(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronEvents>>;

    /**
     * Get list of transactions
     */
    getTransactions(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronEvents>;

    /**
     * Get user wallet address data
     * @param {string} ownerAddress owner address
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TronApiInterface
     */
    getWalletRaw(requestParameters: GetWalletRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronWallet>>;

    /**
     * Get user wallet address data
     */
    getWallet(requestParameters: GetWalletRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronWallet>;

    /**
     * Get wallet balance
     * @param {string} walletAddress wallet address
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TronApiInterface
     */
    getWalletBalancesRaw(requestParameters: GetWalletBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronBalances>>;

    /**
     * Get wallet balance
     */
    getWalletBalances(requestParameters: GetWalletBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronBalances>;

    /**
     * Publish transaction
     * @param {string} ownerAddress owner address
     * @param {PublishTransactionRequest} publishTransactionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TronApiInterface
     */
    publishTransactionRaw(requestParameters: PublishTransactionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PublishPayload>>;

    /**
     * Publish transaction
     */
    publishTransaction(requestParameters: PublishTransactionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PublishPayload>;

}

/**
 * 
 */
export class TronApi extends runtime.BaseAPI implements TronApiInterface {

    /**
     * Get transaction estimate
     */
    async getEstimationRaw(requestParameters: GetEstimationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<EstimatePayload>> {
        if (requestParameters.ownerAddress === null || requestParameters.ownerAddress === undefined) {
            throw new runtime.RequiredError('ownerAddress','Required parameter requestParameters.ownerAddress was null or undefined when calling getEstimation.');
        }

        if (requestParameters.getEstimationRequest === null || requestParameters.getEstimationRequest === undefined) {
            throw new runtime.RequiredError('getEstimationRequest','Required parameter requestParameters.getEstimationRequest was null or undefined when calling getEstimation.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/api/v2/wallet/{owner_address}/estimate`.replace(`{${"owner_address"}}`, encodeURIComponent(String(requestParameters.ownerAddress))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: GetEstimationRequestToJSON(requestParameters.getEstimationRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EstimatePayloadFromJSON(jsonValue));
    }

    /**
     * Get transaction estimate
     */
    async getEstimation(requestParameters: GetEstimationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<EstimatePayload> {
        const response = await this.getEstimationRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get service configuration
     */
    async getSettingsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronSettings>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/api/v2/settings`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TronSettingsFromJSON(jsonValue));
    }

    /**
     * Get service configuration
     */
    async getSettings(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronSettings> {
        const response = await this.getSettingsRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get transaction data
     */
    async getTransactionRaw(requestParameters: GetTransactionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronEvent>> {
        if (requestParameters.transactionHash === null || requestParameters.transactionHash === undefined) {
            throw new runtime.RequiredError('transactionHash','Required parameter requestParameters.transactionHash was null or undefined when calling getTransaction.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/api/v2/transactions/{transaction_hash}`.replace(`{${"transaction_hash"}}`, encodeURIComponent(String(requestParameters.transactionHash))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TronEventFromJSON(jsonValue));
    }

    /**
     * Get transaction data
     */
    async getTransaction(requestParameters: GetTransactionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronEvent> {
        const response = await this.getTransactionRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get list of transactions
     */
    async getTransactionsRaw(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronEvents>> {
        if (requestParameters.ownerAddress === null || requestParameters.ownerAddress === undefined) {
            throw new runtime.RequiredError('ownerAddress','Required parameter requestParameters.ownerAddress was null or undefined when calling getTransactions.');
        }

        const queryParameters: any = {};

        if (requestParameters.fingerprint !== undefined) {
            queryParameters['fingerprint'] = requestParameters.fingerprint;
        }

        if (requestParameters.limit !== undefined) {
            queryParameters['limit'] = requestParameters.limit;
        }

        if (requestParameters.offset !== undefined) {
            queryParameters['offset'] = requestParameters.offset;
        }

        if (requestParameters.minTimestamp !== undefined) {
            queryParameters['min_timestamp'] = requestParameters.minTimestamp;
        }

        if (requestParameters.maxTimestamp !== undefined) {
            queryParameters['max_timestamp'] = requestParameters.maxTimestamp;
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/api/v2/wallet/{owner_address}/transactions`.replace(`{${"owner_address"}}`, encodeURIComponent(String(requestParameters.ownerAddress))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TronEventsFromJSON(jsonValue));
    }

    /**
     * Get list of transactions
     */
    async getTransactions(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronEvents> {
        const response = await this.getTransactionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get user wallet address data
     */
    async getWalletRaw(requestParameters: GetWalletRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronWallet>> {
        if (requestParameters.ownerAddress === null || requestParameters.ownerAddress === undefined) {
            throw new runtime.RequiredError('ownerAddress','Required parameter requestParameters.ownerAddress was null or undefined when calling getWallet.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/api/v2/wallet/{owner_address}`.replace(`{${"owner_address"}}`, encodeURIComponent(String(requestParameters.ownerAddress))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TronWalletFromJSON(jsonValue));
    }

    /**
     * Get user wallet address data
     */
    async getWallet(requestParameters: GetWalletRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronWallet> {
        const response = await this.getWalletRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get wallet balance
     */
    async getWalletBalancesRaw(requestParameters: GetWalletBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TronBalances>> {
        if (requestParameters.walletAddress === null || requestParameters.walletAddress === undefined) {
            throw new runtime.RequiredError('walletAddress','Required parameter requestParameters.walletAddress was null or undefined when calling getWalletBalances.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/api/v2/balance/{wallet_address}`.replace(`{${"wallet_address"}}`, encodeURIComponent(String(requestParameters.walletAddress))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TronBalancesFromJSON(jsonValue));
    }

    /**
     * Get wallet balance
     */
    async getWalletBalances(requestParameters: GetWalletBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TronBalances> {
        const response = await this.getWalletBalancesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Publish transaction
     */
    async publishTransactionRaw(requestParameters: PublishTransactionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PublishPayload>> {
        if (requestParameters.ownerAddress === null || requestParameters.ownerAddress === undefined) {
            throw new runtime.RequiredError('ownerAddress','Required parameter requestParameters.ownerAddress was null or undefined when calling publishTransaction.');
        }

        if (requestParameters.publishTransactionRequest === null || requestParameters.publishTransactionRequest === undefined) {
            throw new runtime.RequiredError('publishTransactionRequest','Required parameter requestParameters.publishTransactionRequest was null or undefined when calling publishTransaction.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/api/v2/wallet/{owner_address}/publish`.replace(`{${"owner_address"}}`, encodeURIComponent(String(requestParameters.ownerAddress))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: PublishTransactionRequestToJSON(requestParameters.publishTransactionRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PublishPayloadFromJSON(jsonValue));
    }

    /**
     * Publish transaction
     */
    async publishTransaction(requestParameters: PublishTransactionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PublishPayload> {
        const response = await this.publishTransactionRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
