/* tslint:disable */
/* eslint-disable */
/**
 * REST api to TON blockchain explorer
 * Provide access to indexed TON blockchain
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Accounts,
  GetWalletBackup200Response,
  Seqno,
  StatusDefaultResponse,
  TonConnectProof200Response,
  TonConnectProofRequest,
} from '../models/index';
import {
    AccountsFromJSON,
    AccountsToJSON,
    GetWalletBackup200ResponseFromJSON,
    GetWalletBackup200ResponseToJSON,
    SeqnoFromJSON,
    SeqnoToJSON,
    StatusDefaultResponseFromJSON,
    StatusDefaultResponseToJSON,
    TonConnectProof200ResponseFromJSON,
    TonConnectProof200ResponseToJSON,
    TonConnectProofRequestFromJSON,
    TonConnectProofRequestToJSON,
} from '../models/index';

export interface GetAccountSeqnoRequest {
    accountId: string;
}

export interface GetWalletBackupRequest {
    xTonConnectAuth: string;
}

export interface GetWalletsByPublicKeyRequest {
    publicKey: string;
}

export interface SetWalletBackupRequest {
    xTonConnectAuth: string;
    body: Blob;
}

export interface TonConnectProofOperationRequest {
    tonConnectProofRequest: TonConnectProofRequest;
}

/**
 * WalletApi - interface
 * 
 * @export
 * @interface WalletApiInterface
 */
export interface WalletApiInterface {
    /**
     * Get account seqno
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WalletApiInterface
     */
    getAccountSeqnoRaw(requestParameters: GetAccountSeqnoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Seqno>>;

    /**
     * Get account seqno
     */
    getAccountSeqno(requestParameters: GetAccountSeqnoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Seqno>;

    /**
     * Get backup info
     * @param {string} xTonConnectAuth 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WalletApiInterface
     */
    getWalletBackupRaw(requestParameters: GetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetWalletBackup200Response>>;

    /**
     * Get backup info
     */
    getWalletBackup(requestParameters: GetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetWalletBackup200Response>;

    /**
     * Get wallets by public key
     * @param {string} publicKey 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WalletApiInterface
     */
    getWalletsByPublicKeyRaw(requestParameters: GetWalletsByPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Accounts>>;

    /**
     * Get wallets by public key
     */
    getWalletsByPublicKey(requestParameters: GetWalletsByPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Accounts>;

    /**
     * Set backup info
     * @param {string} xTonConnectAuth 
     * @param {Blob} body Information for saving backup
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WalletApiInterface
     */
    setWalletBackupRaw(requestParameters: SetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Set backup info
     */
    setWalletBackup(requestParameters: SetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Account verification and token issuance
     * @param {TonConnectProofRequest} tonConnectProofRequest Data that is expected from TON Connect
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof WalletApiInterface
     */
    tonConnectProofRaw(requestParameters: TonConnectProofOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TonConnectProof200Response>>;

    /**
     * Account verification and token issuance
     */
    tonConnectProof(requestParameters: TonConnectProofOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TonConnectProof200Response>;

}

/**
 * 
 */
export class WalletApi extends runtime.BaseAPI implements WalletApiInterface {

    /**
     * Get account seqno
     */
    async getAccountSeqnoRaw(requestParameters: GetAccountSeqnoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Seqno>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountSeqno().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/wallet/{account_id}/seqno`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SeqnoFromJSON(jsonValue));
    }

    /**
     * Get account seqno
     */
    async getAccountSeqno(requestParameters: GetAccountSeqnoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Seqno> {
        const response = await this.getAccountSeqnoRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get backup info
     */
    async getWalletBackupRaw(requestParameters: GetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetWalletBackup200Response>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling getWalletBackup().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/v2/wallet/backup`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetWalletBackup200ResponseFromJSON(jsonValue));
    }

    /**
     * Get backup info
     */
    async getWalletBackup(requestParameters: GetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetWalletBackup200Response> {
        const response = await this.getWalletBackupRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get wallets by public key
     */
    async getWalletsByPublicKeyRaw(requestParameters: GetWalletsByPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Accounts>> {
        if (requestParameters['publicKey'] == null) {
            throw new runtime.RequiredError(
                'publicKey',
                'Required parameter "publicKey" was null or undefined when calling getWalletsByPublicKey().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/pubkeys/{public_key}/wallets`.replace(`{${"public_key"}}`, encodeURIComponent(String(requestParameters['publicKey']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountsFromJSON(jsonValue));
    }

    /**
     * Get wallets by public key
     */
    async getWalletsByPublicKey(requestParameters: GetWalletsByPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Accounts> {
        const response = await this.getWalletsByPublicKeyRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Set backup info
     */
    async setWalletBackupRaw(requestParameters: SetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling setWalletBackup().'
            );
        }

        if (requestParameters['body'] == null) {
            throw new runtime.RequiredError(
                'body',
                'Required parameter "body" was null or undefined when calling setWalletBackup().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/octet-stream';

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/v2/wallet/backup`,
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: requestParameters['body'] as any,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Set backup info
     */
    async setWalletBackup(requestParameters: SetWalletBackupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.setWalletBackupRaw(requestParameters, initOverrides);
    }

    /**
     * Account verification and token issuance
     */
    async tonConnectProofRaw(requestParameters: TonConnectProofOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TonConnectProof200Response>> {
        if (requestParameters['tonConnectProofRequest'] == null) {
            throw new runtime.RequiredError(
                'tonConnectProofRequest',
                'Required parameter "tonConnectProofRequest" was null or undefined when calling tonConnectProof().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/v2/wallet/auth/proof`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: TonConnectProofRequestToJSON(requestParameters['tonConnectProofRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TonConnectProof200ResponseFromJSON(jsonValue));
    }

    /**
     * Account verification and token issuance
     */
    async tonConnectProof(requestParameters: TonConnectProofOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TonConnectProof200Response> {
        const response = await this.tonConnectProofRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
