/* tslint:disable */
/* eslint-disable */
/**
 * REST api to TON blockchain explorer
 * Provide access to indexed TON blockchain
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  StatusDefaultResponse,
  Trace,
} from '../models/index';
import {
    StatusDefaultResponseFromJSON,
    StatusDefaultResponseToJSON,
    TraceFromJSON,
    TraceToJSON,
} from '../models/index';

export interface GetTraceRequest {
    traceId: string;
}

/**
 * TracesApi - interface
 * 
 * @export
 * @interface TracesApiInterface
 */
export interface TracesApiInterface {
    /**
     * Get the trace by trace ID or hash of any transaction in trace
     * @param {string} traceId trace ID or transaction hash in hex (without 0x) or base64url format
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof TracesApiInterface
     */
    getTraceRaw(requestParameters: GetTraceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Trace>>;

    /**
     * Get the trace by trace ID or hash of any transaction in trace
     */
    getTrace(requestParameters: GetTraceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Trace>;

}

/**
 * 
 */
export class TracesApi extends runtime.BaseAPI implements TracesApiInterface {

    /**
     * Get the trace by trace ID or hash of any transaction in trace
     */
    async getTraceRaw(requestParameters: GetTraceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Trace>> {
        if (requestParameters['traceId'] == null) {
            throw new runtime.RequiredError(
                'traceId',
                'Required parameter "traceId" was null or undefined when calling getTrace().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/traces/{trace_id}`.replace(`{${"trace_id"}}`, encodeURIComponent(String(requestParameters['traceId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TraceFromJSON(jsonValue));
    }

    /**
     * Get the trace by trace ID or hash of any transaction in trace
     */
    async getTrace(requestParameters: GetTraceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Trace> {
        const response = await this.getTraceRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
