/* tslint:disable */
/* eslint-disable */
/**
 * REST api to TON blockchain explorer
 * Provide access to indexed TON blockchain
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  GetChartRates200Response,
  GetMarketsRates200Response,
  GetRates200Response,
  StatusDefaultResponse,
} from '../models/index';
import {
    GetChartRates200ResponseFromJSON,
    GetChartRates200ResponseToJSON,
    GetMarketsRates200ResponseFromJSON,
    GetMarketsRates200ResponseToJSON,
    GetRates200ResponseFromJSON,
    GetRates200ResponseToJSON,
    StatusDefaultResponseFromJSON,
    StatusDefaultResponseToJSON,
} from '../models/index';

export interface GetChartRatesRequest {
    token: string;
    currency?: string;
    startDate?: number;
    endDate?: number;
    pointsCount?: number;
}

export interface GetRatesRequest {
    tokens: Array<string>;
    currencies: Array<string>;
}

/**
 * RatesApi - interface
 * 
 * @export
 * @interface RatesApiInterface
 */
export interface RatesApiInterface {
    /**
     * Get chart by token
     * @param {string} token accept jetton master address
     * @param {string} [currency] 
     * @param {number} [startDate] 
     * @param {number} [endDate] 
     * @param {number} [pointsCount] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RatesApiInterface
     */
    getChartRatesRaw(requestParameters: GetChartRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetChartRates200Response>>;

    /**
     * Get chart by token
     */
    getChartRates(requestParameters: GetChartRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetChartRates200Response>;

    /**
     * Get the TON price from markets
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RatesApiInterface
     */
    getMarketsRatesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetMarketsRates200Response>>;

    /**
     * Get the TON price from markets
     */
    getMarketsRates(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetMarketsRates200Response>;

    /**
     * Get the token price in the chosen currency for display only. Don’t use this for financial transactions.
     * @param {Array<string>} tokens accept ton and jetton master addresses, separated by commas
     * @param {Array<string>} currencies accept ton and all possible fiat currencies, separated by commas
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof RatesApiInterface
     */
    getRatesRaw(requestParameters: GetRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRates200Response>>;

    /**
     * Get the token price in the chosen currency for display only. Don’t use this for financial transactions.
     */
    getRates(requestParameters: GetRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRates200Response>;

}

/**
 * 
 */
export class RatesApi extends runtime.BaseAPI implements RatesApiInterface {

    /**
     * Get chart by token
     */
    async getChartRatesRaw(requestParameters: GetChartRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetChartRates200Response>> {
        if (requestParameters['token'] == null) {
            throw new runtime.RequiredError(
                'token',
                'Required parameter "token" was null or undefined when calling getChartRates().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['token'] != null) {
            queryParameters['token'] = requestParameters['token'];
        }

        if (requestParameters['currency'] != null) {
            queryParameters['currency'] = requestParameters['currency'];
        }

        if (requestParameters['startDate'] != null) {
            queryParameters['start_date'] = requestParameters['startDate'];
        }

        if (requestParameters['endDate'] != null) {
            queryParameters['end_date'] = requestParameters['endDate'];
        }

        if (requestParameters['pointsCount'] != null) {
            queryParameters['points_count'] = requestParameters['pointsCount'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/rates/chart`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetChartRates200ResponseFromJSON(jsonValue));
    }

    /**
     * Get chart by token
     */
    async getChartRates(requestParameters: GetChartRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetChartRates200Response> {
        const response = await this.getChartRatesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the TON price from markets
     */
    async getMarketsRatesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetMarketsRates200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/rates/markets`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetMarketsRates200ResponseFromJSON(jsonValue));
    }

    /**
     * Get the TON price from markets
     */
    async getMarketsRates(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetMarketsRates200Response> {
        const response = await this.getMarketsRatesRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get the token price in the chosen currency for display only. Don’t use this for financial transactions.
     */
    async getRatesRaw(requestParameters: GetRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRates200Response>> {
        if (requestParameters['tokens'] == null) {
            throw new runtime.RequiredError(
                'tokens',
                'Required parameter "tokens" was null or undefined when calling getRates().'
            );
        }

        if (requestParameters['currencies'] == null) {
            throw new runtime.RequiredError(
                'currencies',
                'Required parameter "currencies" was null or undefined when calling getRates().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['tokens'] != null) {
            queryParameters['tokens'] = requestParameters['tokens']!.join(runtime.COLLECTION_FORMATS["csv"]);
        }

        if (requestParameters['currencies'] != null) {
            queryParameters['currencies'] = requestParameters['currencies']!.join(runtime.COLLECTION_FORMATS["csv"]);
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/rates`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRates200ResponseFromJSON(jsonValue));
    }

    /**
     * Get the token price in the chosen currency for display only. Don’t use this for financial transactions.
     */
    async getRates(requestParameters: GetRatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRates200Response> {
        const response = await this.getRatesRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
