/* tslint:disable */
/* eslint-disable */
/**
 * REST api to TON blockchain explorer
 * Provide access to indexed TON blockchain
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  GetAllRawShardsInfo200Response,
  GetOutMsgQueueSizes200Response,
  GetRawAccountState200Response,
  GetRawBlockProof200Response,
  GetRawBlockchainBlock200Response,
  GetRawBlockchainBlockHeader200Response,
  GetRawBlockchainBlockState200Response,
  GetRawConfig200Response,
  GetRawListBlockTransactions200Response,
  GetRawMasterchainInfo200Response,
  GetRawMasterchainInfoExt200Response,
  GetRawShardBlockProof200Response,
  GetRawShardInfo200Response,
  GetRawTime200Response,
  GetRawTransactions200Response,
  SendRawMessage200Response,
  SendRawMessageRequest,
  StatusDefaultResponse,
} from '../models/index';
import {
    GetAllRawShardsInfo200ResponseFromJSON,
    GetAllRawShardsInfo200ResponseToJSON,
    GetOutMsgQueueSizes200ResponseFromJSON,
    GetOutMsgQueueSizes200ResponseToJSON,
    GetRawAccountState200ResponseFromJSON,
    GetRawAccountState200ResponseToJSON,
    GetRawBlockProof200ResponseFromJSON,
    GetRawBlockProof200ResponseToJSON,
    GetRawBlockchainBlock200ResponseFromJSON,
    GetRawBlockchainBlock200ResponseToJSON,
    GetRawBlockchainBlockHeader200ResponseFromJSON,
    GetRawBlockchainBlockHeader200ResponseToJSON,
    GetRawBlockchainBlockState200ResponseFromJSON,
    GetRawBlockchainBlockState200ResponseToJSON,
    GetRawConfig200ResponseFromJSON,
    GetRawConfig200ResponseToJSON,
    GetRawListBlockTransactions200ResponseFromJSON,
    GetRawListBlockTransactions200ResponseToJSON,
    GetRawMasterchainInfo200ResponseFromJSON,
    GetRawMasterchainInfo200ResponseToJSON,
    GetRawMasterchainInfoExt200ResponseFromJSON,
    GetRawMasterchainInfoExt200ResponseToJSON,
    GetRawShardBlockProof200ResponseFromJSON,
    GetRawShardBlockProof200ResponseToJSON,
    GetRawShardInfo200ResponseFromJSON,
    GetRawShardInfo200ResponseToJSON,
    GetRawTime200ResponseFromJSON,
    GetRawTime200ResponseToJSON,
    GetRawTransactions200ResponseFromJSON,
    GetRawTransactions200ResponseToJSON,
    SendRawMessage200ResponseFromJSON,
    SendRawMessage200ResponseToJSON,
    SendRawMessageRequestFromJSON,
    SendRawMessageRequestToJSON,
    StatusDefaultResponseFromJSON,
    StatusDefaultResponseToJSON,
} from '../models/index';

export interface GetAllRawShardsInfoRequest {
    blockId: string;
}

export interface GetRawAccountStateRequest {
    accountId: string;
    targetBlock?: string;
}

export interface GetRawBlockProofRequest {
    knownBlock: string;
    mode: number;
    targetBlock?: string;
}

export interface GetRawBlockchainBlockRequest {
    blockId: string;
}

export interface GetRawBlockchainBlockHeaderRequest {
    blockId: string;
    mode: number;
}

export interface GetRawBlockchainBlockStateRequest {
    blockId: string;
}

export interface GetRawConfigRequest {
    blockId: string;
    mode: number;
}

export interface GetRawListBlockTransactionsRequest {
    blockId: string;
    mode: number;
    count: number;
    accountId?: string;
    lt?: number;
}

export interface GetRawMasterchainInfoExtRequest {
    mode: number;
}

export interface GetRawShardBlockProofRequest {
    blockId: string;
}

export interface GetRawShardInfoRequest {
    blockId: string;
    workchain: number;
    shard: number;
    exact: boolean;
}

export interface GetRawTransactionsRequest {
    accountId: string;
    count: number;
    lt: number;
    hash: string;
}

export interface SendRawMessageOperationRequest {
    sendRawMessageRequest: SendRawMessageRequest;
}

/**
 * LiteServerApi - interface
 * 
 * @export
 * @interface LiteServerApiInterface
 */
export interface LiteServerApiInterface {
    /**
     * Get all raw shards info
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getAllRawShardsInfoRaw(requestParameters: GetAllRawShardsInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetAllRawShardsInfo200Response>>;

    /**
     * Get all raw shards info
     */
    getAllRawShardsInfo(requestParameters: GetAllRawShardsInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetAllRawShardsInfo200Response>;

    /**
     * Get out msg queue sizes
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getOutMsgQueueSizesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetOutMsgQueueSizes200Response>>;

    /**
     * Get out msg queue sizes
     */
    getOutMsgQueueSizes(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetOutMsgQueueSizes200Response>;

    /**
     * Get raw account state
     * @param {string} accountId account ID
     * @param {string} [targetBlock] target block: (workchain,shard,seqno,root_hash,file_hash)
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawAccountStateRaw(requestParameters: GetRawAccountStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawAccountState200Response>>;

    /**
     * Get raw account state
     */
    getRawAccountState(requestParameters: GetRawAccountStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawAccountState200Response>;

    /**
     * Get raw block proof
     * @param {string} knownBlock known block: (workchain,shard,seqno,root_hash,file_hash)
     * @param {number} mode mode
     * @param {string} [targetBlock] target block: (workchain,shard,seqno,root_hash,file_hash)
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawBlockProofRaw(requestParameters: GetRawBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockProof200Response>>;

    /**
     * Get raw block proof
     */
    getRawBlockProof(requestParameters: GetRawBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockProof200Response>;

    /**
     * Get raw blockchain block
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawBlockchainBlockRaw(requestParameters: GetRawBlockchainBlockRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockchainBlock200Response>>;

    /**
     * Get raw blockchain block
     */
    getRawBlockchainBlock(requestParameters: GetRawBlockchainBlockRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockchainBlock200Response>;

    /**
     * Get raw blockchain block header
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {number} mode mode
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawBlockchainBlockHeaderRaw(requestParameters: GetRawBlockchainBlockHeaderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockchainBlockHeader200Response>>;

    /**
     * Get raw blockchain block header
     */
    getRawBlockchainBlockHeader(requestParameters: GetRawBlockchainBlockHeaderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockchainBlockHeader200Response>;

    /**
     * Get raw blockchain block state
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawBlockchainBlockStateRaw(requestParameters: GetRawBlockchainBlockStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockchainBlockState200Response>>;

    /**
     * Get raw blockchain block state
     */
    getRawBlockchainBlockState(requestParameters: GetRawBlockchainBlockStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockchainBlockState200Response>;

    /**
     * Get raw config
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {number} mode mode
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawConfigRaw(requestParameters: GetRawConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawConfig200Response>>;

    /**
     * Get raw config
     */
    getRawConfig(requestParameters: GetRawConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawConfig200Response>;

    /**
     * Get raw list block transactions
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {number} mode mode
     * @param {number} count count
     * @param {string} [accountId] account ID
     * @param {number} [lt] lt
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawListBlockTransactionsRaw(requestParameters: GetRawListBlockTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawListBlockTransactions200Response>>;

    /**
     * Get raw list block transactions
     */
    getRawListBlockTransactions(requestParameters: GetRawListBlockTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawListBlockTransactions200Response>;

    /**
     * Get raw masterchain info
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawMasterchainInfoRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawMasterchainInfo200Response>>;

    /**
     * Get raw masterchain info
     */
    getRawMasterchainInfo(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawMasterchainInfo200Response>;

    /**
     * Get raw masterchain info ext
     * @param {number} mode mode
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawMasterchainInfoExtRaw(requestParameters: GetRawMasterchainInfoExtRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawMasterchainInfoExt200Response>>;

    /**
     * Get raw masterchain info ext
     */
    getRawMasterchainInfoExt(requestParameters: GetRawMasterchainInfoExtRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawMasterchainInfoExt200Response>;

    /**
     * Get raw shard block proof
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawShardBlockProofRaw(requestParameters: GetRawShardBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawShardBlockProof200Response>>;

    /**
     * Get raw shard block proof
     */
    getRawShardBlockProof(requestParameters: GetRawShardBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawShardBlockProof200Response>;

    /**
     * Get raw shard info
     * @param {string} blockId block ID: (workchain,shard,seqno,root_hash,file_hash)
     * @param {number} workchain workchain
     * @param {number} shard shard
     * @param {boolean} exact exact
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawShardInfoRaw(requestParameters: GetRawShardInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawShardInfo200Response>>;

    /**
     * Get raw shard info
     */
    getRawShardInfo(requestParameters: GetRawShardInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawShardInfo200Response>;

    /**
     * Get raw time
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawTimeRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawTime200Response>>;

    /**
     * Get raw time
     */
    getRawTime(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawTime200Response>;

    /**
     * Get raw transactions
     * @param {string} accountId account ID
     * @param {number} count count
     * @param {number} lt lt
     * @param {string} hash hash
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    getRawTransactionsRaw(requestParameters: GetRawTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawTransactions200Response>>;

    /**
     * Get raw transactions
     */
    getRawTransactions(requestParameters: GetRawTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawTransactions200Response>;

    /**
     * Send raw message to blockchain
     * @param {SendRawMessageRequest} sendRawMessageRequest Data that is expected
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LiteServerApiInterface
     */
    sendRawMessageRaw(requestParameters: SendRawMessageOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SendRawMessage200Response>>;

    /**
     * Send raw message to blockchain
     */
    sendRawMessage(requestParameters: SendRawMessageOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SendRawMessage200Response>;

}

/**
 * 
 */
export class LiteServerApi extends runtime.BaseAPI implements LiteServerApiInterface {

    /**
     * Get all raw shards info
     */
    async getAllRawShardsInfoRaw(requestParameters: GetAllRawShardsInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetAllRawShardsInfo200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getAllRawShardsInfo().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_all_shards_info/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetAllRawShardsInfo200ResponseFromJSON(jsonValue));
    }

    /**
     * Get all raw shards info
     */
    async getAllRawShardsInfo(requestParameters: GetAllRawShardsInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetAllRawShardsInfo200Response> {
        const response = await this.getAllRawShardsInfoRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get out msg queue sizes
     */
    async getOutMsgQueueSizesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetOutMsgQueueSizes200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_out_msg_queue_sizes`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetOutMsgQueueSizes200ResponseFromJSON(jsonValue));
    }

    /**
     * Get out msg queue sizes
     */
    async getOutMsgQueueSizes(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetOutMsgQueueSizes200Response> {
        const response = await this.getOutMsgQueueSizesRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get raw account state
     */
    async getRawAccountStateRaw(requestParameters: GetRawAccountStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawAccountState200Response>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getRawAccountState().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['targetBlock'] != null) {
            queryParameters['target_block'] = requestParameters['targetBlock'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_account_state/{account_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawAccountState200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw account state
     */
    async getRawAccountState(requestParameters: GetRawAccountStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawAccountState200Response> {
        const response = await this.getRawAccountStateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw block proof
     */
    async getRawBlockProofRaw(requestParameters: GetRawBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockProof200Response>> {
        if (requestParameters['knownBlock'] == null) {
            throw new runtime.RequiredError(
                'knownBlock',
                'Required parameter "knownBlock" was null or undefined when calling getRawBlockProof().'
            );
        }

        if (requestParameters['mode'] == null) {
            throw new runtime.RequiredError(
                'mode',
                'Required parameter "mode" was null or undefined when calling getRawBlockProof().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['knownBlock'] != null) {
            queryParameters['known_block'] = requestParameters['knownBlock'];
        }

        if (requestParameters['targetBlock'] != null) {
            queryParameters['target_block'] = requestParameters['targetBlock'];
        }

        if (requestParameters['mode'] != null) {
            queryParameters['mode'] = requestParameters['mode'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_block_proof`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawBlockProof200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw block proof
     */
    async getRawBlockProof(requestParameters: GetRawBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockProof200Response> {
        const response = await this.getRawBlockProofRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw blockchain block
     */
    async getRawBlockchainBlockRaw(requestParameters: GetRawBlockchainBlockRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockchainBlock200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getRawBlockchainBlock().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_block/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawBlockchainBlock200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw blockchain block
     */
    async getRawBlockchainBlock(requestParameters: GetRawBlockchainBlockRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockchainBlock200Response> {
        const response = await this.getRawBlockchainBlockRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw blockchain block header
     */
    async getRawBlockchainBlockHeaderRaw(requestParameters: GetRawBlockchainBlockHeaderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockchainBlockHeader200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getRawBlockchainBlockHeader().'
            );
        }

        if (requestParameters['mode'] == null) {
            throw new runtime.RequiredError(
                'mode',
                'Required parameter "mode" was null or undefined when calling getRawBlockchainBlockHeader().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['mode'] != null) {
            queryParameters['mode'] = requestParameters['mode'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_block_header/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawBlockchainBlockHeader200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw blockchain block header
     */
    async getRawBlockchainBlockHeader(requestParameters: GetRawBlockchainBlockHeaderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockchainBlockHeader200Response> {
        const response = await this.getRawBlockchainBlockHeaderRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw blockchain block state
     */
    async getRawBlockchainBlockStateRaw(requestParameters: GetRawBlockchainBlockStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawBlockchainBlockState200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getRawBlockchainBlockState().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_state/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawBlockchainBlockState200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw blockchain block state
     */
    async getRawBlockchainBlockState(requestParameters: GetRawBlockchainBlockStateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawBlockchainBlockState200Response> {
        const response = await this.getRawBlockchainBlockStateRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw config
     */
    async getRawConfigRaw(requestParameters: GetRawConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawConfig200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getRawConfig().'
            );
        }

        if (requestParameters['mode'] == null) {
            throw new runtime.RequiredError(
                'mode',
                'Required parameter "mode" was null or undefined when calling getRawConfig().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['mode'] != null) {
            queryParameters['mode'] = requestParameters['mode'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_config_all/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawConfig200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw config
     */
    async getRawConfig(requestParameters: GetRawConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawConfig200Response> {
        const response = await this.getRawConfigRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw list block transactions
     */
    async getRawListBlockTransactionsRaw(requestParameters: GetRawListBlockTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawListBlockTransactions200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getRawListBlockTransactions().'
            );
        }

        if (requestParameters['mode'] == null) {
            throw new runtime.RequiredError(
                'mode',
                'Required parameter "mode" was null or undefined when calling getRawListBlockTransactions().'
            );
        }

        if (requestParameters['count'] == null) {
            throw new runtime.RequiredError(
                'count',
                'Required parameter "count" was null or undefined when calling getRawListBlockTransactions().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['mode'] != null) {
            queryParameters['mode'] = requestParameters['mode'];
        }

        if (requestParameters['count'] != null) {
            queryParameters['count'] = requestParameters['count'];
        }

        if (requestParameters['accountId'] != null) {
            queryParameters['account_id'] = requestParameters['accountId'];
        }

        if (requestParameters['lt'] != null) {
            queryParameters['lt'] = requestParameters['lt'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/list_block_transactions/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawListBlockTransactions200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw list block transactions
     */
    async getRawListBlockTransactions(requestParameters: GetRawListBlockTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawListBlockTransactions200Response> {
        const response = await this.getRawListBlockTransactionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw masterchain info
     */
    async getRawMasterchainInfoRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawMasterchainInfo200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_masterchain_info`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawMasterchainInfo200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw masterchain info
     */
    async getRawMasterchainInfo(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawMasterchainInfo200Response> {
        const response = await this.getRawMasterchainInfoRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get raw masterchain info ext
     */
    async getRawMasterchainInfoExtRaw(requestParameters: GetRawMasterchainInfoExtRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawMasterchainInfoExt200Response>> {
        if (requestParameters['mode'] == null) {
            throw new runtime.RequiredError(
                'mode',
                'Required parameter "mode" was null or undefined when calling getRawMasterchainInfoExt().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['mode'] != null) {
            queryParameters['mode'] = requestParameters['mode'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_masterchain_info_ext`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawMasterchainInfoExt200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw masterchain info ext
     */
    async getRawMasterchainInfoExt(requestParameters: GetRawMasterchainInfoExtRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawMasterchainInfoExt200Response> {
        const response = await this.getRawMasterchainInfoExtRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw shard block proof
     */
    async getRawShardBlockProofRaw(requestParameters: GetRawShardBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawShardBlockProof200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getRawShardBlockProof().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_shard_block_proof/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawShardBlockProof200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw shard block proof
     */
    async getRawShardBlockProof(requestParameters: GetRawShardBlockProofRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawShardBlockProof200Response> {
        const response = await this.getRawShardBlockProofRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw shard info
     */
    async getRawShardInfoRaw(requestParameters: GetRawShardInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawShardInfo200Response>> {
        if (requestParameters['blockId'] == null) {
            throw new runtime.RequiredError(
                'blockId',
                'Required parameter "blockId" was null or undefined when calling getRawShardInfo().'
            );
        }

        if (requestParameters['workchain'] == null) {
            throw new runtime.RequiredError(
                'workchain',
                'Required parameter "workchain" was null or undefined when calling getRawShardInfo().'
            );
        }

        if (requestParameters['shard'] == null) {
            throw new runtime.RequiredError(
                'shard',
                'Required parameter "shard" was null or undefined when calling getRawShardInfo().'
            );
        }

        if (requestParameters['exact'] == null) {
            throw new runtime.RequiredError(
                'exact',
                'Required parameter "exact" was null or undefined when calling getRawShardInfo().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['workchain'] != null) {
            queryParameters['workchain'] = requestParameters['workchain'];
        }

        if (requestParameters['shard'] != null) {
            queryParameters['shard'] = requestParameters['shard'];
        }

        if (requestParameters['exact'] != null) {
            queryParameters['exact'] = requestParameters['exact'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_shard_info/{block_id}`.replace(`{${"block_id"}}`, encodeURIComponent(String(requestParameters['blockId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawShardInfo200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw shard info
     */
    async getRawShardInfo(requestParameters: GetRawShardInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawShardInfo200Response> {
        const response = await this.getRawShardInfoRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get raw time
     */
    async getRawTimeRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawTime200Response>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_time`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawTime200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw time
     */
    async getRawTime(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawTime200Response> {
        const response = await this.getRawTimeRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get raw transactions
     */
    async getRawTransactionsRaw(requestParameters: GetRawTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetRawTransactions200Response>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getRawTransactions().'
            );
        }

        if (requestParameters['count'] == null) {
            throw new runtime.RequiredError(
                'count',
                'Required parameter "count" was null or undefined when calling getRawTransactions().'
            );
        }

        if (requestParameters['lt'] == null) {
            throw new runtime.RequiredError(
                'lt',
                'Required parameter "lt" was null or undefined when calling getRawTransactions().'
            );
        }

        if (requestParameters['hash'] == null) {
            throw new runtime.RequiredError(
                'hash',
                'Required parameter "hash" was null or undefined when calling getRawTransactions().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['count'] != null) {
            queryParameters['count'] = requestParameters['count'];
        }

        if (requestParameters['lt'] != null) {
            queryParameters['lt'] = requestParameters['lt'];
        }

        if (requestParameters['hash'] != null) {
            queryParameters['hash'] = requestParameters['hash'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/liteserver/get_transactions/{account_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetRawTransactions200ResponseFromJSON(jsonValue));
    }

    /**
     * Get raw transactions
     */
    async getRawTransactions(requestParameters: GetRawTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetRawTransactions200Response> {
        const response = await this.getRawTransactionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Send raw message to blockchain
     */
    async sendRawMessageRaw(requestParameters: SendRawMessageOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SendRawMessage200Response>> {
        if (requestParameters['sendRawMessageRequest'] == null) {
            throw new runtime.RequiredError(
                'sendRawMessageRequest',
                'Required parameter "sendRawMessageRequest" was null or undefined when calling sendRawMessage().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/v2/liteserver/send_message`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: SendRawMessageRequestToJSON(requestParameters['sendRawMessageRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SendRawMessage200ResponseFromJSON(jsonValue));
    }

    /**
     * Send raw message to blockchain
     */
    async sendRawMessage(requestParameters: SendRawMessageOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SendRawMessage200Response> {
        const response = await this.sendRawMessageRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
