/* tslint:disable */
/* eslint-disable */
/**
 * REST api to TON blockchain explorer
 * Provide access to indexed TON blockchain
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Event,
  JettonHolders,
  JettonInfo,
  JettonTransferPayload,
  Jettons,
  StatusDefaultResponse,
} from '../models/index';
import {
    EventFromJSON,
    EventToJSON,
    JettonHoldersFromJSON,
    JettonHoldersToJSON,
    JettonInfoFromJSON,
    JettonInfoToJSON,
    JettonTransferPayloadFromJSON,
    JettonTransferPayloadToJSON,
    JettonsFromJSON,
    JettonsToJSON,
    StatusDefaultResponseFromJSON,
    StatusDefaultResponseToJSON,
} from '../models/index';

export interface GetJettonHoldersRequest {
    accountId: string;
    limit?: number;
    offset?: number;
}

export interface GetJettonInfoRequest {
    accountId: string;
}

export interface GetJettonTransferPayloadRequest {
    accountId: string;
    jettonId: string;
}

export interface GetJettonsRequest {
    limit?: number;
    offset?: number;
}

export interface GetJettonsEventsRequest {
    eventId: string;
    acceptLanguage?: string;
}

/**
 * JettonsApi - interface
 * 
 * @export
 * @interface JettonsApiInterface
 */
export interface JettonsApiInterface {
    /**
     * Get jetton\'s holders
     * @param {string} accountId account ID
     * @param {number} [limit] 
     * @param {number} [offset] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof JettonsApiInterface
     */
    getJettonHoldersRaw(requestParameters: GetJettonHoldersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonHolders>>;

    /**
     * Get jetton\'s holders
     */
    getJettonHolders(requestParameters: GetJettonHoldersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonHolders>;

    /**
     * Get jetton metadata by jetton master address
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof JettonsApiInterface
     */
    getJettonInfoRaw(requestParameters: GetJettonInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonInfo>>;

    /**
     * Get jetton metadata by jetton master address
     */
    getJettonInfo(requestParameters: GetJettonInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonInfo>;

    /**
     * Get jetton\'s custom payload and state init required for transfer
     * @param {string} accountId account ID
     * @param {string} jettonId jetton ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof JettonsApiInterface
     */
    getJettonTransferPayloadRaw(requestParameters: GetJettonTransferPayloadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonTransferPayload>>;

    /**
     * Get jetton\'s custom payload and state init required for transfer
     */
    getJettonTransferPayload(requestParameters: GetJettonTransferPayloadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonTransferPayload>;

    /**
     * Get a list of all indexed jetton masters in the blockchain.
     * @param {number} [limit] 
     * @param {number} [offset] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof JettonsApiInterface
     */
    getJettonsRaw(requestParameters: GetJettonsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Jettons>>;

    /**
     * Get a list of all indexed jetton masters in the blockchain.
     */
    getJettons(requestParameters: GetJettonsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Jettons>;

    /**
     * Get only jetton transfers in the event
     * @param {string} eventId event ID or transaction hash in hex (without 0x) or base64url format
     * @param {string} [acceptLanguage] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof JettonsApiInterface
     */
    getJettonsEventsRaw(requestParameters: GetJettonsEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Event>>;

    /**
     * Get only jetton transfers in the event
     */
    getJettonsEvents(requestParameters: GetJettonsEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Event>;

}

/**
 * 
 */
export class JettonsApi extends runtime.BaseAPI implements JettonsApiInterface {

    /**
     * Get jetton\'s holders
     */
    async getJettonHoldersRaw(requestParameters: GetJettonHoldersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonHolders>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getJettonHolders().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['offset'] != null) {
            queryParameters['offset'] = requestParameters['offset'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/jettons/{account_id}/holders`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => JettonHoldersFromJSON(jsonValue));
    }

    /**
     * Get jetton\'s holders
     */
    async getJettonHolders(requestParameters: GetJettonHoldersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonHolders> {
        const response = await this.getJettonHoldersRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get jetton metadata by jetton master address
     */
    async getJettonInfoRaw(requestParameters: GetJettonInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonInfo>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getJettonInfo().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/jettons/{account_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => JettonInfoFromJSON(jsonValue));
    }

    /**
     * Get jetton metadata by jetton master address
     */
    async getJettonInfo(requestParameters: GetJettonInfoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonInfo> {
        const response = await this.getJettonInfoRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get jetton\'s custom payload and state init required for transfer
     */
    async getJettonTransferPayloadRaw(requestParameters: GetJettonTransferPayloadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonTransferPayload>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getJettonTransferPayload().'
            );
        }

        if (requestParameters['jettonId'] == null) {
            throw new runtime.RequiredError(
                'jettonId',
                'Required parameter "jettonId" was null or undefined when calling getJettonTransferPayload().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/jettons/{jetton_id}/transfer/{account_id}/payload`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"jetton_id"}}`, encodeURIComponent(String(requestParameters['jettonId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => JettonTransferPayloadFromJSON(jsonValue));
    }

    /**
     * Get jetton\'s custom payload and state init required for transfer
     */
    async getJettonTransferPayload(requestParameters: GetJettonTransferPayloadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonTransferPayload> {
        const response = await this.getJettonTransferPayloadRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get a list of all indexed jetton masters in the blockchain.
     */
    async getJettonsRaw(requestParameters: GetJettonsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Jettons>> {
        const queryParameters: any = {};

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['offset'] != null) {
            queryParameters['offset'] = requestParameters['offset'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/jettons`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => JettonsFromJSON(jsonValue));
    }

    /**
     * Get a list of all indexed jetton masters in the blockchain.
     */
    async getJettons(requestParameters: GetJettonsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Jettons> {
        const response = await this.getJettonsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get only jetton transfers in the event
     */
    async getJettonsEventsRaw(requestParameters: GetJettonsEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Event>> {
        if (requestParameters['eventId'] == null) {
            throw new runtime.RequiredError(
                'eventId',
                'Required parameter "eventId" was null or undefined when calling getJettonsEvents().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        const response = await this.request({
            path: `/v2/events/{event_id}/jettons`.replace(`{${"event_id"}}`, encodeURIComponent(String(requestParameters['eventId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => EventFromJSON(jsonValue));
    }

    /**
     * Get only jetton transfers in the event
     */
    async getJettonsEvents(requestParameters: GetJettonsEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Event> {
        const response = await this.getJettonsEventsRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
