/* tslint:disable */
/* eslint-disable */
/**
 * REST api to TON blockchain explorer
 * Provide access to indexed TON blockchain
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  AccountEvents,
  GetInscriptionOpTemplate200Response,
  InscriptionBalances,
  StatusDefaultResponse,
} from '../models/index';
import {
    AccountEventsFromJSON,
    AccountEventsToJSON,
    GetInscriptionOpTemplate200ResponseFromJSON,
    GetInscriptionOpTemplate200ResponseToJSON,
    InscriptionBalancesFromJSON,
    InscriptionBalancesToJSON,
    StatusDefaultResponseFromJSON,
    StatusDefaultResponseToJSON,
} from '../models/index';

export interface GetAccountInscriptionsRequest {
    accountId: string;
    limit?: number;
    offset?: number;
}

export interface GetAccountInscriptionsHistoryRequest {
    accountId: string;
    acceptLanguage?: string;
    beforeLt?: number;
    limit?: number;
}

export interface GetAccountInscriptionsHistoryByTickerRequest {
    accountId: string;
    ticker: string;
    acceptLanguage?: string;
    beforeLt?: number;
    limit?: number;
}

export interface GetInscriptionOpTemplateRequest {
    type: GetInscriptionOpTemplateTypeEnum;
    operation: GetInscriptionOpTemplateOperationEnum;
    amount: string;
    ticker: string;
    who: string;
    destination?: string;
    comment?: string;
}

/**
 * InscriptionsApi - interface
 * 
 * @export
 * @interface InscriptionsApiInterface
 */
export interface InscriptionsApiInterface {
    /**
     * Get all inscriptions by owner address. It\'s experimental API and can be dropped in the future.
     * @param {string} accountId account ID
     * @param {number} [limit] 
     * @param {number} [offset] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof InscriptionsApiInterface
     */
    getAccountInscriptionsRaw(requestParameters: GetAccountInscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InscriptionBalances>>;

    /**
     * Get all inscriptions by owner address. It\'s experimental API and can be dropped in the future.
     */
    getAccountInscriptions(requestParameters: GetAccountInscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InscriptionBalances>;

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     * @param {string} accountId account ID
     * @param {string} [acceptLanguage] 
     * @param {number} [beforeLt] omit this parameter to get last events
     * @param {number} [limit] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof InscriptionsApiInterface
     */
    getAccountInscriptionsHistoryRaw(requestParameters: GetAccountInscriptionsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>>;

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     */
    getAccountInscriptionsHistory(requestParameters: GetAccountInscriptionsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents>;

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     * @param {string} accountId account ID
     * @param {string} ticker 
     * @param {string} [acceptLanguage] 
     * @param {number} [beforeLt] omit this parameter to get last events
     * @param {number} [limit] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof InscriptionsApiInterface
     */
    getAccountInscriptionsHistoryByTickerRaw(requestParameters: GetAccountInscriptionsHistoryByTickerRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>>;

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     */
    getAccountInscriptionsHistoryByTicker(requestParameters: GetAccountInscriptionsHistoryByTickerRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents>;

    /**
     * return comment for making operation with inscription. please don\'t use it if you don\'t know what you are doing
     * @param {'ton20' | 'gram20'} type 
     * @param {'transfer'} operation 
     * @param {string} amount 
     * @param {string} ticker 
     * @param {string} who 
     * @param {string} [destination] 
     * @param {string} [comment] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof InscriptionsApiInterface
     */
    getInscriptionOpTemplateRaw(requestParameters: GetInscriptionOpTemplateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetInscriptionOpTemplate200Response>>;

    /**
     * return comment for making operation with inscription. please don\'t use it if you don\'t know what you are doing
     */
    getInscriptionOpTemplate(requestParameters: GetInscriptionOpTemplateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetInscriptionOpTemplate200Response>;

}

/**
 * 
 */
export class InscriptionsApi extends runtime.BaseAPI implements InscriptionsApiInterface {

    /**
     * Get all inscriptions by owner address. It\'s experimental API and can be dropped in the future.
     */
    async getAccountInscriptionsRaw(requestParameters: GetAccountInscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InscriptionBalances>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountInscriptions().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['offset'] != null) {
            queryParameters['offset'] = requestParameters['offset'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/experimental/accounts/{account_id}/inscriptions`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => InscriptionBalancesFromJSON(jsonValue));
    }

    /**
     * Get all inscriptions by owner address. It\'s experimental API and can be dropped in the future.
     */
    async getAccountInscriptions(requestParameters: GetAccountInscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InscriptionBalances> {
        const response = await this.getAccountInscriptionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     */
    async getAccountInscriptionsHistoryRaw(requestParameters: GetAccountInscriptionsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountInscriptionsHistory().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['beforeLt'] != null) {
            queryParameters['before_lt'] = requestParameters['beforeLt'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        const response = await this.request({
            path: `/v2/experimental/accounts/{account_id}/inscriptions/history`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountEventsFromJSON(jsonValue));
    }

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     */
    async getAccountInscriptionsHistory(requestParameters: GetAccountInscriptionsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents> {
        const response = await this.getAccountInscriptionsHistoryRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     */
    async getAccountInscriptionsHistoryByTickerRaw(requestParameters: GetAccountInscriptionsHistoryByTickerRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountInscriptionsHistoryByTicker().'
            );
        }

        if (requestParameters['ticker'] == null) {
            throw new runtime.RequiredError(
                'ticker',
                'Required parameter "ticker" was null or undefined when calling getAccountInscriptionsHistoryByTicker().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['beforeLt'] != null) {
            queryParameters['before_lt'] = requestParameters['beforeLt'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        const response = await this.request({
            path: `/v2/experimental/accounts/{account_id}/inscriptions/{ticker}/history`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"ticker"}}`, encodeURIComponent(String(requestParameters['ticker']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountEventsFromJSON(jsonValue));
    }

    /**
     * Get the transfer inscriptions history for account. It\'s experimental API and can be dropped in the future.
     */
    async getAccountInscriptionsHistoryByTicker(requestParameters: GetAccountInscriptionsHistoryByTickerRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents> {
        const response = await this.getAccountInscriptionsHistoryByTickerRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * return comment for making operation with inscription. please don\'t use it if you don\'t know what you are doing
     */
    async getInscriptionOpTemplateRaw(requestParameters: GetInscriptionOpTemplateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetInscriptionOpTemplate200Response>> {
        if (requestParameters['type'] == null) {
            throw new runtime.RequiredError(
                'type',
                'Required parameter "type" was null or undefined when calling getInscriptionOpTemplate().'
            );
        }

        if (requestParameters['operation'] == null) {
            throw new runtime.RequiredError(
                'operation',
                'Required parameter "operation" was null or undefined when calling getInscriptionOpTemplate().'
            );
        }

        if (requestParameters['amount'] == null) {
            throw new runtime.RequiredError(
                'amount',
                'Required parameter "amount" was null or undefined when calling getInscriptionOpTemplate().'
            );
        }

        if (requestParameters['ticker'] == null) {
            throw new runtime.RequiredError(
                'ticker',
                'Required parameter "ticker" was null or undefined when calling getInscriptionOpTemplate().'
            );
        }

        if (requestParameters['who'] == null) {
            throw new runtime.RequiredError(
                'who',
                'Required parameter "who" was null or undefined when calling getInscriptionOpTemplate().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['type'] != null) {
            queryParameters['type'] = requestParameters['type'];
        }

        if (requestParameters['destination'] != null) {
            queryParameters['destination'] = requestParameters['destination'];
        }

        if (requestParameters['comment'] != null) {
            queryParameters['comment'] = requestParameters['comment'];
        }

        if (requestParameters['operation'] != null) {
            queryParameters['operation'] = requestParameters['operation'];
        }

        if (requestParameters['amount'] != null) {
            queryParameters['amount'] = requestParameters['amount'];
        }

        if (requestParameters['ticker'] != null) {
            queryParameters['ticker'] = requestParameters['ticker'];
        }

        if (requestParameters['who'] != null) {
            queryParameters['who'] = requestParameters['who'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/experimental/inscriptions/op-template`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetInscriptionOpTemplate200ResponseFromJSON(jsonValue));
    }

    /**
     * return comment for making operation with inscription. please don\'t use it if you don\'t know what you are doing
     */
    async getInscriptionOpTemplate(requestParameters: GetInscriptionOpTemplateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetInscriptionOpTemplate200Response> {
        const response = await this.getInscriptionOpTemplateRaw(requestParameters, initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const GetInscriptionOpTemplateTypeEnum = {
    Ton20: 'ton20',
    Gram20: 'gram20'
} as const;
export type GetInscriptionOpTemplateTypeEnum = typeof GetInscriptionOpTemplateTypeEnum[keyof typeof GetInscriptionOpTemplateTypeEnum];
/**
 * @export
 */
export const GetInscriptionOpTemplateOperationEnum = {
    Transfer: 'transfer'
} as const;
export type GetInscriptionOpTemplateOperationEnum = typeof GetInscriptionOpTemplateOperationEnum[keyof typeof GetInscriptionOpTemplateOperationEnum];
