/* tslint:disable */
/* eslint-disable */
/**
 * REST api to TON blockchain explorer
 * Provide access to indexed TON blockchain
 *
 * The version of the OpenAPI document: 2.0.0
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  Account,
  AccountEvent,
  AccountEvents,
  Accounts,
  DnsExpiring,
  DomainNames,
  FoundAccounts,
  GetAccountDiff200Response,
  GetAccountPublicKey200Response,
  GetAccountsRequest,
  JettonBalance,
  JettonsBalances,
  Multisigs,
  NftItems,
  StatusDefaultResponse,
  Subscriptions,
  TraceIDs,
} from '../models/index';
import {
    AccountFromJSON,
    AccountToJSON,
    AccountEventFromJSON,
    AccountEventToJSON,
    AccountEventsFromJSON,
    AccountEventsToJSON,
    AccountsFromJSON,
    AccountsToJSON,
    DnsExpiringFromJSON,
    DnsExpiringToJSON,
    DomainNamesFromJSON,
    DomainNamesToJSON,
    FoundAccountsFromJSON,
    FoundAccountsToJSON,
    GetAccountDiff200ResponseFromJSON,
    GetAccountDiff200ResponseToJSON,
    GetAccountPublicKey200ResponseFromJSON,
    GetAccountPublicKey200ResponseToJSON,
    GetAccountsRequestFromJSON,
    GetAccountsRequestToJSON,
    JettonBalanceFromJSON,
    JettonBalanceToJSON,
    JettonsBalancesFromJSON,
    JettonsBalancesToJSON,
    MultisigsFromJSON,
    MultisigsToJSON,
    NftItemsFromJSON,
    NftItemsToJSON,
    StatusDefaultResponseFromJSON,
    StatusDefaultResponseToJSON,
    SubscriptionsFromJSON,
    SubscriptionsToJSON,
    TraceIDsFromJSON,
    TraceIDsToJSON,
} from '../models/index';

export interface AccountDnsBackResolveRequest {
    accountId: string;
}

export interface GetAccountRequest {
    accountId: string;
}

export interface GetAccountDiffRequest {
    accountId: string;
    startDate: number;
    endDate: number;
}

export interface GetAccountDnsExpiringRequest {
    accountId: string;
    period?: number;
}

export interface GetAccountEventRequest {
    accountId: string;
    eventId: string;
    acceptLanguage?: string;
    subjectOnly?: boolean;
}

export interface GetAccountEventsRequest {
    accountId: string;
    limit: number;
    acceptLanguage?: string;
    initiator?: boolean;
    subjectOnly?: boolean;
    beforeLt?: number;
    startDate?: number;
    endDate?: number;
}

export interface GetAccountJettonBalanceRequest {
    accountId: string;
    jettonId: string;
    currencies?: Array<string>;
    supportedExtensions?: Array<string>;
}

export interface GetAccountJettonHistoryByIDRequest {
    accountId: string;
    jettonId: string;
    limit: number;
    acceptLanguage?: string;
    beforeLt?: number;
    startDate?: number;
    endDate?: number;
}

export interface GetAccountJettonsBalancesRequest {
    accountId: string;
    currencies?: Array<string>;
    supportedExtensions?: Array<string>;
}

export interface GetAccountJettonsHistoryRequest {
    accountId: string;
    limit: number;
    acceptLanguage?: string;
    beforeLt?: number;
    startDate?: number;
    endDate?: number;
}

export interface GetAccountMultisigsRequest {
    accountId: string;
}

export interface GetAccountNftItemsRequest {
    accountId: string;
    collection?: string;
    limit?: number;
    offset?: number;
    indirectOwnership?: boolean;
}

export interface GetAccountPublicKeyRequest {
    accountId: string;
}

export interface GetAccountSubscriptionsRequest {
    accountId: string;
}

export interface GetAccountTracesRequest {
    accountId: string;
    beforeLt?: number;
    limit?: number;
}

export interface GetAccountsOperationRequest {
    currency?: string;
    getAccountsRequest?: GetAccountsRequest;
}

export interface ReindexAccountRequest {
    accountId: string;
}

export interface SearchAccountsRequest {
    name: string;
}

/**
 * AccountsApi - interface
 * 
 * @export
 * @interface AccountsApiInterface
 */
export interface AccountsApiInterface {
    /**
     * Get account\'s domains
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    accountDnsBackResolveRaw(requestParameters: AccountDnsBackResolveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DomainNames>>;

    /**
     * Get account\'s domains
     */
    accountDnsBackResolve(requestParameters: AccountDnsBackResolveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DomainNames>;

    /**
     * Get human-friendly information about an account without low-level details.
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountRaw(requestParameters: GetAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Account>>;

    /**
     * Get human-friendly information about an account without low-level details.
     */
    getAccount(requestParameters: GetAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Account>;

    /**
     * Get account\'s balance change
     * @param {string} accountId account ID
     * @param {number} startDate 
     * @param {number} endDate 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountDiffRaw(requestParameters: GetAccountDiffRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetAccountDiff200Response>>;

    /**
     * Get account\'s balance change
     */
    getAccountDiff(requestParameters: GetAccountDiffRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetAccountDiff200Response>;

    /**
     * Get expiring account .ton dns
     * @param {string} accountId account ID
     * @param {number} [period] number of days before expiration
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountDnsExpiringRaw(requestParameters: GetAccountDnsExpiringRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DnsExpiring>>;

    /**
     * Get expiring account .ton dns
     */
    getAccountDnsExpiring(requestParameters: GetAccountDnsExpiringRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DnsExpiring>;

    /**
     * Get event for an account by event_id
     * @param {string} accountId account ID
     * @param {string} eventId event ID or transaction hash in hex (without 0x) or base64url format
     * @param {string} [acceptLanguage] 
     * @param {boolean} [subjectOnly] filter actions where requested account is not real subject (for example sender or receiver jettons)
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountEventRaw(requestParameters: GetAccountEventRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvent>>;

    /**
     * Get event for an account by event_id
     */
    getAccountEvent(requestParameters: GetAccountEventRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvent>;

    /**
     * Get events for an account. Each event is built on top of a trace which is a series of transactions caused by one inbound message. TonAPI looks for known patterns inside the trace and splits the trace into actions, where a single action represents a meaningful high-level operation like a Jetton Transfer or an NFT Purchase. Actions are expected to be shown to users. It is advised not to build any logic on top of actions because actions can be changed at any time.
     * @param {string} accountId account ID
     * @param {number} limit 
     * @param {string} [acceptLanguage] 
     * @param {boolean} [initiator] Show only events that are initiated by this account
     * @param {boolean} [subjectOnly] filter actions where requested account is not real subject (for example sender or receiver jettons)
     * @param {number} [beforeLt] omit this parameter to get last events
     * @param {number} [startDate] 
     * @param {number} [endDate] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountEventsRaw(requestParameters: GetAccountEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>>;

    /**
     * Get events for an account. Each event is built on top of a trace which is a series of transactions caused by one inbound message. TonAPI looks for known patterns inside the trace and splits the trace into actions, where a single action represents a meaningful high-level operation like a Jetton Transfer or an NFT Purchase. Actions are expected to be shown to users. It is advised not to build any logic on top of actions because actions can be changed at any time.
     */
    getAccountEvents(requestParameters: GetAccountEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents>;

    /**
     * Get Jetton balance by owner address
     * @param {string} accountId account ID
     * @param {string} jettonId jetton ID
     * @param {Array<string>} [currencies] accept ton and all possible fiat currencies, separated by commas
     * @param {Array<string>} [supportedExtensions] comma separated list supported extensions
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountJettonBalanceRaw(requestParameters: GetAccountJettonBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonBalance>>;

    /**
     * Get Jetton balance by owner address
     */
    getAccountJettonBalance(requestParameters: GetAccountJettonBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonBalance>;

    /**
     * Get the transfer jetton history for account and jetton
     * @param {string} accountId account ID
     * @param {string} jettonId jetton ID
     * @param {number} limit 
     * @param {string} [acceptLanguage] 
     * @param {number} [beforeLt] omit this parameter to get last events
     * @param {number} [startDate] 
     * @param {number} [endDate] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountJettonHistoryByIDRaw(requestParameters: GetAccountJettonHistoryByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>>;

    /**
     * Get the transfer jetton history for account and jetton
     */
    getAccountJettonHistoryByID(requestParameters: GetAccountJettonHistoryByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents>;

    /**
     * Get all Jettons balances by owner address
     * @param {string} accountId account ID
     * @param {Array<string>} [currencies] accept ton and all possible fiat currencies, separated by commas
     * @param {Array<string>} [supportedExtensions] comma separated list supported extensions
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountJettonsBalancesRaw(requestParameters: GetAccountJettonsBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonsBalances>>;

    /**
     * Get all Jettons balances by owner address
     */
    getAccountJettonsBalances(requestParameters: GetAccountJettonsBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonsBalances>;

    /**
     * Get the transfer jettons history for account
     * @param {string} accountId account ID
     * @param {number} limit 
     * @param {string} [acceptLanguage] 
     * @param {number} [beforeLt] omit this parameter to get last events
     * @param {number} [startDate] 
     * @param {number} [endDate] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountJettonsHistoryRaw(requestParameters: GetAccountJettonsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>>;

    /**
     * Get the transfer jettons history for account
     */
    getAccountJettonsHistory(requestParameters: GetAccountJettonsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents>;

    /**
     * Get account\'s multisigs
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountMultisigsRaw(requestParameters: GetAccountMultisigsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Multisigs>>;

    /**
     * Get account\'s multisigs
     */
    getAccountMultisigs(requestParameters: GetAccountMultisigsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Multisigs>;

    /**
     * Get all NFT items by owner address
     * @param {string} accountId account ID
     * @param {string} [collection] nft collection
     * @param {number} [limit] 
     * @param {number} [offset] 
     * @param {boolean} [indirectOwnership] Selling nft items in ton implemented usually via transfer items to special selling account. This option enables including items which owned not directly.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountNftItemsRaw(requestParameters: GetAccountNftItemsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NftItems>>;

    /**
     * Get all NFT items by owner address
     */
    getAccountNftItems(requestParameters: GetAccountNftItemsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NftItems>;

    /**
     * Get public key by account id
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountPublicKeyRaw(requestParameters: GetAccountPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetAccountPublicKey200Response>>;

    /**
     * Get public key by account id
     */
    getAccountPublicKey(requestParameters: GetAccountPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetAccountPublicKey200Response>;

    /**
     * Get all subscriptions by wallet address
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountSubscriptionsRaw(requestParameters: GetAccountSubscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Subscriptions>>;

    /**
     * Get all subscriptions by wallet address
     */
    getAccountSubscriptions(requestParameters: GetAccountSubscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Subscriptions>;

    /**
     * Get traces for account
     * @param {string} accountId account ID
     * @param {number} [beforeLt] omit this parameter to get last events
     * @param {number} [limit] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountTracesRaw(requestParameters: GetAccountTracesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TraceIDs>>;

    /**
     * Get traces for account
     */
    getAccountTraces(requestParameters: GetAccountTracesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TraceIDs>;

    /**
     * Get human-friendly information about several accounts without low-level details.
     * @param {string} [currency] 
     * @param {GetAccountsRequest} [getAccountsRequest] a list of account ids
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    getAccountsRaw(requestParameters: GetAccountsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Accounts>>;

    /**
     * Get human-friendly information about several accounts without low-level details.
     */
    getAccounts(requestParameters: GetAccountsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Accounts>;

    /**
     * Update internal cache for a particular account
     * @param {string} accountId account ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    reindexAccountRaw(requestParameters: ReindexAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Update internal cache for a particular account
     */
    reindexAccount(requestParameters: ReindexAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Search by account domain name
     * @param {string} name 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof AccountsApiInterface
     */
    searchAccountsRaw(requestParameters: SearchAccountsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FoundAccounts>>;

    /**
     * Search by account domain name
     */
    searchAccounts(requestParameters: SearchAccountsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FoundAccounts>;

}

/**
 * 
 */
export class AccountsApi extends runtime.BaseAPI implements AccountsApiInterface {

    /**
     * Get account\'s domains
     */
    async accountDnsBackResolveRaw(requestParameters: AccountDnsBackResolveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DomainNames>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling accountDnsBackResolve().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/dns/backresolve`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DomainNamesFromJSON(jsonValue));
    }

    /**
     * Get account\'s domains
     */
    async accountDnsBackResolve(requestParameters: AccountDnsBackResolveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DomainNames> {
        const response = await this.accountDnsBackResolveRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get human-friendly information about an account without low-level details.
     */
    async getAccountRaw(requestParameters: GetAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Account>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccount().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountFromJSON(jsonValue));
    }

    /**
     * Get human-friendly information about an account without low-level details.
     */
    async getAccount(requestParameters: GetAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Account> {
        const response = await this.getAccountRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get account\'s balance change
     */
    async getAccountDiffRaw(requestParameters: GetAccountDiffRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetAccountDiff200Response>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountDiff().'
            );
        }

        if (requestParameters['startDate'] == null) {
            throw new runtime.RequiredError(
                'startDate',
                'Required parameter "startDate" was null or undefined when calling getAccountDiff().'
            );
        }

        if (requestParameters['endDate'] == null) {
            throw new runtime.RequiredError(
                'endDate',
                'Required parameter "endDate" was null or undefined when calling getAccountDiff().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['startDate'] != null) {
            queryParameters['start_date'] = requestParameters['startDate'];
        }

        if (requestParameters['endDate'] != null) {
            queryParameters['end_date'] = requestParameters['endDate'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/diff`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetAccountDiff200ResponseFromJSON(jsonValue));
    }

    /**
     * Get account\'s balance change
     */
    async getAccountDiff(requestParameters: GetAccountDiffRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetAccountDiff200Response> {
        const response = await this.getAccountDiffRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get expiring account .ton dns
     */
    async getAccountDnsExpiringRaw(requestParameters: GetAccountDnsExpiringRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<DnsExpiring>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountDnsExpiring().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['period'] != null) {
            queryParameters['period'] = requestParameters['period'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/dns/expiring`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => DnsExpiringFromJSON(jsonValue));
    }

    /**
     * Get expiring account .ton dns
     */
    async getAccountDnsExpiring(requestParameters: GetAccountDnsExpiringRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<DnsExpiring> {
        const response = await this.getAccountDnsExpiringRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get event for an account by event_id
     */
    async getAccountEventRaw(requestParameters: GetAccountEventRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvent>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountEvent().'
            );
        }

        if (requestParameters['eventId'] == null) {
            throw new runtime.RequiredError(
                'eventId',
                'Required parameter "eventId" was null or undefined when calling getAccountEvent().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['subjectOnly'] != null) {
            queryParameters['subject_only'] = requestParameters['subjectOnly'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        const response = await this.request({
            path: `/v2/accounts/{account_id}/events/{event_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"event_id"}}`, encodeURIComponent(String(requestParameters['eventId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountEventFromJSON(jsonValue));
    }

    /**
     * Get event for an account by event_id
     */
    async getAccountEvent(requestParameters: GetAccountEventRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvent> {
        const response = await this.getAccountEventRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get events for an account. Each event is built on top of a trace which is a series of transactions caused by one inbound message. TonAPI looks for known patterns inside the trace and splits the trace into actions, where a single action represents a meaningful high-level operation like a Jetton Transfer or an NFT Purchase. Actions are expected to be shown to users. It is advised not to build any logic on top of actions because actions can be changed at any time.
     */
    async getAccountEventsRaw(requestParameters: GetAccountEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountEvents().'
            );
        }

        if (requestParameters['limit'] == null) {
            throw new runtime.RequiredError(
                'limit',
                'Required parameter "limit" was null or undefined when calling getAccountEvents().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['initiator'] != null) {
            queryParameters['initiator'] = requestParameters['initiator'];
        }

        if (requestParameters['subjectOnly'] != null) {
            queryParameters['subject_only'] = requestParameters['subjectOnly'];
        }

        if (requestParameters['beforeLt'] != null) {
            queryParameters['before_lt'] = requestParameters['beforeLt'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['startDate'] != null) {
            queryParameters['start_date'] = requestParameters['startDate'];
        }

        if (requestParameters['endDate'] != null) {
            queryParameters['end_date'] = requestParameters['endDate'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        const response = await this.request({
            path: `/v2/accounts/{account_id}/events`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountEventsFromJSON(jsonValue));
    }

    /**
     * Get events for an account. Each event is built on top of a trace which is a series of transactions caused by one inbound message. TonAPI looks for known patterns inside the trace and splits the trace into actions, where a single action represents a meaningful high-level operation like a Jetton Transfer or an NFT Purchase. Actions are expected to be shown to users. It is advised not to build any logic on top of actions because actions can be changed at any time.
     */
    async getAccountEvents(requestParameters: GetAccountEventsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents> {
        const response = await this.getAccountEventsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Jetton balance by owner address
     */
    async getAccountJettonBalanceRaw(requestParameters: GetAccountJettonBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonBalance>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountJettonBalance().'
            );
        }

        if (requestParameters['jettonId'] == null) {
            throw new runtime.RequiredError(
                'jettonId',
                'Required parameter "jettonId" was null or undefined when calling getAccountJettonBalance().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['currencies'] != null) {
            queryParameters['currencies'] = requestParameters['currencies']!.join(runtime.COLLECTION_FORMATS["csv"]);
        }

        if (requestParameters['supportedExtensions'] != null) {
            queryParameters['supported_extensions'] = requestParameters['supportedExtensions']!.join(runtime.COLLECTION_FORMATS["csv"]);
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/jettons/{jetton_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"jetton_id"}}`, encodeURIComponent(String(requestParameters['jettonId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => JettonBalanceFromJSON(jsonValue));
    }

    /**
     * Get Jetton balance by owner address
     */
    async getAccountJettonBalance(requestParameters: GetAccountJettonBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonBalance> {
        const response = await this.getAccountJettonBalanceRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the transfer jetton history for account and jetton
     */
    async getAccountJettonHistoryByIDRaw(requestParameters: GetAccountJettonHistoryByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountJettonHistoryByID().'
            );
        }

        if (requestParameters['jettonId'] == null) {
            throw new runtime.RequiredError(
                'jettonId',
                'Required parameter "jettonId" was null or undefined when calling getAccountJettonHistoryByID().'
            );
        }

        if (requestParameters['limit'] == null) {
            throw new runtime.RequiredError(
                'limit',
                'Required parameter "limit" was null or undefined when calling getAccountJettonHistoryByID().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['beforeLt'] != null) {
            queryParameters['before_lt'] = requestParameters['beforeLt'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['startDate'] != null) {
            queryParameters['start_date'] = requestParameters['startDate'];
        }

        if (requestParameters['endDate'] != null) {
            queryParameters['end_date'] = requestParameters['endDate'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        const response = await this.request({
            path: `/v2/accounts/{account_id}/jettons/{jetton_id}/history`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"jetton_id"}}`, encodeURIComponent(String(requestParameters['jettonId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountEventsFromJSON(jsonValue));
    }

    /**
     * Get the transfer jetton history for account and jetton
     */
    async getAccountJettonHistoryByID(requestParameters: GetAccountJettonHistoryByIDRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents> {
        const response = await this.getAccountJettonHistoryByIDRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get all Jettons balances by owner address
     */
    async getAccountJettonsBalancesRaw(requestParameters: GetAccountJettonsBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<JettonsBalances>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountJettonsBalances().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['currencies'] != null) {
            queryParameters['currencies'] = requestParameters['currencies']!.join(runtime.COLLECTION_FORMATS["csv"]);
        }

        if (requestParameters['supportedExtensions'] != null) {
            queryParameters['supported_extensions'] = requestParameters['supportedExtensions']!.join(runtime.COLLECTION_FORMATS["csv"]);
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/jettons`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => JettonsBalancesFromJSON(jsonValue));
    }

    /**
     * Get all Jettons balances by owner address
     */
    async getAccountJettonsBalances(requestParameters: GetAccountJettonsBalancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<JettonsBalances> {
        const response = await this.getAccountJettonsBalancesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get the transfer jettons history for account
     */
    async getAccountJettonsHistoryRaw(requestParameters: GetAccountJettonsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AccountEvents>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountJettonsHistory().'
            );
        }

        if (requestParameters['limit'] == null) {
            throw new runtime.RequiredError(
                'limit',
                'Required parameter "limit" was null or undefined when calling getAccountJettonsHistory().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['beforeLt'] != null) {
            queryParameters['before_lt'] = requestParameters['beforeLt'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['startDate'] != null) {
            queryParameters['start_date'] = requestParameters['startDate'];
        }

        if (requestParameters['endDate'] != null) {
            queryParameters['end_date'] = requestParameters['endDate'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        const response = await this.request({
            path: `/v2/accounts/{account_id}/jettons/history`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountEventsFromJSON(jsonValue));
    }

    /**
     * Get the transfer jettons history for account
     */
    async getAccountJettonsHistory(requestParameters: GetAccountJettonsHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AccountEvents> {
        const response = await this.getAccountJettonsHistoryRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get account\'s multisigs
     */
    async getAccountMultisigsRaw(requestParameters: GetAccountMultisigsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Multisigs>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountMultisigs().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/multisigs`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => MultisigsFromJSON(jsonValue));
    }

    /**
     * Get account\'s multisigs
     */
    async getAccountMultisigs(requestParameters: GetAccountMultisigsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Multisigs> {
        const response = await this.getAccountMultisigsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get all NFT items by owner address
     */
    async getAccountNftItemsRaw(requestParameters: GetAccountNftItemsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<NftItems>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountNftItems().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['collection'] != null) {
            queryParameters['collection'] = requestParameters['collection'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['offset'] != null) {
            queryParameters['offset'] = requestParameters['offset'];
        }

        if (requestParameters['indirectOwnership'] != null) {
            queryParameters['indirect_ownership'] = requestParameters['indirectOwnership'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/nfts`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => NftItemsFromJSON(jsonValue));
    }

    /**
     * Get all NFT items by owner address
     */
    async getAccountNftItems(requestParameters: GetAccountNftItemsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<NftItems> {
        const response = await this.getAccountNftItemsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get public key by account id
     */
    async getAccountPublicKeyRaw(requestParameters: GetAccountPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GetAccountPublicKey200Response>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountPublicKey().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/publickey`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GetAccountPublicKey200ResponseFromJSON(jsonValue));
    }

    /**
     * Get public key by account id
     */
    async getAccountPublicKey(requestParameters: GetAccountPublicKeyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GetAccountPublicKey200Response> {
        const response = await this.getAccountPublicKeyRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get all subscriptions by wallet address
     */
    async getAccountSubscriptionsRaw(requestParameters: GetAccountSubscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Subscriptions>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountSubscriptions().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/subscriptions`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SubscriptionsFromJSON(jsonValue));
    }

    /**
     * Get all subscriptions by wallet address
     */
    async getAccountSubscriptions(requestParameters: GetAccountSubscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Subscriptions> {
        const response = await this.getAccountSubscriptionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get traces for account
     */
    async getAccountTracesRaw(requestParameters: GetAccountTracesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<TraceIDs>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling getAccountTraces().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['beforeLt'] != null) {
            queryParameters['before_lt'] = requestParameters['beforeLt'];
        }

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/traces`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TraceIDsFromJSON(jsonValue));
    }

    /**
     * Get traces for account
     */
    async getAccountTraces(requestParameters: GetAccountTracesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<TraceIDs> {
        const response = await this.getAccountTracesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get human-friendly information about several accounts without low-level details.
     */
    async getAccountsRaw(requestParameters: GetAccountsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Accounts>> {
        const queryParameters: any = {};

        if (requestParameters['currency'] != null) {
            queryParameters['currency'] = requestParameters['currency'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/v2/accounts/_bulk`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: GetAccountsRequestToJSON(requestParameters['getAccountsRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AccountsFromJSON(jsonValue));
    }

    /**
     * Get human-friendly information about several accounts without low-level details.
     */
    async getAccounts(requestParameters: GetAccountsOperationRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Accounts> {
        const response = await this.getAccountsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Update internal cache for a particular account
     */
    async reindexAccountRaw(requestParameters: ReindexAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['accountId'] == null) {
            throw new runtime.RequiredError(
                'accountId',
                'Required parameter "accountId" was null or undefined when calling reindexAccount().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/{account_id}/reindex`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Update internal cache for a particular account
     */
    async reindexAccount(requestParameters: ReindexAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.reindexAccountRaw(requestParameters, initOverrides);
    }

    /**
     * Search by account domain name
     */
    async searchAccountsRaw(requestParameters: SearchAccountsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<FoundAccounts>> {
        if (requestParameters['name'] == null) {
            throw new runtime.RequiredError(
                'name',
                'Required parameter "name" was null or undefined when calling searchAccounts().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['name'] != null) {
            queryParameters['name'] = requestParameters['name'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/v2/accounts/search`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => FoundAccountsFromJSON(jsonValue));
    }

    /**
     * Search by account domain name
     */
    async searchAccounts(requestParameters: SearchAccountsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<FoundAccounts> {
        const response = await this.searchAccountsRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
