/* tslint:disable */
/* eslint-disable */
/**
 * Custodial-Battery REST API.
 * REST API for Custodial Battery which provides gas to different networks to help execute transactions.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  EmulateMessageToWalletRequest,
  GetTonConnectPayloadDefaultResponse,
  MessageConsequences,
} from '../models/index';
import {
    EmulateMessageToWalletRequestFromJSON,
    EmulateMessageToWalletRequestToJSON,
    GetTonConnectPayloadDefaultResponseFromJSON,
    GetTonConnectPayloadDefaultResponseToJSON,
    MessageConsequencesFromJSON,
    MessageConsequencesToJSON,
} from '../models/index';

export interface EmulateMessageToWalletOperationRequest {
    xTonConnectAuth: string;
    emulateMessageToWalletRequest: EmulateMessageToWalletRequest;
    acceptLanguage?: string;
}

export interface GetJettonMetadataRequest {
    name: string;
}

/**
 * EmulationApi - interface
 * 
 * @export
 * @interface EmulationApiInterface
 */
export interface EmulationApiInterface {
    /**
     * Emulate sending message to blockchain
     * @param {string} xTonConnectAuth 
     * @param {EmulateMessageToWalletRequest} emulateMessageToWalletRequest bag-of-cells serialized to base64
     * @param {string} [acceptLanguage] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof EmulationApiInterface
     */
    emulateMessageToWalletRaw(requestParameters: EmulateMessageToWalletOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<MessageConsequences>>;

    /**
     * Emulate sending message to blockchain
     */
    emulateMessageToWallet(requestParameters: EmulateMessageToWalletOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<MessageConsequences>;

    /**
     * 
     * @param {string} name 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof EmulationApiInterface
     */
    getJettonMetadataRaw(requestParameters: GetJettonMetadataRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>>;

    /**
     */
    getJettonMetadata(requestParameters: GetJettonMetadataRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }>;

}

/**
 * 
 */
export class EmulationApi extends runtime.BaseAPI implements EmulationApiInterface {

    /**
     * Emulate sending message to blockchain
     */
    async emulateMessageToWalletRaw(requestParameters: EmulateMessageToWalletOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<MessageConsequences>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling emulateMessageToWallet().'
            );
        }

        if (requestParameters['emulateMessageToWalletRequest'] == null) {
            throw new runtime.RequiredError(
                'emulateMessageToWalletRequest',
                'Required parameter "emulateMessageToWalletRequest" was null or undefined when calling emulateMessageToWallet().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/wallet/emulate`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: EmulateMessageToWalletRequestToJSON(requestParameters['emulateMessageToWalletRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => MessageConsequencesFromJSON(jsonValue));
    }

    /**
     * Emulate sending message to blockchain
     */
    async emulateMessageToWallet(requestParameters: EmulateMessageToWalletOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<MessageConsequences> {
        const response = await this.emulateMessageToWalletRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     */
    async getJettonMetadataRaw(requestParameters: GetJettonMetadataRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>> {
        if (requestParameters['name'] == null) {
            throw new runtime.RequiredError(
                'name',
                'Required parameter "name" was null or undefined when calling getJettonMetadata().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/jetton-metadata/{name}.json`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))),
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     */
    async getJettonMetadata(requestParameters: GetJettonMetadataRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }> {
        const response = await this.getJettonMetadataRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
