/* tslint:disable */
/* eslint-disable */
/**
 * Custodial-Battery REST API.
 * REST API for Custodial Battery which provides gas to different networks to help execute transactions.
 *
 * The version of the OpenAPI document: 0.0.1
 * Contact: support@tonkeeper.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  AndroidBatteryPurchaseRequest,
  AndroidBatteryPurchaseStatus,
  AppStoreNotificationRequest,
  ApplyPromoRequest,
  Balance,
  Config,
  CreateCustomRefundRequest,
  EmulateMessageToWalletRequest,
  EstimateGaslessCostRequest,
  GaslessEstimation,
  GetTonConnectPayloadDefaultResponse,
  IOSBatteryPurchaseStatus,
  IosBatteryPurchaseRequest,
  PromoCodeBatteryPurchaseRequest,
  PromoCodeBatteryPurchaseStatus,
  Purchases,
  RechargeMethods,
  RequestRefundRequest,
  ResetUserBalanceRequest,
  Status,
  Transactions,
} from '../models/index';
import {
    AndroidBatteryPurchaseRequestFromJSON,
    AndroidBatteryPurchaseRequestToJSON,
    AndroidBatteryPurchaseStatusFromJSON,
    AndroidBatteryPurchaseStatusToJSON,
    AppStoreNotificationRequestFromJSON,
    AppStoreNotificationRequestToJSON,
    ApplyPromoRequestFromJSON,
    ApplyPromoRequestToJSON,
    BalanceFromJSON,
    BalanceToJSON,
    ConfigFromJSON,
    ConfigToJSON,
    CreateCustomRefundRequestFromJSON,
    CreateCustomRefundRequestToJSON,
    EmulateMessageToWalletRequestFromJSON,
    EmulateMessageToWalletRequestToJSON,
    EstimateGaslessCostRequestFromJSON,
    EstimateGaslessCostRequestToJSON,
    GaslessEstimationFromJSON,
    GaslessEstimationToJSON,
    GetTonConnectPayloadDefaultResponseFromJSON,
    GetTonConnectPayloadDefaultResponseToJSON,
    IOSBatteryPurchaseStatusFromJSON,
    IOSBatteryPurchaseStatusToJSON,
    IosBatteryPurchaseRequestFromJSON,
    IosBatteryPurchaseRequestToJSON,
    PromoCodeBatteryPurchaseRequestFromJSON,
    PromoCodeBatteryPurchaseRequestToJSON,
    PromoCodeBatteryPurchaseStatusFromJSON,
    PromoCodeBatteryPurchaseStatusToJSON,
    PurchasesFromJSON,
    PurchasesToJSON,
    RechargeMethodsFromJSON,
    RechargeMethodsToJSON,
    RequestRefundRequestFromJSON,
    RequestRefundRequestToJSON,
    ResetUserBalanceRequestFromJSON,
    ResetUserBalanceRequestToJSON,
    StatusFromJSON,
    StatusToJSON,
    TransactionsFromJSON,
    TransactionsToJSON,
} from '../models/index';

export interface AndroidBatteryPurchaseOperationRequest {
    xTonConnectAuth: string;
    androidBatteryPurchaseRequest: AndroidBatteryPurchaseRequest;
}

export interface AppStoreNotificationOperationRequest {
    appStoreNotificationRequest: AppStoreNotificationRequest;
}

export interface ApplyPromoOperationRequest {
    token: string;
    applyPromoRequest: ApplyPromoRequest;
}

export interface CreateCustomRefundOperationRequest {
    token: string;
    createCustomRefundRequest: CreateCustomRefundRequest;
}

export interface EstimateGaslessCostOperationRequest {
    jettonMaster: string;
    estimateGaslessCostRequest: EstimateGaslessCostRequest;
    xTonConnectAuth?: string;
    walletAddress?: string;
    walletPublicKey?: string;
}

export interface ExtendRefundPeriodRequest {
    token: string;
    purchaseId: number;
}

export interface GetBalanceRequest {
    xTonConnectAuth: string;
    units?: GetBalanceUnitsEnum;
}

export interface GetPurchasesRequest {
    xTonConnectAuth: string;
    limit?: number;
    offset?: number;
    includeGiftsOnTheWay?: boolean;
}

export interface GetRechargeMethodsRequest {
    includeRechargeOnly?: boolean;
}

export interface GetStatusRequest {
    xTonConnectAuth: string;
}

export interface GetTransactionsRequest {
    xTonConnectAuth: string;
    limit?: number;
    offset?: number;
}

export interface IosBatteryPurchaseOperationRequest {
    xTonConnectAuth: string;
    iosBatteryPurchaseRequest: IosBatteryPurchaseRequest;
}

export interface PromoCodeBatteryPurchaseOperationRequest {
    xTonConnectAuth: string;
    promoCodeBatteryPurchaseRequest: PromoCodeBatteryPurchaseRequest;
    acceptLanguage?: string;
}

export interface RequestRefundOperationRequest {
    xTonConnectAuth: string;
    requestRefundRequest: RequestRefundRequest;
}

export interface ResetUserBalanceOperationRequest {
    token: string;
    userId: number;
    resetUserBalanceRequest: ResetUserBalanceRequest;
}

export interface SendMessageRequest {
    xTonConnectAuth: string;
    emulateMessageToWalletRequest: EmulateMessageToWalletRequest;
}

export interface VerifyPurchasePromoRequest {
    promo?: string;
}

/**
 * DefaultApi - interface
 * 
 * @export
 * @interface DefaultApiInterface
 */
export interface DefaultApiInterface {
    /**
     * verify an in-app purchase
     * @param {string} xTonConnectAuth 
     * @param {AndroidBatteryPurchaseRequest} androidBatteryPurchaseRequest In-App purchase
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    androidBatteryPurchaseRaw(requestParameters: AndroidBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AndroidBatteryPurchaseStatus>>;

    /**
     * verify an in-app purchase
     */
    androidBatteryPurchase(requestParameters: AndroidBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AndroidBatteryPurchaseStatus>;

    /**
     * 
     * @param {AppStoreNotificationRequest} appStoreNotificationRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    appStoreNotificationRaw(requestParameters: AppStoreNotificationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<object>>;

    /**
     */
    appStoreNotification(requestParameters: AppStoreNotificationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<object>;

    /**
     * 
     * @param {string} token 
     * @param {ApplyPromoRequest} applyPromoRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    applyPromoRaw(requestParameters: ApplyPromoOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PromoCodeBatteryPurchaseStatus>>;

    /**
     */
    applyPromo(requestParameters: ApplyPromoOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PromoCodeBatteryPurchaseStatus>;

    /**
     * 
     * @param {string} token 
     * @param {CreateCustomRefundRequest} createCustomRefundRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    createCustomRefundRaw(requestParameters: CreateCustomRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>>;

    /**
     */
    createCustomRefund(requestParameters: CreateCustomRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }>;

    /**
     * 
     * @param {string} jettonMaster 
     * @param {EstimateGaslessCostRequest} estimateGaslessCostRequest 
     * @param {string} [xTonConnectAuth] 
     * @param {string} [walletAddress] 
     * @param {string} [walletPublicKey] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    estimateGaslessCostRaw(requestParameters: EstimateGaslessCostOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GaslessEstimation>>;

    /**
     */
    estimateGaslessCost(requestParameters: EstimateGaslessCostOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GaslessEstimation>;

    /**
     * 
     * @param {string} token 
     * @param {number} purchaseId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    extendRefundPeriodRaw(requestParameters: ExtendRefundPeriodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>>;

    /**
     */
    extendRefundPeriod(requestParameters: ExtendRefundPeriodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }>;

    /**
     * This method returns information about a user\'s balance.
     * @param {string} xTonConnectAuth 
     * @param {'usd' | 'ton'} [units] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getBalanceRaw(requestParameters: GetBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Balance>>;

    /**
     * This method returns information about a user\'s balance.
     */
    getBalance(requestParameters: GetBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Balance>;

    /**
     * This method returns information about Battery Service.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getConfigRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Config>>;

    /**
     * This method returns information about Battery Service.
     */
    getConfig(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Config>;

    /**
     * This method returns a list of purchases made by a specific user.
     * @param {string} xTonConnectAuth 
     * @param {number} [limit] 
     * @param {number} [offset] 
     * @param {boolean} [includeGiftsOnTheWay] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getPurchasesRaw(requestParameters: GetPurchasesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Purchases>>;

    /**
     * This method returns a list of purchases made by a specific user.
     */
    getPurchases(requestParameters: GetPurchasesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Purchases>;

    /**
     * This method returns on-chain recharge methods.
     * @param {boolean} [includeRechargeOnly] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getRechargeMethodsRaw(requestParameters: GetRechargeMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RechargeMethods>>;

    /**
     * This method returns on-chain recharge methods.
     */
    getRechargeMethods(requestParameters: GetRechargeMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RechargeMethods>;

    /**
     * This method returns information about the current status of Battery Service.
     * @param {string} xTonConnectAuth 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getStatusRaw(requestParameters: GetStatusRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Status>>;

    /**
     * This method returns information about the current status of Battery Service.
     */
    getStatus(requestParameters: GetStatusRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Status>;

    /**
     * This method returns a list of transactions made by a specific user.
     * @param {string} xTonConnectAuth 
     * @param {number} [limit] 
     * @param {number} [offset] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    getTransactionsRaw(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Transactions>>;

    /**
     * This method returns a list of transactions made by a specific user.
     */
    getTransactions(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Transactions>;

    /**
     * verify an in-app purchase
     * @param {string} xTonConnectAuth 
     * @param {IosBatteryPurchaseRequest} iosBatteryPurchaseRequest In-App purchase
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    iosBatteryPurchaseRaw(requestParameters: IosBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<IOSBatteryPurchaseStatus>>;

    /**
     * verify an in-app purchase
     */
    iosBatteryPurchase(requestParameters: IosBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<IOSBatteryPurchaseStatus>;

    /**
     * charge battery with promo code
     * @param {string} xTonConnectAuth 
     * @param {PromoCodeBatteryPurchaseRequest} promoCodeBatteryPurchaseRequest charge battery with promo code
     * @param {string} [acceptLanguage] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    promoCodeBatteryPurchaseRaw(requestParameters: PromoCodeBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PromoCodeBatteryPurchaseStatus>>;

    /**
     * charge battery with promo code
     */
    promoCodeBatteryPurchase(requestParameters: PromoCodeBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PromoCodeBatteryPurchaseStatus>;

    /**
     * 
     * @param {string} xTonConnectAuth 
     * @param {RequestRefundRequest} requestRefundRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    requestRefundRaw(requestParameters: RequestRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     */
    requestRefund(requestParameters: RequestRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 
     * @param {string} token 
     * @param {number} userId 
     * @param {ResetUserBalanceRequest} resetUserBalanceRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    resetUserBalanceRaw(requestParameters: ResetUserBalanceOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>>;

    /**
     */
    resetUserBalance(requestParameters: ResetUserBalanceOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }>;

    /**
     * Send message to blockchain
     * @param {string} xTonConnectAuth 
     * @param {EmulateMessageToWalletRequest} emulateMessageToWalletRequest bag-of-cells serialized to base64
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    sendMessageRaw(requestParameters: SendMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Send message to blockchain
     */
    sendMessage(requestParameters: SendMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * 
     * @param {string} [promo] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof DefaultApiInterface
     */
    verifyPurchasePromoRaw(requestParameters: VerifyPurchasePromoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>>;

    /**
     */
    verifyPurchasePromo(requestParameters: VerifyPurchasePromoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }>;

}

/**
 * 
 */
export class DefaultApi extends runtime.BaseAPI implements DefaultApiInterface {

    /**
     * verify an in-app purchase
     */
    async androidBatteryPurchaseRaw(requestParameters: AndroidBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AndroidBatteryPurchaseStatus>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling androidBatteryPurchase().'
            );
        }

        if (requestParameters['androidBatteryPurchaseRequest'] == null) {
            throw new runtime.RequiredError(
                'androidBatteryPurchaseRequest',
                'Required parameter "androidBatteryPurchaseRequest" was null or undefined when calling androidBatteryPurchase().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/purchase-battery/android`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: AndroidBatteryPurchaseRequestToJSON(requestParameters['androidBatteryPurchaseRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => AndroidBatteryPurchaseStatusFromJSON(jsonValue));
    }

    /**
     * verify an in-app purchase
     */
    async androidBatteryPurchase(requestParameters: AndroidBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AndroidBatteryPurchaseStatus> {
        const response = await this.androidBatteryPurchaseRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     */
    async appStoreNotificationRaw(requestParameters: AppStoreNotificationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<object>> {
        if (requestParameters['appStoreNotificationRequest'] == null) {
            throw new runtime.RequiredError(
                'appStoreNotificationRequest',
                'Required parameter "appStoreNotificationRequest" was null or undefined when calling appStoreNotification().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/purchase-battery/ios/app-store-notification`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: AppStoreNotificationRequestToJSON(requestParameters['appStoreNotificationRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     */
    async appStoreNotification(requestParameters: AppStoreNotificationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<object> {
        const response = await this.appStoreNotificationRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     */
    async applyPromoRaw(requestParameters: ApplyPromoOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PromoCodeBatteryPurchaseStatus>> {
        if (requestParameters['token'] == null) {
            throw new runtime.RequiredError(
                'token',
                'Required parameter "token" was null or undefined when calling applyPromo().'
            );
        }

        if (requestParameters['applyPromoRequest'] == null) {
            throw new runtime.RequiredError(
                'applyPromoRequest',
                'Required parameter "applyPromoRequest" was null or undefined when calling applyPromo().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['token'] != null) {
            queryParameters['token'] = requestParameters['token'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/restricted/apply-promo`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ApplyPromoRequestToJSON(requestParameters['applyPromoRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PromoCodeBatteryPurchaseStatusFromJSON(jsonValue));
    }

    /**
     */
    async applyPromo(requestParameters: ApplyPromoOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PromoCodeBatteryPurchaseStatus> {
        const response = await this.applyPromoRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     */
    async createCustomRefundRaw(requestParameters: CreateCustomRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>> {
        if (requestParameters['token'] == null) {
            throw new runtime.RequiredError(
                'token',
                'Required parameter "token" was null or undefined when calling createCustomRefund().'
            );
        }

        if (requestParameters['createCustomRefundRequest'] == null) {
            throw new runtime.RequiredError(
                'createCustomRefundRequest',
                'Required parameter "createCustomRefundRequest" was null or undefined when calling createCustomRefund().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['token'] != null) {
            queryParameters['token'] = requestParameters['token'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/restricted/create-custom-refund`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: CreateCustomRefundRequestToJSON(requestParameters['createCustomRefundRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     */
    async createCustomRefund(requestParameters: CreateCustomRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }> {
        const response = await this.createCustomRefundRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     */
    async estimateGaslessCostRaw(requestParameters: EstimateGaslessCostOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GaslessEstimation>> {
        if (requestParameters['jettonMaster'] == null) {
            throw new runtime.RequiredError(
                'jettonMaster',
                'Required parameter "jettonMaster" was null or undefined when calling estimateGaslessCost().'
            );
        }

        if (requestParameters['estimateGaslessCostRequest'] == null) {
            throw new runtime.RequiredError(
                'estimateGaslessCostRequest',
                'Required parameter "estimateGaslessCostRequest" was null or undefined when calling estimateGaslessCost().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['walletAddress'] != null) {
            queryParameters['wallet_address'] = requestParameters['walletAddress'];
        }

        if (requestParameters['walletPublicKey'] != null) {
            queryParameters['wallet_public_key'] = requestParameters['walletPublicKey'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/gasless/estimate-cost/{jetton_master}`.replace(`{${"jetton_master"}}`, encodeURIComponent(String(requestParameters['jettonMaster']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: EstimateGaslessCostRequestToJSON(requestParameters['estimateGaslessCostRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => GaslessEstimationFromJSON(jsonValue));
    }

    /**
     */
    async estimateGaslessCost(requestParameters: EstimateGaslessCostOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GaslessEstimation> {
        const response = await this.estimateGaslessCostRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     */
    async extendRefundPeriodRaw(requestParameters: ExtendRefundPeriodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>> {
        if (requestParameters['token'] == null) {
            throw new runtime.RequiredError(
                'token',
                'Required parameter "token" was null or undefined when calling extendRefundPeriod().'
            );
        }

        if (requestParameters['purchaseId'] == null) {
            throw new runtime.RequiredError(
                'purchaseId',
                'Required parameter "purchaseId" was null or undefined when calling extendRefundPeriod().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['token'] != null) {
            queryParameters['token'] = requestParameters['token'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/restricted/purchases/{purchase_id}/extend-refund-period`.replace(`{${"purchase_id"}}`, encodeURIComponent(String(requestParameters['purchaseId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     */
    async extendRefundPeriod(requestParameters: ExtendRefundPeriodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }> {
        const response = await this.extendRefundPeriodRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * This method returns information about a user\'s balance.
     */
    async getBalanceRaw(requestParameters: GetBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Balance>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling getBalance().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['units'] != null) {
            queryParameters['units'] = requestParameters['units'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/balance`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => BalanceFromJSON(jsonValue));
    }

    /**
     * This method returns information about a user\'s balance.
     */
    async getBalance(requestParameters: GetBalanceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Balance> {
        const response = await this.getBalanceRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * This method returns information about Battery Service.
     */
    async getConfigRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Config>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/config`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ConfigFromJSON(jsonValue));
    }

    /**
     * This method returns information about Battery Service.
     */
    async getConfig(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Config> {
        const response = await this.getConfigRaw(initOverrides);
        return await response.value();
    }

    /**
     * This method returns a list of purchases made by a specific user.
     */
    async getPurchasesRaw(requestParameters: GetPurchasesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Purchases>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling getPurchases().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['offset'] != null) {
            queryParameters['offset'] = requestParameters['offset'];
        }

        if (requestParameters['includeGiftsOnTheWay'] != null) {
            queryParameters['include_gifts_on_the_way'] = requestParameters['includeGiftsOnTheWay'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/purchases`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PurchasesFromJSON(jsonValue));
    }

    /**
     * This method returns a list of purchases made by a specific user.
     */
    async getPurchases(requestParameters: GetPurchasesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Purchases> {
        const response = await this.getPurchasesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * This method returns on-chain recharge methods.
     */
    async getRechargeMethodsRaw(requestParameters: GetRechargeMethodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RechargeMethods>> {
        const queryParameters: any = {};

        if (requestParameters['includeRechargeOnly'] != null) {
            queryParameters['include_recharge_only'] = requestParameters['includeRechargeOnly'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/recharge-methods`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => RechargeMethodsFromJSON(jsonValue));
    }

    /**
     * This method returns on-chain recharge methods.
     */
    async getRechargeMethods(requestParameters: GetRechargeMethodsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RechargeMethods> {
        const response = await this.getRechargeMethodsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * This method returns information about the current status of Battery Service.
     */
    async getStatusRaw(requestParameters: GetStatusRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Status>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling getStatus().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/status`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => StatusFromJSON(jsonValue));
    }

    /**
     * This method returns information about the current status of Battery Service.
     */
    async getStatus(requestParameters: GetStatusRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Status> {
        const response = await this.getStatusRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * This method returns a list of transactions made by a specific user.
     */
    async getTransactionsRaw(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Transactions>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling getTransactions().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['limit'] != null) {
            queryParameters['limit'] = requestParameters['limit'];
        }

        if (requestParameters['offset'] != null) {
            queryParameters['offset'] = requestParameters['offset'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/transactions`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => TransactionsFromJSON(jsonValue));
    }

    /**
     * This method returns a list of transactions made by a specific user.
     */
    async getTransactions(requestParameters: GetTransactionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Transactions> {
        const response = await this.getTransactionsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * verify an in-app purchase
     */
    async iosBatteryPurchaseRaw(requestParameters: IosBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<IOSBatteryPurchaseStatus>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling iosBatteryPurchase().'
            );
        }

        if (requestParameters['iosBatteryPurchaseRequest'] == null) {
            throw new runtime.RequiredError(
                'iosBatteryPurchaseRequest',
                'Required parameter "iosBatteryPurchaseRequest" was null or undefined when calling iosBatteryPurchase().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/purchase-battery/ios`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: IosBatteryPurchaseRequestToJSON(requestParameters['iosBatteryPurchaseRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => IOSBatteryPurchaseStatusFromJSON(jsonValue));
    }

    /**
     * verify an in-app purchase
     */
    async iosBatteryPurchase(requestParameters: IosBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<IOSBatteryPurchaseStatus> {
        const response = await this.iosBatteryPurchaseRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * charge battery with promo code
     */
    async promoCodeBatteryPurchaseRaw(requestParameters: PromoCodeBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PromoCodeBatteryPurchaseStatus>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling promoCodeBatteryPurchase().'
            );
        }

        if (requestParameters['promoCodeBatteryPurchaseRequest'] == null) {
            throw new runtime.RequiredError(
                'promoCodeBatteryPurchaseRequest',
                'Required parameter "promoCodeBatteryPurchaseRequest" was null or undefined when calling promoCodeBatteryPurchase().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (requestParameters['acceptLanguage'] != null) {
            headerParameters['Accept-Language'] = String(requestParameters['acceptLanguage']);
        }

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/purchase-battery/promo-code`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: PromoCodeBatteryPurchaseRequestToJSON(requestParameters['promoCodeBatteryPurchaseRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => PromoCodeBatteryPurchaseStatusFromJSON(jsonValue));
    }

    /**
     * charge battery with promo code
     */
    async promoCodeBatteryPurchase(requestParameters: PromoCodeBatteryPurchaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PromoCodeBatteryPurchaseStatus> {
        const response = await this.promoCodeBatteryPurchaseRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     */
    async requestRefundRaw(requestParameters: RequestRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling requestRefund().'
            );
        }

        if (requestParameters['requestRefundRequest'] == null) {
            throw new runtime.RequiredError(
                'requestRefundRequest',
                'Required parameter "requestRefundRequest" was null or undefined when calling requestRefund().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/request-refund`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: RequestRefundRequestToJSON(requestParameters['requestRefundRequest']),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     */
    async requestRefund(requestParameters: RequestRefundOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.requestRefundRaw(requestParameters, initOverrides);
    }

    /**
     */
    async resetUserBalanceRaw(requestParameters: ResetUserBalanceOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>> {
        if (requestParameters['token'] == null) {
            throw new runtime.RequiredError(
                'token',
                'Required parameter "token" was null or undefined when calling resetUserBalance().'
            );
        }

        if (requestParameters['userId'] == null) {
            throw new runtime.RequiredError(
                'userId',
                'Required parameter "userId" was null or undefined when calling resetUserBalance().'
            );
        }

        if (requestParameters['resetUserBalanceRequest'] == null) {
            throw new runtime.RequiredError(
                'resetUserBalanceRequest',
                'Required parameter "resetUserBalanceRequest" was null or undefined when calling resetUserBalance().'
            );
        }

        const queryParameters: any = {};

        if (requestParameters['token'] != null) {
            queryParameters['token'] = requestParameters['token'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        const response = await this.request({
            path: `/restricted/users/{user_id}/reset-balance`.replace(`{${"user_id"}}`, encodeURIComponent(String(requestParameters['userId']))),
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ResetUserBalanceRequestToJSON(requestParameters['resetUserBalanceRequest']),
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     */
    async resetUserBalance(requestParameters: ResetUserBalanceOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }> {
        const response = await this.resetUserBalanceRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Send message to blockchain
     */
    async sendMessageRaw(requestParameters: SendMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters['xTonConnectAuth'] == null) {
            throw new runtime.RequiredError(
                'xTonConnectAuth',
                'Required parameter "xTonConnectAuth" was null or undefined when calling sendMessage().'
            );
        }

        if (requestParameters['emulateMessageToWalletRequest'] == null) {
            throw new runtime.RequiredError(
                'emulateMessageToWalletRequest',
                'Required parameter "emulateMessageToWalletRequest" was null or undefined when calling sendMessage().'
            );
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (requestParameters['xTonConnectAuth'] != null) {
            headerParameters['X-TonConnect-Auth'] = String(requestParameters['xTonConnectAuth']);
        }

        const response = await this.request({
            path: `/message`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: EmulateMessageToWalletRequestToJSON(requestParameters['emulateMessageToWalletRequest']),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Send message to blockchain
     */
    async sendMessage(requestParameters: SendMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.sendMessageRaw(requestParameters, initOverrides);
    }

    /**
     */
    async verifyPurchasePromoRaw(requestParameters: VerifyPurchasePromoRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<{ [key: string]: any; }>> {
        const queryParameters: any = {};

        if (requestParameters['promo'] != null) {
            queryParameters['promo'] = requestParameters['promo'];
        }

        const headerParameters: runtime.HTTPHeaders = {};

        const response = await this.request({
            path: `/purchase-battery/verify-purchase-promo`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse<any>(response);
    }

    /**
     */
    async verifyPurchasePromo(requestParameters: VerifyPurchasePromoRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<{ [key: string]: any; }> {
        const response = await this.verifyPurchasePromoRaw(requestParameters, initOverrides);
        return await response.value();
    }

}

/**
 * @export
 */
export const GetBalanceUnitsEnum = {
    Usd: 'usd',
    Ton: 'ton'
} as const;
export type GetBalanceUnitsEnum = typeof GetBalanceUnitsEnum[keyof typeof GetBalanceUnitsEnum];
